/*
 * Decompiled with CFR 0.152.
 */
package compbio.data.sequence;

import compbio.data.sequence.FastaSequence;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SequenceUtil {
    public static final Pattern WHITE_SPACE = Pattern.compile("\\s");
    public static final Pattern DIGIT = Pattern.compile("\\d");
    public static final Pattern NONWORD = Pattern.compile("\\W");
    public static final Pattern AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern NON_AA = Pattern.compile("[^ARNDCQEGHILKMFPSTWYV]+", 2);
    public static final Pattern AMBIGUOUS_AA = Pattern.compile("[ARNDCQEGHILKMFPSTWYVXU]+", 2);
    public static final Pattern NUCLEOTIDE = Pattern.compile("[AGTCU]+", 2);
    public static final Pattern AMBIGUOUS_NUCLEOTIDE = Pattern.compile("[AGTCRYMKSWHBVDNU]+", 2);
    public static final Pattern NON_NUCLEOTIDE = Pattern.compile("[^AGTCU]+", 2);

    private SequenceUtil() {
    }

    public static boolean isNucleotideSequence(FastaSequence fastaSequence) {
        return SequenceUtil.isNonAmbNucleotideSequence(fastaSequence.getSequence());
    }

    public static boolean isNonAmbNucleotideSequence(String string) {
        if (DIGIT.matcher(string = SequenceUtil.cleanSequence(string)).find()) {
            return false;
        }
        if (NON_NUCLEOTIDE.matcher(string).find()) {
            return false;
        }
        Matcher matcher = NUCLEOTIDE.matcher(string);
        return matcher.find();
    }

    public static String cleanSequence(String string) {
        assert (string != null);
        Matcher matcher = WHITE_SPACE.matcher(string);
        string = matcher.replaceAll("").toUpperCase();
        return string;
    }

    public static String deepCleanSequence(String string) {
        string = SequenceUtil.cleanSequence(string);
        string = DIGIT.matcher(string).replaceAll("");
        string = NONWORD.matcher(string).replaceAll("");
        Pattern pattern = Pattern.compile("[_-]+");
        string = pattern.matcher(string).replaceAll("");
        return string;
    }

    public static boolean isProteinSequence(String string) {
        if (SequenceUtil.isNonAmbNucleotideSequence(string = SequenceUtil.cleanSequence(string))) {
            return false;
        }
        if (DIGIT.matcher(string).find()) {
            return false;
        }
        if (NON_AA.matcher(string).find()) {
            return false;
        }
        Matcher matcher = AA.matcher(string);
        return matcher.find();
    }

    public static boolean isAmbiguosProtein(String string) {
        if (SequenceUtil.isNonAmbNucleotideSequence(string = SequenceUtil.cleanSequence(string))) {
            return false;
        }
        if (DIGIT.matcher(string).find()) {
            return false;
        }
        if (NON_AA.matcher(string).find()) {
            return false;
        }
        if (AA.matcher(string).find()) {
            return false;
        }
        Matcher matcher = AMBIGUOUS_AA.matcher(string);
        return matcher.find();
    }

    public static void writeFasta(OutputStream outputStream, List<FastaSequence> list, int n) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (FastaSequence fastaSequence : list) {
            bufferedWriter.write(fastaSequence.getOnelineFasta());
        }
        outputStream.flush();
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    public static List<FastaSequence> readFasta(InputStream inputStream) throws IOException {
        String string;
        ArrayList<FastaSequence> arrayList = new ArrayList<FastaSequence>();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        Pattern pattern = Pattern.compile("//s+");
        String string2 = "";
        String string3 = null;
        do {
            if ((string = bufferedReader.readLine()) == null || string.startsWith(">")) {
                if (string3 != null) {
                    arrayList.add(new FastaSequence(string2.substring(1), string3));
                }
                string2 = string;
                string3 = "";
                continue;
            }
            String string4 = pattern.matcher(string).replaceAll("");
            string3 = string3 + string4;
        } while (string != null);
        inputStreamReader.close();
        bufferedReader.close();
        return arrayList;
    }

    public static void writeFasta(OutputStream outputStream, List<FastaSequence> list) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        for (FastaSequence fastaSequence : list) {
            bufferedWriter.write(fastaSequence.getOnelineFasta());
        }
        bufferedWriter.close();
        outputStreamWriter.close();
    }

    public static final void closeSilently(Logger logger, Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                logger.log(Level.WARNING, iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
    }
}

