/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.metadata.Argument;
import compbio.metadata.WrongParameterException;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Option<T>
implements Argument<T> {
    @XmlElement(required=true)
    protected String description;
    @XmlElement(required=true)
    Set<String> optionNames = new HashSet<String>();
    @XmlElement(required=true)
    protected String name;
    @XmlAttribute
    protected boolean isRequired;
    @XmlElement
    protected URL furtherDetails;
    @XmlElement
    protected String defaultValue;

    Option() {
    }

    public Option(String string, String string2) {
        this.name = string;
        this.description = string2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public URL getFurtherDetails() {
        return this.furtherDetails;
    }

    public void setFurtherDetails(URL uRL) {
        this.furtherDetails = uRL;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) throws WrongParameterException {
        if (this.optionNames.isEmpty()) {
            throw new IllegalStateException("Please define optionNames first!");
        }
        if (!Option.valueExist(string, this.getOptionNames())) {
            throw new WrongParameterException("Attempting to set illegal defaultValue '" + string + "' which is not defined optionNames for option: " + this);
        }
        this.defaultValue = string;
    }

    static boolean valueExist(String string, List<String> list) {
        assert (!Util.isEmpty(string));
        for (String string2 : list) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean bl) {
        this.isRequired = bl;
    }

    public List<String> getOptionNames() {
        return new ArrayList<String>(this.optionNames);
    }

    public void setOptionNames(Set<String> set) {
        this.optionNames = new HashSet<String>(set);
    }

    public Set<String> addOptionNames(String ... stringArray) {
        for (String string : stringArray) {
            boolean bl = this.optionNames.add(string);
            assert (bl) : "Duplicated optionName is detected!";
        }
        return this.optionNames;
    }

    public String toString() {
        String string = "Option name: " + this.name + SysPrefs.newlinechar;
        string = string + "Description: " + this.description + SysPrefs.newlinechar;
        if (!Util.isEmpty(this.defaultValue)) {
            string = string + "Default value: " + this.defaultValue + SysPrefs.newlinechar;
        }
        string = string + "URL: " + this.furtherDetails + SysPrefs.newlinechar;
        string = string + "Is required: " + this.isRequired + SysPrefs.newlinechar;
        if (!this.optionNames.isEmpty()) {
            TreeSet<String> treeSet = new TreeSet<String>(this.optionNames);
            string = string + "Option Names: " + SysPrefs.newlinechar;
            for (String string2 : treeSet) {
                string = string + string2 + SysPrefs.newlinechar;
            }
        }
        return string;
    }

    public String toCommand(String string) {
        if (this.optionNames.size() == 1) {
            return this.optionNames.iterator().next();
        }
        return this.getDefaultValue();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Option option = null;
        if (!(object instanceof Option)) {
            return false;
        }
        option = (Option)object;
        if (!(Util.isEmpty(option.name) || Util.isEmpty(this.name) || option.name.equals(this.name))) {
            return false;
        }
        if (!(Util.isEmpty(option.description) || Util.isEmpty(this.description) || option.description.equals(this.description))) {
            return false;
        }
        if (option.isRequired != this.isRequired) {
            return false;
        }
        if (!(Util.isEmpty(option.defaultValue) || Util.isEmpty(this.defaultValue) || option.defaultValue.equals(this.defaultValue))) {
            return false;
        }
        if (option.optionNames.size() != this.optionNames.size()) {
            return false;
        }
        int n = 0;
        block0: for (String string : option.optionNames) {
            if (Util.isEmpty(string)) continue;
            for (String string2 : this.optionNames) {
                if (!string.equals(string2)) continue;
                ++n;
                continue block0;
            }
        }
        return n == option.optionNames.size();
    }

    public int hashCode() {
        int n = this.name.hashCode() * this.description.hashCode();
        if (this.isRequired) {
            n += this.furtherDetails.hashCode() * 3;
        } else if (this.defaultValue != null) {
            n += this.defaultValue.hashCode() * 2;
        }
        if (this.description != null) {
            n += this.description.hashCode() * 4;
        }
        return n;
    }

    @Override
    public List<String> getPossibleValues() {
        return new ArrayList<String>(this.optionNames);
    }

    @Override
    public void setValue(String string) throws WrongParameterException {
        this.setDefaultValue(string);
    }

    void validate() throws ValidationException {
        if (this.optionNames == null) {
            throw new ValidationException("Option names are not defined for option: " + this);
        }
        if (this.optionNames.size() > 1 && Util.isEmpty(this.getDefaultValue())) {
            throw new ValidationException("Default value is required as multiple optionNames are defined for option: " + this);
        }
        if (Util.isEmpty(this.name)) {
            throw new ValidationException("No name is defined for option: " + this);
        }
    }
}

