/*
 * Decompiled with CFR 0.152.
 */
package compbio.metadata;

import compbio.util.Util;
import javax.xml.bind.ValidationException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class ValueConstrain {
    @XmlElement(required=true)
    Type type;
    String max;
    String min;

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Number getMax() {
        if (Util.isEmpty(this.max)) {
            return null;
        }
        switch (this.type) {
            case Float: {
                return Double.parseDouble(this.max);
            }
            case Integer: {
                return Integer.parseInt(this.max);
            }
        }
        throw new RuntimeException("Type is undefined! ");
    }

    public void setMax(String string) {
        this.max = string;
    }

    public Number getMin() {
        if (Util.isEmpty(this.min)) {
            return null;
        }
        switch (this.type) {
            case Float: {
                return Double.parseDouble(this.min);
            }
            case Integer: {
                return Integer.parseInt(this.min);
            }
        }
        throw new RuntimeException("Type is undefined! ");
    }

    public void setMin(String string) {
        this.min = string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        ValueConstrain valueConstrain = null;
        if (!(object instanceof ValueConstrain)) {
            return false;
        }
        valueConstrain = (ValueConstrain)object;
        if (this.type != valueConstrain.type) {
            return false;
        }
        if (this.max != null && valueConstrain.max != null) {
            if (!this.max.equals(valueConstrain.max)) {
                return false;
            }
        } else {
            return false;
        }
        if (this.min != null && valueConstrain.min != null) {
            return this.min.equals(valueConstrain.min);
        }
        return false;
    }

    public String toString() {
        String string = "Type: " + (Object)((Object)this.type) + "\n";
        if (this.min != null) {
            string = string + "Min: " + this.min + "\n";
        }
        if (this.max != null) {
            string = string + "Max: " + this.max + "\n";
        }
        return string;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        if (this.max != null) {
            n *= this.max.hashCode();
        }
        if (this.min != null) {
            n *= this.min.hashCode();
        }
        return n;
    }

    boolean hasMinValue() {
        return !Util.isEmpty(this.min);
    }

    boolean hasMaxValue() {
        return !Util.isEmpty(this.max);
    }

    void checkValue(String string) {
        switch (this.type) {
            case Float: {
                float f = Float.parseFloat(string);
                if (this.getMin() != null && new Float(this.getMin().floatValue()).compareTo(Float.valueOf(f)) == 1) {
                    throw new IndexOutOfBoundsException("Value '" + string + "' is lower that minumim value '" + this.getMin() + "'");
                }
                if (this.getMax() == null || new Float(this.getMax().floatValue()).compareTo(Float.valueOf(f)) != -1) break;
                throw new IndexOutOfBoundsException("Value '" + string + "' is greater that maximum value '" + this.getMax() + "'");
            }
            case Integer: {
                int n = Integer.parseInt(string);
                if (this.getMin() != null && new Integer(this.getMin().intValue()).compareTo(n) == 1) {
                    throw new IndexOutOfBoundsException("Value '" + string + "' is lower that minumim value '" + this.getMin() + "'");
                }
                if (this.getMax() == null || new Integer(this.getMax().intValue()).compareTo(n) != -1) break;
                throw new IndexOutOfBoundsException("Value '" + string + "' is greater that maximum value '" + this.getMax() + "'");
            }
        }
    }

    void validate() throws ValidationException {
        if (this.type == null) {
            throw new ValidationException("Type is not defined for ValueConstrain: " + this);
        }
        if (Util.isEmpty(this.min) && Util.isEmpty(this.max)) {
            throw new ValidationException("Both boundaries (min and max) is undefined for ValueConstrain: " + this);
        }
    }

    public static enum Type {
        Integer,
        Float;

    }
}

