/*
 * Decompiled with CFR 0.152.
 */
package compbio.util;

import compbio.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.apache.log4j.Logger;

public class FileWatcher {
    public static final int MIN_CHUNK_SIZE_BYTES = 256;
    public static final int MAX_CHUNK_SIZE_BYTES = 0xA00000;
    private static final Charset charset = Charset.forName("UTF-8");
    private static final CharsetDecoder decoder = charset.newDecoder();
    private static final Logger log = Logger.getLogger(FileWatcher.class);
    private long read = 0L;
    private int chunkSizeBytes;
    private FileChannel fc;

    private FileWatcher(FileInputStream input, int chunkSizeBytes) {
        assert (input != null) : "Input must be provided!";
        assert (chunkSizeBytes >= 1);
        this.chunkSizeBytes = chunkSizeBytes;
        this.fc = input.getChannel();
    }

    public static FileWatcher newFileWatcher(String input, int chunkSizeBytes) {
        FileWatcher.validateInput(input, chunkSizeBytes);
        File file = new File(input);
        FileInputStream freader = null;
        try {
            freader = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " must exist!");
        }
        return new FileWatcher(freader, chunkSizeBytes);
    }

    public static FileWatcher newProgressWatcher(String input) {
        if (Util.isEmpty(input)) {
            throw new NullPointerException("Input must be provided!");
        }
        File file = new File(input);
        FileInputStream freader = null;
        try {
            freader = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage());
            throw new IllegalArgumentException("File " + file.getAbsolutePath() + " must exist!");
        }
        return new FileWatcher(freader, 3);
    }

    public boolean disconnected() {
        return this.fc == null;
    }

    public String pull() throws IOException {
        if (this.disconnected()) {
            throw new IllegalStateException("This FileWatcher has disconnected from the file. Please construct a new one.");
        }
        if (!this.hasMore()) {
            return "";
        }
        long sz = this.fc.size();
        if ((long)this.chunkSizeBytes > sz) {
            this.chunkSizeBytes = (int)sz;
        }
        if (sz < this.read) {
            throw new IllegalStateException("File has been reduced during pooling! File size is " + sz + ". While " + this.read + " bytes has been already read from this file!");
        }
        return this.read(this.read).toString();
    }

    private String read(long fromPosition) throws IOException {
        this.read = fromPosition;
        long sz = this.fc.size();
        if (this.read > 0L && sz - this.read < (long)this.chunkSizeBytes) {
            this.chunkSizeBytes = (int)(sz - this.read);
        }
        ByteBuffer bf = ByteBuffer.allocateDirect(this.chunkSizeBytes);
        this.fc.position(this.read);
        int length = this.fc.read(bf);
        bf.rewind();
        CharBuffer cb = decoder.decode(bf);
        if (length > 0) {
            this.read += (long)length;
        }
        return cb.toString();
    }

    public String pull(long position) throws IOException {
        if (this.disconnected()) {
            throw new IllegalStateException("This FileWatcher has disconnected from the file. Please construct a new one.");
        }
        long size = this.fc.size();
        if (position < 0L || position > size) {
            throw new IndexOutOfBoundsException("Position must be within 0 and file size (" + size + ") but given value is " + position);
        }
        return this.read(position);
    }

    public static void validateInput(String input, int chunkSizeBytes) {
        if (chunkSizeBytes > 0xA00000 || chunkSizeBytes < 256) {
            throw new IllegalArgumentException("chunkSize must be between 256 bytes and 10Mb. But given value is: " + chunkSizeBytes);
        }
    }

    public boolean hasMore() throws IOException {
        if (this.disconnected()) {
            throw new IllegalStateException("This FileWatcher has disconnected from the file. Please construct a new one.");
        }
        long size = this.fc.size();
        return this.read < size;
    }

    public long getCursorPosition() {
        if (this.disconnected()) {
            throw new IllegalStateException("This FileWatcher has disconnected from the file. Please construct a new one.");
        }
        return this.read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.fc != null) {
            try {
                this.fc.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
            finally {
                this.fc = null;
            }
        }
    }

    public byte getProgress() throws IOException {
        String progress = this.get3Chars();
        if (Util.isEmpty(progress)) {
            return 0;
        }
        progress = progress.trim();
        assert (progress.length() <= 3);
        return Byte.parseByte(progress);
    }

    String get3Chars() throws IOException {
        if (this.disconnected()) {
            throw new IllegalStateException("This FileWatcher has disconnected from the file. Please construct a new one.");
        }
        if (this.chunkSizeBytes > 3) {
            this.chunkSizeBytes = 3;
        }
        return this.read(0L);
    }
}

