/*
 * Decompiled with CFR 0.152.
 */
package compbio.util;

import compbio.util.FileUtil;
import compbio.util.SysPrefs;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertyHelper {
    private final Properties properties;
    private static Logger log = Logger.getLogger(PropertyHelper.class);

    public PropertyHelper(StringReader input) {
        try {
            this.properties = new Properties();
            this.properties.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException("Properties file could not be found !", e);
        }
    }

    public PropertyHelper(String ... propertyPaths) throws IOException {
        this(PropertyHelper.getReader(propertyPaths));
    }

    public PropertyHelper(File ... propertyPaths) throws IOException {
        this(PropertyHelper.getReader(propertyPaths));
    }

    private static StringReader getReader(String ... propertyPaths) throws IOException {
        String props = "";
        for (String path : propertyPaths) {
            File prop = new File(path);
            props = props + PropertyHelper.readProp(prop);
        }
        return new StringReader(props);
    }

    private static String readProp(File propFile) throws IOException {
        String props = "";
        if (propFile == null) {
            log.error("PropFile is expected!");
            return "";
        }
        if (propFile.exists() && propFile.canRead()) {
            props = props + FileUtil.readFileToString(propFile) + SysPrefs.newlinechar;
        } else {
            log.debug("Cannot read properties file: " + propFile.getAbsolutePath());
        }
        return props;
    }

    private static StringReader getReader(File ... propertyPaths) throws IOException {
        String props = "";
        assert (propertyPaths != null && propertyPaths.length > 0) : " No property files provided!";
        for (File prop : propertyPaths) {
            log.debug("Reading properties from file: " + prop.getAbsolutePath());
            props = props + PropertyHelper.readProp(prop);
        }
        return new StringReader(props);
    }

    public String getProperty(String name) {
        String property = null;
        if (property == null && this.properties != null) {
            property = this.properties.getProperty(name);
        }
        if (property == null) {
            log.warn("Properties '" + name + "' not found in file.");
        }
        return property;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

