/*
 * Decompiled with CFR 0.152.
 */
package compbio.util;

import java.util.concurrent.TimeUnit;

public class Timer {
    private long checkPoint;
    private final long startTime;
    private TimeUnit reportTimeUnit;

    public Timer() {
        this.checkPoint = this.startTime = System.nanoTime();
        this.reportTimeUnit = TimeUnit.SECONDS;
    }

    public Timer(TimeUnit reportIn) {
        this();
        this.reportTimeUnit = reportIn;
    }

    public static Timer getMicroSecondsTimer() {
        return new Timer(TimeUnit.MICROSECONDS);
    }

    public static Timer getMinutesTimer() {
        return new Timer(TimeUnit.MINUTES);
    }

    public static Timer getMilliSecondsTimer() {
        return new Timer(TimeUnit.MILLISECONDS);
    }

    private void checkPoint() {
        this.checkPoint = System.nanoTime();
    }

    public long getStepTime(TimeUnit tunit) {
        long duration = tunit.convert(System.nanoTime() - this.checkPoint, TimeUnit.NANOSECONDS);
        this.checkPoint();
        return duration;
    }

    public long getStepTime() {
        return this.getStepTime(this.reportTimeUnit);
    }

    public long getTotalTime() {
        return this.getTotalTime(this.reportTimeUnit);
    }

    public long getTotalTime(TimeUnit tunit) {
        return tunit.convert(System.nanoTime() - this.startTime, TimeUnit.NANOSECONDS);
    }
}

