/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.ClustalAlignmentUtil;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.Services;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;

public class Jws2Client {
    private static final Logger log = Logger.getLogger(Jws2Client.class.getCanonicalName());
    static final String pseparator = "=";
    static final String hostkey = "-h";
    static final String servicekey = "-s";
    static final String inputkey = "-i";
    static final String paramList = "-parameters";
    static final String presetList = "-presets";
    static final String limitList = "-limits";
    static final String paramFile = "-f";
    static final String outputkey = "-o";
    static final String parameterkey = "-p";
    static final String presetkey = "-r";
    static final String qualifiedServiceName = "http://msa.data.compbio/01/01/2010/";

    private boolean listParameters(String[] stringArray) {
        return this.keyFound(stringArray, paramList);
    }

    boolean listPresets(String[] stringArray) {
        return this.keyFound(stringArray, presetList);
    }

    <T> Preset<T> getPreset(MsaWS<T> msaWS, String string) {
        assert (string != null);
        PresetManager<T> presetManager = this.getPresetList(msaWS);
        if (presetManager == null) {
            System.out.println("No presets are supported by the service! Ignoring -r directive!");
            return null;
        }
        Preset<T> preset = presetManager.getPresetByName(string);
        if (preset == null) {
            System.out.println("Cannot find preset: " + string + " WARN: ignoring -r directive!");
        }
        return preset;
    }

    String getPresetName(String[] stringArray) {
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.trim().toLowerCase().startsWith("-r=")) continue;
            string = string2.substring(string2.indexOf(pseparator) + 1);
            break;
        }
        return string;
    }

    boolean listLimits(String[] stringArray) {
        return this.keyFound(stringArray, limitList);
    }

    boolean keyFound(String[] stringArray, String string) {
        assert (stringArray != null && stringArray.length > 0);
        assert (string != null);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string2.trim().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean validURL(String string) {
        try {
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    public static String getServiceName(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.trim().toLowerCase().startsWith("-s=")) continue;
            return string.substring(string.indexOf(pseparator) + 1);
        }
        return null;
    }

    public static String getHost(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!string.trim().toLowerCase().startsWith("-h=")) continue;
            return string.substring(string.indexOf(pseparator) + 1);
        }
        return null;
    }

    File getFile(String[] stringArray, String string, boolean bl) throws IOException {
        assert (string != null && string.trim().length() != 0);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!(string2 = string2.trim()).toLowerCase().startsWith(string + pseparator)) continue;
            string2 = string2.substring((string + pseparator).length());
            File file = new File(string2);
            if (bl && !file.exists()) {
                System.out.println(string + " file " + file.getAbsolutePath() + " does not exist");
                return null;
            }
            if (!bl && !file.exists()) {
                file.createNewFile();
            }
            if (!file.canRead()) {
                System.out.println("Cannot read " + string + " file " + file.getAbsolutePath());
                return null;
            }
            return file;
        }
        return null;
    }

    <T> Jws2Client(String[] stringArray) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Object object;
        Services services;
        String string;
        String string2 = Jws2Client.getHost(stringArray);
        if (string2 == null) {
            System.out.println("Host name is not provided!");
            Jws2Client.printUsage(1);
        }
        if (!Jws2Client.validURL(string2)) {
            System.out.println("Host name is not valid!");
            Jws2Client.printUsage(1);
        }
        if ((string = Jws2Client.getServiceName(stringArray)) == null) {
            System.out.println("Service name is no provided!");
            Jws2Client.printUsage(1);
        }
        if ((services = Services.getService(string)) == null) {
            System.out.println("Service " + string + " is no supported! Valid values are: " + Arrays.toString((Object[])Services.values()));
            Jws2Client.printUsage(1);
        }
        File file = this.getFile(stringArray, inputkey, true);
        File file2 = this.getFile(stringArray, outputkey, false);
        File file3 = this.getFile(stringArray, paramFile, true);
        String string3 = this.getPresetName(stringArray);
        MsaWS<T> msaWS = Jws2Client.connect(string2, services);
        Preset<T> preset = null;
        if (string3 != null) {
            preset = this.getPreset(msaWS, string3);
        }
        List<Option<T>> list = null;
        if (file3 != null) {
            object = this.loadParameters(file3);
            list = this.processParameters((List<String>)object, msaWS.getRunnerOptions());
        }
        object = null;
        if (file != null) {
            object = Jws2Client.align(file, msaWS, preset, list);
            OutputStream outputStream = null;
            outputStream = file2 != null ? this.getOutStream(file2) : System.out;
            this.writeOut(outputStream, (Alignment)object);
        }
        if (bl3 = this.listParameters(stringArray)) {
            System.out.println(this.getParametersList(msaWS));
        }
        if (bl2 = this.listPresets(stringArray)) {
            System.out.println(this.getPresetList(msaWS));
        }
        if (bl = this.listLimits(stringArray)) {
            System.out.println(this.getLimits(msaWS));
        }
        log.fine("Disconnecting...");
        ((Closeable)((Object)msaWS)).close();
        log.fine("Disconnected successfully!");
    }

    List<String> loadParameters(File file) throws IOException {
        assert (file != null && file.exists());
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() == 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    <T> List<Option<T>> processParameters(List<String> list, RunnerConfig<T> runnerConfig) {
        ArrayList<Option<T>> arrayList = new ArrayList<Option<T>>();
        for (String string : list) {
            String string2 = null;
            string2 = this.isParameter(string) ? this.getParamName(string) : string;
            Option<T> option = runnerConfig.getArgumentByOptionName(string2);
            if (option == null) {
                System.out.println("WARN ignoring unsuppoted parameter: " + string2);
                continue;
            }
            if (this.isParameter(string)) {
                try {
                    option.setValue(this.getParamValue(string));
                }
                catch (WrongParameterException wrongParameterException) {
                    System.out.println("Problem setting value for the parameter: " + string);
                    wrongParameterException.printStackTrace();
                }
            }
            arrayList.add(option);
        }
        return arrayList;
    }

    String getParamName(String string) {
        assert (this.isParameter(string));
        return string.substring(0, string.indexOf(pseparator));
    }

    String getParamValue(String string) {
        assert (this.isParameter(string));
        return string.substring(string.indexOf(pseparator) + 1);
    }

    boolean isParameter(String string) {
        return string.contains(pseparator);
    }

    OutputStream getOutStream(File file) {
        assert (file != null && file.exists());
        try {
            return new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOut(OutputStream outputStream, Alignment alignment) {
        try {
            ClustalAlignmentUtil.writeClustalAlignment(outputStream, alignment);
        }
        catch (IOException iOException) {
            System.err.println("Problems writing output file! Stack trace is below: ");
            iOException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static <T> MsaWS<T> connect(String string, Services services) throws WebServiceException {
        URL uRL = null;
        log.log(Level.FINE, "Attempt to connect...");
        try {
            uRL = new URL(string + "/" + services.toString() + "?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        QName qName = new QName(qualifiedServiceName, services.toString());
        Service service = Service.create(uRL, (QName)qName);
        MsaWS msaWS = (MsaWS)service.getPort(new QName(qualifiedServiceName, (Object)((Object)services) + "Port"), MsaWS.class);
        log.log(Level.FINE, "Connected successfully!");
        return msaWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Alignment align(File file, MsaWS<T> msaWS, Preset<T> preset, List<Option<T>> list) {
        FileInputStream fileInputStream = null;
        List<FastaSequence> list2 = null;
        Alignment alignment = null;
        try {
            fileInputStream = new FileInputStream(file);
            list2 = SequenceUtil.readFasta(fileInputStream);
            fileInputStream.close();
            String string = null;
            if (list != null && preset != null) {
                System.out.println("WARN: Parameters (-f) are defined together with a preset (-r) ignoring preset!");
            }
            string = list != null ? msaWS.customAlign(list2, list) : (preset != null ? msaWS.presetAlign(list2, preset) : msaWS.align(list2));
            Thread.sleep(1000L);
            alignment = msaWS.getResult(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception while reading the input file. Check that the input file contains a list of fasta formatted sequences! Exception details are below:");
            iOException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.err.println("Exception while submitting job to a web server. Exception details are below:");
            jobSubmissionException.printStackTrace();
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.err.println("Exception while waiting for results. Exception details are below:");
            resultNotAvailableException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (WrongParameterException wrongParameterException) {
            wrongParameterException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return alignment;
    }

    <T> List<Option<T>> getParametersList(MsaWS<T> msaWS) {
        assert (msaWS != null);
        return msaWS.getRunnerOptions().getArguments();
    }

    <T> PresetManager<T> getPresetList(MsaWS<T> msaWS) {
        assert (msaWS != null);
        PresetManager<T> presetManager = msaWS.getPresets();
        return presetManager;
    }

    <T> List<Limit<T>> getLimits(MsaWS<T> msaWS) {
        assert (msaWS != null);
        LimitsManager<T> limitsManager = msaWS.getLimits();
        return limitsManager != null ? limitsManager.getLimits() : null;
    }

    static void printUsage(int n) {
        System.out.println();
        System.out.println("Usage: <Class or Jar file name> -h=host_and_context -s=serviceName ACTION [OPTIONS] ");
        System.out.println();
        System.out.println("-h=<host_and_context> - a full URL to the JWS2 web server including context path e.g. http://10.31.1.159:8080/ws");
        System.out.println("-s=<ServiceName> - one of " + Arrays.toString((Object[])Services.values()));
        System.out.println();
        System.out.println("ACTIONS: ");
        System.out.println("-i=<inputFile> - full path to fasta formatted sequence file, from which to align sequences");
        System.out.println("-parameters - lists parameters supported by web service");
        System.out.println("-presets - lists presets supported by web service");
        System.out.println("-limits - lists web services limits");
        System.out.println("Please note that if input file is specified other actions are ignored");
        System.out.println();
        System.out.println("OPTIONS (only for use with -i action):");
        System.out.println("-r=<presetName> - name of the preset to use");
        System.out.println("-o=<outputFile> - full path to the file where to write an alignment");
        System.out.println("-f=<parameterInputFile> - the name of the file with the list of parameters to use.");
        System.out.println("Please note that -r and -f options cannot be used together. Alignment is done with either preset or a parameters from the file, but not both!");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        if (stringArray == null) {
            Jws2Client.printUsage(1);
        }
        if (stringArray.length < 2) {
            System.out.println("Host and service names are required!");
            Jws2Client.printUsage(1);
        }
        try {
            new Jws2Client(stringArray);
        }
        catch (IOException iOException) {
            log.log(Level.SEVERE, "IOException in client! " + iOException.getMessage(), iOException.getCause());
            System.err.println("Cannot write output file! Stack trace: ");
            iOException.printStackTrace();
        }
    }
}

