/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.client;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.SequenceUtil;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import compbio.ws.client.Jws2Client;
import compbio.ws.client.Services;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.ws.WebServiceException;

public class WSTester {
    static final String fastaInput = ">Foobar\nMTADGPRELLQLRAAVRHRPQDFVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAVARLGRVRWTQQRHAEAAVLLQQASDAAPEHPGIALWLGHALEDAGQAEAAAAAYTRAHQLLPEEPYITAQLLNWRRRLCDWRALDVLSAQVRAAVAQGVGAVEPFAFLSEDASAAEQLACARTRAQAIAASVRPLAPTRVRSKGPLRVGFVSNGFGAHPTGLLTVALFEALQRRQPDLQMHLFATSGDDGSTLRTRLAQASTLHDVTALGHLATAKHIRHHGIDLLFDLRGWGGGGRPEVFALRPAPVQVNWLAYPGTSGAPWMDYVLGDAFALPPALEPFYSEHVLRLQGAFQPSDTSRVVAEPPSRTQCGLPEQGVVLCCFNNSYKLNPQSMARMLAVLREVPDSVLWLLSGPGEADARLRAFAHAQGVDAQRLVFMPKLPHPQYLARYRHADLFLDTHPYNAHTTASDALWTGCPVLTTPGETFAARVAGSLNHHLGLDEMNVADDAAFVAKA\n>Barbar\nASDAAPEHPGIALWLHALEDAGQAEAAAAYTRAHQLLPEEPYITAQLLNAVAQGVGAVEPFAFLSEDASAAESVRPLAPTRVRSKGPLRVGFVSNGFGAHPTGLLTVALFEALQRRQPDLQMHLFATSGDDGSTLRTRLAQASTLHDVTALGHLATAKHIRHHGIDLLFDLRGWGGGGRPEVFALRPAPVQVNWLAYPGTSGAPWMDYVLGDAFALPPALEPFYSEHVLRLQGAFQPSDTSRVVAEPPSRTQCGLPEQGVVLCCFNNSYKLNPQSMARMLAVLREVPDSVLWLLSGPGEADARLRAFAHAQGVDAQRLVFMPKLPHPQYLARYRHADLFLDTHPYNAHTTASDALWTGCPVLTTPGETFAARVAGSLNHHLGLDEMNVADDAAFVAKAVALASDPAALTALHARVDVLRRESGVFEMDGFADDFGALLQALARRHGWLGI\n>Foofriend\nMTADGPRELLQLRAAVRHRPQDVAWLMLADAELGMGDTTAGEMAVQRGLALHPGHPEAVARLGRVRWTQQRHAEAAVLLQQASDAAPEHPGIALWLGHALEDHQLLPEEPYITAQLDVLSAQVRAAVAQGVGAVEPFAFLSEDASAAEQLACARTRAQAIAASVRPLAPTRVRSKGPLRVGFVSNGFGAHPTGLLTVALFEALQRRQPDLQMHLFATSGDDGSTLRTRLAQASTLHDVTALGHLATAKHIRHHGIDLLFDLRGWGGGGRPEVFALRPAPVQVNWLAYPGTSGAPWMDYVLGDAFALPPALEPFYSEHVLRLQGAFQPSDTSRVVAEPPSRTQCGLPEQGVVLCCFNNSYKLNPQSMARMLAVLREVPDSVLWLLSGPGEADARLRAFAHAQGVDAQRLVFMPKLPHPQYLARYRHADLFLDTHPYNAHTTASDALWTGCPVLTTPGETFAARVAGSLNHHLGLDEMNVADDAAFVAKAVALASDPAALTALHARVDVLRRESI\n";
    static final List<FastaSequence> seqs = WSTester.loadSeqs();
    private static final String FAILED = "FAILED";
    private static final String OK = "OK";

    static List<FastaSequence> loadSeqs() {
        try {
            return SequenceUtil.readFasta(new ByteArrayInputStream(fastaInput.getBytes()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    static void printUsage() {
        System.out.println("Usage: <Class or Jar file name> -h=host_and_context <-s=serviceName>");
        System.out.println();
        System.out.println("-h=<host_and_context> - a full URL to the JWS2 web server including context path e.g. http://10.31.1.159:8080/ws");
        System.out.println("-s=<ServiceName> - optional if unspecified all services are tested otherwise one of " + Arrays.toString((Object[])Services.values()));
        System.out.println();
    }

    static <T> boolean presetAlign(MsaWS<T> msaWS, List<Preset<T>> list) throws UnsupportedRuntimeException {
        boolean bl = false;
        for (Preset<T> preset : list) {
            System.out.print("Aligning with preset '" + preset.getName() + "'... ");
            Alignment alignment = null;
            try {
                String string = msaWS.presetAlign(seqs, preset);
                alignment = msaWS.getResult(string);
                if (alignment != null) {
                    System.out.println(OK);
                }
                bl = true;
            }
            catch (UnsupportedRuntimeException unsupportedRuntimeException) {
                System.out.println(FAILED);
                throw new UnsupportedRuntimeException(unsupportedRuntimeException);
            }
            catch (JobSubmissionException jobSubmissionException) {
                System.out.println(FAILED);
                System.out.println();
                jobSubmissionException.printStackTrace();
            }
            catch (WrongParameterException wrongParameterException) {
                System.out.println(FAILED);
                System.out.println();
                wrongParameterException.printStackTrace();
            }
            catch (ResultNotAvailableException resultNotAvailableException) {
                System.out.println(FAILED);
                System.out.println();
                resultNotAvailableException.printStackTrace();
            }
        }
        return bl;
    }

    static <T> boolean checkService(MsaWS<T> msaWS) throws UnsupportedRuntimeException {
        Object object;
        boolean bl = WSTester.testDefaultAlignment(msaWS);
        PresetManager<T> presetManager = msaWS.getPresets();
        if (presetManager != null && presetManager.getPresets().size() > 0) {
            System.out.println("Testing alignment with presets:");
            object = presetManager.getPresets();
            bl = !bl ? WSTester.presetAlign(msaWS, object) : bl;
        }
        System.out.print("Querying presets...");
        if (presetManager != null && presetManager.getPresets().size() > 0) {
            System.out.println(OK);
        } else {
            System.out.println("UNSUPPORTED");
        }
        System.out.print("Querying Parameters...");
        object = msaWS.getRunnerOptions();
        if (object != null && ((RunnerConfig)object).getArguments().size() > 0) {
            System.out.println(OK);
        } else {
            System.out.println(FAILED);
            bl = false;
        }
        System.out.print("Querying Limits...");
        LimitsManager<T> limitsManager = msaWS.getLimits();
        if (limitsManager != null && limitsManager.getLimits().size() > 0) {
            System.out.println(OK);
        } else {
            System.out.println("UNSUPPORTED");
        }
        System.out.print("Querying Local Engine Limits...");
        Limit<T> limit = msaWS.getLimit("# LocalEngineExecutionLimit #");
        if (limit != null) {
            System.out.println(OK);
        } else {
            System.out.println("UNSUPPORTED");
        }
        return bl;
    }

    static <T> boolean testDefaultAlignment(MsaWS<T> msaWS) throws UnsupportedRuntimeException {
        System.out.print("Testing alignment with default parameters:");
        Alignment alignment = null;
        boolean bl = false;
        try {
            String string = msaWS.align(seqs);
            System.out.print("\nQuerying job status...");
            JobStatus jobStatus = msaWS.getJobStatus(string);
            while (jobStatus != JobStatus.FINISHED) {
                Thread.sleep(1000L);
                jobStatus = msaWS.getJobStatus(string);
            }
            System.out.println(OK);
            System.out.print("Retrieving results...");
            alignment = msaWS.getResult(string);
            bl = true;
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            System.out.println(FAILED);
            resultNotAvailableException.printStackTrace();
        }
        catch (JobSubmissionException jobSubmissionException) {
            System.out.println(FAILED);
            System.out.println();
            jobSubmissionException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            System.out.println(FAILED);
            System.out.println();
            interruptedException.printStackTrace();
        }
        if (alignment != null) {
            System.out.println(OK);
        }
        return bl;
    }

    static <T> MsaWS<T> connect(String string, Services services) {
        MsaWS msaWS = null;
        try {
            System.out.print("Connecting to service " + (Object)((Object)services) + " on " + string + " ... ");
            msaWS = Jws2Client.connect(string, services);
            System.out.println(OK);
        }
        catch (WebServiceException webServiceException) {
            System.out.println(FAILED);
        }
        return msaWS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void main(String[] stringArray) throws IOException {
        if (stringArray == null || stringArray.length < 1) {
            WSTester.printUsage();
            System.exit(0);
        }
        String string = Jws2Client.getHost(stringArray);
        String string2 = Jws2Client.getServiceName(stringArray);
        if (!Jws2Client.validURL(string)) {
            System.out.println("<host_and_context> parameter is not provided or is incorrect!");
            System.exit(1);
        }
        boolean bl = false;
        MsaWS<T> msaWS = null;
        if (string2 != null) {
            Services[] servicesArray = Services.getService(string2);
            if (servicesArray == null) {
                System.out.println("Service '" + string2 + "' is not supported. Valid values are: " + Arrays.toString((Object[])Services.values()));
                System.out.println();
                WSTester.printUsage();
                System.exit(1);
            }
            if ((msaWS = WSTester.connect(string, (Services)servicesArray)) == null) {
                System.exit(1);
            }
            try {
                bl = WSTester.checkService(msaWS);
            }
            catch (UnsupportedRuntimeException unsupportedRuntimeException) {
                System.exit(1);
            }
            finally {
                ((Closeable)((Object)msaWS)).close();
            }
            WSTester.reportResults((Services)servicesArray, bl);
            System.exit(0);
        }
        System.out.println("<ServiceName> is not provided checking all known services...");
        for (Services services : Services.values()) {
            System.out.println();
            msaWS = WSTester.connect(string, services);
            if (msaWS == null) continue;
            try {
                bl = WSTester.checkService(msaWS);
            }
            catch (UnsupportedRuntimeException unsupportedRuntimeException) {
                System.out.println("Service " + (Object)((Object)services) + " IS NOT FUNCTIONAL");
                continue;
            }
            finally {
                ((Closeable)((Object)msaWS)).close();
            }
            WSTester.reportResults(services, bl);
        }
    }

    private static void reportResults(Services services, boolean bl) {
        if (bl) {
            System.out.println("Check is completed. The Service " + (Object)((Object)services) + " IS WORKING");
        } else {
            System.out.println("Check is completed. The Service " + (Object)((Object)services) + " HAS SOME PROBLEMS");
        }
    }
}

