/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.visitor.CpInfoVisitor;

public class FloatCpInfo
extends CpInfo {
    public int u4bytes;

    public FloatCpInfo(float f) {
        this.setValue(f);
    }

    protected FloatCpInfo() {
    }

    public float getValue() {
        return Float.intBitsToFloat(this.u4bytes);
    }

    public void setValue(float f) {
        this.u4bytes = Float.floatToIntBits(f);
    }

    public int getTag() {
        return 4;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u4bytes = dataInput.readInt();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.u4bytes);
    }

    public void accept(ClassFile classFile, CpInfoVisitor cpInfoVisitor) {
        cpInfoVisitor.visitFloatCpInfo(classFile, this);
    }
}

