/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;

public class EnclosingMethodAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 4;
    public int u2classIndex;
    public int u2nameAndTypeIndex;
    public ClassFile referencedClassFile;
    public MethodInfo referencedMethodInfo;

    protected EnclosingMethodAttrInfo() {
    }

    public String getClassName(ClassFile classFile) {
        return classFile.getCpClassNameString(this.u2classIndex);
    }

    public String getName(ClassFile classFile) {
        return classFile.getCpNameString(this.u2nameAndTypeIndex);
    }

    public String getType(ClassFile classFile) {
        return classFile.getCpTypeString(this.u2nameAndTypeIndex);
    }

    public void referencedClassAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFile != null) {
            this.referencedClassFile.accept(classFileVisitor);
        }
    }

    public void referencedMethodInfoAccept(MemberInfoVisitor memberInfoVisitor) {
        if (this.referencedMethodInfo != null) {
            this.referencedMethodInfo.accept(this.referencedClassFile, memberInfoVisitor);
        }
    }

    protected int getLength() {
        return 4;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2classIndex = dataInput.readUnsignedShort();
        this.u2nameAndTypeIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2classIndex);
        dataOutput.writeShort(this.u2nameAndTypeIndex);
    }

    public void accept(ClassFile classFile, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitEnclosingMethodAttrInfo(classFile, this);
    }
}

