/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;

public class ClassFilePresenceFilter
implements ClassFileVisitor {
    private ClassPool classPool;
    private ClassFileVisitor presentClassFileVisitor;
    private ClassFileVisitor missingClassFileVisitor;

    public ClassFilePresenceFilter(ClassPool classPool, ClassFileVisitor classFileVisitor, ClassFileVisitor classFileVisitor2) {
        this.classPool = classPool;
        this.presentClassFileVisitor = classFileVisitor;
        this.missingClassFileVisitor = classFileVisitor2;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        ClassFileVisitor classFileVisitor = this.classFileVisitor(programClassFile);
        if (classFileVisitor != null) {
            classFileVisitor.visitProgramClassFile(programClassFile);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        ClassFileVisitor classFileVisitor = this.classFileVisitor(libraryClassFile);
        if (classFileVisitor != null) {
            classFileVisitor.visitLibraryClassFile(libraryClassFile);
        }
    }

    private ClassFileVisitor classFileVisitor(ClassFile classFile) {
        return this.classPool.getClass(classFile.getName()) != null ? this.presentClassFileVisitor : this.missingClassFileVisitor;
    }
}

