/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class GenNBOReader
extends MOReader {
    private boolean isOutputFile;
    private String moType = "";
    private static String DS_LIST = "255   252   253   254   251";
    private static String DC_LIST = "201   204   206   202   203   205";
    private static String FS_LIST = "351   352   353   354   355   356   357";
    private static String FC_LIST = "301   307   310   304   302   303   306   309   308   305";

    protected void initializeReader() throws Exception {
        boolean bl;
        String string = this.readLine().trim();
        this.readLine();
        boolean bl2 = this.isOutputFile = this.line.indexOf("***") >= 0;
        if (this.isOutputFile) {
            bl = this.readFile31();
            super.initializeReader();
        } else if (this.line.indexOf("s in the AO basis:") >= 0) {
            this.moType = this.line.substring(1, this.line.indexOf("s"));
            this.atomSetCollection.setCollectionName(string + ": " + this.moType + "s");
            bl = this.readFile31();
        } else {
            this.moType = "AO";
            this.atomSetCollection.setCollectionName(string + ": " + this.moType + "s");
            bl = this.readData31(string, this.line);
        }
        if (!bl) {
            Logger.error("Unimplemented shell type -- no orbitals avaliable: " + this.line);
        }
        if (this.isOutputFile) {
            return;
        }
        if (bl) {
            this.readFile46();
            this.readOrbitalData(!this.moType.equals("AO"));
            this.setMOData(false);
            this.moData.put("isNormalized", Boolean.TRUE);
        }
        this.continuing = false;
    }

    protected boolean checkLine() throws Exception {
        return this.checkNboLine();
    }

    private String getFileData(String string) {
        String string2;
        String string3 = (String)this.htParams.get("fullPathName");
        int n = string3.lastIndexOf(".");
        if (n < 0) {
            n = string3.length();
        }
        if ((string2 = this.viewer.getFileAsString(string3 = string3.substring(0, n) + string)).length() == 0) {
            Logger.error(" supplemental file " + string3 + " was not found");
            this.continuing = false;
            return null;
        }
        return string2;
    }

    private boolean readFile31() throws Exception {
        String string = this.getFileData(".31");
        if (string == null) {
            return false;
        }
        BufferedReader bufferedReader = this.reader;
        this.reader = new BufferedReader(new StringReader(string));
        if (!this.readData31(null, null)) {
            return false;
        }
        this.reader = bufferedReader;
        return true;
    }

    private void readFile46() throws Exception {
        String string = this.getFileData(".46");
        if (string == null) {
            return;
        }
        BufferedReader bufferedReader = this.reader;
        this.reader = new BufferedReader(new StringReader(string));
        this.readData46();
        this.reader = bufferedReader;
    }

    private boolean readData31(String string, String string2) throws Exception {
        int n;
        if (string == null) {
            string = this.readLine();
        }
        if (string2 == null) {
            string2 = this.readLine();
        }
        this.readLine();
        String[] stringArray = GenNBOReader.getTokens(this.readLine());
        int n2 = this.parseInt(stringArray[0]);
        this.shellCount = this.parseInt(stringArray[1]);
        this.gaussianCount = this.parseInt(stringArray[2]);
        this.readLine();
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(this.moType + "s: " + string.trim());
        for (n = 0; n < n2; ++n) {
            stringArray = GenNBOReader.getTokens(this.readLine());
            int n3 = this.parseInt(stringArray[0]);
            if (n3 < 0) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementNumber = (short)n3;
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
        }
        this.shells = new ArrayList();
        this.gaussians = new float[this.gaussianCount][];
        for (n = 0; n < this.gaussianCount; ++n) {
            this.gaussians[n] = new float[5];
        }
        this.readLine();
        this.nOrbitals = 0;
        for (n = 0; n < this.shellCount; ++n) {
            stringArray = GenNBOReader.getTokens(this.readLine());
            int[] nArray = new int[4];
            nArray[0] = this.parseInt(stringArray[0]) - 1;
            int n4 = this.parseInt(stringArray[1]);
            this.nOrbitals += n4;
            this.line = this.readLine().trim();
            switch (n4) {
                case 1: {
                    nArray[1] = 0;
                    break;
                }
                case 3: {
                    if (!"101   102   103".equals(this.line)) {
                        return false;
                    }
                    nArray[1] = 1;
                    break;
                }
                case 4: {
                    if (!"1   101   102   103".equals(this.line)) {
                        return false;
                    }
                    nArray[1] = 2;
                    break;
                }
                case 5: {
                    if (!this.getDFMap(this.line, 3, DS_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = 3;
                    break;
                }
                case 6: {
                    if (!this.getDFMap(this.line, 4, DC_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = 4;
                    break;
                }
                case 7: {
                    if (!this.getDFMap(this.line, 5, FS_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = 5;
                    break;
                }
                case 10: {
                    if (!this.getDFMap(this.line, 6, FC_LIST, 3)) {
                        return false;
                    }
                    nArray[1] = 6;
                }
            }
            nArray[2] = this.parseInt(stringArray[2]) - 1;
            nArray[3] = this.parseInt(stringArray[3]);
            this.shells.add(nArray);
        }
        for (n = 0; n < 5; ++n) {
            this.readLine();
            float[] fArray = new float[this.gaussianCount];
            this.fillFloatArray(fArray);
            for (int i = 0; i < this.gaussianCount; ++i) {
                this.gaussians[i][n] = fArray[i];
            }
        }
        if (Logger.debugging) {
            Logger.debug(this.shells.size() + " slater shells read");
            Logger.debug(this.gaussians.length + " gaussian primitives read");
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean readData46() throws Exception {
        int n;
        String[] stringArray = GenNBOReader.getTokens(this.readLine());
        if (this.parseInt(stringArray[1]) != this.nOrbitals) {
            Logger.error("file 46 number of orbitals does not match nOrbitals: " + this.nOrbitals);
            return false;
        }
        String string = null;
        if (this.moType.equals("AO")) {
            string = "AO";
        } else if (this.moType.indexOf("NHO") >= 0) {
            string = "NHO";
        } else if (this.moType.indexOf("NBO") >= 0) {
            string = "NBO";
        } else if (this.moType.indexOf("NAO") >= 0) {
            string = "NAO";
        } else if (this.moType.indexOf("MO") >= 0) {
            string = "MO";
        }
        if (string == null) {
            Logger.error("uninterpretable type " + this.moType);
            return false;
        }
        if (!string.equals("AO")) {
            this.discardLinesUntilContains(string.equals("MO") ? "NBO" : string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && this.line.indexOf("O    ") < 0) {
            stringBuffer.append(this.line);
        }
        stringBuffer.append(' ');
        String string2 = stringBuffer.toString();
        int n2 = string2.length() - 1;
        stringBuffer = new StringBuffer();
        block5: for (n = 0; n < n2; ++n) {
            char c = string2.charAt(n);
            switch (c) {
                case '(': 
                case '-': {
                    if (string2.charAt(n + 1) != ' ') break;
                    ++n;
                    break;
                }
                case ' ': {
                    if (Character.isDigit(string2.charAt(n + 1)) || string2.charAt(n + 1) == '(') continue block5;
                }
            }
            stringBuffer.append(c);
        }
        Logger.info(stringBuffer.toString());
        stringArray = GenNBOReader.getTokens(stringBuffer.toString());
        for (n = 0; n < stringArray.length; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            this.setMO(hashtable);
        }
        if (string.equals("MO")) {
            return true;
        }
        n = 0;
        while (n < stringArray.length) {
            Map map = (Map)this.orbitals.get(n);
            String string3 = stringArray[n];
            map.put("type", this.moType + " " + string3);
            map.put("occupancy", new Float(string3.indexOf("*") >= 0 ? 0.0f : 2.0f));
            ++n;
        }
        return true;
    }

    private void readOrbitalData(boolean bl) throws Exception {
        if (bl) {
            this.readLine();
        }
        int n = this.nOrbitals;
        this.nOrbitals = this.orbitals.size();
        for (int i = 0; i < this.nOrbitals; ++i) {
            Map map = (Map)this.orbitals.get(i);
            float[] fArray = new float[n];
            map.put("coefficients", fArray);
            if (bl) {
                this.fillFloatArray(fArray);
                continue;
            }
            fArray[i] = 1.0f;
        }
    }
}

