/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.SpartanArchive;
import org.jmol.adapter.readers.quantum.SpartanInputReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends SpartanInputReader {
    private boolean iHaveModelStatement = false;
    boolean isCompoundDocument = false;
    private String endCheck = "END Directory Entry ";
    private Map<String, Object> moData = new Hashtable<String, Object>();
    private String title;
    SpartanArchive spartanArchive;
    Map<String, String> titles;

    protected void initializeReader() throws Exception {
        this.modelName = "Spartan file";
        this.isCompoundDocument = this.readLine().indexOf("Compound Document File Directory") >= 0;
    }

    protected boolean checkLine() throws Exception {
        String string;
        if (this.isCompoundDocument && (string = this.line.toLowerCase()).equals("begin directory entry molecule") || this.line.indexOf("JMOL_MODEL") >= 0 && !this.line.startsWith("END")) {
            if (this.modelNumber > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            this.iHaveModelStatement = true;
            int n = this.getModelNumber();
            this.modelNumber = this.bsModels == null && n != Integer.MIN_VALUE ? n : this.modelNumber + 1;
            this.bondData = "";
            if (!this.doGetModel(this.modelNumber)) {
                return this.checkLastModel();
            }
            this.atomSetCollection.newAtomSet();
            this.moData = new Hashtable<String, Object>();
            this.moData.put("isNormalized", Boolean.TRUE);
            if (n == Integer.MIN_VALUE) {
                n = this.modelNumber;
                this.title = "Model " + n;
            } else {
                this.title = this.titles.get("Title" + n);
                this.title = "Profile " + n + (this.title == null ? "" : ": " + this.title);
            }
            Logger.info(this.title);
            this.atomSetCollection.setAtomSetName(this.title);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.FALSE);
            this.atomSetCollection.setAtomSetNumber(n);
            if (this.isCompoundDocument) {
                this.readTransform();
            }
            return true;
        }
        if (this.iHaveModelStatement && !this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("BEGIN") == 0) {
            string = this.line.toLowerCase();
            if (string.endsWith("input")) {
                this.bondData = "";
                this.readInputRecords();
                if (this.atomSetCollection.errorMessage != null) {
                    this.continuing = false;
                    return false;
                }
                if (this.title != null) {
                    this.atomSetCollection.setAtomSetName(this.title);
                }
                if (this.filter != null && this.filter.toLowerCase().indexOf("input") >= 0) {
                    this.continuing = false;
                    return false;
                }
            } else {
                if (string.endsWith("_output")) {
                    return true;
                }
                if (string.endsWith("output")) {
                    this.readOutput();
                    return false;
                }
                if (string.endsWith("molecule") || string.endsWith("molecule:asbinarystring")) {
                    this.readTransform();
                    return false;
                }
                if (string.endsWith("proparc") || string.endsWith("propertyarchive")) {
                    this.readProperties();
                    return false;
                }
                if (string.endsWith("archive")) {
                    this.readArchive();
                    return false;
                }
            }
            return true;
        }
        if (this.line.indexOf("5D shell") >= 0) {
            this.calculationType = this.line;
            this.moData.put("calculationType", this.calculationType);
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        super.finalizeReader();
        if (this.atomCount > 0 && this.spartanArchive != null && this.atomSetCollection.getBondCount() == 0 && this.bondData != null) {
            this.spartanArchive.addBonds(this.bondData, 0);
        }
    }

    private void readTransform() throws Exception {
        int n;
        String string = this.readLine();
        String[] stringArray = SpartanSmolReader.getTokens(string.trim());
        if (stringArray.length < 16) {
            return;
        }
        byte[] byArray = new byte[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            byArray[n] = (byte)Integer.parseInt(stringArray[n], 16);
        }
        float[] fArray = new float[16];
        n = 16;
        int n2 = byArray.length;
        while (--n >= 0) {
            fArray[n] = this.bytesToDoubleToFloat(byArray, n2);
            n2 -= 8;
        }
        this.setTransform(fArray[0], fArray[1], fArray[2], fArray[4], fArray[5], fArray[6], fArray[8], fArray[9], fArray[10]);
    }

    private float bytesToDoubleToFloat(byte[] byArray, int n) {
        double d = Double.longBitsToDouble(((long)byArray[--n] & 0xFFL) << 56 | ((long)byArray[--n] & 0xFFL) << 48 | ((long)byArray[--n] & 0xFFL) << 40 | ((long)byArray[--n] & 0xFFL) << 32 | ((long)byArray[--n] & 0xFFL) << 24 | ((long)byArray[--n] & 0xFFL) << 16 | ((long)byArray[--n] & 0xFFL) << 8 | (long)byArray[--n] & 0xFFL);
        return (float)d;
    }

    private void readOutput() throws Exception {
        this.titles = new Hashtable<String, String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (this.readLine() != null && !this.line.startsWith("END ")) {
            stringBuffer.append(this.line).append("\n");
            int n = this.line.indexOf(")");
            if (n <= 0) continue;
            this.titles.put("Title" + this.parseInt(this.line.substring(0, n)), this.line.substring(n + 1).trim());
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", stringBuffer.toString());
    }

    private void readArchive() throws Exception {
        this.spartanArchive = new SpartanArchive(this, this.atomSetCollection, this.moData, this.bondData, this.endCheck);
        if (this.readArchiveHeader()) {
            this.modelAtomCount = this.spartanArchive.readArchive(this.line, false, this.atomCount, false);
            if (this.atomCount == 0 || !this.isTrajectory) {
                this.atomCount += this.modelAtomCount;
            }
        }
    }

    private void readProperties() throws Exception {
        if (this.spartanArchive == null) {
            this.readLine();
            return;
        }
        this.spartanArchive.readProperties();
        boolean bl = false;
        if (this.filter != null && this.filter.toLowerCase().indexOf("espcharges") >= 0) {
            bl = this.atomSetCollection.setAtomSetCollectionPartialCharges("ESPCHARGES");
        }
        if (!bl && !this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES")) {
            this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES");
        }
        Float f = (Float)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("HOMO_N");
        if (this.moData != null && f != null) {
            this.moData.put("HOMO", f.intValue());
        }
        this.readLine();
    }

    private int getModelNumber() {
        try {
            int n = this.line.indexOf("JMOL_MODEL ") + 11;
            return this.parseInt(this.line, n);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private boolean readArchiveHeader() throws Exception {
        String string = this.readLine();
        Logger.debug(string);
        if (string.indexOf("Error:") == 0) {
            return false;
        }
        this.atomSetCollection.setCollectionName(string);
        this.modelName = this.readLine();
        Logger.debug(this.modelName);
        this.readLine();
        return true;
    }
}

