/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlChem3dReader
extends XmlReader {
    String[] chem3dImplementedAttributes = new String[]{"id", "symbol", "cartCoords", "bondAtom1", "bondAtom2", "bondOrder", "gridDatXDim", "gridDatYDim", "gridDatZDim", "gridDatXSize", "gridDatYSize", "gridDatZSize", "gridDatOrigin", "gridDatDat", "calcPartialCharges", "calcAtoms"};

    XmlChem3dReader() {
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.parent = xmlReader;
        this.reader = bufferedReader;
        this.atomSetCollection = atomSetCollection;
        new Chem3dHandler(xMLReader);
        this.parseReaderXML(xMLReader);
    }

    @Override
    protected void processXml(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, JSObject jSObject) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.chem3dImplementedAttributes;
        new Chem3dHandler().walkDOMTree(jSObject);
    }

    @Override
    public void processStartElement(String string, String string2, String string3, Map<String, String> map) {
        int n;
        String[] stringArray;
        if ("model".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string2)) {
            this.atom = new Atom();
            this.atom.atomName = map.get("id");
            this.atom.elementSymbol = map.get("symbol");
            if (map.containsKey("cartCoords")) {
                String string4 = map.get("cartCoords");
                String[] stringArray2 = XmlChem3dReader.getTokens(string4);
                this.atom.set(this.parseFloat(stringArray2[0]), this.parseFloat(stringArray2[1]), this.parseFloat(stringArray2[2]));
            }
            return;
        }
        if ("bond".equals(string2)) {
            String string5 = map.get("bondAtom1");
            String string6 = map.get("bondAtom2");
            int n2 = 1;
            if (map.containsKey("bondOrder")) {
                n2 = this.parseInt(map.get("bondOrder"));
            }
            this.atomSetCollection.addNewBond(string5, string6, n2);
            return;
        }
        if ("electronicStructureCalculation".equals(string2)) {
            stringArray = XmlChem3dReader.getTokens(map.get("calcPartialCharges"));
            String[] stringArray3 = XmlChem3dReader.getTokens(map.get("calcAtoms"));
            n = this.parseInt(stringArray[0]);
            while (--n >= 0) {
                this.atomSetCollection.mapPartialCharge(stringArray3[n + 1], this.parseFloat(stringArray[n + 1]));
            }
        }
        if ("gridData".equals(string2)) {
            this.atomSetCollection.newVolumeData();
            int n3 = this.parseInt(map.get("gridDatXDim"));
            n = this.parseInt(map.get("gridDatYDim"));
            int n4 = this.parseInt(map.get("gridDatZDim"));
            this.atomSetCollection.setVoxelCounts(n3, n, n4);
            float f = this.parseFloat(map.get("gridDatXSize")) / (float)n3;
            float f2 = this.parseFloat(map.get("gridDatYSize")) / (float)n;
            float f3 = this.parseFloat(map.get("gridDatZSize")) / (float)n4;
            this.atomSetCollection.setVolumetricVector(0, f, 0.0f, 0.0f);
            this.atomSetCollection.setVolumetricVector(1, 0.0f, f2, 0.0f);
            this.atomSetCollection.setVolumetricVector(2, 0.0f, 0.0f, f3);
            stringArray = XmlChem3dReader.getTokens(map.get("gridDatOrigin"));
            this.atomSetCollection.setVolumetricOrigin(this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
            stringArray = XmlChem3dReader.getTokens(map.get("gridDatData"));
            int n5 = this.parseInt(stringArray[0]);
            int n6 = 1;
            float[][][] fArray = new float[n3][n][n4];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n; ++j) {
                    for (int k = 0; k < n3; ++k) {
                        fArray[k][j][i] = this.parseFloat(stringArray[n6++]);
                    }
                }
            }
            this.atomSetCollection.setVoxelData(fArray);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("surfaceDataType", "mo");
            hashtable.put("defaultCutoff", Float.valueOf(0.01f));
            hashtable.put("nCubeData", n5);
            hashtable.put("volumeData", this.atomSetCollection.getVolumeData());
            this.atomSetCollection.setAtomSetAuxiliaryInfo("jmolSurfaceInfo", hashtable);
            Logger.debug("Chem3D molecular orbital data displayable using:  isosurface sign \"\" ");
            return;
        }
    }

    @Override
    public void processEndElement(String string, String string2, String string3) {
        if ("atom".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class Chem3dHandler
    extends XmlReader.JmolXmlHandler {
        Chem3dHandler() {
            super(XmlChem3dReader.this);
        }

        Chem3dHandler(XMLReader xMLReader) {
            super(XmlChem3dReader.this);
            this.setHandler(xMLReader, this);
        }
    }
}

