/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Tuple3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Measurement;
import org.jmol.script.Token;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelToken {
    private String text;
    private String key;
    private float[] data;
    private int tok;
    private int pt = -1;
    private char ch1;
    private int width;
    private int precision = Integer.MAX_VALUE;
    private boolean alignLeft;
    private boolean zeroPad;
    private boolean intAsFloat;
    private static final String labelTokenParams = "AaBbCcDEefGgIiLlMmNnoPpQqRrSsTtUuVvWXxYyZz%%%gqW";
    private static final int[] labelTokenIds = new int[]{1087373315, 1087375362, 1087375361, 1112541198, 1632634889, 0x40D00004, 1095761923, 1087373322, 1087375365, 1112539142, 1095761931, 103, 1112541194, 1095763969, 1095761936, 1095763976, 1095766028, 1087373319, 1095761934, 1087373318, 1089470478, 1112541195, 1112539143, 81, 1129318401, 1095761937, 114, 1095761938, 0x40D00004, 1112539144, 1112541198, 1087373321, 1112539145, 1112541199, 1146095630, 87, 1112541188, 1112541185, 1112541189, 1112541186, 1112541190, 1112541187, 1115297793, 1113200642, 1113198595, 1113198596, 1113198597, 1113200646, 1113200647, 1113200649, 1113200650, 1113200652, 1650071565, 1113200654, 1112539137, 1112539138, 1095761922, 1095761924, 1766856708, 1095761930, 1112539139, 1229984263, 1288701960, 1826248716, 1095761933, 1112539140, 1112539141, 1095761935, 1716520972, 1666189314, 1114638349, 1087373323, 1087373320, 1113200651, 1641025539, 1095761939, 1087373324, 1087375373, 1112539146, 1112539147, 1112539148, 1112539149, 1095763988, 1112541200, 1112541201, 1112541202, 1313866247, 1146093581, 1146095627, 1146095626, 1146095628, 1112541191, 1112541192, 1112541193};
    private static final String twoCharLabelTokenParams = "fuv";
    private static final int[] twoCharLabelTokenIds = new int[]{1112541188, 1112541189, 1112541190, 1112539147, 1112539148, 1112539149, 1112541200, 1112541201, 1112541202};
    public static final String STANDARD_LABEL = "%[identify]";

    private static boolean isLabelPropertyTok(int n) {
        int n2 = labelTokenIds.length;
        while (--n2 >= 0) {
            if (labelTokenIds[n2] != n) continue;
            return true;
        }
        return false;
    }

    private LabelToken(String string) {
        this.text = string;
    }

    private LabelToken(int n) {
        this.pt = n;
    }

    public static LabelToken[] compile(Viewer viewer, String string, char c, Map<String, Object> map) {
        int n;
        if (string.indexOf("%") < 0 || string.length() < 2) {
            return new LabelToken[]{new LabelToken(string)};
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = string.length();
        while (++n3 < n4 && (n3 = string.indexOf(37, n3)) >= 0) {
            ++n2;
        }
        LabelToken[] labelTokenArray = new LabelToken[n2 * 2 + 1];
        int n5 = 0;
        n3 = 0;
        while ((n = string.indexOf(37, n3)) >= 0) {
            if (n3 != n) {
                labelTokenArray[n5++] = new LabelToken(string.substring(n3, n));
            }
            int n6 = n5++;
            LabelToken labelToken = new LabelToken(n);
            labelTokenArray[n6] = labelToken;
            LabelToken labelToken2 = labelToken;
            viewer.autoCalculate(labelToken2.tok);
            n3 = LabelToken.setToken(viewer, string, labelToken2, n4, c, map);
        }
        if (n3 < n4) {
            labelTokenArray[n5++] = new LabelToken(string.substring(n3));
        }
        return labelTokenArray;
    }

    private static int setToken(Viewer viewer, String string, LabelToken labelToken, int n, int n2, Map<String, Object> map) {
        char c;
        int n3 = labelToken.pt + 1;
        if (string.charAt(n3) == '-') {
            labelToken.alignLeft = true;
            ++n3;
        }
        if (string.charAt(n3) == '0') {
            labelToken.zeroPad = true;
            ++n3;
        }
        while (Character.isDigit(c = string.charAt(n3))) {
            labelToken.width = 10 * labelToken.width + (c - 48);
            ++n3;
        }
        labelToken.precision = Integer.MAX_VALUE;
        boolean bl = false;
        if (string.charAt(n3) == '.') {
            if ((c = string.charAt(++n3)) == '-') {
                bl = true;
                ++n3;
            }
            if (Character.isDigit(c = string.charAt(n3))) {
                labelToken.precision = c - 48;
                if (bl) {
                    labelToken.precision = -1 - labelToken.precision;
                }
                ++n3;
            }
        }
        if (map != null) {
            for (String string2 : map.keySet()) {
                if (string.indexOf(string2) != n3) continue;
                labelToken.key = string2;
                return n3 + string2.length();
            }
        }
        c = string.charAt(n3++);
        switch (c) {
            case '%': {
                labelToken.text = "%";
                return n3;
            }
            case '[': {
                String string2;
                int n4 = string.indexOf(93, n3);
                if (n4 < n3) {
                    n3 = n;
                    break;
                }
                string2 = string.substring(n3, n4).toLowerCase();
                if (string2.startsWith("property_")) {
                    labelToken.text = string2;
                    labelToken.tok = 135270407;
                    labelToken.data = viewer.getDataFloat(labelToken.text);
                } else {
                    Token token = Token.getTokenFromName(string2);
                    if (token != null && LabelToken.isLabelPropertyTok(token.tok)) {
                        labelToken.tok = token.tok;
                    }
                }
                n3 = n4 + 1;
                break;
            }
            case '{': {
                int n5 = string.indexOf(125, n3);
                if (n5 < n3) {
                    n3 = n;
                    break;
                }
                labelToken.text = string.substring(n3, n5);
                labelToken.tok = 135270407;
                labelToken.data = viewer.getDataFloat(labelToken.text);
                n3 = n5 + 1;
                break;
            }
            default: {
                int n6;
                int n7;
                if (n3 < n && (n7 = twoCharLabelTokenParams.indexOf(c)) >= 0 && (n6 = "xyz".indexOf(string.charAt(n3))) >= 0) {
                    labelToken.tok = twoCharLabelTokenIds[n7 * 3 + n6];
                    ++n3;
                    break;
                }
                n7 = labelTokenParams.indexOf(c);
                if (n7 < 0) break;
                labelToken.tok = labelTokenIds[n7];
            }
        }
        labelToken.text = string.substring(labelToken.pt, n3);
        if (n2 != 0 && n3 < n && Character.isDigit(c = string.charAt(n3))) {
            ++n3;
            labelToken.ch1 = c;
            if (c != n2 && n2 != 1) {
                labelToken.tok = 0;
            }
        }
        return n3;
    }

    public static String formatLabel(Viewer viewer, Atom atom, String string) {
        return LabelToken.formatLabel(viewer, atom, string, null, '\u0000', null);
    }

    public static String formatLabel(Viewer viewer, Atom atom, String string, LabelToken[] labelTokenArray, char c, int[] nArray) {
        LabelToken labelToken;
        StringBuffer stringBuffer;
        if (atom == null || labelTokenArray == null && (string == null || string.length() == 0)) {
            return null;
        }
        StringBuffer stringBuffer2 = stringBuffer = c > '0' ? null : new StringBuffer();
        if (labelTokenArray == null) {
            labelTokenArray = LabelToken.compile(viewer, string, c, null);
        }
        for (int i = 0; i < labelTokenArray.length && (labelToken = labelTokenArray[i]) != null; ++i) {
            if (c > '0' && labelToken.ch1 != c) continue;
            if (labelToken.tok <= 0 || labelToken.key != null) {
                if (stringBuffer == null) continue;
                stringBuffer.append(labelToken.text);
                if (labelToken.ch1 == '\u0000') continue;
                stringBuffer.append(labelToken.ch1);
                continue;
            }
            LabelToken.appendAtomTokenValue(viewer, atom, labelToken, stringBuffer, nArray);
        }
        return stringBuffer == null ? null : stringBuffer.toString().intern();
    }

    private static void appendAtomTokenValue(Viewer viewer, Atom atom, LabelToken labelToken, StringBuffer stringBuffer, int[] nArray) {
        String string = null;
        float f = Float.NaN;
        Tuple3f tuple3f = null;
        try {
            block1 : switch (labelToken.tok) {
                case 1095761923: {
                    string = "" + (nArray == null ? atom.index : nArray[atom.index]);
                    break;
                }
                case 1766856708: {
                    tuple3f = Atom.atomPropertyTuple(atom, labelToken.tok);
                    break;
                }
                case 135270407: {
                    f = labelToken.data != null ? labelToken.data[atom.index] : Float.NaN;
                    break;
                }
                case 1632634889: {
                    int n = atom.getFormalCharge();
                    if (n > 0) {
                        string = "" + n + "+";
                        break;
                    }
                    if (n < 0) {
                        string = "" + -n + "-";
                        break;
                    }
                    string = "";
                    break;
                }
                case 103: {
                    string = "" + atom.getSelectedGroupIndexWithinChain();
                    break;
                }
                case 1095766028: {
                    string = atom.getModelNumberForLabel();
                    break;
                }
                case 1129318401: {
                    string = "" + Atom.atomPropertyInt(atom, labelToken.tok);
                    break;
                }
                case 81: {
                    f = (float)atom.getOccupancy100() / 100.0f;
                    break;
                }
                case 1666189314: {
                    f = Atom.atomPropertyFloat(viewer, atom, labelToken.tok);
                    break;
                }
                case 114: {
                    string = atom.getSeqcodeString();
                    break;
                }
                case 1087373324: {
                    string = atom.getStructureId();
                    break;
                }
                case 1095761939: {
                    int n = atom.getStrucNo();
                    string = n <= 0 ? "" : "" + n;
                    break;
                }
                case 1112539144: {
                    f = atom.getGroupParameter(1112539144);
                    if (Float.isNaN(f)) {
                        string = "null";
                    }
                    break;
                }
                case 1641025539: {
                    string = Atom.atomPropertyString(viewer, atom, labelToken.tok);
                    break;
                }
                case 87: {
                    string = atom.getIdentityXYZ(false);
                    break;
                }
                default: {
                    switch (labelToken.tok & 0x43D00000) {
                        case 1095761920: {
                            if (labelToken.intAsFloat) {
                                f = Atom.atomPropertyInt(atom, labelToken.tok);
                                break block1;
                            }
                            string = "" + Atom.atomPropertyInt(atom, labelToken.tok);
                            break block1;
                        }
                        case 1112539136: {
                            f = Atom.atomPropertyFloat(viewer, atom, labelToken.tok);
                            break block1;
                        }
                        case 0x40D00000: {
                            string = Atom.atomPropertyString(viewer, atom, labelToken.tok);
                            break block1;
                        }
                        case 0x40500000: {
                            tuple3f = Atom.atomPropertyTuple(atom, labelToken.tok);
                        }
                    }
                    break;
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            f = Float.NaN;
            string = null;
            tuple3f = null;
        }
        string = labelToken.format(f, string, tuple3f);
        if (stringBuffer == null) {
            labelToken.text = string;
        } else {
            stringBuffer.append(string);
        }
    }

    public static Map<String, Object> getBondLabelValues() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("#", "");
        hashtable.put("ORDER", "");
        hashtable.put("TYPE", "");
        hashtable.put("LENGTH", new Float(0.0f));
        hashtable.put("ENERGY", new Float(0.0f));
        return hashtable;
    }

    public static String formatLabel(Viewer viewer, Bond bond, LabelToken[] labelTokenArray, Map<String, Object> map, int[] nArray) {
        map.put("#", "" + (bond.index + 1));
        map.put("ORDER", "" + bond.getOrderNumberAsString());
        map.put("TYPE", bond.getOrderName());
        map.put("LENGTH", new Float(bond.atom1.distance(bond.atom2)));
        map.put("ENERGY", new Float(bond.getEnergy()));
        LabelToken.setValues(labelTokenArray, map);
        LabelToken.formatLabel(viewer, bond.atom1, null, labelTokenArray, '1', nArray);
        LabelToken.formatLabel(viewer, bond.atom2, null, labelTokenArray, '2', nArray);
        return LabelToken.getLabel(labelTokenArray);
    }

    public static String formatLabel(Viewer viewer, Measurement measurement, String string, float f, String string2) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("#", "" + (measurement.getIndex() + 1));
        hashtable.put("VALUE", new Float(f));
        hashtable.put("UNITS", string2);
        LabelToken[] labelTokenArray = LabelToken.compile(viewer, string, '\u0001', hashtable);
        LabelToken.setValues(labelTokenArray, hashtable);
        Atom[] atomArray = measurement.modelSet.atoms;
        int[] nArray = measurement.getCountPlusIndices();
        for (int i = nArray[0]; i >= 1; --i) {
            if (nArray[i] < 0) continue;
            LabelToken.formatLabel(viewer, atomArray[nArray[i]], null, labelTokenArray, (char)(48 + i), null);
        }
        string = LabelToken.getLabel(labelTokenArray);
        return string == null ? "" : string;
    }

    private String format(float f, String string, Tuple3f tuple3f) {
        if (!Float.isNaN(f)) {
            return TextFormat.format(f, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (string != null) {
            return TextFormat.format(string, this.width, this.precision, this.alignLeft, this.zeroPad);
        }
        if (tuple3f != null) {
            if (this.width == 0 && this.precision == Integer.MAX_VALUE) {
                this.width = 6;
                this.precision = 2;
            }
            return TextFormat.format(tuple3f.x, this.width, this.precision, false, false) + TextFormat.format(tuple3f.y, this.width, this.precision, false, false) + TextFormat.format(tuple3f.z, this.width, this.precision, false, false);
        }
        return this.text;
    }

    public static void setValues(LabelToken[] labelTokenArray, Map<String, Object> map) {
        LabelToken labelToken;
        for (int i = 0; i < labelTokenArray.length && (labelToken = labelTokenArray[i]) != null; ++i) {
            if (labelToken.key == null) continue;
            Object object = map.get(labelToken.key);
            labelToken.text = object instanceof Float ? labelToken.format(((Float)object).floatValue(), null, null) : labelToken.format(Float.NaN, (String)object, null);
        }
    }

    public static String getLabel(LabelToken[] labelTokenArray) {
        LabelToken labelToken;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < labelTokenArray.length && (labelToken = labelTokenArray[i]) != null; ++i) {
            stringBuffer.append(labelToken.text);
        }
        return stringBuffer.toString();
    }
}

