/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jmol.modelset.Atom;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.modelsetbio.Turn;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.OutputStringBuffer;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphaPolymer
extends BioPolymer {
    static final byte CODE_NADA = 0;
    static final byte CODE_RIGHT_HELIX = 1;
    static final byte CODE_BETA_SHEET = 2;
    static final byte CODE_LEFT_HELIX = 3;
    static final byte CODE_LEFT_TURN = 4;
    static final byte CODE_RIGHT_TURN = 5;
    static final byte TAG_NADA = 0;
    static final byte TAG_TURN = 1;
    static final byte TAG_SHEET = 2;
    static final byte TAG_HELIX = 3;

    AlphaPolymer(Monomer[] monomerArray) {
        super(monomerArray);
    }

    @Override
    public void addSecondaryStructure(byte by, String string, int n, int n2, char c, int n3, char c2, int n4) {
        int n5;
        int n6 = this.getIndex(c, n3);
        if (n6 == -1 || (n5 = this.getIndex(c2, n4)) == -1) {
            return;
        }
        this.addSecondaryStructure(by, string, n, n2, n6, n5);
    }

    void addSecondaryStructure(byte by, String string, int n, int n2, int n3, int n4) {
        if (n4 < n3) {
            Logger.error("AlphaPolymer:addSecondaryStructure error:  indexStart:" + n3 + " indexEnd:" + n4);
            return;
        }
        int n5 = n4 - n3 + 1;
        ProteinStructure proteinStructure = null;
        switch (by) {
            case 3: {
                proteinStructure = new Helix(this, n3, n5, 0);
                break;
            }
            case 2: {
                proteinStructure = new Sheet(this, n3, n5, 0);
                break;
            }
            case 1: {
                proteinStructure = new Turn(this, n3, n5, 0);
                break;
            }
            default: {
                Logger.error("unrecognized secondary structure type");
                return;
            }
        }
        proteinStructure.structureID = string;
        proteinStructure.serialID = n;
        proteinStructure.strandCount = n2;
        for (int i = n3; i <= n4; ++i) {
            this.monomers[i].setStructure(proteinStructure);
        }
    }

    void calcHydrogenBonds() {
    }

    @Override
    public void calculateStructures() {
        if (this.monomerCount < 4) {
            return;
        }
        float[] fArray = this.calculateAnglesInDegrees();
        byte[] byArray = this.calculateCodes(fArray);
        this.checkBetaSheetAlphaHelixOverlap(byArray, fArray);
        byte[] byArray2 = this.calculateRunsFourOrMore(byArray);
        this.extendRuns(byArray2);
        this.searchForTurns(byArray, fArray, byArray2);
        this.addStructuresFromTags(byArray2);
    }

    float[] calculateAnglesInDegrees() {
        float[] fArray = new float[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            fArray[n] = Measure.computeTorsion(this.monomers[n - 2].getLeadAtom(), this.monomers[n - 1].getLeadAtom(), this.monomers[n].getLeadAtom(), this.monomers[n + 1].getLeadAtom(), true);
        }
        return fArray;
    }

    byte[] calculateCodes(float[] fArray) {
        byte[] byArray = new byte[this.monomerCount];
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            float f = fArray[n];
            byArray[n] = f >= 10.0f && f < 120.0f ? 1 : (f >= 120.0f || f < -90.0f ? 2 : (f >= -90.0f && f < 0.0f ? 3 : 0));
        }
        return byArray;
    }

    void checkBetaSheetAlphaHelixOverlap(byte[] byArray, float[] fArray) {
        int n = this.monomerCount - 2;
        while (--n >= 2) {
            if (byArray[n] != 2 || !(fArray[n] <= 140.0f) || byArray[n - 2] != 1 || byArray[n - 1] != 1 || byArray[n + 1] != 1 || byArray[n + 2] != 1) continue;
            byArray[n] = 1;
        }
    }

    byte[] calculateRunsFourOrMore(byte[] byArray) {
        byte[] byArray2 = new byte[this.monomerCount];
        int n = 0;
        byte by = 0;
        int n2 = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (byArray[i] == by && by != 0 && by != 2) {
                if (++n2 == 4) {
                    n = by == 2 ? 2 : 3;
                    int n3 = 4;
                    while (--n3 >= 0) {
                        byArray2[i - n3] = n;
                    }
                    continue;
                }
                if (n2 <= 4) continue;
                byArray2[i] = n;
                continue;
            }
            n2 = 1;
            by = byArray[i];
        }
        return byArray2;
    }

    void extendRuns(byte[] byArray) {
        for (int i = 1; i < this.monomerCount - 4; ++i) {
            if (byArray[i] != 0 || byArray[i + 1] == 0) continue;
            byArray[i] = byArray[i + 1];
        }
        byArray[0] = byArray[1];
        byArray[this.monomerCount - 1] = byArray[this.monomerCount - 2];
    }

    void searchForTurns(byte[] byArray, float[] fArray, byte[] byArray2) {
        int n = this.monomerCount - 1;
        while (--n >= 2) {
            byArray[n] = 0;
            if (byArray2[n] != 0) continue;
            float f = fArray[n];
            if (f >= -90.0f && f < 0.0f) {
                byArray[n] = 4;
                continue;
            }
            if (!(f >= 0.0f) || !(f < 90.0f)) continue;
            byArray[n] = 5;
        }
        n = this.monomerCount - 1;
        while (--n >= 0) {
            if (byArray[n] == 0 || byArray[n + 1] != byArray[n] || byArray2[n] != 0) continue;
            byArray2[n] = 1;
        }
    }

    void addStructuresFromTags(byte[] byArray) {
        int n = 0;
        while (n < this.monomerCount) {
            int n2;
            byte by = byArray[n];
            if (by == 0) {
                ++n;
                continue;
            }
            for (n2 = n + 1; n2 < this.monomerCount && byArray[n2] == by; ++n2) {
            }
            this.addSecondaryStructure(by, null, 0, 0, n, n2 - 1);
            n = n2;
        }
    }

    @Override
    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, boolean bl, BitSet bitSet, OutputStringBuffer outputStringBuffer, StringBuffer stringBuffer, BitSet bitSet2, boolean bl2, boolean bl3, BitSet bitSet3) {
        AlphaPolymer.getPdbData(viewer, this, c, c2, n, n2, bl, bitSet, outputStringBuffer, stringBuffer, bitSet2, bl2, bl3, bitSet3);
    }

    @Override
    public List<Atom[]> calculateStruts(ModelSet modelSet, Atom[] atomArray, BitSet bitSet, BitSet bitSet2, List<Atom> list, float f, int n, boolean bl) {
        float f2;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        ArrayList<Atom[]> arrayList = new ArrayList<Atom[]>();
        float f3 = f * f;
        int n9 = list.size();
        int n10 = 3;
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        BitSet bitSet5 = new BitSet();
        Atom atom = list.get(0);
        int n11 = modelSet.getBioPolymerCountInModel(atom.modelIndex);
        int[][] nArray = new int[n11][n10 * 2];
        for (int i = 0; i < n9; ++i) {
            atom = list.get(i);
            n8 = atom.getPolymerIndexInModel();
            n7 = atom.getMonomerIndex();
            n6 = n7;
            if (n6 < n10) {
                nArray[n8][n6] = i + 1;
            }
            if ((n6 = ((Monomer)atom.getGroup()).getBioPolymerLength() - n7 - 1) >= n10) continue;
            nArray[n8][n10 + n6] = i + 1;
        }
        float[] fArray = new float[n9 * (n9 - 1) / 2];
        for (n8 = 0; n8 < n9; ++n8) {
            atom = list.get(n8);
            for (n7 = n8 + 1; n7 < n9; ++n7) {
                n6 = this.strutPoint(n8, n7, n9);
                Atom atom2 = list.get(n7);
                n5 = atom.getResno();
                n4 = atom.getPolymerIndexInModel();
                n3 = atom2.getResno();
                n2 = atom2.getPolymerIndexInModel();
                if (n4 == n2 && Math.abs(n3 - n5) < n) {
                    bitSet5.set(n6);
                }
                if (!((f2 = (fArray[n6] = atom.distanceSquared(list.get(n7)))) >= f3)) continue;
                bitSet4.set(n6);
            }
        }
        n8 = 5;
        while (--n8 >= 0) {
            f3 = (f - (float)n8) * (f - (float)n8);
            for (n7 = 0; n7 < n9; ++n7) {
                if (!bl && bitSet3.get(n7)) continue;
                for (n6 = n7 + 1; n6 < n9; ++n6) {
                    n5 = this.strutPoint(n7, n6, n9);
                    if (bitSet4.get(n5) || bitSet5.get(n5) || !bl && bitSet3.get(n6) || !(fArray[n5] <= f3)) continue;
                    this.setStrut(n7, n6, n9, list, bitSet, bitSet2, arrayList, bitSet3, bitSet4, bitSet5, n);
                }
            }
        }
        for (n8 = 0; n8 < n11; ++n8) {
            for (n7 = 0; n7 < n10 * 2; ++n7) {
                n6 = nArray[n8][n7] - 1;
                if (n6 < 0 || !bitSet3.get(n6)) continue;
                for (n5 = 0; n5 < n10; ++n5) {
                    n4 = n7 / n10 * n10 + n5;
                    n6 = nArray[n8][n4] - 1;
                    if (n6 >= 0) {
                        bitSet3.set(n6);
                    }
                    nArray[n8][n4] = -1;
                }
            }
            if (nArray[n8][0] == -1 && nArray[n8][n10] == -1) continue;
            n7 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            n2 = 0;
            f2 = Float.MAX_VALUE;
            float f4 = Float.MAX_VALUE;
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n10 * 2; ++j) {
                    int n12;
                    int n13 = nArray[n8][j] - 1;
                    if (n13 == -2) {
                        j = (j / n10 + 1) * n10 - 1;
                        continue;
                    }
                    if (i == n13 || n13 == -1 || bitSet5.get(n12 = this.strutPoint(n13, i, n9)) || fArray[n12] > (j < n10 ? f2 : f4)) continue;
                    if (j < n10) {
                        if (bitSet4.get(n12)) {
                            n7 = 1;
                        }
                        n4 = i;
                        n5 = n13;
                        f2 = fArray[n12];
                        continue;
                    }
                    if (bitSet4.get(n12)) {
                        n6 = 1;
                    }
                    n2 = i;
                    n3 = n13;
                    f4 = fArray[n12];
                }
            }
            if (n7 != 0) {
                this.setStrut(n5, n4, n9, list, bitSet, bitSet2, arrayList, bitSet3, bitSet4, bitSet5, n);
            }
            if (n6 == 0) continue;
            this.setStrut(n3, n2, n9, list, bitSet, bitSet2, arrayList, bitSet3, bitSet4, bitSet5, n);
        }
        return arrayList;
    }

    private int strutPoint(int n, int n2, int n3) {
        return n2 < n ? n2 * (2 * n3 - n2 - 1) / 2 + n - n2 - 1 : n * (2 * n3 - n - 1) / 2 + n2 - n - 1;
    }

    private void setStrut(int n, int n2, int n3, List<Atom> list, BitSet bitSet, BitSet bitSet2, List<Atom[]> list2, BitSet bitSet3, BitSet bitSet4, BitSet bitSet5, int n4) {
        Atom atom = list.get(n);
        Atom atom2 = list.get(n2);
        if (!bitSet.get(atom.index) || !bitSet2.get(atom2.index)) {
            return;
        }
        list2.add(new Atom[]{atom, atom2});
        bitSet3.set(n);
        bitSet3.set(n2);
        for (int i = Math.max(0, n - n4); i <= n + n4 && i < n3; ++i) {
            for (int j = Math.max(0, n2 - n4); j <= n2 + n4 && j < n3; ++j) {
                int n5;
                if (i == j || bitSet5.get(n5 = this.strutPoint(i, j, n3))) continue;
                bitSet4.set(n5);
            }
        }
    }
}

