/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.AtomShape;
import org.jmol.util.Escape;
import org.jmol.util.Quadric;

public class Ellipsoids
extends AtomShape {
    Map<String, Ellipsoid> htEllipsoids = new Hashtable<String, Ellipsoid>();
    boolean haveEllipsoids;
    Ellipsoid ellipsoid;
    private static float[] crtval = new float[]{0.3389f, 0.4299f, 0.4951f, 0.5479f, 0.5932f, 0.6334f, 0.6699f, 0.7035f, 0.7349f, 0.7644f, 0.7924f, 0.8192f, 0.8447f, 0.8694f, 0.8932f, 0.9162f, 0.9386f, 0.9605f, 0.9818f, 1.0026f, 1.023f, 1.043f, 1.0627f, 1.0821f, 1.1012f, 1.12f, 1.1386f, 1.157f, 1.1751f, 1.1932f, 1.211f, 1.2288f, 1.2464f, 1.2638f, 1.2812f, 1.2985f, 1.3158f, 1.333f, 1.3501f, 1.3672f, 1.3842f, 1.4013f, 1.4183f, 1.4354f, 1.4524f, 1.4695f, 1.4866f, 1.5037f, 1.5209f, 1.5382f, 1.5555f, 1.5729f, 1.5904f, 1.608f, 1.6257f, 1.6436f, 1.6616f, 1.6797f, 1.698f, 1.7164f, 1.7351f, 1.754f, 1.773f, 1.7924f, 1.8119f, 1.8318f, 1.8519f, 1.8724f, 1.8932f, 1.9144f, 1.936f, 1.958f, 1.9804f, 2.0034f, 2.0269f, 2.051f, 2.0757f, 2.1012f, 2.1274f, 2.1544f, 2.1824f, 2.2114f, 2.2416f, 2.273f, 2.3059f, 2.3404f, 2.3767f, 2.4153f, 2.4563f, 2.5003f, 2.5478f, 2.5997f, 2.6571f, 2.7216f, 2.7955f, 2.8829f, 2.9912f, 3.1365f, 3.3682f};

    public int getIndexFromName(String string) {
        this.ellipsoid = this.htEllipsoids.get(string);
        return this.ellipsoid == null ? -1 : 1;
    }

    public void setSize(int n, BitSet bitSet) {
        super.setSize(n, bitSet);
        if (n == 0) {
            return;
        }
        float f = Ellipsoids.getRadius(n);
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            Object[] objectArray = this.atoms[n2].getEllipsoid();
            if (objectArray != null) {
                float[] fArray = (float[])objectArray[1];
                int n3 = 3;
                while (--n3 >= 0) {
                    fArray[n3 + 3] = fArray[n3] * f;
                }
                if (objectArray[0] == null) {
                    fArray[3] = fArray[5] = fArray[4];
                }
            }
            n2 = bitSet.nextSetBit(n2 + 1);
        }
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (string == "thisID") {
            Ellipsoid ellipsoid = this.ellipsoid = object == null ? null : this.htEllipsoids.get(object);
            if (object == null) {
                return;
            }
            if (this.ellipsoid == null) {
                String string2 = (String)object;
                this.ellipsoid = new Ellipsoid(string2, this.viewer.getCurrentModelIndex());
                this.htEllipsoids.put(string2, this.ellipsoid);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Iterator<Ellipsoid> iterator = this.htEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                Ellipsoid ellipsoid = iterator.next();
                if (ellipsoid.modelIndex > n) {
                    --ellipsoid.modelIndex;
                    continue;
                }
                if (ellipsoid.modelIndex != n) continue;
                iterator.remove();
            }
            this.ellipsoid = null;
            return;
        }
        if (this.ellipsoid != null) {
            this.haveEllipsoids = true;
            if ("delete" == string) {
                this.htEllipsoids.remove(this.ellipsoid.id);
                return;
            }
            if ("modelindex" == string) {
                this.ellipsoid.modelIndex = (Integer)object;
                return;
            }
            if ("on" == string) {
                this.ellipsoid.isOn = (Boolean)object;
                return;
            }
            if ("axes" == string) {
                int n;
                this.ellipsoid.isValid = false;
                this.ellipsoid.axes = (Vector3f[])object;
                this.ellipsoid.lengths = new float[3];
                this.ellipsoid.scale = 1.0f;
                for (n = 0; n < 2; ++n) {
                    if (!(this.ellipsoid.axes[n].length() > this.ellipsoid.axes[n + 1].length())) continue;
                    Vector3f vector3f = this.ellipsoid.axes[n];
                    this.ellipsoid.axes[n] = this.ellipsoid.axes[n + 1];
                    this.ellipsoid.axes[n + 1] = vector3f;
                    if (n != 1) continue;
                    n = -1;
                }
                for (n = 0; n < 3; ++n) {
                    this.ellipsoid.lengths[n] = this.ellipsoid.axes[n].length();
                    if (this.ellipsoid.lengths[n] == 0.0f) {
                        return;
                    }
                    this.ellipsoid.axes[n].normalize();
                }
                if (Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f) {
                    return;
                }
                this.updateEquation(this.ellipsoid);
                return;
            }
            if ("equation" == string) {
                this.ellipsoid.coef = (double[])object;
                this.ellipsoid.axes = new Vector3f[3];
                this.ellipsoid.lengths = new float[3];
                Quadric.getAxesForEllipsoid(this.ellipsoid.coef, this.ellipsoid.axes, this.ellipsoid.lengths);
                return;
            }
            if ("center" == string) {
                this.ellipsoid.center = (Point3f)object;
                this.updateEquation(this.ellipsoid);
                return;
            }
            if ("scale" == string) {
                float f = ((Float)object).floatValue();
                if (f <= 0.0f || this.ellipsoid.lengths == null) {
                    this.ellipsoid.isValid = false;
                } else {
                    int n = 0;
                    while (n < 3) {
                        int n2 = n++;
                        this.ellipsoid.lengths[n2] = this.ellipsoid.lengths[n2] * (f / this.ellipsoid.scale);
                    }
                    this.ellipsoid.scale = f;
                    this.updateEquation(this.ellipsoid);
                }
                return;
            }
            if ("color" == string) {
                this.ellipsoid.colix = Graphics3D.getColix(object);
                return;
            }
            if ("translucentLevel" == string) {
                super.setProperty(string, object, bitSet);
                return;
            }
            if ("translucency" == string) {
                boolean bl = object.equals("translucent");
                this.ellipsoid.colix = Graphics3D.getColixTranslucent(this.ellipsoid.colix, bl, this.translucentLevel);
                return;
            }
        }
        super.setProperty(string, object, bitSet);
    }

    private void updateEquation(Ellipsoid ellipsoid) {
        if (ellipsoid.axes == null || ellipsoid.lengths == null) {
            return;
        }
        Matrix3f matrix3f = new Matrix3f();
        Matrix3f matrix3f2 = new Matrix3f();
        Vector3f vector3f = new Vector3f();
        ellipsoid.coef = new double[10];
        Quadric.getEquationForQuadricWithCenter(ellipsoid.center.x, ellipsoid.center.y, ellipsoid.center.z, matrix3f, vector3f, matrix3f2, ellipsoid.coef, null);
        ellipsoid.isValid = true;
    }

    public String getShapeState() {
        Object object;
        Iterator<Ellipsoid> iterator = this.htEllipsoids.values().iterator();
        StringBuffer stringBuffer = new StringBuffer();
        Vector3f vector3f = new Vector3f();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((Ellipsoid)object).axes == null || ((Ellipsoid)object).lengths == null) continue;
            stringBuffer.append("  Ellipsoid ID ").append(((Ellipsoid)object).id).append(" modelIndex ").append(((Ellipsoid)object).modelIndex).append(" center ").append(Escape.escape(((Ellipsoid)object).center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                vector3f.set(((Ellipsoid)object).axes[i]);
                vector3f.scale(((Ellipsoid)object).lengths[i]);
                stringBuffer.append(" ").append(Escape.escape(vector3f));
            }
            stringBuffer.append(" " + this.getColorCommand("", ((Ellipsoid)object).colix));
            if (!((Ellipsoid)object).isOn) {
                stringBuffer.append(" off");
            }
            stringBuffer.append(";\n");
        }
        if (this.isActive) {
            int n;
            object = new Hashtable();
            Hashtable<String, BitSet> hashtable = new Hashtable<String, BitSet>();
            if (this.bsSizeSet != null) {
                n = this.bsSizeSet.nextSetBit(0);
                while (n >= 0) {
                    Ellipsoids.setStateInfo((Map<String, BitSet>)object, n, "Ellipsoids " + this.mads[n]);
                    n = this.bsSizeSet.nextSetBit(n + 1);
                }
            }
            if (this.bsColixSet != null) {
                n = this.bsColixSet.nextSetBit(0);
                while (n >= 0) {
                    Ellipsoids.setStateInfo(hashtable, n, this.getColorCommand("Ellipsoids", this.paletteIDs[n], this.colixes[n]));
                    n = this.bsColixSet.nextSetBit(n + 1);
                }
            }
            stringBuffer.append(Ellipsoids.getShapeCommands((Map<String, BitSet>)object, hashtable));
        }
        return stringBuffer.toString();
    }

    public void setVisibilityFlags(BitSet bitSet) {
        for (Ellipsoid ellipsoid : this.htEllipsoids.values()) {
            ellipsoid.visible = ellipsoid.isOn && (ellipsoid.modelIndex < 0 || bitSet.get(ellipsoid.modelIndex));
        }
    }

    static final float getRadius(int n) {
        return crtval[n < 1 ? 0 : (n > 99 ? 98 : n - 1)];
    }

    static class Ellipsoid {
        String id;
        Vector3f[] axes;
        float[] lengths;
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        double[] coef;
        short colix = (short)23;
        int modelIndex;
        float scale = 1.0f;
        boolean visible;
        boolean isValid;
        boolean isOn = true;

        Ellipsoid(String string, int n) {
            this.id = string;
            this.modelIndex = n;
        }
    }
}

