/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.AtomIndexIterator;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.shape.AtomShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.viewer.JmolConstants;

public class Polyhedra
extends AtomShape {
    private static final float DEFAULT_DISTANCE_FACTOR = 1.85f;
    private static final float DEFAULT_FACECENTEROFFSET = 0.25f;
    private static final int EDGES_NONE = 0;
    static final int EDGES_ALL = 1;
    static final int EDGES_FRONT = 2;
    private static final int MAX_VERTICES = 150;
    private static final int FACE_COUNT_MAX = 147;
    private Point3f[] otherAtoms = new Point3f[151];
    int polyhedronCount;
    Polyhedron[] polyhedrons = new Polyhedron[32];
    int drawEdges;
    private float radius;
    private int nVertices;
    float faceCenterOffset;
    float distanceFactor;
    boolean isCollapsed;
    private boolean iHaveCenterBitSet;
    private boolean bondedOnly;
    private boolean haveBitSetVertices;
    private BitSet centers;
    private BitSet bsVertices;
    private BitSet bsVertexCount;
    private short[] normixesT = new short[150];
    private byte[] planesT = new byte[450];
    private static final Point3f randomPoint = new Point3f(3141.0f, 2718.0f, 1414.0f);
    private Vector3f align1 = new Vector3f();
    private Vector3f align2 = new Vector3f();
    private final Vector3f vAB = new Vector3f();
    private final Vector3f vAC = new Vector3f();
    private static float minDistanceForPlanarity = 0.1f;

    public void setProperty(String string, Object object, BitSet bitSet) {
        if ("init" == string) {
            this.faceCenterOffset = 0.25f;
            this.distanceFactor = 1.85f;
            this.radius = 0.0f;
            this.nVertices = 0;
            this.bsVertices = null;
            this.centers = null;
            this.bsVertexCount = new BitSet();
            this.iHaveCenterBitSet = false;
            this.isCollapsed = false;
            this.bondedOnly = false;
            this.drawEdges = 0;
            this.haveBitSetVertices = false;
            return;
        }
        if ("generate" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bitSet;
            }
            this.deletePolyhedra();
            this.buildPolyhedra();
            return;
        }
        if ("collapsed" == string) {
            this.isCollapsed = (Boolean)object;
            return;
        }
        if ("nVertices" == string) {
            this.nVertices = (Integer)object;
            this.bsVertexCount.set(this.nVertices);
            return;
        }
        if ("centers" == string) {
            this.centers = (BitSet)object;
            this.iHaveCenterBitSet = true;
            return;
        }
        if ("to" == string) {
            this.bsVertices = (BitSet)object;
            return;
        }
        if ("toBitSet" == string) {
            this.bsVertices = (BitSet)object;
            this.haveBitSetVertices = true;
            return;
        }
        if ("faceCenterOffset" == string) {
            this.faceCenterOffset = ((Float)object).floatValue();
            return;
        }
        if ("distanceFactor" == string) {
            this.distanceFactor = ((Float)object).floatValue();
            return;
        }
        if ("bonds" == string) {
            this.bondedOnly = true;
            return;
        }
        if ("delete" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bitSet;
            }
            this.deletePolyhedra();
            return;
        }
        if ("on" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bitSet;
            }
            this.setVisible(true);
            return;
        }
        if ("off" == string) {
            if (!this.iHaveCenterBitSet) {
                this.centers = bitSet;
            }
            this.setVisible(false);
            return;
        }
        if ("noedges" == string) {
            this.drawEdges = 0;
            return;
        }
        if ("edges" == string) {
            this.drawEdges = 1;
            return;
        }
        if ("frontedges" == string) {
            this.drawEdges = 2;
            return;
        }
        if (string.indexOf("color") == 0) {
            if ("colorThis" == string && this.iHaveCenterBitSet) {
                bitSet = this.centers;
            } else {
                this.andBitSet(bitSet);
            }
            string = "color";
        }
        if (string.indexOf("translucency") == 0) {
            if ("translucencyThis" == string && this.iHaveCenterBitSet) {
                bitSet = this.centers;
            } else {
                this.andBitSet(bitSet);
            }
        }
        if ("radius" == string) {
            this.radius = ((Float)object).floatValue();
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.polyhedronCount;
            while (--n2 >= 0) {
                if (this.polyhedrons[n2].modelIndex == n) {
                    --this.polyhedronCount;
                    this.polyhedrons = (Polyhedron[])ArrayUtil.deleteElements(this.polyhedrons, n2, 1);
                    continue;
                }
                if (this.polyhedrons[n2].modelIndex <= n) continue;
                --this.polyhedrons[n2].modelIndex;
            }
        }
        super.setProperty(string, object, bitSet);
    }

    private void andBitSet(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        int n = this.polyhedronCount;
        while (--n >= 0) {
            bitSet2.set(this.polyhedrons[n].centralAtom.getIndex());
        }
        bitSet.and(bitSet2);
    }

    private void deletePolyhedra() {
        int n;
        int n2 = 0;
        byte by = JmolConstants.pidOf(null);
        for (n = 0; n < this.polyhedronCount; ++n) {
            Polyhedron polyhedron = this.polyhedrons[n];
            int n3 = polyhedron.centralAtom.getIndex();
            if (this.centers.get(n3)) {
                this.setColixAndPalette((short)0, by, n3);
                continue;
            }
            this.polyhedrons[n2++] = polyhedron;
        }
        for (n = n2; n < this.polyhedronCount; ++n) {
            this.polyhedrons[n] = null;
        }
        this.polyhedronCount = n2;
    }

    private void setVisible(boolean bl) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            if (polyhedron == null || !this.centers.get(polyhedron.centralAtom.getIndex())) continue;
            polyhedron.visible = bl;
        }
    }

    private void buildPolyhedra() {
        boolean bl = this.radius == 0.0f || this.bondedOnly;
        AtomIndexIterator atomIndexIterator = this.modelSet.getSelectedAtomIterator(null, false, false, false);
        int n = this.centers.nextSetBit(0);
        while (n >= 0) {
            Polyhedron polyhedron;
            Polyhedron polyhedron2 = this.haveBitSetVertices ? this.constructBitSetPolyhedron(n) : (polyhedron = bl ? this.constructBondsPolyhedron(n) : this.constructRadiusPolyhedron(n, atomIndexIterator));
            if (polyhedron != null) {
                if (this.polyhedronCount == this.polyhedrons.length) {
                    this.polyhedrons = (Polyhedron[])ArrayUtil.doubleLength(this.polyhedrons);
                }
                this.polyhedrons[this.polyhedronCount++] = polyhedron;
            }
            if (this.haveBitSetVertices) break;
            n = this.centers.nextSetBit(n + 1);
        }
        atomIndexIterator.release();
    }

    private Polyhedron constructBondsPolyhedron(int n) {
        Atom atom = this.atoms[n];
        Bond[] bondArray = atom.getBonds();
        if (bondArray == null) {
            return null;
        }
        int n2 = 0;
        int n3 = bondArray.length;
        while (--n3 >= 0) {
            Atom atom2;
            Bond bond = bondArray[n3];
            Atom atom3 = atom2 = bond.getAtom1() == atom ? bond.getAtom2() : bond.getAtom1();
            if (this.bsVertices != null && !this.bsVertices.get(atom2.getIndex()) || this.radius > 0.0f && bond.getAtom1().distance(bond.getAtom2()) > this.radius) continue;
            this.otherAtoms[n2++] = atom2;
            if (n2 != 150) continue;
            break;
        }
        if (n2 < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n2)) {
            return null;
        }
        return this.validatePolyhedronNew(atom, n2, this.otherAtoms);
    }

    private Polyhedron constructBitSetPolyhedron(int n) {
        int n2 = 0;
        int n3 = this.bsVertices.nextSetBit(0);
        while (n3 >= 0) {
            this.otherAtoms[n2++] = this.atoms[n3];
            n3 = this.bsVertices.nextSetBit(n3 + 1);
        }
        return this.validatePolyhedronNew(this.atoms[n], n2, this.otherAtoms);
    }

    private Polyhedron constructRadiusPolyhedron(int n, AtomIndexIterator atomIndexIterator) {
        Atom atom = this.atoms[n];
        int n2 = 0;
        this.viewer.setIteratorForAtom(atomIndexIterator, n, this.radius);
        while (atomIndexIterator.hasNext()) {
            Atom atom2 = this.atoms[atomIndexIterator.next()];
            if (this.bsVertices != null && !this.bsVertices.get(atom2.getIndex()) || atom.distance(atom2) > this.radius || atom2.getAlternateLocationID() != atom.getAlternateLocationID() && atom2.getAlternateLocationID() != '\u0000' && atom.getAlternateLocationID() != '\u0000') continue;
            if (n2 == 150) break;
            this.otherAtoms[n2++] = atom2;
        }
        if (n2 < 3 || this.nVertices > 0 && !this.bsVertexCount.get(n2)) {
            return null;
        }
        return this.validatePolyhedronNew(atom, n2, this.otherAtoms);
    }

    private Polyhedron validatePolyhedronNew(Atom atom, int n, Point3f[] point3fArray) {
        int n2;
        int n3;
        int n4;
        boolean bl;
        Vector3f vector3f = new Vector3f();
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        int n8 = n7 + 1;
        float f = 0.0f;
        float f2 = 0.0f;
        Point3f[] point3fArray2 = new Point3f[450];
        point3fArray2[n7] = point3fArray[n7] = atom;
        for (int i = 0; i < n7; ++i) {
            point3fArray2[i] = point3fArray[i];
            f2 += point3fArray2[n7].distance(point3fArray2[i]);
        }
        float f3 = this.distanceFactor;
        BitSet bitSet = new BitSet(n7);
        boolean bl2 = bl = (f2 /= (float)n7) == 0.0f;
        block1: while (!bl && f3 < 10.0f) {
            int n9;
            f = f2 * f3;
            for (n9 = 0; n9 < n7; ++n9) {
                bitSet.set(n9);
            }
            for (n9 = 0; n9 < n7 - 2; ++n9) {
                for (int i = n9 + 1; i < n7 - 1; ++i) {
                    if (point3fArray2[n9].distance(point3fArray2[i]) > f) continue;
                    for (n4 = i + 1; n4 < n7; ++n4) {
                        if (point3fArray2[n9].distance(point3fArray2[n4]) > f || point3fArray2[i].distance(point3fArray2[n4]) > f) continue;
                        bitSet.clear(n9);
                        bitSet.clear(i);
                        bitSet.clear(n4);
                    }
                }
            }
            bl = true;
            for (n9 = 0; n9 < n7; ++n9) {
                if (!bitSet.get(n9)) continue;
                bl = false;
                f3 *= 1.05f;
                if (!Logger.debugging) continue block1;
                Logger.debug("Polyhedra distanceFactor for " + n7 + " atoms increased to " + f3 + " in order to include " + ((Atom)point3fArray[n9]).getInfo());
                continue block1;
            }
        }
        String string = "";
        String string2 = "";
        for (n4 = 0; n4 < n7 - 2; ++n4) {
            for (n3 = n4 + 1; n3 < n7 - 1; ++n3) {
                for (n2 = n3 + 1; n2 < n7; ++n2) {
                    if (!this.isPlanar(point3fArray2[n4], point3fArray2[n3], point3fArray2[n2], point3fArray2[n7])) continue;
                    string = string + this.faceId(n4, n3, n2);
                }
            }
        }
        for (n4 = 0; n4 < n7 - 1; ++n4) {
            for (n3 = n4 + 1; n3 < n7; ++n3) {
                if (!this.isAligned(point3fArray2[n4], point3fArray2[n3], point3fArray2[n7])) continue;
                string2 = string2 + this.faceId(n4, n3, -1);
            }
        }
        Point3f point3f = new Point3f();
        BitSet bitSet2 = new BitSet();
        for (n2 = 0; n2 < n7 - 2; ++n2) {
            for (int i = n2 + 1; i < n7 - 1; ++i) {
                if (point3fArray2[n2].distance(point3fArray2[i]) > f) continue;
                for (int j = i + 1; j < n7; ++j) {
                    if (point3fArray2[n2].distance(point3fArray2[j]) > f || point3fArray2[i].distance(point3fArray2[j]) > f) continue;
                    if (n5 >= 147) {
                        Logger.error("Polyhedron error: maximum face(147) -- reduce RADIUS or DISTANCEFACTOR");
                        return null;
                    }
                    if (n8 >= 150) {
                        Logger.error("Polyhedron error: maximum vertex count(150) -- reduce RADIUS");
                        return null;
                    }
                    boolean bl3 = string.indexOf(this.faceId(n2, i, j)) >= 0;
                    boolean bl4 = bl3 ? Measure.getNormalFromCenter(randomPoint, point3fArray2[n2], point3fArray2[i], point3fArray2[j], false, vector3f) : Measure.getNormalFromCenter(point3fArray2[n7], point3fArray2[n2], point3fArray2[i], point3fArray2[j], true, vector3f);
                    vector3f.scale(this.isCollapsed && !bl3 ? this.faceCenterOffset : 0.001f);
                    int n10 = n8;
                    point3f.set(point3fArray2[n7]);
                    if (this.isCollapsed && !bl3) {
                        point3fArray2[n8] = new Point3f(point3fArray2[n7]);
                        point3fArray2[n8].add(vector3f);
                        point3fArray[n8] = point3fArray2[n8];
                    } else if (bl3) {
                        point3f.sub(vector3f);
                        n10 = n7;
                    }
                    String string3 = this.faceId(n2, i, -1);
                    if (this.isCollapsed || bl3 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        this.planesT[n6++] = (byte)(bl4 ? n2 : i);
                        this.planesT[n6++] = (byte)(bl4 ? i : n2);
                        this.planesT[n6++] = (byte)n10;
                        Measure.getNormalFromCenter(point3fArray2[j], point3fArray2[n2], point3fArray2[i], point3f, false, vector3f);
                        this.normixesT[n5++] = bl3 ? Graphics3D.get2SidedNormix(vector3f, bitSet2) : Graphics3D.getNormix(vector3f, bitSet2);
                    }
                    string3 = this.faceId(n2, j, -1);
                    if (this.isCollapsed || bl3 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        this.planesT[n6++] = (byte)(bl4 ? n2 : j);
                        this.planesT[n6++] = (byte)n10;
                        this.planesT[n6++] = (byte)(bl4 ? j : n2);
                        Measure.getNormalFromCenter(point3fArray2[i], point3fArray2[n2], point3f, point3fArray2[j], false, vector3f);
                        this.normixesT[n5++] = bl3 ? Graphics3D.get2SidedNormix(vector3f, bitSet2) : Graphics3D.getNormix(vector3f, bitSet2);
                    }
                    string3 = this.faceId(i, j, -1);
                    if (this.isCollapsed || bl3 && string2.indexOf(string3) < 0) {
                        string2 = string2 + string3;
                        this.planesT[n6++] = (byte)n10;
                        this.planesT[n6++] = (byte)(bl4 ? i : j);
                        this.planesT[n6++] = (byte)(bl4 ? j : i);
                        Measure.getNormalFromCenter(point3fArray2[n2], point3f, point3fArray2[i], point3fArray2[j], false, vector3f);
                        short s = this.normixesT[n5++] = bl3 ? Graphics3D.get2SidedNormix(vector3f, bitSet2) : Graphics3D.getNormix(vector3f, bitSet2);
                    }
                    if (bl3) continue;
                    if (this.isCollapsed) {
                        ++n8;
                        continue;
                    }
                    this.planesT[n6++] = (byte)(bl4 ? n2 : i);
                    this.planesT[n6++] = (byte)(bl4 ? i : n2);
                    this.planesT[n6++] = (byte)j;
                    this.normixesT[n5++] = Graphics3D.getNormix(vector3f, bitSet2);
                }
            }
        }
        return new Polyhedron(atom, n7, n8, n5, point3fArray, this.normixesT, this.planesT);
    }

    private String faceId(int n, int n2, int n3) {
        return new Point3i(n, n2, n3).toString();
    }

    private boolean isAligned(Point3f point3f, Point3f point3f2, Point3f point3f3) {
        this.align1.sub(point3f, point3f3);
        this.align2.sub(point3f2, point3f3);
        float f = this.align1.angle(this.align2);
        return f < 0.01f || f > 3.13f;
    }

    private boolean isPlanar(Point3f point3f, Point3f point3f2, Point3f point3f3, Point3f point3f4) {
        Vector3f vector3f = new Vector3f();
        float f = Measure.getNormalThroughPoints(point3f, point3f2, point3f3, vector3f, this.vAB, this.vAC);
        float f2 = Measure.distanceToPlane(vector3f, f, point3f4);
        return Math.abs(f2) < minDistanceForPlanarity;
    }

    public void setVisibilityFlags(BitSet bitSet) {
        int n = this.polyhedronCount;
        while (--n >= 0) {
            Polyhedron polyhedron = this.polyhedrons[n];
            polyhedron.visibilityFlags = polyhedron.visible && bitSet.get(polyhedron.modelIndex) && !this.modelSet.isAtomHidden(polyhedron.centralAtom.getIndex()) ? this.myVisibilityFlag : 0;
        }
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.polyhedronCount; ++i) {
            stringBuffer.append(this.polyhedrons[i].getState());
        }
        if (this.drawEdges == 2) {
            Polyhedra.appendCmd(stringBuffer, "polyhedra frontedges");
        } else if (this.drawEdges == 1) {
            Polyhedra.appendCmd(stringBuffer, "polyhedra edges");
        }
        stringBuffer.append(super.getShapeState());
        return stringBuffer.toString();
    }

    class Polyhedron {
        int modelIndex;
        final Atom centralAtom;
        final Point3f[] vertices;
        int ptCenter;
        boolean visible;
        final short[] normixes;
        byte[] planes;
        int visibilityFlags = 0;
        boolean collapsed = false;
        float myFaceCenterOffset;
        float myDistanceFactor;

        Polyhedron(Atom atom, int n, int n2, int n3, Point3f[] point3fArray, short[] sArray, byte[] byArray) {
            this.collapsed = Polyhedra.this.isCollapsed;
            this.centralAtom = atom;
            this.modelIndex = atom.getModelIndex();
            this.ptCenter = n;
            this.vertices = new Point3f[n2];
            this.visible = true;
            this.normixes = new short[n3];
            this.planes = new byte[n3 * 3];
            this.myFaceCenterOffset = Polyhedra.this.faceCenterOffset;
            this.myDistanceFactor = Polyhedra.this.distanceFactor;
            int n4 = n2;
            while (--n4 >= 0) {
                this.vertices[n4] = point3fArray[n4];
            }
            n4 = n3;
            while (--n4 >= 0) {
                this.normixes[n4] = sArray[n4];
            }
            n4 = n3 * 3;
            while (--n4 >= 0) {
                this.planes[n4] = byArray[n4];
            }
        }

        protected String getState() {
            BitSet bitSet = new BitSet();
            for (int i = 0; i < this.ptCenter; ++i) {
                bitSet.set(((Atom)this.vertices[i]).getIndex());
            }
            return "  polyhedra ({" + this.centralAtom.getIndex() + "}) " + (this.myDistanceFactor == 1.85f ? "" : " distanceFactor " + this.myDistanceFactor) + (this.myFaceCenterOffset == 0.25f ? "" : " faceCenterOffset " + this.myFaceCenterOffset) + " to " + Escape.escape(bitSet) + (this.collapsed ? " collapsed" : "") + ";" + (this.visible ? "" : "polyhedra off;") + "\n";
        }
    }
}

