/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jmol.console.KeyJCheckBox;
import org.jmol.console.KeyJCheckBoxMenuItem;
import org.jmol.console.KeyJMenu;
import org.jmol.console.KeyJMenuItem;
import org.jmol.console.KeyJRadioButtonMenuItem;
import org.jmol.i18n.GT;

class GuiMap {
    Map<String, AbstractButton> map = new Hashtable<String, AbstractButton>();
    Map<String, String> labels;

    GuiMap() {
    }

    private void setupLabels() {
        this.labels = new Hashtable<String, String>();
        this.labels.put("macros", GT._("&Macros"));
        this.labels.put("file", GT._("&File"));
        this.labels.put("newwin", GT._("&New"));
        this.labels.put("open", GT._("&Open"));
        this.labels.put("openTip", GT._("Open a file."));
        this.labels.put("openurl", GT._("Open &URL"));
        this.labels.put("openpdb", GT._("&Get PDB"));
        this.labels.put("openmol", GT._("Get &MOL"));
        this.labels.put("editor", GT._("Scrip&t Editor..."));
        this.labels.put("console", GT._("Conso&le..."));
        this.labels.put("jconsole", GT._("Jmol Java &Console"));
        this.labels.put("atomsetchooser", GT._("AtomSet&Chooser..."));
        this.labels.put("saveas", GT._("&Save As..."));
        this.labels.put("exportMenu", GT._("&Export"));
        this.labels.put("export", GT._("Export &Image..."));
        this.labels.put("exportTip", GT._("Save current view as an image."));
        this.labels.put("toweb", GT._("Export to &Web Page..."));
        this.labels.put("towebTip", GT._("Export one or more views to a web page."));
        this.labels.put("povray", GT._("Render in POV-&Ray..."));
        this.labels.put("povrayTip", GT._("Render in POV-Ray"));
        this.labels.put("write", GT._("Write &State..."));
        this.labels.put("writeTip", GT._("Save current view as a Jmol state script."));
        this.labels.put("print", GT._("&Print..."));
        this.labels.put("printTip", GT._("Print view."));
        this.labels.put("close", GT._("&Close"));
        this.labels.put("exit", GT._("E&xit"));
        this.labels.put("recentFiles", GT._("Recent &Files..."));
        this.labels.put("edit", GT._("&Edit"));
        this.labels.put("selectall", GT._("Select &All"));
        this.labels.put("deselectall", GT._("Deselect All"));
        this.labels.put("copyImage", GT._("Copy &Image"));
        this.labels.put("copyScript", GT._("Copy Script"));
        this.labels.put("prefs", GT._("Pr&eferences..."));
        this.labels.put("pasteClipboard", GT._("&Paste"));
        this.labels.put("editSelectAllScript", GT._("Select &All"));
        this.labels.put("selectMenu", GT._("&Select"));
        this.labels.put("selectAllScript", GT._("&All"));
        this.labels.put("selectNoneScript", GT._("&None"));
        this.labels.put("selectHydrogenScript", GT._("Hydrogen"));
        this.labels.put("selectCarbonScript", GT._("Carbon"));
        this.labels.put("selectNitrogenScript", GT._("Nitrogen"));
        this.labels.put("selectOxygenScript", GT._("Oxygen"));
        this.labels.put("selectPhosphorusScript", GT._("Phosphorus"));
        this.labels.put("selectSulfurScript", GT._("Sulfur"));
        this.labels.put("selectAminoScript", GT._("Amino"));
        this.labels.put("selectNucleicScript", GT._("Nucleic"));
        this.labels.put("selectWaterScript", GT._("Water"));
        this.labels.put("selectHeteroScript", GT._("Hetero"));
        this.labels.put("display", GT._("&Display"));
        this.labels.put("atomMenu", GT._("&Atom"));
        this.labels.put("atomNoneScript", GT._("&None"));
        this.labels.put("atom15Script", GT._("{0}% van der Waals", "15"));
        this.labels.put("atom20Script", GT._("{0}% van der Waals", "20"));
        this.labels.put("atom25Script", GT._("{0}% van der Waals", "25"));
        this.labels.put("atom100Script", GT._("{0}% van der Waals", "100"));
        this.labels.put("bondMenu", GT._("&Bond"));
        this.labels.put("bondNoneScript", GT._("&None"));
        this.labels.put("bondWireframeScript", GT._("&Wireframe"));
        this.labels.put("bond100Script", GT._("{0} \u00c5", "0.10"));
        this.labels.put("bond150Script", GT._("{0} \u00c5", "0.15"));
        this.labels.put("bond200Script", GT._("{0} \u00c5", "0.20"));
        this.labels.put("labelMenu", GT._("&Label"));
        this.labels.put("labelNoneScript", GT._("&None"));
        this.labels.put("labelSymbolScript", GT._("&Symbol"));
        this.labels.put("labelNameScript", GT._("&Name"));
        this.labels.put("labelNumberScript", GT._("&Number"));
        this.labels.put("labelCenteredScript", GT._("&Centered"));
        this.labels.put("labelUpperRightScript", GT._("&Upper right"));
        this.labels.put("vectorMenu", GT._("&Vector"));
        this.labels.put("vectorOffScript", GT._("&None"));
        this.labels.put("vectorOnScript", GT._("&On"));
        this.labels.put("vector3Script", GT._("{0} pixels", "3"));
        this.labels.put("vector005Script", GT._("{0} \u00c5", "0.05"));
        this.labels.put("vector01Script", GT._("{0} \u00c5", "0.1"));
        this.labels.put("vectorScale02Script", GT._("Scale {0}", "0.2"));
        this.labels.put("vectorScale05Script", GT._("Scale {0}", "0.5"));
        this.labels.put("vectorScale1Script", GT._("Scale {0}", "1"));
        this.labels.put("vectorScale2Script", GT._("Scale {0}", "2"));
        this.labels.put("vectorScale5Script", GT._("Scale {0}", "5"));
        this.labels.put("zoomMenu", GT._("&Zoom"));
        this.labels.put("zoom100Script", GT._("{0}%", "100"));
        this.labels.put("zoom150Script", GT._("{0}%", "150"));
        this.labels.put("zoom200Script", GT._("{0}%", "200"));
        this.labels.put("zoom400Script", GT._("{0}%", "400"));
        this.labels.put("zoom800Script", GT._("{0}%", "800"));
        this.labels.put("perspectiveCheck", GT._("&Perspective Depth"));
        this.labels.put("axesCheck", GT._("A&xes"));
        this.labels.put("boundboxCheck", GT._("B&ounding Box"));
        this.labels.put("hydrogensCheck", GT._("&Hydrogens"));
        this.labels.put("vectorsCheck", GT._("V&ectors"));
        this.labels.put("measurementsCheck", GT._("&Measurements"));
        this.labels.put("resize", GT._("Resi&ze"));
        this.labels.put("view", GT._("&View"));
        this.labels.put("front", GT._("&Front"));
        this.labels.put("top", GT._("&Top"));
        this.labels.put("bottom", GT._("&Bottom"));
        this.labels.put("right", GT._("&Right"));
        this.labels.put("left", GT._("&Left"));
        this.labels.put("transform", GT._("Tr&ansform..."));
        this.labels.put("definecenter", GT._("Define &Center"));
        this.labels.put("tools", GT._("&Tools"));
        this.labels.put("gauss", GT._("&Gaussian..."));
        this.labels.put("viewMeasurementTable", GT._("&Measurements") + "...");
        this.labels.put("distanceUnitsMenu", GT._("Distance &Units"));
        this.labels.put("distanceNanometersScript", GT._("&Nanometers 1E-9"));
        this.labels.put("distanceAngstromsScript", GT._("&Angstroms 1E-10"));
        this.labels.put("distancePicometersScript", GT._("&Picometers 1E-12"));
        this.labels.put("animateMenu", GT._("&Animate..."));
        this.labels.put("vibrateMenu", GT._("&Vibrate..."));
        this.labels.put("graph", GT._("&Graph..."));
        this.labels.put("chemicalShifts", GT._("Calculate chemical &shifts..."));
        this.labels.put("crystprop", GT._("&Crystal Properties"));
        this.labels.put("animateOnceScript", GT._("&Once"));
        this.labels.put("animateLoopScript", GT._("&Loop"));
        this.labels.put("animatePalindromeScript", GT._("P&alindrome"));
        this.labels.put("animateStopScript", GT._("&Stop animation"));
        this.labels.put("animateRewindScript", GT._("&Rewind to first frame"));
        this.labels.put("animateRewindScriptTip", GT._("Rewind to first frame"));
        this.labels.put("animateNextScript", GT._("Go to &next frame"));
        this.labels.put("animateNextScriptTip", GT._("Go to next frame"));
        this.labels.put("animatePrevScript", GT._("Go to &previous frame"));
        this.labels.put("animatePrevScriptTip", GT._("Go to previous frame"));
        this.labels.put("animateAllScript", GT._("All &frames"));
        this.labels.put("animateAllScriptTip", GT._("All frames"));
        this.labels.put("animateLastScript", GT._("Go to &last frame"));
        this.labels.put("animateLastScriptTip", GT._("Go to last frame"));
        this.labels.put("vibrateStartScript", GT._("Start &vibration"));
        this.labels.put("vibrateStopScript", GT._("&Stop vibration"));
        this.labels.put("vibrateRewindScript", GT._("&First frequency"));
        this.labels.put("vibrateNextScript", GT._("&Next frequency"));
        this.labels.put("vibratePrevScript", GT._("&Previous frequency"));
        this.labels.put("help", GT._("&Help"));
        this.labels.put("about", GT._("About Jmol"));
        this.labels.put("uguide", GT._("User Guide"));
        this.labels.put("whatsnew", GT._("What's New"));
        this.labels.put("Prefs.showHydrogens", GT._("Hydrogens"));
        this.labels.put("Prefs.showMeasurements", GT._("Measurements"));
        this.labels.put("Prefs.perspectiveDepth", GT._("Perspective Depth"));
        this.labels.put("Prefs.showAxes", GT._("Axes"));
        this.labels.put("Prefs.showBoundingBox", GT._("Bounding Box"));
        this.labels.put("Prefs.axesOrientationRasmol", GT._("RasMol/Chime compatible axes orientation/rotations"));
        this.labels.put("Prefs.openFilePreview", GT._("File Preview (requires restarting Jmol)"));
        this.labels.put("Prefs.clearConsoleButton", GT._("Clear console button (requires restarting Jmol)"));
        this.labels.put("Prefs.isLabelAtomColor", GT._("Use Atom Color"));
        this.labels.put("Prefs.isBondAtomColor", GT._("Use Atom Color"));
        this.labels.put("rotateScriptTip", GT._("Rotate molecule."));
        this.labels.put("pickScriptTip", GT._("Select a set of atoms using SHIFT-LEFT-DRAG."));
        this.labels.put("pickMeasureScriptTip", GT._("Click atoms to measure distances"));
        this.labels.put("homeTip", GT._("Return molecule to home position."));
        this.labels.put("modelkitScriptTip", GT._("Open the model kit."));
        this.labels.put("JavaConsole.clear", GT._("Clear"));
    }

    String getLabel(String string) {
        if (this.labels == null) {
            this.setupLabels();
        }
        String string2 = this.labels.get(string);
        return string2;
    }

    JMenu newJMenu(String string) {
        return new KeyJMenu(string, this.getLabel(string), this.map);
    }

    JMenuItem newJMenuItem(String string) {
        return new KeyJMenuItem(string, this.getLabel(string), this.map);
    }

    JCheckBoxMenuItem newJCheckBoxMenuItem(String string, boolean bl) {
        return new KeyJCheckBoxMenuItem(string, this.getLabel(string), this.map, bl);
    }

    JRadioButtonMenuItem newJRadioButtonMenuItem(String string) {
        return new KeyJRadioButtonMenuItem(string, this.getLabel(string), this.map);
    }

    JCheckBox newJCheckBox(String string, boolean bl) {
        return new KeyJCheckBox(string, this.getLabel(string), this.map, bl);
    }

    JButton newJButton(String string) {
        JButton jButton = new JButton(this.getLabel(string));
        this.map.put(string, jButton);
        return jButton;
    }

    Object get(String string) {
        return this.map.get(string);
    }

    void setSelected(String string, boolean bl) {
        ((AbstractButton)this.get(string)).setSelected(bl);
    }

    public void updateLabels() {
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(true);
        this.setupLabels();
        KeyJMenuItem.setAbstractButtonLabels(this.map, this.labels);
        GT.setDoTranslate(bl);
    }
}

