/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.applet.Applet;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.export.dialog.Dialog;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.AppConsole;
import org.openscience.jmol.app.jmolpanel.DisplayPanel;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;
import org.openscience.jmol.app.webexport.WebExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusListener
implements JmolStatusListener {
    JmolPanel jmol;
    DisplayPanel display;
    JmolViewer viewer;

    void setViewer(JmolViewer jmolViewer) {
        this.viewer = jmolViewer;
    }

    StatusListener(JmolPanel jmolPanel, DisplayPanel displayPanel) {
        this.jmol = jmolPanel;
        this.display = displayPanel;
    }

    @Override
    public boolean notifyEnabled(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(int n, Object[] objectArray) {
        String string = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
        switch (n) {
            case 5: {
                this.notifyFileLoaded(string, (String)objectArray[2], (String)objectArray[3], (String)objectArray[4]);
                return;
            }
            case 0: {
                int[] nArray = (int[])objectArray[1];
                int n2 = nArray[0];
                if (n2 <= -2) {
                    n2 = -2 - n2;
                }
                if (this.display.haveDisplay) {
                    String string2 = (String)objectArray[2];
                    this.display.status.setStatus(1, string2);
                    if (this.jmol.frame != null) {
                        this.jmol.frame.setTitle(string2);
                    }
                }
                return;
            }
            case 11: {
                int n3 = (Integer)objectArray[3];
                if (n3 == 0 && objectArray[2] != null && this.display.haveDisplay) {
                    this.display.status.setStatus(1, (String)objectArray[2]);
                }
                return;
            }
            case 1: {
                break;
            }
            case 6: {
                String string3 = (String)objectArray[3];
                if (string3.indexOf("Pending") < 0 && this.display.haveDisplay) {
                    this.display.measurementTable.updateTables();
                    return;
                }
                if (string3.indexOf("Picked") >= 0) {
                    this.notifyAtomPicked(string);
                    break;
                }
                if (string3.indexOf("Completed") >= 0) break;
                return;
            }
            case 7: {
                break;
            }
            case 9: {
                this.notifyAtomPicked(string);
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 10: 
            case 12: {
                return;
            }
        }
        JmolCallbackListener jmolCallbackListener = (JmolCallbackListener)this.viewer.getProperty("DATA_API", "getAppConsole", null);
        if (jmolCallbackListener != null) {
            jmolCallbackListener.notifyCallback(n, objectArray);
        }
    }

    @Override
    public void setCallbackFunction(String string, String string2) {
        if (string.equals("modelkit")) {
            this.jmol.setButtonMode(string2.equals("ON") ? "modelkit" : "rotate");
            return;
        }
        if (string.equalsIgnoreCase("menu")) {
            this.jmol.setupNewFrame(this.viewer.getStateInfo());
            return;
        }
        if (string.equalsIgnoreCase("language")) {
            AppConsole appConsole;
            JmolResourceHandler.clear();
            Dialog.setupUIManager();
            if (this.jmol.webExport != null) {
                WebExport.saveHistory();
                WebExport.dispose();
                this.jmol.createWebExport();
            }
            if ((appConsole = (AppConsole)this.viewer.getProperty("DATA_API", "getAppConsole", null)) != null) {
                appConsole.sendConsoleEcho(null);
            }
            this.display.jmolPanel.updateLabels();
            return;
        }
    }

    @Override
    public String eval(String string) {
        String string2 = "# this funcationality is implemented only for the applet.\n" + string;
        this.sendConsoleMessage(string2);
        return string2;
    }

    @Override
    public String createImage(String string, String string2, Object object, int n) {
        return null;
    }

    private void notifyAtomPicked(String string) {
        if (this.display.haveDisplay) {
            this.display.status.setStatus(1, string);
        }
    }

    private void notifyFileLoaded(String string, String string2, String string3, String string4) {
        if (string4 != null) {
            return;
        }
        if (!this.display.haveDisplay) {
            return;
        }
        String string5 = "Jmol";
        if (string3 != null && string2 != null) {
            string5 = string2 + " - " + string3;
        } else if (string2 != null) {
            string5 = string2;
        } else if (string3 != null) {
            string5 = string3;
        }
        this.jmol.notifyFileOpen(string, string5);
    }

    private void sendConsoleMessage(String string) {
        JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)this.viewer.getProperty("DATA_API", "getAppConsole", null);
        if (jmolAppConsoleInterface != null) {
            jmolAppConsoleInterface.sendConsoleMessage(string);
        }
    }

    @Override
    public void showUrl(String string) {
        try {
            Class<?> clazz = Class.forName("java.awt.Desktop");
            Method method = clazz.getMethod("getDesktop", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            Method method2 = clazz.getMethod("browse", URI.class);
            Object[] objectArray = new Object[]{new URI(string)};
            method2.invoke(object, objectArray);
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            JmolAppConsoleInterface jmolAppConsoleInterface = (JmolAppConsoleInterface)this.viewer.getProperty("DATA_API", "getAppConsole", null);
            if (jmolAppConsoleInterface != null) {
                jmolAppConsoleInterface.sendConsoleMessage("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
            }
            Logger.error("Java 6 Desktop.browse() capability unavailable. Could not open " + string);
        }
    }

    @Override
    public float[][] functionXY(String string, int n, int n2) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        float[][] fArray = new float[n][n2];
        int n3 = n;
        while (--n3 >= 0) {
            int n4 = n2;
            while (--n4 >= 0) {
                float f = (float)n3 / 5.0f;
                float f2 = (float)n4 / 5.0f;
                fArray[n3][n4] = f * f + f2;
                if (!Float.isNaN(fArray[n3][n4])) continue;
                fArray[n3][n4] = -((float)Math.sqrt(-f * f - f2));
            }
        }
        return fArray;
    }

    @Override
    public float[][][] functionXYZ(String string, int n, int n2, int n3) {
        n = Math.abs(n);
        n2 = Math.abs(n2);
        n3 = Math.abs(n3);
        float[][][] fArray = new float[n][n2][n3];
        int n4 = n;
        while (--n4 >= 0) {
            int n5 = n2;
            while (--n5 >= 0) {
                int n6 = n3;
                while (--n6 >= 0) {
                    float f = (float)n4 / ((float)(n - 1) / 2.0f) - 1.0f;
                    float f2 = (float)n5 / ((float)(n2 - 1) / 2.0f) - 1.0f;
                    float f3 = (float)n6 / ((float)(n3 - 1) / 2.0f) - 1.0f;
                    fArray[n4][n5][n6] = f * f + f2 * f2 - f3 * f3;
                }
            }
        }
        return fArray;
    }

    @Override
    public Map<String, Applet> getRegistryInfo() {
        return null;
    }
}

