/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.binding;

import java.util.Hashtable;
import org.exolab.castor.builder.binding.xml.Binding;
import org.exolab.castor.builder.binding.xml.ComponentBindingType;
import org.exolab.castor.xml.schema.Annotated;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;

public final class ExtendedBinding
extends Binding {
    protected static final String PATH_SEPARATOR = "/";
    protected static final String ATTRIBUTE_PREFIX = "@";
    protected static final String COMPLEXTYPE_ID = "complexType:";
    protected static final String SIMPLETYPE_ID = "simpleType:";
    protected static final String ENUMTYPE_ID = "enumType:";
    protected static final String GROUP_ID = "group:";
    private static final short ATTRIBUTE = 10;
    private static final short ELEMENT = 11;
    private static final short COMPLEXTYPE = 12;
    private static final short GROUP = 13;
    private static final short ENUM_TYPE = 14;
    private static final short SIMPLETYPE = 15;
    private Hashtable _componentBindings = new Hashtable();
    private boolean _bindingProcessed = false;

    public ComponentBindingType getComponentBindingType(Annotated annotated) {
        String xPath;
        ComponentBindingType result;
        if (annotated == null) {
            return null;
        }
        if (annotated.getStructureType() == 10) {
            return null;
        }
        if (!this._bindingProcessed) {
            this.processBindingComponents();
        }
        if ((result = this.lookupComponentBindingType(xPath = ExtendedBinding.getSchemaLocation((Structure)annotated))) == null) {
            switch (annotated.getStructureType()) {
                case 8: {
                    if (result != null) break;
                    ElementDecl element = (ElementDecl)annotated;
                    if (element.isReference()) {
                        xPath = ExtendedBinding.getSchemaLocation((Structure)element.getReference());
                        result = this.lookupComponentBindingType(xPath);
                    }
                    element = null;
                    break;
                }
                case 3: {
                    if (result != null) break;
                    AttributeDecl attribute = (AttributeDecl)annotated;
                    if (attribute.isReference()) {
                        xPath = ExtendedBinding.getSchemaLocation((Structure)attribute.getReference());
                        result = this.lookupComponentBindingType(xPath);
                    }
                    attribute = null;
                    break;
                }
            }
        }
        return result;
    }

    private ComponentBindingType lookupComponentBindingType(String xPath) {
        if (xPath == null) {
            return null;
        }
        return (ComponentBindingType)this._componentBindings.get(xPath);
    }

    private void processBindingComponents() {
        ComponentBindingType temp;
        int i;
        ComponentBindingType[] tempBindings = this.getAttributeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 10);
        }
        tempBindings = this.getComplexTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 12);
        }
        tempBindings = this.getElementBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 11);
        }
        tempBindings = this.getGroupBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 13);
        }
        tempBindings = this.getEnumBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 14);
        }
        tempBindings = this.getSimpleTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, null, 15);
        }
        temp = null;
        tempBindings = null;
        this._bindingProcessed = true;
    }

    private void handleComponent(ComponentBindingType binding, String xPath, int type) {
        ComponentBindingType temp;
        int i;
        String name;
        if (binding == null) {
            return;
        }
        String currentPath = xPath;
        if (currentPath == null) {
            currentPath = new String();
        }
        boolean xpathUsed = (name = binding.getName()).indexOf(PATH_SEPARATOR) != -1;
        switch (type) {
            case 10: {
                if (!xpathUsed) {
                    currentPath = currentPath + PATH_SEPARATOR + ATTRIBUTE_PREFIX;
                }
                currentPath = currentPath + name;
                this._componentBindings.put(currentPath, binding);
                break;
            }
            case 15: {
                if (!xpathUsed) {
                    currentPath = currentPath + SIMPLETYPE_ID;
                }
                currentPath = currentPath + name;
                this._componentBindings.put(currentPath, binding);
                break;
            }
            case 11: {
                if (!xpathUsed) {
                    currentPath = currentPath + PATH_SEPARATOR;
                }
                currentPath = currentPath + name;
                this._componentBindings.put(currentPath, binding);
                break;
            }
            case 12: {
                if (!xpathUsed) {
                    currentPath = currentPath + COMPLEXTYPE_ID;
                }
                currentPath = currentPath + name;
                this._componentBindings.put(currentPath, binding);
                break;
            }
            case 14: {
                if (!xpathUsed) {
                    currentPath = currentPath + ENUMTYPE_ID;
                }
                currentPath = currentPath + name;
                this._componentBindings.put(currentPath, binding);
                break;
            }
            case 13: {
                if (!xpathUsed) {
                    currentPath = currentPath + GROUP_ID;
                }
                currentPath = currentPath + name;
                this._componentBindings.put(currentPath, binding);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid ComponentBindingType: the type (attribute, element, complextype or group) is unknown");
            }
        }
        ComponentBindingType[] tempBindings = binding.getAttributeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, currentPath, 10);
        }
        tempBindings = binding.getComplexTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, currentPath, 12);
        }
        tempBindings = binding.getSimpleTypeBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, currentPath, 15);
        }
        tempBindings = binding.getElementBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, currentPath, 11);
        }
        tempBindings = binding.getGroupBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, currentPath, 13);
        }
        tempBindings = binding.getEnumBinding();
        for (i = 0; i < tempBindings.length; ++i) {
            temp = tempBindings[i];
            this.handleComponent(temp, currentPath, 14);
        }
        temp = null;
        tempBindings = null;
    }

    public static String getSchemaLocation(Structure structure) {
        if (structure == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(30);
        ExtendedBinding.getSchemaLocation(structure, buffer);
        return buffer.toString();
    }

    private static void getSchemaLocation(Structure structure, StringBuffer location) {
        if (structure == null) {
            throw new IllegalArgumentException("Structure cannot be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("location cannot be null");
        }
        Structure parent = null;
        switch (structure.getStructureType()) {
            case 8: {
                parent = ((ElementDecl)structure).getParent();
                if (parent.getStructureType() != 19) {
                    ExtendedBinding.getSchemaLocation(parent, location);
                }
                location.append(PATH_SEPARATOR);
                location.append(((ElementDecl)structure).getName());
                break;
            }
            case 6: {
                ComplexType complexType = (ComplexType)structure;
                parent = complexType.getParent();
                if (parent.getStructureType() != 19) {
                    ExtendedBinding.getSchemaLocation(parent, location);
                }
                if (complexType.getName() == null) break;
                location.append(PATH_SEPARATOR);
                location.append(COMPLEXTYPE_ID);
                location.append(((ComplexType)structure).getName());
                break;
            }
            case 21: {
                SimpleType simpleType = (SimpleType)structure;
                parent = simpleType.getParent();
                if (parent != null && parent.getStructureType() != 19) {
                    ExtendedBinding.getSchemaLocation(parent, location);
                }
                if (parent == null || simpleType.getName() == null) break;
                location.append(PATH_SEPARATOR);
                location.append(ENUMTYPE_ID);
                location.append(((SimpleType)structure).getName());
                break;
            }
            case 16: {
                ModelGroup group = (ModelGroup)structure;
                parent = group.getParent();
                if (parent.getStructureType() != 19) {
                    ExtendedBinding.getSchemaLocation(parent, location);
                }
                if (group.getName() == null) break;
                location.append(GROUP_ID);
                location.append(group.getName());
                break;
            }
            case 3: {
                parent = ((AttributeDecl)structure).getParent();
                if (parent.getStructureType() != 19) {
                    ExtendedBinding.getSchemaLocation(parent, location);
                }
                location.append(PATH_SEPARATOR);
                location.append(ATTRIBUTE_PREFIX);
                location.append(((AttributeDecl)structure).getName());
                break;
            }
            case 10: {
                ExtendedBinding.getSchemaLocation(((Group)structure).getParent(), location);
                break;
            }
        }
    }
}

