/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.conflictresolution;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.builder.conflictresolution.ClassNameCRStrategy;

public final class ClassNameCRStrategyRegistry {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry == null ? (class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry = ClassNameCRStrategyRegistry.class$("org.exolab.castor.builder.conflictresolution.ClassNameCRStrategyRegistry")) : class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry));
    private Map _strategies = new HashMap();
    static /* synthetic */ Class class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry;

    public ClassNameCRStrategyRegistry(String enlistedNameConflictStrategies) {
        StringTokenizer tokenizer = new StringTokenizer(enlistedNameConflictStrategies, ", ");
        ClassLoader loader = (class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry == null ? (class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry = ClassNameCRStrategyRegistry.class$("org.exolab.castor.builder.conflictresolution.ClassNameCRStrategyRegistry")) : class$org$exolab$castor$builder$conflictresolution$ClassNameCRStrategyRegistry).getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken();
            try {
                Class<?> cls = loader.loadClass(classname);
                Object obj = cls.newInstance();
                ClassNameCRStrategy strategy = (ClassNameCRStrategy)obj;
                this._strategies.put(strategy.getName(), strategy);
            }
            catch (Exception except) {
                LOG.error((Object)("The ClassNameConflictResolutionStrategy " + classname + " " + "specified in the Castor builder properties file could not " + "be instantiated."));
            }
        }
    }

    public String[] getClassNameConflictResolutionStrategyNames() {
        String[] names = new String[this._strategies.size()];
        return this._strategies.keySet().toArray(names);
    }

    public ClassNameCRStrategy getClassNameConflictResolutionStrategy(String name) {
        Object factory = this._strategies.get(name);
        if (factory == null) {
            String msg = "The ClassNameConflictResolutionStrategy '" + name + "' " + "does not exist in the Castor builder properties file " + "and is therefore not supported.";
            LOG.error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        return (ClassNameCRStrategy)factory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

