/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.lang.reflect.Array;
import org.exolab.castor.util.OrderedHashMap;
import org.exolab.javasource.JAnnotationType;
import org.exolab.javasource.JSourceWriter;

public final class JAnnotation {
    private static final String VALUE = "value";
    private JAnnotationType _annotationType;
    private OrderedHashMap _elementValues = new OrderedHashMap();

    public JAnnotation(JAnnotationType annotationType) {
        this._annotationType = annotationType;
    }

    public JAnnotationType getAnnotationType() {
        return this._annotationType;
    }

    public void setValue(String stringValue) {
        this._elementValues.put((Object)VALUE, (Object)stringValue);
    }

    public void setValue(String[] stringValue) {
        this._elementValues.put((Object)VALUE, (Object)stringValue);
    }

    public void setValue(JAnnotation annotationValue) {
        this._elementValues.put((Object)VALUE, (Object)annotationValue);
    }

    public void setValue(JAnnotation[] annotationValues) {
        this._elementValues.put((Object)VALUE, (Object)annotationValues);
    }

    public void setElementValue(String elementName, String stringValue) {
        this._elementValues.put((Object)elementName, (Object)stringValue);
    }

    public void setElementValue(String elementName, String[] stringValues) {
        this._elementValues.put((Object)elementName, (Object)stringValues);
    }

    public void setElementValue(String elementName, JAnnotation annotationValue) {
        this._elementValues.put((Object)elementName, (Object)annotationValue);
    }

    public void setElementValue(String elementName, JAnnotation[] annotationValues) {
        this._elementValues.put((Object)elementName, (Object)annotationValues);
    }

    public String getValue() {
        Object elementValue = this.getElementValueObject(VALUE);
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        throw new IllegalStateException("'value' element is not of type String.");
    }

    public JAnnotation getValueAnnotation() {
        Object elementValue = this.getElementValueObject(VALUE);
        if (elementValue instanceof JAnnotation) {
            return (JAnnotation)elementValue;
        }
        throw new IllegalStateException("'value' element is not of type JAnnotation.");
    }

    public String getElementValue(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof String) {
            return (String)elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type String.");
    }

    public String[] getElementValueList(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof String[]) {
            return (String[])elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type String[].");
    }

    public Object getElementValueObject(String elementName) {
        return this._elementValues.get((Object)elementName);
    }

    public JAnnotation getElementValueAnnotation(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof JAnnotation) {
            return (JAnnotation)elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type JAnnotation.");
    }

    public JAnnotation[] getElementValueAnnotationList(String elementName) {
        Object elementValue = this.getElementValueObject(elementName);
        if (elementValue instanceof JAnnotation[]) {
            return (JAnnotation[])elementValue;
        }
        throw new IllegalStateException("'" + elementName + "' element is not of type JAnnotation[].");
    }

    public String[] getElementNames() {
        return this._elementValues.keySet().toArray(new String[this._elementValues.size()]);
    }

    public void print(JSourceWriter jsw) {
        jsw.write("@");
        jsw.write(this._annotationType.getLocalName());
        jsw.write("(");
        String[] elementNames = this.getElementNames();
        if (elementNames.length == 1 && elementNames[0].equals(VALUE)) {
            this.printElementValue(jsw, this.getElementValueObject(VALUE));
        } else if (elementNames.length > 0) {
            int elementNameLength;
            int i;
            int maxLength = 0;
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                if (elementNameLength <= maxLength) continue;
                maxLength = elementNameLength;
            }
            jsw.writeln();
            jsw.indent();
            for (i = 0; i < elementNames.length; ++i) {
                elementNameLength = elementNames[i].length();
                jsw.write(elementNames[i]);
                for (int p = 0; p < maxLength - elementNameLength; ++p) {
                    jsw.write(" ");
                }
                jsw.write(" = ");
                this.printElementValue(jsw, this.getElementValueObject(elementNames[i]));
                if (i >= elementNames.length - 1) continue;
                jsw.write(",");
                jsw.writeln();
            }
            jsw.unindent();
        }
        jsw.write(")");
    }

    private void printElementValue(JSourceWriter jsw, Object elementValue) {
        if (elementValue instanceof String) {
            jsw.write((String)elementValue);
            return;
        }
        if (elementValue instanceof JAnnotation) {
            JAnnotation annotation = (JAnnotation)elementValue;
            annotation.print(jsw);
            return;
        }
        if (elementValue.getClass().isArray()) {
            int listLength = Array.getLength(elementValue);
            if (listLength == 1) {
                this.printElementValue(jsw, Array.get(elementValue, 0));
                return;
            }
            jsw.indent();
            jsw.writeln();
            jsw.write("{");
            jsw.writeln();
            jsw.indent();
            for (int i = 0; i < listLength; ++i) {
                this.printElementValue(jsw, Array.get(elementValue, i));
                if (i < listLength - 1) {
                    jsw.write(",");
                }
                jsw.writeln();
            }
            jsw.unindent();
            jsw.write("}");
            jsw.unindent();
            return;
        }
        throw new IllegalArgumentException("'" + elementValue + "' was not expected.");
    }
}

