/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.jalopy.language.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class DeclarationType
implements Comparable,
Type {
    public static final int CLASS_INT = 2;
    public static final int CTOR_INT = 4;
    public static final int INIT_INT = 16;
    public static final int INTERFACE_INT = 8;
    public static final int METHOD_INT = 32;
    public static final int VARIABLE_INT = 1;
    public static final int STATIC_VAR_INIT_INT = 64;
    private static final String DELIMETER = "|";
    private static String _sortOrder;
    private static final String BUNDLE_NAME = "de.hunsicker.jalopy.language.Bundle";
    private static final List _order;
    public static final DeclarationType CLASS;
    public static final DeclarationType INTERFACE;
    public static final DeclarationType VARIABLE;
    public static final DeclarationType INIT;
    public static final DeclarationType CTOR;
    public static final DeclarationType METHOD;
    public static final DeclarationType STATIC_VARIABLE_INIT;
    private final String _displayName;
    private final String _name;
    private final int _key;

    private DeclarationType(String name, String displayName, int key) {
        this._name = name;
        this._displayName = displayName;
        this._key = key;
    }

    public String getName() {
        return this._name;
    }

    public static synchronized void setOrder(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("invalid order string -- " + str);
        }
        StringTokenizer tokens = new StringTokenizer(str, DELIMETER);
        ArrayList<DeclarationType> temp = new ArrayList<DeclarationType>(_order.size());
        StringBuffer buf = new StringBuffer(20);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            DeclarationType type = DeclarationType.valueOf(token);
            if (temp.contains(type)) {
                throw new IllegalArgumentException("invalid order string -- " + temp);
            }
            temp.add(type);
            buf.append(type.toString());
            buf.append(DELIMETER);
        }
        if (_order.size() != temp.size()) {
            throw new IllegalArgumentException("invalid order string -- " + temp);
        }
        if (!(temp.contains(CLASS) && temp.contains(INTERFACE) && temp.contains(CTOR) && temp.contains(VARIABLE) && temp.contains(METHOD) && temp.contains(INIT) && temp.contains(STATIC_VARIABLE_INIT))) {
            throw new IllegalArgumentException("invalid order string -- " + temp);
        }
        _order.clear();
        _order.addAll(temp);
        buf.deleteCharAt(buf.length() - 1);
        _sortOrder = buf.toString();
    }

    public static synchronized String getOrder() {
        return _sortOrder;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof DeclarationType) {
            int otherIndex;
            int thisIndex = _order.indexOf(this);
            if (thisIndex > (otherIndex = _order.indexOf(other))) {
                return 1;
            }
            if (thisIndex < otherIndex) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException(other == null ? "null" : other.getClass().getName());
    }

    public String toString() {
        return this._displayName;
    }

    public static DeclarationType valueOf(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("invalid declaration name -- " + name);
        }
        if (DeclarationType.METHOD._name.equals(name = name.trim())) {
            return METHOD;
        }
        if (DeclarationType.CTOR._name.equals(name)) {
            return CTOR;
        }
        if (DeclarationType.VARIABLE._name.equals(name)) {
            return VARIABLE;
        }
        if (DeclarationType.STATIC_VARIABLE_INIT._name.equals(name)) {
            return STATIC_VARIABLE_INIT;
        }
        if (DeclarationType.INIT._name.equals(name)) {
            return INIT;
        }
        if (DeclarationType.CLASS._name.equals(name)) {
            return CLASS;
        }
        if (DeclarationType.INTERFACE._name.equals(name)) {
            return INTERFACE;
        }
        return null;
    }

    static {
        _order = new ArrayList(7);
        CLASS = new DeclarationType("class", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_CLASS"), 2);
        INTERFACE = new DeclarationType("interface", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_INTERFACE"), 8);
        VARIABLE = new DeclarationType("field", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_FIELD"), 1);
        INIT = new DeclarationType("initializer", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_INITIALIZER"), 16);
        CTOR = new DeclarationType("constructor", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_CONSTRUCTOR"), 4);
        METHOD = new DeclarationType("method", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_METHOD"), 32);
        STATIC_VARIABLE_INIT = new DeclarationType("static", ResourceBundle.getBundle(BUNDLE_NAME).getString("TYPE_STATIC"), 64);
        _order.add(STATIC_VARIABLE_INIT);
        _order.add(VARIABLE);
        _order.add(INIT);
        _order.add(CTOR);
        _order.add(METHOD);
        _order.add(INTERFACE);
        _order.add(CLASS);
        StringBuffer buf = new StringBuffer(100);
        int size = _order.size();
        for (int i = 0; i < size; ++i) {
            buf.append(((DeclarationType)DeclarationType._order.get((int)i))._name);
            buf.append(DELIMETER);
        }
        buf.setLength(buf.length() - 1);
        _sortOrder = buf.toString();
    }
}

