/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.Token;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.Annotation;
import de.hunsicker.jalopy.language.Node;
import de.hunsicker.jalopy.language.Position;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaNode
extends Node {
    protected JavaNode parent;
    protected JavaNode prevSibling;
    private List _annotations = Collections.EMPTY_LIST;
    private Position _position;

    public JavaNode(int startLine, int startColumn, int endLine, int endColumn) {
        super(startLine, startColumn, endLine, endColumn);
    }

    public JavaNode() {
    }

    public JavaNode(Token tok) {
        super(tok);
    }

    public JavaNode(int type, String text) {
        super(type, text);
    }

    public CommonHiddenStreamToken getCommentAfter() {
        if (this.hiddenAfter != null) {
            block3: for (CommonHiddenStreamToken t = this.hiddenAfter; t != null; t = t.getHiddenAfter()) {
                switch (t.getType()) {
                    case 153: {
                        continue block3;
                    }
                    default: {
                        return t;
                    }
                }
            }
        }
        return null;
    }

    public CommonHiddenStreamToken getCommentBefore() {
        CommonHiddenStreamToken result = null;
        block3: for (CommonHiddenStreamToken t = this.getHiddenBefore(); t != null; t = t.getHiddenBefore()) {
            switch (t.getType()) {
                case 153: {
                    continue block3;
                }
                default: {
                    result = t;
                }
            }
        }
        return result;
    }

    public void setParent(JavaNode node) {
        this.parent = node;
    }

    public JavaNode getParent() {
        return this.parent;
    }

    public void setPosition(Position position) {
        this._position = position;
    }

    public Position getPosition() {
        return this._position;
    }

    public void setPreviousSibling(JavaNode node) {
        this.prevSibling = node;
    }

    public JavaNode getPreviousSibling() {
        return this.prevSibling;
    }

    public int getSizeCommentsAfter() {
        if (this.hiddenAfter != null) {
            int result = 0;
            block3: for (CommonHiddenStreamToken t = this.hiddenAfter; t != null; t = t.getHiddenAfter()) {
                switch (t.getType()) {
                    case 153: {
                        continue block3;
                    }
                    default: {
                        ++result;
                    }
                }
            }
            return result;
        }
        return 0;
    }

    public int getSizeCommentsBefore() {
        if (this.hiddenBefore != null) {
            int result = 0;
            block3: for (CommonHiddenStreamToken t = this.hiddenBefore; t != null; t = t.getHiddenBefore()) {
                switch (t.getType()) {
                    case 153: {
                        continue block3;
                    }
                    default: {
                        ++result;
                    }
                }
            }
            return result;
        }
        return 0;
    }

    public void addChild(AST node) {
        if (node == null) {
            return;
        }
        JavaNode t = (JavaNode)this.down;
        JavaNode n = (JavaNode)node;
        if (t != null) {
            while (t.getNextSibling() != null) {
                t = (JavaNode)t.getNextSibling();
            }
            t.setNextSibling(node);
            n.prevSibling = t;
        } else {
            this.down = n;
            n.prevSibling = this;
        }
        n.parent = this;
        this.endLine = n.endLine;
        this.endColumn = n.endColumn;
    }

    public void attachAnnotation(Annotation annotation) {
        if (this._annotations == Collections.EMPTY_LIST) {
            this._annotations = new ArrayList(10);
        }
        this._annotations.add(annotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List detachAnnotations() {
        try {
            List list = this._annotations;
            return list;
        }
        finally {
            if (this._annotations != Collections.EMPTY_LIST) {
                this._annotations = Collections.EMPTY_LIST;
            }
        }
    }

    public boolean hasCommentsAfter() {
        return this.getSizeCommentsAfter() > 0;
    }

    public boolean hasCommentsBefore() {
        return this.getSizeCommentsBefore() > 0;
    }

    public boolean hasJavadocComment() {
        for (CommonHiddenStreamToken comment = this.getHiddenBefore(); comment != null; comment = comment.getHiddenBefore()) {
            switch (comment.getType()) {
                case 6: {
                    return true;
                }
            }
        }
        return false;
    }

    public void initialize(AST node) {
        super.initialize(node);
        JavaNode n = (JavaNode)node;
        this.parent = n.parent;
        this.prevSibling = n.prevSibling;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append('\"');
        buf.append(this.text);
        buf.append('\"');
        buf.append(", <");
        buf.append(this.type);
        buf.append(">");
        buf.append(", par ");
        buf.append(this.parent != null ? this.parent.text : "NONE");
        buf.append(", prev ");
        buf.append(this.prevSibling != null ? this.prevSibling.text : "NONE");
        buf.append(", next ");
        buf.append(this.getNextSibling() != null ? this.getNextSibling().getText() : "NONE");
        buf.append(", [");
        buf.append(this.startLine);
        buf.append(':');
        buf.append(this.startColumn);
        buf.append("-");
        buf.append(this.endLine);
        buf.append(':');
        buf.append(this.endColumn);
        buf.append("], ");
        buf.append(this.getSizeCommentsBefore());
        buf.append(",");
        buf.append(this.getSizeCommentsAfter());
        return buf.toString();
    }

    public void updatePosition(int line, int column) {
        if (this._position != null) {
            this._position.line = line;
            this._position.column = column;
        }
        int size = this._annotations.size();
        for (int i = 0; i < size; ++i) {
            Annotation annotation = (Annotation)this._annotations.get(i);
            annotation.setLine(line);
        }
    }
}

