/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ArrayTypePrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ArrayTypePrinter();

    protected ArrayTypePrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        AST child;
        boolean bracketsAfterIdentifier = settings.getBoolean(ConventionKeys.ARRAY_BRACKETS_AFTER_IDENT, false);
        if (child != null) {
            block4: for (child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                switch (child.getType()) {
                    case 32: {
                        if (settings.getBoolean(ConventionKeys.PADDING_BRACKETS, false)) {
                            out.print("[ ", 57);
                            PrinterFactory.create(child).print(child, out);
                            out.print(" ]", 58);
                            continue block4;
                        }
                        out.print("[", 57);
                        PrinterFactory.create(child).print(child, out);
                        out.print("]", 58);
                        continue block4;
                    }
                    case 21: {
                        this.print(child, out);
                        if (child.getNextSibling() != null) continue block4;
                        if (bracketsAfterIdentifier && this.canMoveBrackets(node)) {
                            ++out.state.arrayBrackets;
                            continue block4;
                        }
                        out.print("[]", 58);
                        continue block4;
                    }
                    default: {
                        PrinterFactory.create(child).print(child, out);
                        if (bracketsAfterIdentifier && this.canMoveBrackets(node)) {
                            ++out.state.arrayBrackets;
                            continue block4;
                        }
                        if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) {
                            out.print(" []", 21);
                            continue block4;
                        }
                        out.print("[]", 58);
                    }
                }
            }
        } else if (settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES, false)) {
            out.print(" []", 21);
        } else {
            out.print("[]", 58);
        }
        out.last = 21;
    }

    private boolean canMoveBrackets(AST node) {
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            case 17: {
                switch (parent.getParent().getType()) {
                    case 13: 
                    case 27: 
                    case 131: {
                        return false;
                    }
                }
                break;
            }
            case 27: 
            case 146: {
                return false;
            }
            case 21: {
                return this.canMoveBrackets(parent);
            }
        }
        AST next = node.getNextSibling();
        if (next != null) {
            switch (next.getType()) {
                case 79: {
                    return false;
                }
            }
        }
        return true;
    }
}

