/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.printer.BlockStatementPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ForPrinter
extends BlockStatementPrinter {
    private static final Printer INSTANCE = new ForPrinter();

    protected ForPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        super.print(node, out);
        int offset = 1;
        offset = settings.getBoolean(ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN, true) ? out.print("for ", 94) : out.print("for", 94);
        this.trackPosition((JavaNode)node, out.line, offset, out);
        AST lparen = node.getFirstChild();
        PrinterFactory.create(lparen).print(lparen, out);
        Marker marker = out.state.markers.add();
        AST forInit = lparen.getNextSibling();
        AST firstSemi = forInit.getNextSibling();
        AST forCond = firstSemi.getNextSibling();
        AST secondSemi = forCond.getNextSibling();
        AST forIter = secondSemi.getNextSibling();
        int lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean indentDeep = settings.getBoolean(ConventionKeys.INDENT_DEEP, false);
        boolean firstWrap = false;
        if (out.mode == 1) {
            ++out.state.paramLevel;
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN, false)) {
                AST child;
                TestNodeWriter tester = out.testers.get();
                for (AST c = child = forInit.getFirstChild(); c != null; c = c.getNextSibling()) {
                    PrinterFactory.create(c).print(c, tester);
                }
                child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child).print(child, tester);
                }
                if ((child = forIter.getFirstChild()) != null) {
                    PrinterFactory.create(child).print(child, tester);
                }
                if (out.column + tester.length > lineLength) {
                    firstWrap = true;
                }
                out.testers.release(tester);
            }
        }
        this.printForInit(forInit, firstWrap, out);
        boolean wrapAll = settings.getBoolean(ConventionKeys.LINE_WRAP_PARAMS_EXCEED, false);
        boolean spaceAfterSemi = settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true);
        out.continuation = settings.getBoolean(ConventionKeys.INDENT_CONTINUATION_BLOCK, true);
        boolean secondWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                secondWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forCond.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 3 : 2);
                }
                if (out.column + tester.length > lineLength) {
                    secondWrap = true;
                }
                out.testers.release(tester);
            }
        }
        out.print(";", 39);
        this.printCommentsAfter(firstSemi, false, false, out);
        this.printForCond(forCond, secondWrap, out);
        boolean thirdWrap = false;
        if (out.mode == 1) {
            if (firstWrap && wrapAll) {
                thirdWrap = true;
            } else {
                TestNodeWriter tester = out.testers.get();
                AST child = forIter.getFirstChild();
                if (child != null) {
                    PrinterFactory.create(child).print(child, tester);
                    tester.length = tester.length + (spaceAfterSemi ? 5 : 3);
                }
                if (out.column + tester.length > lineLength) {
                    thirdWrap = true;
                }
                out.testers.release(tester);
            }
        }
        out.print(";", 39);
        this.printCommentsAfter(secondSemi, false, false, out);
        this.printForIter(forIter, thirdWrap, out);
        out.continuation = false;
        if (firstWrap || secondWrap || thirdWrap) {
            if (settings.getBoolean(ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN, false)) {
                if (!out.newline) {
                    out.printNewline();
                    if (indentDeep) {
                        out.print(out.getString(marker.column - 1 - out.getIndentLength()), 153);
                    }
                }
                out.print(EMPTY_STRING, 153);
            }
        }
        AST rparen = forIter.getNextSibling();
        PrinterFactory.create(rparen).print(rparen, out);
        out.state.markers.remove(marker);
        if (out.mode == 1) {
            --out.state.paramLevel;
            out.state.parenScope.removeFirst();
        }
        out.last = 94;
        AST body = rparen.getNextSibling();
        switch (body.getType()) {
            case 11: {
                PrinterFactory.create(body).print(body, out);
                break;
            }
            default: {
                if (settings.getBoolean(ConventionKeys.BRACE_INSERT_FOR, false)) {
                    out.printLeftBrace(settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false), true);
                    PrinterFactory.create(body).print(body, out);
                    out.printRightBrace();
                    break;
                }
                out.printNewline();
                out.indent();
                PrinterFactory.create(body).print(body, out);
                out.unindent();
            }
        }
        out.last = 8;
    }

    private void printForCond(AST node, boolean wrap, NodeWriter out) throws IOException {
        if (node.getFirstChild() == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 39);
        }
        for (AST child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            PrinterFactory.create(child).print(child, out);
        }
    }

    private void printForInit(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST child;
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        }
        if ((child = node.getFirstChild()) != null) {
            this.printVariableDefs(node, out);
        }
    }

    private void printForIter(AST node, boolean wrap, NodeWriter out) throws IOException {
        AST elist = node.getFirstChild();
        if (elist == null) {
            return;
        }
        if (wrap) {
            out.printNewline();
            this.printIndentation(out);
        } else if (settings.getBoolean(ConventionKeys.SPACE_AFTER_SEMICOLON, true)) {
            out.print(" ", 39);
        }
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        block3: for (AST element = elist.getFirstChild(); element != null; element = element.getNextSibling()) {
            switch (element.getType()) {
                case 82: {
                    out.print(comma, 82);
                    continue block3;
                }
                default: {
                    PrinterFactory.create(element).print(element, out);
                }
            }
        }
    }

    private void printVariableDef(AST node, NodeWriter out, boolean printType) throws IOException {
        switch (node.getType()) {
            case 38: {
                boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
                String comma = spaceAfterComma ? ", " : ",";
                for (AST param = node.getFirstChild(); param != null; param = param.getNextSibling()) {
                    PrinterFactory.create(param).print(param, out);
                    if (param.getNextSibling() == null) continue;
                    out.print(comma, 82);
                }
                return;
            }
        }
        AST modifier = node.getFirstChild();
        AST type = modifier.getNextSibling();
        if (printType) {
            PrinterFactory.create(modifier).print(modifier, out);
            PrinterFactory.create(type).print(type, out);
        }
        AST identifier = type.getNextSibling();
        if (out.last != 82) {
            out.print(" ", out.last);
        }
        PrinterFactory.create(identifier).print(identifier, out);
        AST assign = identifier.getNextSibling();
        if (assign != null) {
            switch (assign.getType()) {
                case 55: {
                    break;
                }
                default: {
                    PrinterFactory.create(assign).print(assign, out);
                }
            }
        }
    }

    private void printVariableDefs(AST node, NodeWriter out) throws IOException {
        AST child = node.getFirstChild();
        boolean spaceAfterComma = settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        String comma = spaceAfterComma ? ", " : ",";
        switch (child.getType()) {
            case 14: {
                this.printVariableDef(child, out, true);
                for (child = child.getNextSibling(); child != null; child = child.getNextSibling()) {
                    out.print(comma, 82);
                    this.printVariableDef(child, out, false);
                }
                break;
            }
            case 38: {
                block8: for (AST var = child.getFirstChild(); var != null; var = var.getNextSibling()) {
                    switch (child.getType()) {
                        case 82: {
                            out.print(comma, 82);
                            continue block8;
                        }
                        default: {
                            PrinterFactory.create(var).print(var, out);
                        }
                    }
                }
                break;
            }
        }
    }
}

