/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.storage;

import de.hunsicker.io.Copy;
import de.hunsicker.io.ExtensionFilter;
import de.hunsicker.io.IoHelper;
import de.hunsicker.jalopy.language.DeclarationType;
import de.hunsicker.jalopy.language.ModifierType;
import de.hunsicker.jalopy.storage.ConventionDefaults;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.History;
import de.hunsicker.jalopy.storage.ImportPolicy;
import de.hunsicker.jalopy.storage.Loggers;
import de.hunsicker.jalopy.storage.Project;
import de.hunsicker.util.ChainingRuntimeException;
import de.hunsicker.util.StringHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public final class Convention {
    public static final String EXTENSION_JAL = ".jal";
    public static final String EXTENSION_XML = ".xml";
    public static final String EXTENSION_DAT = ".dat";
    private static final String FILENAME_PROJECT = "project.dat";
    private static final String FILENAME_PREFERENCES = "preferences.dat";
    private static final String FILENAME_SETTINGS = "settings.xml";
    private static final String NAME_REPOSITORY = "repository";
    private static final String FILENAME_HISTORY = "history.dat";
    private static final String NAME_BACKUP = "bak";
    private static final Map EMPTY_MAP;
    private static final String VERSION = "6";
    private static final Object _lock;
    private static Convention INSTANCE;
    private static final Convention EMPTY_PREFERENCES;
    private static final Project DEFAULT_PROJECT;
    private static Project _project;
    private static File _settingsDirectory;
    private static File _backupDirectory;
    private static File _repositoryDirectory;
    private static File _settingsFile;
    private static File _projectSettingsDirectory;
    private static File _historyFile;
    private Locale _locale;
    private Map _snapshot;
    private Map _values = EMPTY_MAP;
    static /* synthetic */ Class class$de$hunsicker$jalopy$storage$Convention;

    private Convention(Map values) {
        Iterator keys;
        Object key;
        if (!values.isEmpty() && (key = (keys = values.keySet().iterator()).next()) instanceof de.hunsicker.jalopy.prefs.Key) {
            HashMap t = new HashMap(values.size());
            Iterator i = values.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                t.put(new Key(entry.getKey().toString()), entry.getValue());
            }
            values = t;
        }
        this._values = values;
    }

    public static File getBackupDirectory() {
        return _backupDirectory;
    }

    public static Project getDefaultProject() {
        return DEFAULT_PROJECT;
    }

    public static File getHistoryFile() {
        return _historyFile;
    }

    public static Convention getInstance() {
        return INSTANCE;
    }

    public Locale getLocale() {
        return this._locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setProject(Project project) {
        Object object = _lock;
        synchronized (object) {
            try {
                INSTANCE.snapshot();
                File activeFile = Convention.getSettingsFile();
                Convention.setDirectories(project);
                Convention.storeProject(project);
                File file = Convention.getSettingsFile();
                if (file.exists()) {
                    Convention.importSettings(file);
                } else if (activeFile.exists()) {
                    Convention.importSettings(activeFile);
                }
                _project = project;
                return true;
            }
            catch (IOException ex) {
                _project = DEFAULT_PROJECT;
                Convention.setDirectories(_project);
                INSTANCE.revert();
                return false;
            }
        }
    }

    public static File getProjectSettingsDirectory() {
        return _projectSettingsDirectory;
    }

    public static File getRepositoryDirectory() {
        return _repositoryDirectory;
    }

    public static File getSettingsDirectory() {
        return _settingsDirectory;
    }

    public static File getSettingsFile() {
        return _settingsFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addProject(Project project) throws IOException {
        Object object = _lock;
        synchronized (object) {
            File projectDirectory = new File(Convention.getSettingsDirectory(), project.getName());
            File activeProjectDirectory = new File(Convention.getSettingsDirectory(), _project.getName());
            try {
                if (activeProjectDirectory.exists()) {
                    File[] files = activeProjectDirectory.listFiles(new ExtensionFilter(EXTENSION_DAT));
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].isFile()) continue;
                        Copy.file(files[i], new File(projectDirectory, files[i].getName()));
                    }
                }
                if (IoHelper.ensureDirectoryExists(projectDirectory)) {
                    IoHelper.serialize((Object)project, new File(projectDirectory, FILENAME_PROJECT));
                }
            }
            catch (IOException ex) {
                IoHelper.delete(projectDirectory, true);
                throw ex;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importSettings(InputStream in, String extension) throws IOException {
        if (EXTENSION_DAT.equals(extension) || EXTENSION_JAL.equals(extension)) {
            Convention.INSTANCE._values = (Map)IoHelper.deserialize(in);
            Convention.synchronize(INSTANCE);
            return;
        }
        if (!EXTENSION_XML.equals(extension)) throw new IllegalArgumentException("invalid extension -- " + extension);
        InputStreamReader isr = null;
        try {
            try {
                isr = new InputStreamReader((InputStream)new BufferedInputStream(in), "UTF-8");
                SAXBuilder builder = new SAXBuilder();
                Document document = builder.build((Reader)isr);
                Convention.INSTANCE._values = new HashMap();
                Convention.convertXmlToMap(Convention.INSTANCE._values, document.getRootElement());
                Convention.synchronize(INSTANCE);
            }
            catch (JDOMException ex) {
                throw new IOException(ex.getMessage());
            }
            Object var6_6 = null;
            if (isr == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (isr == null) throw throwable;
            try {
                ((Reader)isr).close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        ((Reader)isr).close();
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void importSettings(URL url) throws IOException {
        InputStream in = null;
        try {
            try {
                in = url.openStream();
                Convention.importSettings(in, Convention.getExtension(url));
            }
            catch (MalformedURLException ex) {
                throw new ChainingRuntimeException("Could not load code convention from the given url -- " + url, ex);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        if (in == null) return;
        in.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void importSettings(File file) throws IOException {
        InputStream in = null;
        try {
            if (!file.exists()) {
                if (file.getAbsolutePath().indexOf(File.separatorChar) >= 0) throw new FileNotFoundException(file.getAbsolutePath());
                file = new File(System.getProperty("user.dir") + File.separator + file);
                if (file.exists()) {
                    in = new FileInputStream(file);
                } else {
                    file = new File(System.getProperty("user.home") + File.separator + file);
                    if (file.exists()) {
                        in = new FileInputStream(file);
                    } else {
                        in = (class$de$hunsicker$jalopy$storage$Convention == null ? (class$de$hunsicker$jalopy$storage$Convention = Convention.class$("de.hunsicker.jalopy.storage.Convention")) : class$de$hunsicker$jalopy$storage$Convention).getResourceAsStream(file.getAbsolutePath());
                        if (in == null) {
                            throw new FileNotFoundException("file not found -- " + file.getAbsolutePath());
                        }
                    }
                }
            } else {
                if (!file.isFile()) throw new IllegalArgumentException("no valid file -- " + file.getAbsolutePath());
                in = new FileInputStream(file);
            }
            Convention.importSettings(in, Convention.getExtension(file));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in == null) return;
            in.close();
            return;
        }
        catch (IOException ignored) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProject(Project project) throws IOException {
        Object object = _lock;
        synchronized (object) {
            File projectDirectory = new File(Convention.getSettingsDirectory(), project.getName());
            IoHelper.delete(projectDirectory, true);
        }
    }

    public boolean getBoolean(Key key, boolean def) {
        boolean result = def;
        String value = this.get(key, null);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    public int getInt(Key key, int def) {
        int result = def;
        try {
            String value = this.get(key, null);
            if (value != null) {
                result = Integer.parseInt(value);
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return result;
    }

    public void exportSettings(File file) throws IOException {
        this.exportSettings(new FileOutputStream(file), Convention.getExtension(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSettings(OutputStream out, String extension) throws IOException {
        this._values.put(ConventionKeys.INTERNAL_VERSION, VERSION);
        if (extension == null) {
            extension = EXTENSION_JAL;
        }
        if (EXTENSION_DAT.equals(extension) || EXTENSION_JAL.equals(extension)) {
            IoHelper.serialize((Object)this._values, new BufferedOutputStream(out));
        } else if (EXTENSION_XML.equals(extension)) {
            try {
                XMLOutputter outputter = new XMLOutputter("    ", true);
                Document document = new Document(this.convertMapToXml(this._values));
                outputter.output(document, out);
            }
            finally {
                out.close();
            }
        } else {
            throw new IllegalArgumentException("invalid file extension -- " + extension);
        }
    }

    public void flush() throws IOException {
        File directory = Convention.getProjectSettingsDirectory();
        if (!IoHelper.ensureDirectoryExists(directory)) {
            throw new IOException("could not create settings directory -- " + directory);
        }
        this._values.put(ConventionKeys.INTERNAL_VERSION, VERSION);
        IoHelper.serialize((Object)this._values, Convention.getSettingsFile());
        Convention.storeProject(_project);
    }

    public String get(Key key, String def) {
        if (key == null) {
            throw new NullPointerException("null no valid key");
        }
        String result = null;
        try {
            result = (String)this._values.get(key);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return result == null ? def : result;
    }

    public void put(Key key, String value) {
        if (key == null || value == null) {
            throw new NullPointerException(key + ", " + value);
        }
        this._values.put(key, value);
    }

    public void putBoolean(Key key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    public void putInt(Key key, int value) {
        this.put(key, Integer.toString(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert() {
        Object object = _lock;
        synchronized (object) {
            if (this._snapshot != null) {
                this._values.clear();
                this._values.putAll(this._snapshot);
                this._snapshot = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot() {
        Object object = _lock;
        synchronized (object) {
            this._snapshot = new HashMap(this._values);
        }
    }

    public String toString() {
        return this._values.toString();
    }

    private static void setDirectories(Project project) {
        _projectSettingsDirectory = new File(_settingsDirectory, project.getName());
        _backupDirectory = new File(_projectSettingsDirectory, NAME_BACKUP);
        _repositoryDirectory = new File(_projectSettingsDirectory, NAME_REPOSITORY);
        _settingsFile = new File(_projectSettingsDirectory, FILENAME_PREFERENCES);
        _historyFile = new File(_projectSettingsDirectory, FILENAME_HISTORY);
    }

    private static String getExtension(String location) throws IOException {
        int offset = location.lastIndexOf(46);
        if (offset > -1) {
            String extension = location.substring(offset);
            if (extension == null && !EXTENSION_JAL.equals(extension) && EXTENSION_DAT.equals(extension) && !EXTENSION_XML.equals(extension)) {
                throw new IOException("no valid location given -- " + location);
            }
            return extension;
        }
        throw new IllegalArgumentException("invalid file extension -- " + location);
    }

    private static String getExtension(File file) throws IOException {
        return Convention.getExtension(file.getName());
    }

    private static String getExtension(URL url) throws IOException {
        return Convention.getExtension(url.getFile());
    }

    private static History.Policy getHistoryPolicy(String policy) {
        if ("1".equals(policy)) {
            return History.Policy.COMMENT;
        }
        if ("2".equals(policy)) {
            return History.Policy.FILE;
        }
        return History.Policy.DISABLED;
    }

    private static void convertXmlToMap(Map map, Element element) {
        List children = element.getChildren();
        if (children.size() == 0) {
            StringBuffer path = new StringBuffer();
            String value = element.getText();
            do {
                if (path.length() > 0) {
                    path.insert(0, '/');
                }
                path.insert(0, element.getName());
            } while ((element = element.getParent()) != null && !element.getName().equals("jalopy"));
            map.put(new Key(new String(path)), value);
            return;
        }
        int i_len = children.size();
        for (int i = 0; i < i_len; ++i) {
            Element childElement = (Element)children.get(i);
            Convention.convertXmlToMap(map, childElement);
        }
    }

    private static Project loadProject() {
        try {
            File file = new File(Convention.getSettingsDirectory(), FILENAME_PROJECT);
            if (file.exists()) {
                Project project = (Project)IoHelper.deserialize(file);
                return project;
            }
            return DEFAULT_PROJECT;
        }
        catch (Throwable ex) {
            return DEFAULT_PROJECT;
        }
    }

    private static Convention readFromStream(InputStream in) throws IOException, ClassNotFoundException {
        return new Convention((Map)IoHelper.deserialize(new BufferedInputStream(in)));
    }

    private static void renameKey(Convention settings, String oldName, Key newKey) {
        Object value = settings._values.remove(new Key(oldName));
        if (value != null) {
            settings._values.put(newKey, value);
        }
    }

    private static void storeProject(Project project) throws IOException {
        File file = new File(Convention.getProjectSettingsDirectory(), FILENAME_PROJECT);
        IoHelper.serialize((Object)project, file);
        if (!project.getName().equals(DEFAULT_PROJECT.getName())) {
            IoHelper.serialize((Object)project, new File(Convention.getSettingsDirectory(), FILENAME_PROJECT));
        } else {
            File f = new File(Convention.getSettingsDirectory(), FILENAME_PROJECT);
            f.delete();
        }
    }

    private static void sync0To1(Convention settings) {
        INSTANCE = EMPTY_PREFERENCES;
        Convention.INSTANCE._values = EMPTY_MAP;
    }

    private static void sync1To2(Convention settings) {
        Object expand;
        Convention.renameKey(settings, "printer/alignment/throwsTypes", ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS);
        Convention.renameKey(settings, "printer/alignment/implementsTypes", ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS);
        Convention.renameKey(settings, "printer/alignment/extendsTypes", ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS);
        Object collapse = Convention.INSTANCE._values.get("transform/import/collapse");
        if (collapse != null) {
            Convention.INSTANCE._values.remove("transform/import/collapse");
            if ("true".equals(collapse)) {
                INSTANCE.putInt(ConventionKeys.IMPORT_POLICY, 2);
            }
        }
        if ((expand = Convention.INSTANCE._values.get("transform/import/expand")) != null) {
            Convention.INSTANCE._values.remove("transform/import/expand");
            if ("true".equals(expand)) {
                INSTANCE.putInt(ConventionKeys.IMPORT_POLICY, 1);
            }
        }
    }

    private static void sync2To3(Convention settings) {
        int historyPolicy = INSTANCE.getInt(ConventionKeys.HISTORY_POLICY, 0);
        switch (historyPolicy) {
            case -1: {
                INSTANCE.putInt(ConventionKeys.HISTORY_POLICY, 0);
            }
        }
    }

    private static void sync3To4(Convention settings) {
        HashMap values = new HashMap(settings._values.size());
        Iterator i = settings._values.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (entry.getKey() instanceof String) {
                Key key = new Key((String)entry.getKey());
                values.put(key, entry.getValue());
                continue;
            }
            values.put((Key)entry.getKey(), entry.getValue());
        }
        settings._values = values;
        settings._values.remove(new Key("printer/comments/javadoc/templateDescription"));
        settings._values.remove(new Key("printer/comments/javadoc/templateParam"));
        settings._values.remove(new Key("printer/comments/javadoc/templateReturn"));
        settings._values.remove(new Key("printer/comments/javadoc/templateThrows"));
        settings._values.remove(new Key("internal/urls/import"));
        settings._values.remove(new Key("internal/urls/backup"));
        settings._values.remove(new Key("internal/urls/export"));
        settings._values.remove(new Key("internal/styleLastPanel"));
        settings._values.remove(new Key("internal/styleLastPanelClass"));
        settings._values.remove(new Key("internal/styleLastPanelTitle"));
        settings._values.remove(new Key("printer/comments/removeSeparator"));
        settings._values.remove(new Key("messages/showIoMsg"));
        settings._values.remove(new Key("messages/showParserMsg"));
        settings._values.remove(new Key("messages/showParserJavadocMsg"));
        settings._values.remove(new Key("messages/showTransformMsg"));
        settings._values.remove(new Key("messages/showPrinterJavadocMsg"));
        settings._values.remove(new Key("messages/showPrinterMsg"));
        String sortOrder = settings.get(ConventionKeys.SORT_ORDER, DeclarationType.getOrder());
        StringBuffer newSortOrder = new StringBuffer(150);
        StringTokenizer tokens = new StringTokenizer(sortOrder, ",");
        while (tokens.hasMoreElements()) {
            String value = tokens.nextToken();
            if ("Variable".equals(value)) {
                newSortOrder.append("Static Variables/Initializers,");
                continue;
            }
            if ("Initializer".equals(value)) {
                newSortOrder.append("Instance Variables,Instance Initializers,");
                continue;
            }
            if ("Constructor".equals(value)) {
                newSortOrder.append("Constructors,");
                continue;
            }
            if ("Method".equals(value)) {
                newSortOrder.append("Methods,");
                continue;
            }
            if ("Interface".equals(value)) {
                newSortOrder.append("Interfaces,");
                continue;
            }
            if (!"Class".equals(value)) continue;
            newSortOrder.append("Classes,");
        }
        if (',' == newSortOrder.charAt(newSortOrder.length() - 1)) {
            newSortOrder = newSortOrder.deleteCharAt(newSortOrder.length() - 1);
        }
        settings._values.put(ConventionKeys.SORT_ORDER, newSortOrder.toString());
        settings._values.put(ConventionKeys.HISTORY_POLICY, Convention.getHistoryPolicy(settings.get(ConventionKeys.HISTORY_POLICY, "0")).toString());
        int importPolicy = settings.getInt(ConventionKeys.IMPORT_POLICY, 0);
        switch (importPolicy) {
            case 1: {
                settings._values.put(ConventionKeys.IMPORT_POLICY, ImportPolicy.EXPAND.toString());
                break;
            }
            case 2: {
                settings._values.put(ConventionKeys.IMPORT_POLICY, ImportPolicy.COLLAPSE.toString());
                break;
            }
            default: {
                settings._values.put(ConventionKeys.IMPORT_POLICY, ImportPolicy.DISABLED.toString());
            }
        }
        String backupDirectory = settings.get(ConventionKeys.BACKUP_DIRECTORY, "").trim();
        if (backupDirectory.endsWith(".jalopy/bak") || backupDirectory.endsWith(".jalopy\\bak")) {
            settings._values.put(ConventionKeys.BACKUP_DIRECTORY, NAME_BACKUP);
        }
    }

    private static void sync4To5(Convention settings) {
        String header = settings.get(ConventionKeys.HEADER_TEXT, "").trim();
        String[] lines = StringHelper.split(header, "\n");
        StringBuffer buf = new StringBuffer(header.length());
        for (int i = 0; i < lines.length; ++i) {
            buf.append(StringHelper.trimTrailing(lines[i]));
            buf.append('|');
        }
        if (lines.length > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        settings.put(ConventionKeys.HEADER_TEXT, buf.toString());
        String footer = settings.get(ConventionKeys.FOOTER_TEXT, "").trim();
        lines = StringHelper.split(footer, "\n");
        buf = new StringBuffer(footer.length());
        for (int i = 0; i < lines.length; ++i) {
            buf.append(StringHelper.trimTrailing(lines[i]));
            buf.append('|');
        }
        if (lines.length > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        settings.put(ConventionKeys.FOOTER_TEXT, buf.toString());
    }

    private static void sync5To6(Convention settings) {
        Convention.renameKey(settings, "printer/braces/insertBracesIfElse", ConventionKeys.BRACE_INSERT_IF_ELSE);
        Convention.renameKey(settings, "printer/braces/insertBracesFor", ConventionKeys.BRACE_INSERT_FOR);
        Convention.renameKey(settings, "printer/braces/insertBracesWhile", ConventionKeys.BRACE_INSERT_WHILE);
        Convention.renameKey(settings, "printer/braces/insertBracesDoWhile", ConventionKeys.BRACE_INSERT_DO_WHILE);
        Convention.renameKey(settings, "printer/braces/removeBracesIfElse", ConventionKeys.BRACE_REMOVE_IF_ELSE);
        Convention.renameKey(settings, "printer/braces/removeBracesFor", ConventionKeys.BRACE_REMOVE_FOR);
        Convention.renameKey(settings, "printer/braces/removeBracesWhile", ConventionKeys.BRACE_REMOVE_WHILE);
        Convention.renameKey(settings, "printer/braces/removeBracesDoWhile", ConventionKeys.BRACE_REMOVE_DO_WHILE);
        Convention.renameKey(settings, "printer/braces/removeBracesBlock", ConventionKeys.BRACE_REMOVE_BLOCK);
        Convention.renameKey(settings, "printer/braces/treatMethodClassDifferent", ConventionKeys.BRACE_TREAT_DIFFERENT);
        Convention.renameKey(settings, "printer/braces/treatMethodClassDifferentIfWrapped", ConventionKeys.BRACE_TREAT_DIFFERENT_IF_WRAPPED);
        Convention.renameKey(settings, "printer/braces/emptyCuddle", ConventionKeys.BRACE_EMPTY_CUDDLE);
        Convention.renameKey(settings, "printer/braces/emptyInsertStatement", ConventionKeys.BRACE_EMPTY_INSERT_STATEMENT);
        Convention.renameKey(settings, "printer/braces/rightBraceNewLine", ConventionKeys.BRACE_NEWLINE_RIGHT);
        Convention.renameKey(settings, "printer/braces/leftBraceNewLine", ConventionKeys.BRACE_NEWLINE_LEFT);
        Convention.renameKey(settings, "messages/ioMsgPrio", ConventionKeys.MSG_PRIORITY_IO);
        Convention.renameKey(settings, "messages/parserMsgPrio", ConventionKeys.MSG_PRIORITY_PARSER);
        Convention.renameKey(settings, "messages/parserJavadocMsgPrio", ConventionKeys.MSG_PRIORITY_PARSER_JAVADOC);
        Convention.renameKey(settings, "messages/printerMsgPrio", ConventionKeys.MSG_PRIORITY_PRINTER);
        Convention.renameKey(settings, "messages/printerJavadocMsgPrio", ConventionKeys.MSG_PRIORITY_PRINTER_JAVADOC);
        Convention.renameKey(settings, "messages/transformMsgPrio", ConventionKeys.MSG_PRIORITY_TRANSFORM);
        Convention.renameKey(settings, "printer/whitespace/paddingAssignmentOperators", ConventionKeys.PADDING_ASSIGNMENT_OPERATORS);
        Convention.renameKey(settings, "printer/whitespace/paddingBitwiseOperators", ConventionKeys.PADDING_BITWISE_OPERATORS);
        Convention.renameKey(settings, "printer/whitespace/padddingBraces", ConventionKeys.PADDING_BRACES);
        Convention.renameKey(settings, "printer/whitespace/padddingBrackets", ConventionKeys.PADDING_BRACKETS);
        Convention.renameKey(settings, "printer/whitespace/padddingTypeCast", ConventionKeys.PADDING_CAST);
        Convention.renameKey(settings, "printer/whitespace/paddingLogicalOperators", ConventionKeys.PADDING_LOGICAL_OPERATORS);
        Convention.renameKey(settings, "printer/whitespace/paddingMathematicalOperators", ConventionKeys.PADDING_MATH_OPERATORS);
        Convention.renameKey(settings, "printer/whitespace/padddingParenthesis", ConventionKeys.PADDING_PAREN);
        Convention.renameKey(settings, "printer/whitespace/paddingRelationalOperators", ConventionKeys.PADDING_RELATIONAL_OPERATORS);
        Convention.renameKey(settings, "printer/whitespace/paddingShiftOperators", ConventionKeys.PADDING_SHIFT_OPERATORS);
        Convention.renameKey(settings, "printer/whitespace/afterCastingParenthesis", ConventionKeys.SPACE_AFTER_CAST);
        Convention.renameKey(settings, "printer/whitespace/afterComma", ConventionKeys.SPACE_AFTER_COMMA);
        Convention.renameKey(settings, "printer/whitespace/afterSemiColon", ConventionKeys.SPACE_AFTER_SEMICOLON);
        Convention.renameKey(settings, "printer/whitespace/beforeBraces", ConventionKeys.SPACE_BEFORE_BRACES);
        Convention.renameKey(settings, "printer/whitespace/beforeBrackets", ConventionKeys.SPACE_BEFORE_BRACKETS);
        Convention.renameKey(settings, "printer/whitespace/beforeBracketsTypes", ConventionKeys.SPACE_BEFORE_BRACKETS_TYPES);
        Convention.renameKey(settings, "printer/whitespace/beforeCaseColon", ConventionKeys.SPACE_BEFORE_CASE_COLON);
        Convention.renameKey(settings, "printer/whitespace/beforeLogicalNot", ConventionKeys.SPACE_BEFORE_LOGICAL_NOT);
        Convention.renameKey(settings, "printer/whitespace/beforeMethodCallParenthesis", ConventionKeys.SPACE_BEFORE_METHOD_CALL_PAREN);
        Convention.renameKey(settings, "printer/whitespace/beforeMethodDeclarationParenthesis", ConventionKeys.SPACE_BEFORE_METHOD_DEF_PAREN);
        Convention.renameKey(settings, "printer/whitespace/beforeStatementParenthesis", ConventionKeys.SPACE_BEFORE_STATEMENT_PAREN);
        Convention.renameKey(settings, "inspector/naming/label", ConventionKeys.REGEXP_LABEL);
        Convention.renameKey(settings, "inspector/naming/localVariable", ConventionKeys.REGEXP_LABEL);
        Convention.renameKey(settings, "inspector/naming/fieldFriendly", ConventionKeys.REGEXP_FIELD_DEFAULT);
        Convention.renameKey(settings, "inspector/naming/fieldFriendlyStatic", ConventionKeys.REGEXP_FIELD_DEFAULT_STATIC);
        Convention.renameKey(settings, "inspector/naming/fieldFriendlyStaticFinal", ConventionKeys.REGEXP_FIELD_DEFAULT_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/fieldPrivate", ConventionKeys.REGEXP_FIELD_PRIVATE);
        Convention.renameKey(settings, "inspector/naming/fieldPrivateStatic", ConventionKeys.REGEXP_FIELD_PRIVATE_STATIC);
        Convention.renameKey(settings, "inspector/naming/fieldPrivateStaticFinal", ConventionKeys.REGEXP_FIELD_PRIVATE_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/fieldProtected", ConventionKeys.REGEXP_FIELD_PROTECTED);
        Convention.renameKey(settings, "inspector/naming/fieldProtectedStatic", ConventionKeys.REGEXP_FIELD_PROTECTED_STATIC);
        Convention.renameKey(settings, "inspector/naming/fieldProtectedStaticFinal", ConventionKeys.REGEXP_FIELD_PROTECTED_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/fieldPublic", ConventionKeys.REGEXP_FIELD_PUBLIC);
        Convention.renameKey(settings, "inspector/naming/fieldPublicStatic", ConventionKeys.REGEXP_FIELD_PUBLIC_STATIC);
        Convention.renameKey(settings, "inspector/naming/fieldPublicStaticFinal", ConventionKeys.REGEXP_FIELD_PUBLIC_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/methodFriendly", ConventionKeys.REGEXP_METHOD_DEFAULT);
        Convention.renameKey(settings, "inspector/naming/methodFriendlyStatic", ConventionKeys.REGEXP_METHOD_DEFAULT_STATIC);
        Convention.renameKey(settings, "inspector/naming/methodFriendlyStaticFinal", ConventionKeys.REGEXP_METHOD_DEFAULT_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/methodPrivate", ConventionKeys.REGEXP_METHOD_PRIVATE);
        Convention.renameKey(settings, "inspector/naming/methodPrivateStatic", ConventionKeys.REGEXP_METHOD_PRIVATE_STATIC);
        Convention.renameKey(settings, "inspector/naming/methodPrivateStaticFinal", ConventionKeys.REGEXP_METHOD_PRIVATE_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/methodProtected", ConventionKeys.REGEXP_METHOD_PROTECTED);
        Convention.renameKey(settings, "inspector/naming/methodProtectedStatic", ConventionKeys.REGEXP_METHOD_PROTECTED_STATIC);
        Convention.renameKey(settings, "inspector/naming/methodProtectedStaticFinal", ConventionKeys.REGEXP_METHOD_PROTECTED_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/methodPublic", ConventionKeys.REGEXP_METHOD_PUBLIC);
        Convention.renameKey(settings, "inspector/naming/methodPublicStatic", ConventionKeys.REGEXP_METHOD_PUBLIC_STATIC);
        Convention.renameKey(settings, "inspector/naming/methodPublicStaticFinal", ConventionKeys.REGEXP_METHOD_PUBLIC_STATIC_FINAL);
        Convention.renameKey(settings, "inspector/naming/param", ConventionKeys.REGEXP_PARAM);
        Convention.renameKey(settings, "inspector/naming/paramFinal", ConventionKeys.REGEXP_PARAM_FINAL);
        Convention.renameKey(settings, "inspector/naming/abstractClasses", ConventionKeys.REGEXP_CLASS_ABSTRACT);
        Convention.renameKey(settings, "inspector/naming/classes", ConventionKeys.REGEXP_CLASS);
        Convention.renameKey(settings, "general/backupDirectory", ConventionKeys.BACKUP_DIRECTORY);
        Convention.renameKey(settings, "general/backupLevel", ConventionKeys.BACKUP_LEVEL);
        Convention.renameKey(settings, "general/threadCount", ConventionKeys.THREAD_COUNT);
        Convention.renameKey(settings, "general/forceFormatting", ConventionKeys.FORCE_FORMATTING);
        Convention.renameKey(settings, "transform/import/grouping", ConventionKeys.IMPORT_GROUPING);
        Convention.renameKey(settings, "transform/import/groupingDepth", ConventionKeys.IMPORT_GROUPING_DEPTH);
        Convention.renameKey(settings, "transform/import/policy", ConventionKeys.IMPORT_POLICY);
        Convention.renameKey(settings, "transform/import/sort", ConventionKeys.IMPORT_SORT);
        Convention.renameKey(settings, "transform/misc/insertExpressionParenthesis", ConventionKeys.INSERT_EXPRESSION_PARENTHESIS);
        Convention.renameKey(settings, "transform/misc/insertLoggingConditional", ConventionKeys.INSERT_LOGGING_CONDITIONAL);
        Convention.renameKey(settings, "transform/misc/insertUID", ConventionKeys.INSERT_SERIAL_UID);
        Convention.renameKey(settings, "general/sourceVersion", ConventionKeys.SOURCE_VERSION);
        Convention.renameKey(settings, "general/styleDescription", ConventionKeys.CONVENTION_DESCRIPTION);
        Convention.renameKey(settings, "general/styleName", ConventionKeys.CONVENTION_NAME);
        Convention.renameKey(settings, "printer/wrapping/afterAssign", ConventionKeys.LINE_WRAP_AFTER_ASSIGN);
        Convention.renameKey(settings, "printer/wrapping/afterChainedMethodCall", ConventionKeys.LINE_WRAP_AFTER_CHAINED_METHOD_CALL);
        Convention.renameKey(settings, "printer/wrapping/afterExtendsTypes", ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS);
        Convention.renameKey(settings, "printer/wrapping/afterExtendsTypesIfExceeded", ConventionKeys.LINE_WRAP_AFTER_TYPES_EXTENDS_EXCEED);
        Convention.renameKey(settings, "printer/wrapping/afterImplementsTypes", ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS);
        Convention.renameKey(settings, "printer/wrapping/afterImplementsTypesIfExceeded", ConventionKeys.LINE_WRAP_AFTER_TYPES_IMPLEMENTS_EXCEED);
        Convention.renameKey(settings, "printer/wrapping/afterLabel", ConventionKeys.LINE_WRAP_AFTER_LABEL);
        Convention.renameKey(settings, "printer/wrapping/afterLeftParen", ConventionKeys.LINE_WRAP_AFTER_LEFT_PAREN);
        Convention.renameKey(settings, "printer/wrapping/afterThrowsTypes", ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS);
        Convention.renameKey(settings, "printer/wrapping/afterThrowsTypesIfExceeded", ConventionKeys.LINE_WRAP_AFTER_TYPES_THROWS_EXCEED);
        Convention.renameKey(settings, "printer/wrapping/arrayElements", ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS);
        Convention.renameKey(settings, "printer/wrapping/beforeExtends", ConventionKeys.LINE_WRAP_BEFORE_EXTENDS);
        Convention.renameKey(settings, "printer/wrapping/beforeImplements", ConventionKeys.LINE_WRAP_BEFORE_IMPLEMENTS);
        Convention.renameKey(settings, "printer/wrapping/beforeOperator", ConventionKeys.LINE_WRAP_BEFORE_OPERATOR);
        Convention.renameKey(settings, "printer/wrapping/beforeRightParen", ConventionKeys.LINE_WRAP_BEFORE_RIGHT_PAREN);
        Convention.renameKey(settings, "printer/wrapping/beforeThrows", ConventionKeys.LINE_WRAP_BEFORE_THROWS);
        Convention.renameKey(settings, "printer/wrapping/ifFirst", ConventionKeys.LINE_WRAP_PARAMS_EXCEED);
        Convention.renameKey(settings, "printer/wrapping/lineLength", ConventionKeys.LINE_LENGTH);
        Convention.renameKey(settings, "printer/wrapping/paramsMethodCall", ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL);
        Convention.renameKey(settings, "printer/wrapping/paramsMethodCallIfCall", ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_CALL_IF_NESTED);
        Convention.renameKey(settings, "printer/wrapping/paramsMethodDef", ConventionKeys.LINE_WRAP_AFTER_PARAMS_METHOD_DEF);
        Convention.renameKey(settings, "printer/wrapping/parenGrouping", ConventionKeys.LINE_WRAP_PAREN_GROUPING);
        Convention.renameKey(settings, "printer/wrapping/use", ConventionKeys.LINE_WRAP);
        Convention.renameKey(settings, "printer/comments/separator/class", ConventionKeys.SEPARATOR_CLASS);
        Convention.renameKey(settings, "printer/comments/separator/ctor", ConventionKeys.SEPARATOR_CTOR);
        Convention.renameKey(settings, "printer/comments/separator/instanceInit", ConventionKeys.SEPARATOR_INSTANCE_INIT);
        Convention.renameKey(settings, "printer/comments/separator/instanceVariable", ConventionKeys.SEPARATOR_INSTANCE_VAR);
        Convention.renameKey(settings, "printer/comments/separator/interface", ConventionKeys.SEPARATOR_INTERFACE);
        Convention.renameKey(settings, "printer/comments/separator/method", ConventionKeys.SEPARATOR_METHOD);
        Convention.renameKey(settings, "printer/comments/separator/staticVariableInit", ConventionKeys.SEPARATOR_STATIC_VAR_INIT);
        Convention.renameKey(settings, "printer/comments/insertSeparator", ConventionKeys.COMMENT_INSERT_SEPARATOR);
        Convention.renameKey(settings, "printer/comments/insertSeparatorRecursive", ConventionKeys.COMMENT_INSERT_SEPARATOR_RECURSIVE);
        Convention.renameKey(settings, "printer/comments/formatMultiLine", ConventionKeys.COMMENT_FORMAT_MULTI_LINE);
        Convention.renameKey(settings, "printer/comments/removeMultiLine", ConventionKeys.COMMENT_REMOVE_MULTI_LINE);
        Convention.renameKey(settings, "printer/comments/removeSingleLine", ConventionKeys.COMMENT_REMOVE_SINGLE_LINE);
        Convention.renameKey(settings, "printer/comments/javadoc/remove", ConventionKeys.COMMENT_JAVADOC_REMOVE);
        Convention.renameKey(settings, "printer/comments/javadoc/addClass", ConventionKeys.COMMENT_JAVADOC_CLASS_MASK);
        Convention.renameKey(settings, "printer/comments/javadoc/addCtor", ConventionKeys.COMMENT_JAVADOC_CTOR_MASK);
        Convention.renameKey(settings, "printer/comments/javadoc/addField", ConventionKeys.COMMENT_JAVADOC_VARIABLE_MASK);
        Convention.renameKey(settings, "printer/comments/javadoc/addMethod", ConventionKeys.COMMENT_JAVADOC_METHOD_MASK);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/classes", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/constructors/bottom", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_BOTTOM);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/constructors/exception", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_EXCEPTION);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/constructors/param", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_PARAM);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/constructors/top", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CTOR_TOP);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/interface", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/methods/bottom", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_BOTTOM);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/methods/exception", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_EXCEPTION);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/methods/param", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_PARAM);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/methods/return", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_RETURN);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/methods/top", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_METHOD_TOP);
        Convention.renameKey(settings, "printer/comments/javadoc/templates/variables", ConventionKeys.COMMENT_JAVADOC_TEMPLATE_VARIABLE);
        Convention.renameKey(settings, "printer/comments/javadoc/checkInnerClass", ConventionKeys.COMMENT_JAVADOC_INNER_CLASS);
        Convention.renameKey(settings, "printer/comments/javadoc/checkTags", ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS);
        Convention.renameKey(settings, "printer/comments/javadoc/checkThrowsTags", ConventionKeys.COMMENT_JAVADOC_CHECK_TAGS_THROWS);
        Convention.renameKey(settings, "printer/sorting/class", ConventionKeys.SORT_CLASS);
        Convention.renameKey(settings, "printer/sorting/constructor", ConventionKeys.SORT_CTOR);
        Convention.renameKey(settings, "printer/sorting/interface", ConventionKeys.SORT_INTERFACE);
        Convention.renameKey(settings, "printer/sorting/method", ConventionKeys.SORT_METHOD);
        Convention.renameKey(settings, "printer/sorting/modifiers/use", ConventionKeys.SORT_MODIFIERS);
        Convention.renameKey(settings, "printer/sorting/order", ConventionKeys.SORT_ORDER);
        Convention.renameKey(settings, "printer/sorting/orderModifiers", ConventionKeys.SORT_ORDER_MODIFIERS);
        Convention.renameKey(settings, "printer/sorting/use", ConventionKeys.SORT);
        Convention.renameKey(settings, "printer/sorting/variable", ConventionKeys.SORT_VARIABLE);
        Convention.renameKey(settings, "printer/alignment/ParamsMethodDef", ConventionKeys.ALIGN_PARAMS_METHOD_DEF);
        Convention.renameKey(settings, "printer/alignment/ternaryExpresssion", ConventionKeys.ALIGN_TERNARY_EXPRESSION);
        Convention.renameKey(settings, "printer/alignment/ternaryOperator", ConventionKeys.ALIGN_TERNARY_OPERATOR);
        Convention.renameKey(settings, "printer/alignment/ternaryValue", ConventionKeys.ALIGN_TERNARY_VALUES);
        Convention.renameKey(settings, "printer/alignment/varAssigns", ConventionKeys.ALIGN_VAR_ASSIGNS);
        Convention.renameKey(settings, "printer/alignment/varIdents", ConventionKeys.ALIGN_VAR_IDENTS);
        Convention.renameKey(settings, "printer/alignment/methodCallChains", ConventionKeys.ALIGN_METHOD_CALL_CHAINS);
        Convention.renameKey(settings, "printer/blankLines/afterBlock", ConventionKeys.BLANK_LINES_AFTER_BLOCK);
        Convention.renameKey(settings, "printer/blankLines/afterBraceLeft", ConventionKeys.BLANK_LINES_AFTER_BRACE_LEFT);
        Convention.renameKey(settings, "printer/blankLines/afterClass", ConventionKeys.BLANK_LINES_AFTER_CLASS);
        Convention.renameKey(settings, "printer/blankLines/afterDeclaration", ConventionKeys.BLANK_LINES_AFTER_DECLARATION);
        Convention.renameKey(settings, "printer/blankLines/afterFooter", ConventionKeys.BLANK_LINES_AFTER_FOOTER);
        Convention.renameKey(settings, "printer/blankLines/afterHeader", ConventionKeys.BLANK_LINES_AFTER_HEADER);
        Convention.renameKey(settings, "printer/blankLines/afterInterface", ConventionKeys.BLANK_LINES_AFTER_INTERFACE);
        Convention.renameKey(settings, "printer/blankLines/afterLastImport", ConventionKeys.BLANK_LINES_AFTER_IMPORT);
        Convention.renameKey(settings, "printer/blankLines/afterMethod", ConventionKeys.BLANK_LINES_AFTER_METHOD);
        Convention.renameKey(settings, "printer/blankLines/afterPackage", ConventionKeys.BLANK_LINES_AFTER_PACKAGE);
        Convention.renameKey(settings, "printer/blankLines/beforeBlock", ConventionKeys.BLANK_LINES_BEFORE_BLOCK);
        Convention.renameKey(settings, "printer/blankLines/beforeBraceRight", ConventionKeys.BLANK_LINES_BEFORE_BRACE_RIGHT);
        Convention.renameKey(settings, "printer/blankLines/beforeCaseBlock", ConventionKeys.BLANK_LINES_BEFORE_CASE_BLOCK);
        Convention.renameKey(settings, "printer/blankLines/beforeCommentMultiLine", ConventionKeys.BLANK_LINES_BEFORE_COMMENT_MULTI_LINE);
        Convention.renameKey(settings, "printer/blankLines/beforeCommentSingleLine", ConventionKeys.BLANK_LINES_BEFORE_COMMENT_SINGLE_LINE);
        Convention.renameKey(settings, "printer/blankLines/beforeControl", ConventionKeys.BLANK_LINES_BEFORE_CONTROL);
        Convention.renameKey(settings, "printer/blankLines/beforeDeclaration", ConventionKeys.BLANK_LINES_BEFORE_DECLARATION);
        Convention.renameKey(settings, "printer/blankLines/beforeFooter", ConventionKeys.BLANK_LINES_BEFORE_FOOTER);
        Convention.renameKey(settings, "printer/blankLines/beforeHeader", ConventionKeys.BLANK_LINES_BEFORE_HEADER);
        Convention.renameKey(settings, "printer/blankLines/beforeJavadoc", ConventionKeys.BLANK_LINES_BEFORE_COMMENT_JAVADOC);
        Convention.renameKey(settings, "printer/blankLines/keepUpTo", ConventionKeys.BLANK_LINES_KEEP_UP_TO);
        Convention.renameKey(settings, "printer/chunks/byBlankLines", ConventionKeys.CHUNKS_BY_BLANK_LINES);
        Convention.renameKey(settings, "printer/chunks/byComments", ConventionKeys.CHUNKS_BY_COMMENTS);
        Convention.renameKey(settings, "printer/footer/smartModeLines", ConventionKeys.FOOTER_SMART_MODE_LINES);
        Convention.renameKey(settings, "printer/header/smartModeLines", ConventionKeys.HEADER_SMART_MODE_LINES);
        settings._values.remove(new Key("printer/indentation/continationIfTernary"));
        Convention.renameKey(settings, "printer/indentation/continationIf", ConventionKeys.INDENT_CONTINUATION_BLOCK);
        Convention.renameKey(settings, "printer/indentation/continationOperator", ConventionKeys.INDENT_CONTINUATION_OPERATOR);
        Convention.renameKey(settings, "printer/indentation/continuation", ConventionKeys.INDENT_SIZE_CONTINUATION);
        Convention.renameKey(settings, "printer/indentation/braceCuddled", ConventionKeys.INDENT_SIZE_BRACE_CUDDLED);
        Convention.renameKey(settings, "printer/indentation/caseFromSwitch", ConventionKeys.INDENT_CASE_FROM_SWITCH);
        Convention.renameKey(settings, "printer/indentation/commentEndline", ConventionKeys.INDENT_SIZE_COMMENT_ENDLINE);
        Convention.renameKey(settings, "printer/indentation/braceLeft", ConventionKeys.INDENT_SIZE_BRACE_LEFT);
        Convention.renameKey(settings, "printer/indentation/braceRight", ConventionKeys.INDENT_SIZE_BRACE_RIGHT);
        Convention.renameKey(settings, "printer/indentation/braceRightAfter", ConventionKeys.INDENT_SIZE_BRACE_RIGHT_AFTER);
        Convention.renameKey(settings, "printer/indentation/deep", ConventionKeys.INDENT_SIZE_DEEP);
        Convention.renameKey(settings, "printer/indentation/extends", ConventionKeys.INDENT_SIZE_EXTENDS);
        Convention.renameKey(settings, "printer/indentation/general", ConventionKeys.INDENT_SIZE);
        Convention.renameKey(settings, "printer/indentation/leading", ConventionKeys.INDENT_SIZE_LEADING);
        Convention.renameKey(settings, "printer/indentation/throws", ConventionKeys.INDENT_SIZE_THROWS);
        Convention.renameKey(settings, "printer/indentation/implements", ConventionKeys.INDENT_SIZE_IMPLEMENTS);
        Convention.renameKey(settings, "printer/indentation/policyDeep", ConventionKeys.INDENT_DEEP);
        Convention.renameKey(settings, "printer/indentation/firstColumnComments", ConventionKeys.INDENT_FIRST_COLUMN_COMMENT);
        Convention.renameKey(settings, "printer/indentation/label", ConventionKeys.INDENT_LABEL);
        Convention.renameKey(settings, "printer/indentation/tabs/size", ConventionKeys.INDENT_SIZE_TABS);
        Convention.renameKey(settings, "printer/indentation/tabs/use", ConventionKeys.INDENT_WITH_TABS);
        Convention.renameKey(settings, "printer/indentation/tabs/useOnlyLeading", ConventionKeys.INDENT_WITH_TABS_ONLY_LEADING);
        String historyMethod = settings.get(ConventionKeys.HISTORY_METHOD, ConventionDefaults.HISTORY_METHOD);
        if (historyMethod.equals("History.Method [adler32]")) {
            settings.put(ConventionKeys.HISTORY_METHOD, "adler32");
        } else if (historyMethod.equals("History.Method [crc32]")) {
            settings.put(ConventionKeys.HISTORY_METHOD, "crc32");
        } else {
            settings.put(ConventionKeys.HISTORY_METHOD, "timestamp");
        }
        String historyPolicy = settings.get(ConventionKeys.HISTORY_POLICY, ConventionDefaults.HISTORY_POLICY);
        if (historyPolicy.equals("History.Policy [file]")) {
            settings.put(ConventionKeys.HISTORY_POLICY, "file");
        } else if (historyPolicy.equals("History.Policy [comment]")) {
            settings.put(ConventionKeys.HISTORY_POLICY, "comment");
        } else {
            settings.put(ConventionKeys.HISTORY_POLICY, "disabled");
        }
        String importPolicy = settings.get(ConventionKeys.IMPORT_POLICY, ConventionDefaults.IMPORT_POLICY);
        if (importPolicy.equals("ImportPolicy [expand]")) {
            settings.put(ConventionKeys.IMPORT_POLICY, "expand");
        } else if (importPolicy.equals("ImportPolicy [collapse]")) {
            settings.put(ConventionKeys.IMPORT_POLICY, "collapse");
        } else {
            settings.put(ConventionKeys.IMPORT_POLICY, "disabled");
        }
        String sortOrderDeclarations = settings.get(ConventionKeys.SORT_ORDER, DeclarationType.getOrder());
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, ",", "|");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Classes", "class");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Constructors", "constructor");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Instance Initializers", "initializer");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Instance Variables", "field");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Interfaces", "interface");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Methods", "method");
        sortOrderDeclarations = StringHelper.replace(sortOrderDeclarations, "Static Variables/Initializers", "static");
        settings.put(ConventionKeys.SORT_ORDER, sortOrderDeclarations);
        String sortOrderModifiers = settings.get(ConventionKeys.SORT_ORDER_MODIFIERS, ModifierType.getOrder());
        sortOrderModifiers = StringHelper.replace(sortOrderModifiers, ",", "|");
        settings.put(ConventionKeys.SORT_ORDER_MODIFIERS, sortOrderModifiers);
    }

    private static void synchronize(Convention settings, int version) {
        int curVersion = Integer.parseInt(VERSION);
        if (version > curVersion) {
            throw new IllegalArgumentException("invalid code convention version detected, was " + version + ", needed <= " + curVersion);
        }
        if (version != curVersion) {
            switch (version) {
                case -1: {
                    Convention.sync0To1(settings);
                    break;
                }
                case 1: {
                    Convention.sync1To2(settings);
                    Convention.synchronize(settings, 2);
                    break;
                }
                case 2: {
                    Convention.sync2To3(settings);
                    Convention.synchronize(settings, 3);
                    break;
                }
                case 3: {
                    Convention.sync3To4(settings);
                    Convention.synchronize(settings, 4);
                    break;
                }
                case 4: {
                    Convention.sync4To5(settings);
                    Convention.synchronize(settings, 5);
                    break;
                }
                case 5: {
                    Convention.sync5To6(settings);
                }
            }
            Iterator i = new HashMap(settings._values).keySet().iterator();
            while (i.hasNext()) {
                Key key = (Key)i.next();
                if (ConventionKeys.isValid(key)) continue;
                settings._values.remove(key);
            }
        }
    }

    private static void synchronize(Convention settings) {
        Convention.synchronize(settings, settings.getInt(ConventionKeys.INTERNAL_VERSION, -1));
        Convention.INSTANCE._locale = new Locale(settings.get(ConventionKeys.LANGUAGE, "en"), settings.get(ConventionKeys.COUNTRY, "US"));
        Convention.INSTANCE._values = settings._values;
        INSTANCE.put(ConventionKeys.INTERNAL_VERSION, VERSION);
    }

    private Element convertMapToXml(Map map) {
        map = new TreeMap(map);
        Element root = new Element("jalopy");
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Key key = (Key)entry.getKey();
            Object value = entry.getValue();
            List pathList = this.splitPath(key.toString());
            Element go = root;
            int size = pathList.size();
            for (int i = 0; i < size; ++i) {
                String elName = (String)pathList.get(i);
                Element child = go.getChild(elName);
                if (child == null) {
                    child = new Element(elName);
                    go.addContent(child);
                }
                go = child;
            }
            go.setText(value.toString());
        }
        return root;
    }

    private List splitPath(String strXPath) {
        strXPath = "/" + strXPath;
        ArrayList<String> result = new ArrayList<String>();
        int i_len = strXPath.length();
        for (int i = 0; i < i_len - 1; ++i) {
            char varCh;
            char ch = strXPath.charAt(i);
            if (ch != '/') continue;
            StringBuffer sb = new StringBuffer();
            for (int j = i + 1; j < i_len && (varCh = strXPath.charAt(j)) != '/'; ++j) {
                sb.append(varCh);
            }
            if (sb.length() == 0) continue;
            result.add(new String(sb));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static {
        block24: {
            Convention.EMPTY_MAP = new HashMap<K, V>();
            Convention._lock = new Object();
            Convention.EMPTY_PREFERENCES = new Convention(Convention.EMPTY_MAP);
            Convention._project = Convention.DEFAULT_PROJECT = new Project("default", "The Jalopy default project space.");
            Convention._settingsDirectory = new File(System.getProperty("user.home") + File.separator + ".jalopy");
            Convention._project = project = Convention.loadProject();
            Convention.setDirectories(project);
            settingsFile = null;
            in = null;
            try {
                block23: {
                    settingsFile = Convention.getSettingsFile();
                    if (settingsFile.exists()) {
                        in = new FileInputStream(settingsFile);
                        Convention.INSTANCE = Convention.readFromStream(in);
                    } else {
                        Convention.INSTANCE = Convention.EMPTY_PREFERENCES;
                    }
                    location = Convention.INSTANCE.get(ConventionKeys.STYLE_LOCATION, "");
                    if (location.startsWith("http")) {
                        try {
                            Convention.importSettings(new URL(location));
                            Convention.INSTANCE.put(ConventionKeys.STYLE_LOCATION, location);
                            Convention.INSTANCE.flush();
                        }
                        catch (IOException ex) {
                            args = new Object[]{location};
                            Loggers.IO.l7dlog((Priority)Level.WARN, "PREF_COULD_NOT_CONNECT", args, null);
                        }
                        break block23;
                    }
                    Convention.synchronize(Convention.INSTANCE);
                }
                var7_11 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var6_15) {
                var7_12 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                throw var6_15;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
lbl-1000:
            // 2 sources

            {
                break block24;
                catch (Throwable ex) {
                    ex.printStackTrace();
                    args = new Object[]{settingsFile};
                    Loggers.IO.l7dlog((Priority)Level.WARN, "PREF_ERROR_LOADING", args, ex);
                    Convention.INSTANCE = Convention.EMPTY_PREFERENCES;
                    var7_11 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
        if (project.getName().equals(Convention.DEFAULT_PROJECT.getName()) && (!Convention._projectSettingsDirectory.exists() || new File(Convention._settingsDirectory, "preferences.jal").exists()) && IoHelper.ensureDirectoryExists(Convention._projectSettingsDirectory)) {
            files = Convention._settingsDirectory.listFiles();
            for (i = 0; i < files.length; ++i) {
                if (files[i].getName().endsWith("preferences.jal")) {
                    try {
                        Copy.file(files[i], new File(Convention._projectSettingsDirectory, "preferences.dat"));
                        files[i].delete();
                    }
                    catch (IOException ex) {}
                    continue;
                }
                if (files[i].getName().equals("project.dat") || !files[i].isDirectory() || !files[i].getName().equals("bak") && !files[i].getName().equals("repository")) continue;
                IoHelper.delete(files[i], true);
            }
            try {
                IoHelper.serialize((Object)project, new File(Convention._projectSettingsDirectory, "project.dat"));
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public static final class Key
    implements Serializable,
    Comparable {
        static final long serialVersionUID = -7320495354745545260L;
        private transient String _name;
        private transient int _hashCode;

        Key(String name) {
            this._name = name.intern();
            this._hashCode = this._name.hashCode();
        }

        public int compareTo(Object o) {
            if (o instanceof Key) {
                return this._name.compareTo(((Key)o)._name);
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return this._name == ((Key)o)._name;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public String toString() {
            return this._name;
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this._name = ((String)in.readObject()).intern();
            this._hashCode = in.readInt();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeObject(this._name);
            out.writeInt(this._hashCode);
        }
    }
}

