/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.picking;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.picking.SocketManager;

class PickServer
extends Thread {
    private Log logger = LogFactory.getLog((Class)PickServer.class);
    static final int PORT = 53782;
    private ServerSocket serverSocket;
    private boolean isServer = false;
    private boolean isAlive = true;
    private SocketManager manager;

    PickServer(SocketManager manager) {
        this.manager = manager;
    }

    boolean isServer() {
        return this.isServer;
    }

    boolean createServer() {
        try {
            this.serverSocket = new ServerSocket(53782);
            this.start();
            this.isServer = true;
            return true;
        }
        catch (IOException e) {
            this.logger.debug((Object)("SERVER: " + e));
            return false;
        }
    }

    public void run() {
        this.logger.debug((Object)"SERVER: listening on 53782 - SERVER");
        while (this.isAlive) {
            try {
                Socket socket = this.serverSocket.accept();
                this.logger.info((Object)"SERVER: connection detected");
                if (!this.isAlive) continue;
                this.manager.addEndPoint(socket);
            }
            catch (IOException iOException) {}
        }
    }

    void terminate() {
        this.logger.debug((Object)"Server shutting down...");
        this.isAlive = false;
        try {
            this.serverSocket.close();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        this.logger.debug((Object)"Server shut down complete.");
    }
}

