/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.vamsas.client.simpleclient;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.ac.vamsas.client.simpleclient.FileWatcher;
import uk.ac.vamsas.client.simpleclient.Lock;
import uk.ac.vamsas.client.simpleclient.VamsasFileWatcherElement;
import uk.ac.vamsas.client.simpleclient.WatcherCallBack;

public abstract class WatcherElement {
    private static Log log = LogFactory.getLog((Class)VamsasFileWatcherElement.class);
    protected FileWatcher watcher = null;
    protected WatcherCallBack handler = null;
    protected boolean watchForChange = true;
    protected boolean handlerCalled = false;

    public WatcherElement(WatcherCallBack handler) {
        this.handler = handler;
    }

    public void haltWatch() {
        this.watchForChange = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("haltWatch on " + this.watcher.getSubject()));
        }
        this.endWatch();
        if (log.isDebugEnabled()) {
            log.debug((Object)("haltWatch completed on " + this.watcher.getSubject()));
        }
    }

    protected abstract void endWatch();

    protected abstract void initWatch();

    protected abstract String getSubject();

    protected void enableWatch() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("enableWatch on " + this.getSubject()));
        }
        this.watchForChange = true;
        this.initWatch();
        if (log.isDebugEnabled()) {
            log.debug((Object)("enableWatch returning on " + this.getSubject()));
        }
    }

    public boolean doWatch() {
        if (!this.watchForChange || this.handler == null) {
            return false;
        }
        if (this.watcher == null) {
            this.initWatch();
        }
        this.handlerCalled = false;
        Lock doclock = null;
        try {
            doclock = this.watcher.getChangedState();
        }
        catch (Exception e) {
            log.error((Object)("Whilst watching " + this.watcher.getSubject()), (Throwable)e);
        }
        if (doclock == null) {
            return false;
        }
        this.callHandler(doclock);
        return true;
    }

    protected void callHandler(Lock doclock) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Triggering watchEvent for change on " + this.watcher.getSubject()));
        }
        boolean finish = !this.handler.handleWatchEvent(this, doclock);
        doclock = null;
        if (finish) {
            this.haltWatch();
        } else {
            this.enableWatch();
        }
        this.handlerCalled = false;
    }

    public WatcherCallBack getHandler() {
        return this.handler;
    }

    public boolean isHandlerCalled() {
        return this.handlerCalled;
    }

    public boolean isWatchEnabled() {
        return this.watchForChange;
    }

    public void setHandler(WatcherCallBack handler) {
        this.handler = handler;
    }

    public FileWatcher getWatcher() {
        return this.watcher;
    }
}

