/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CompareTask
extends Task {
    boolean numeric = false;
    boolean trim = false;
    boolean ignorecase = false;
    String arg1 = null;
    String arg2 = null;
    ArrayList conditions = new ArrayList();

    public Comparison createLesser() {
        Comparison comparison = new Comparison(){

            public void eval(Comparable left, Comparable right) {
                int i = left.compareTo(right);
                if (i < 0) {
                    CompareTask.this.log(String.valueOf(left.toString()) + " < " + CompareTask.this.arg2.toString() + " = " + i, 4);
                    CompareTask.this.getProject().setProperty(this.property, "true");
                }
            }
        };
        this.conditions.add(comparison);
        return comparison;
    }

    public Comparison createLesserOrEqual() {
        Comparison comparison = new Comparison(){

            public void eval(Comparable left, Comparable right) {
                int i = left.compareTo(right);
                if (i <= 0) {
                    CompareTask.this.log(String.valueOf(left.toString()) + " <= " + CompareTask.this.arg2.toString() + " = " + i, 4);
                    CompareTask.this.getProject().setProperty(this.property, "true");
                }
            }
        };
        this.conditions.add(comparison);
        return comparison;
    }

    public Comparison createEqual() {
        Comparison comparison = new Comparison(){

            public void eval(Comparable left, Comparable right) {
                int i = left.compareTo(right);
                if (i == 0) {
                    CompareTask.this.log(String.valueOf(left.toString()) + " == " + CompareTask.this.arg2.toString() + " = " + i, 4);
                    CompareTask.this.getProject().setProperty(this.property, "true");
                }
            }
        };
        this.conditions.add(comparison);
        return comparison;
    }

    public Comparison createContains() {
        Comparison comparison = new Comparison(){

            public void eval(Comparable left, Comparable right) {
                if (left.toString().indexOf(right.toString()) > -1) {
                    CompareTask.this.log(String.valueOf(left.toString()) + " contains " + CompareTask.this.arg2.toString(), 4);
                    CompareTask.this.getProject().setProperty(this.property, "true");
                }
            }
        };
        this.conditions.add(comparison);
        return comparison;
    }

    public Comparison createGreaterOrEqual() {
        Comparison comparison = new Comparison(){

            public void eval(Comparable left, Comparable right) {
                int i = left.compareTo(right);
                if (i >= 0) {
                    CompareTask.this.log(String.valueOf(left.toString()) + " >= " + CompareTask.this.arg2.toString() + " = " + i, 4);
                    CompareTask.this.getProject().setProperty(this.property, "true");
                }
            }
        };
        this.conditions.add(comparison);
        return comparison;
    }

    public Comparison createGreater() {
        Comparison comparison = new Comparison(){

            public void eval(Comparable left, Comparable right) {
                int i = left.compareTo(right);
                if (i > 0) {
                    CompareTask.this.log(String.valueOf(left.toString()) + " > " + CompareTask.this.arg2.toString() + " = " + i, 4);
                    CompareTask.this.getProject().setProperty(this.property, "true");
                }
            }
        };
        this.conditions.add(comparison);
        return comparison;
    }

    public void execute() throws BuildException {
        Object right;
        Object left;
        if (this.arg1 == null || this.arg2 == null) {
            throw new BuildException("attribute \"arg1\" and \"arg2\" are required");
        }
        if (this.conditions.size() == 0) {
            throw new BuildException("no inner element defined (equal, lesser, lesserorequal, greater, greaterorequal are valid inner elements).");
        }
        if (this.trim) {
            this.arg1 = this.arg1.trim();
            this.arg2 = this.arg2.trim();
        }
        if (this.ignorecase) {
            this.arg1 = this.arg1.toLowerCase();
            this.arg2 = this.arg2.toLowerCase();
        }
        try {
            left = this.numeric ? new Double(this.arg1) : this.arg1;
        }
        catch (NumberFormatException e) {
            throw new BuildException("arg1 is not a convertible in a number", (Throwable)e);
        }
        try {
            right = this.numeric ? new Double(this.arg2) : this.arg2;
        }
        catch (NumberFormatException e) {
            throw new BuildException("arg2 is not a convertible to number", (Throwable)e);
        }
        Iterator iter = this.conditions.iterator();
        while (iter.hasNext()) {
            Comparison comparison = (Comparison)iter.next();
            comparison.eval((Comparable)left, (Comparable)right);
        }
    }

    public void setArg1(String string) {
        this.arg1 = string;
    }

    public void setArg2(String string) {
        this.arg2 = string;
    }

    public void setIgnorecase(boolean b) {
        this.ignorecase = b;
    }

    public void setNumeric(boolean b) {
        this.numeric = b;
    }

    public void setTrim(boolean b) {
        this.trim = b;
    }

    public abstract class Comparison {
        String property = null;

        public void setProperty(String property) {
            this.property = property;
        }

        public abstract void eval(Comparable var1, Comparable var2);
    }
}

