/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class FindTask
extends Task {
    FileSet fileSet = null;
    String file = null;
    File dir = null;
    String nameProperty = null;
    String pathProperty = null;
    String property = null;
    String nameNoExtensionProperty = null;

    public void init() throws BuildException {
        this.dir = this.getProject().getBaseDir();
    }

    public void setFile(String s) {
        this.file = s;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public FileSet createFile() {
        if (this.fileSet != null) {
            throw new BuildException("Property \"file\" already defined");
        }
        this.fileSet = new FileSet();
        return this.fileSet;
    }

    public void execute() throws BuildException {
        String[] files;
        if (this.fileSet == null && this.file == null) {
            throw new BuildException("Either inner \"file\" element or \"file\" attribute are required.");
        }
        if (this.fileSet == null) {
            if (this.file == null) {
                throw new BuildException("Inner \"file\" element or \"file\" are required.");
            }
            this.fileSet = new FileSet();
            this.fileSet.setDir(this.dir);
            this.fileSet.setIncludes(this.file);
        }
        if ((files = this.fileSet.getDirectoryScanner(this.project).getIncludedFiles()).length == 0) {
            return;
        }
        if (files.length > 1) {
            this.log("More than one files matched. Taking the first one.", 1);
        }
        File file = new File(files[0]);
        if (this.property == null && this.nameProperty == null && this.pathProperty == null && this.nameNoExtensionProperty == null) {
            throw new BuildException("At least one of \"property\", \"nameProperty\", \"pathProperty\" or \"nameNoExtensionProperty\" attributes are required.");
        }
        if (this.property != null) {
            this.getProject().setProperty(this.property, file.getAbsolutePath());
        }
        if (this.nameProperty != null) {
            this.getProject().setProperty(this.nameProperty, file.getName());
        }
        if (this.nameNoExtensionProperty != null) {
            String name = file.getName();
            if (name.indexOf(46) != -1) {
                name = name.substring(0, name.lastIndexOf(46));
            } else {
                this.log("nameNoExtensionProperty : no extension found in name", 1);
            }
            this.getProject().setProperty(this.nameNoExtensionProperty, name);
        }
        if (this.pathProperty != null) {
            this.getProject().setProperty(this.pathProperty, file.getParentFile().getAbsolutePath());
        }
    }

    public void setNameProperty(String string) {
        this.nameProperty = string;
    }

    public void setNameNoExtensionProperty(String string) {
        this.nameNoExtensionProperty = string;
    }

    public void setPathProperty(String string) {
        this.pathProperty = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }
}

