/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import com.roxes.tools.ant.JNLPTaskMember;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JNLPTask
extends Task
implements JNLPTaskMember {
    String encoding = "UTF-8";
    Security security = null;
    ApplicationDesc applicationDesc = null;
    File toFile = null;
    AppletDesc appletDesc = null;
    ComponentDesc componentDesc = null;
    InstallerDesc installerDesc = null;
    String spec = "1.0+";
    String codebase = null;
    String href = null;
    String version = null;
    ArrayList informations = new ArrayList();
    ArrayList resources = new ArrayList();

    public void setEncoding(String s) {
        this.encoding = s;
    }

    public Security createSecurity() {
        this.security = new Security();
        return this.security;
    }

    public ApplicationDesc createApplication_Desc() {
        this.applicationDesc = new ApplicationDesc();
        return this.applicationDesc;
    }

    public AppletDesc createApplet_Desc() {
        this.appletDesc = new AppletDesc();
        return this.appletDesc;
    }

    public ComponentDesc createComponent_Desc() {
        this.componentDesc = new ComponentDesc();
        return this.componentDesc;
    }

    public InstallerDesc createInstaller_Desc() {
        this.installerDesc = new InstallerDesc();
        return this.installerDesc;
    }

    public Resources createResources() {
        Resources _resources = new Resources();
        this.resources.add(_resources);
        return _resources;
    }

    public void execute() throws BuildException {
        if (this.toFile == null) {
            throw new BuildException("Attribute toFile undefined");
        }
        String s = this.toString();
        this.log(s, 2);
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(this.toFile));
            pw.print(s);
            pw.close();
        }
        catch (IOException ex) {
            throw new BuildException("Error writing created jndi signature to " + this.toFile.getAbsolutePath(), (Throwable)ex);
        }
    }

    public Information createInformation() {
        Information information = new Information();
        this.informations.add(information);
        return information;
    }

    public void setCodebase(String string) {
        this.codebase = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setSpec(String string) {
        this.spec = string;
    }

    public void setHref(String string) {
        this.href = string;
    }

    public void toString(StringBuffer sb, int depth) {
        sb.append("<?xml version=\"1.0\" encoding=\"").append(this.encoding).append("\"?>").append(this.br());
        sb.append("<jnlp");
        if (this.spec != null) {
            sb.append(" spec=\"").append(this.spec).append("\"");
        }
        if (this.version != null) {
            sb.append(" version=\"").append(this.version).append("\"");
        }
        if (this.codebase != null) {
            sb.append(" codebase=\"").append(this.codebase).append("\"");
        }
        if (this.href != null) {
            sb.append(" href=\"").append(this.href).append("\"");
        }
        sb.append('>').append(this.br());
        int i = 0;
        while (i < this.informations.size()) {
            Information information = (Information)this.informations.get(i);
            information.toString(sb, 1);
            ++i;
        }
        if (this.security != null) {
            this.security.toString(sb, depth + 1);
        }
        i = 0;
        while (i < this.resources.size()) {
            Resources resources = (Resources)this.resources.get(i);
            resources.toString(sb, 1);
            ++i;
        }
        int choice = 0;
        if (this.applicationDesc != null) {
            ++choice;
        }
        if (this.appletDesc != null) {
            ++choice;
        }
        if (this.componentDesc != null) {
            ++choice;
        }
        if (this.installerDesc != null) {
            ++choice;
        }
        if (choice == 0) {
            throw new RuntimeException("<jndi> : Sub element missing ( application-desc | applet-desc | component-desc | installer-desc)");
        }
        if (choice > 1) {
            throw new RuntimeException("<jndi> : Only one of application-desc | applet-desc | component-desc | installer-desc expected");
        }
        if (this.applicationDesc != null) {
            this.applicationDesc.toString(sb, depth + 1);
        }
        if (this.appletDesc != null) {
            this.appletDesc.toString(sb, depth + 1);
        }
        if (this.componentDesc != null) {
            this.componentDesc.toString(sb, depth + 1);
        }
        if (this.installerDesc != null) {
            this.installerDesc.toString(sb, depth + 1);
        }
        sb.append("</jnlp>").append(this.br());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        this.toString(sb, 0);
        return sb.toString();
    }

    void appendTabs(StringBuffer sb, int depth) {
        while (depth-- > 0) {
            sb.append('\t');
        }
    }

    String br() {
        return "\r\n";
    }

    public void setToFile(File file) {
        this.toFile = file;
    }

    public class Information
    implements JNLPTaskMember {
        String locale = null;
        Title title = new Title();
        Vendor vendor = new Vendor();
        Homepage homepage = new Homepage();
        ArrayList descriptions = new ArrayList();
        Boolean offlineAllowed = null;
        ArrayList icons = new ArrayList();

        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<information");
            if (this.locale != null) {
                sb.append(" locale=\"").append(this.locale).append('\"');
            }
            sb.append('>').append(JNLPTask.this.br());
            this.title.toString(sb, depth + 1);
            this.vendor.toString(sb, depth + 1);
            this.homepage.toString(sb, depth + 1);
            int i = 0;
            while (i < this.descriptions.size()) {
                Description description = (Description)this.descriptions.get(i);
                description.toString(sb, depth + 1);
                ++i;
            }
            i = 0;
            while (i < this.icons.size()) {
                Icon icon = (Icon)this.icons.get(i);
                icon.toString(sb, depth + 1);
                ++i;
            }
            if (this.offlineAllowed != null && this.offlineAllowed.booleanValue()) {
                JNLPTask.this.appendTabs(sb, depth + 1);
                sb.append("<offline-allowed/>").append(JNLPTask.this.br());
            }
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("</information>").append(JNLPTask.this.br());
        }

        public Homepage createHomepage() {
            return this.homepage;
        }

        public Vendor createVendor() {
            return this.vendor;
        }

        public Title createTitle() {
            return this.title;
        }

        public Description createDescription() {
            Description description = new Description();
            this.descriptions.add(description);
            return description;
        }

        public Boolean createOffline_Allowed() {
            this.offlineAllowed = Boolean.TRUE;
            return this.offlineAllowed;
        }

        public Icon createIcon() {
            Icon icon = new Icon();
            this.icons.add(icon);
            return icon;
        }

        public void setLocale(String string) {
            this.locale = string;
        }

        public class Vendor {
            String vendor = "";

            public void addText(String s) {
                this.vendor = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                if (this.vendor != null) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<vendor>").append(this.vendor).append("</vendor>").append(JNLPTask.this.br());
                }
            }
        }

        public class Title
        implements JNLPTaskMember {
            String title = null;

            public void addText(String s) {
                this.title = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                if (this.title != null) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<title>").append(this.title).append("</title>").append(JNLPTask.this.br());
                }
            }
        }

        public class Homepage
        implements JNLPTaskMember {
            String href = null;

            public void setHref(String string) {
                this.href = string;
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                if (this.href != null) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<homepage href=\"").append(this.href).append("\"/>").append(JNLPTask.this.br());
                }
            }
        }

        public class Description
        implements JNLPTaskMember {
            String kind = null;
            String text = "";

            public void setKind(String string) {
                this.kind = string;
            }

            public void addText(String s) {
                this.text = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<description");
                if (this.kind != null) {
                    sb.append(" kind=\"").append(this.kind).append('\"');
                }
                sb.append('>');
                sb.append(this.text);
                sb.append("</description>").append(JNLPTask.this.br());
            }
        }

        public class Icon
        implements JNLPTaskMember {
            String href = null;
            String kind = null;
            String version = null;
            String width = null;
            String height = null;
            String depth = null;
            String size = null;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<icon");
                if (this.href != null) {
                    sb.append(" href=\"").append(this.href).append('\"');
                }
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.width != null) {
                    sb.append(" width=\"").append(this.width).append('\"');
                }
                if (this.height != null) {
                    sb.append(" height=\"").append(this.height).append('\"');
                }
                if (this.kind != null) {
                    sb.append(" kind=\"").append(this.kind).append('\"');
                }
                if (this.depth != null) {
                    sb.append(" depth=\"").append(this.depth).append('\"');
                }
                if (this.size != null) {
                    sb.append(" size=\"").append(this.size).append('\"');
                }
                sb.append("/>").append(JNLPTask.this.br());
            }

            public void setHref(String s) {
                this.href = s;
            }

            public void setKind(String s) {
                this.kind = s;
            }

            public void setHeight(String string) {
                this.height = string;
            }

            public void setSize(String string) {
                this.size = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }

            public void setWidth(String string) {
                this.width = string;
            }
        }
    }

    public class Security
    implements JNLPTaskMember {
        Permission permission = null;

        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<security>").append(JNLPTask.this.br());
            if (this.permission == null) {
                throw new RuntimeException("<security> requires either <all_permissions/> or <j2ee_application_client_permissions/> as child element.");
            }
            this.permission.toString(sb, depth + 1);
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("</security>").append(JNLPTask.this.br());
        }

        public Permission createAll_Permissions() {
            this.permission = new Permission("all-permissions");
            return this.permission;
        }

        public Permission createJ2ee_Application_Client_Permissions() {
            this.permission = new Permission("j2ee-application-client-permissions");
            return this.permission;
        }

        public class Permission
        implements JNLPTaskMember {
            String name;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append('<').append(this.name).append("/>").append(JNLPTask.this.br());
            }

            public Permission(String s) {
                this.name = s;
            }
        }
    }

    public class ApplicationDesc
    implements JNLPTaskMember {
        String mainClass = null;
        ArrayList arguments = new ArrayList();

        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<application-desc");
            if (this.mainClass != null) {
                sb.append(" main-class=\"").append(this.mainClass).append('\"');
            }
            if (this.arguments.size() == 0) {
                sb.append("/>").append(JNLPTask.this.br());
            } else {
                sb.append('>').append(JNLPTask.this.br());
            }
            int i = 0;
            while (i < this.arguments.size()) {
                Argument arg = (Argument)this.arguments.get(i);
                arg.toString(sb, depth + 1);
                ++i;
            }
            if (this.arguments.size() > 0) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("</application-desc>").append(JNLPTask.this.br());
            }
        }

        public void setMain_Class(String string) {
            this.mainClass = string;
        }

        public Argument createArgument() {
            Argument argument = new Argument();
            this.arguments.add(argument);
            return argument;
        }

        public class Argument
        implements JNLPTaskMember {
            String text = null;

            public void addText(String s) {
                this.text = JNLPTask.this.getProject().replaceProperties(s);
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<argument>");
                if (this.text == null) {
                    throw new RuntimeException("<argument> requires #pcdata content");
                }
                sb.append(this.text);
                sb.append("</argument>").append(JNLPTask.this.br());
            }
        }
    }

    public class AppletDesc
    implements JNLPTaskMember {
        ArrayList params = new ArrayList();
        String documentBase = null;
        String mainClass = null;
        String name = null;
        String width = null;
        String height = null;

        public Param createArgument() {
            Param param = new Param();
            this.params.add(param);
            return param;
        }

        public void setHeight(String string) {
            this.height = string;
        }

        public void setMainClass(String string) {
            this.mainClass = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setWidth(String string) {
            this.width = string;
        }

        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<applet-desc");
            if (this.name == null) {
                throw new RuntimeException("<applet_desc> requires attribute name");
            }
            sb.append(" name=\"").append(this.name).append('\"');
            if (this.mainClass == null) {
                throw new RuntimeException("<applet_desc> requires attribute main_class");
            }
            sb.append(" mainClass=\"").append(this.mainClass).append('\"');
            if (this.width == null) {
                throw new RuntimeException("<applet_desc> requires attribute width");
            }
            sb.append(" width=\"").append(this.width).append('\"');
            if (this.height == null) {
                throw new RuntimeException("<applet_desc> requires attribute height");
            }
            sb.append(" height=\"").append(this.height).append('\"');
            if (this.documentBase != null) {
                sb.append(" documentbase=\"").append(this.documentBase).append('\"');
            }
            if (this.params.size() == 0) {
                sb.append("\">").append(JNLPTask.this.br());
            } else {
                sb.append('>').append(JNLPTask.this.br());
            }
            int i = 0;
            while (i < this.params.size()) {
                Param param = (Param)this.params.get(i);
                param.toString(sb, depth + 1);
                ++i;
            }
            if (this.params.size() > 0) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("</applet-desc>").append(JNLPTask.this.br());
            }
        }

        public void setDocumentBase(String string) {
            this.documentBase = string;
        }

        public class Param
        implements JNLPTaskMember {
            String name = null;
            String value = null;

            public void setName(String string) {
                this.name = string;
            }

            public void setValue(String string) {
                this.value = string;
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<param");
                if (this.name == null) {
                    throw new RuntimeException("<param> requires attribute name");
                }
                sb.append(" name=\"").append(this.name).append('\"');
                if (this.value == null) {
                    throw new RuntimeException("<param> requires attribute value");
                }
                sb.append(" value=\"").append(this.value).append('\"');
                sb.append("/>").append(JNLPTask.this.br());
            }
        }
    }

    public class ComponentDesc
    implements JNLPTaskMember {
        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<component-desc/>").append(JNLPTask.this.br());
        }
    }

    public class InstallerDesc
    implements JNLPTaskMember {
        String mainClass = null;

        public void setMain_Class(String string) {
            this.mainClass = string;
        }

        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<installer-desc");
            if (this.mainClass == null) {
                throw new RuntimeException("<installer_desc> requires attribute main_class");
            }
            sb.append(" main-class=\"").append(this.mainClass).append('\"');
            sb.append("</installer-desc>").append(JNLPTask.this.br());
        }
    }

    public class Resources
    implements JNLPTaskMember {
        ArrayList filesets = new ArrayList();
        ArrayList jars = new ArrayList();
        ArrayList nativeLibs = new ArrayList();
        ArrayList extensions = new ArrayList();
        ArrayList packages = new ArrayList();
        ArrayList properties = new ArrayList();
        ArrayList j2ses = new ArrayList();
        String os = null;
        String arch = null;
        String locale = null;

        public void execute() throws BuildException {
        }

        public void toString(StringBuffer sb, int depth) {
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("<resources");
            if (this.os != null) {
                sb.append(" os=\"").append(this.os).append('\"');
            }
            if (this.arch != null) {
                sb.append(" arch=\"").append(this.arch).append('\"');
            }
            if (this.locale != null) {
                sb.append(" locale=\"").append(this.locale).append('\"');
            }
            sb.append('>').append(JNLPTask.this.br());
            int i = 0;
            while (i < this.j2ses.size()) {
                J2SE j2se = (J2SE)this.j2ses.get(i++);
                j2se.toString(sb, depth + 1);
                ++i;
            }
            i = 0;
            while (i < this.filesets.size()) {
                FileSet fileSet = (FileSet)this.filesets.get(i);
                DirectoryScanner directoryscanner = fileSet.getDirectoryScanner(JNLPTask.this.getProject());
                String[] files = directoryscanner.getIncludedFiles();
                int j = 0;
                while (j < files.length) {
                    String string = files[j];
                    if (string.endsWith(".dll") || string.endsWith(".so")) {
                        NativeLib nativeLib = this.createNativeLib();
                        nativeLib.href = string.replace('\\', '/').replace(' ', '+');
                    } else {
                        Jar jar = this.createJar();
                        jar.href = string.replace('\\', '/').replace(' ', '+');
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < this.jars.size()) {
                Jar jar = (Jar)this.jars.get(i);
                jar.toString(sb, depth + 1);
                ++i;
            }
            i = 0;
            while (i < this.nativeLibs.size()) {
                NativeLib nativeLib = (NativeLib)this.nativeLibs.get(i);
                nativeLib.toString(sb, depth + 1);
                ++i;
            }
            i = 0;
            while (i < this.extensions.size()) {
                Extension extension = (Extension)this.extensions.get(i);
                extension.toString(sb, depth + 1);
                ++i;
            }
            i = 0;
            while (i < this.properties.size()) {
                Property property = (Property)this.properties.get(i);
                property.toString(sb, depth + 1);
                ++i;
            }
            i = 0;
            while (i < this.packages.size()) {
                Package _package = (Package)this.packages.get(i);
                _package.toString(sb, depth + 1);
                ++i;
            }
            JNLPTask.this.appendTabs(sb, depth);
            sb.append("</resources>").append(JNLPTask.this.br());
        }

        public void setArch(String string) {
            this.arch = string;
        }

        public void setLocale(String string) {
            this.locale = string;
        }

        public void setOs(String string) {
            this.os = string;
        }

        public void addFileset(FileSet fileset) {
            this.filesets.add(fileset);
        }

        public Jar createJar() {
            Jar jar = new Jar();
            this.jars.add(jar);
            return jar;
        }

        public J2SE createJ2SE() {
            J2SE j2se = new J2SE();
            this.j2ses.add(j2se);
            return j2se;
        }

        public Extension createExtension() {
            Extension extension = new Extension();
            this.extensions.add(extension);
            return extension;
        }

        public Property createProperty() {
            Property property = new Property();
            this.properties.add(property);
            return property;
        }

        public Package createPackage() {
            Package _package = new Package();
            this.packages.add(_package);
            return _package;
        }

        public NativeLib createNativeLib() {
            NativeLib nativeLib = new NativeLib();
            this.nativeLibs.add(nativeLib);
            return nativeLib;
        }

        public class NativeLib
        implements JNLPTaskMember {
            String href = null;
            String part = null;
            String download = null;
            String version = null;
            String size = null;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<nativelib");
                if (this.href == null) {
                    throw new RuntimeException("<nativelib> requires attribute href");
                }
                sb.append(" href=\"").append(this.href).append('\"');
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.download != null) {
                    sb.append(" download=\"").append(this.download).append('\"');
                }
                if (this.size != null) {
                    sb.append(" size=\"").append(this.size).append('\"');
                }
                if (this.part != null) {
                    sb.append(" part=\"").append(this.part).append('\"');
                }
                sb.append("/>").append(JNLPTask.this.br());
            }

            public void setDownload(String string) {
                this.download = string;
            }

            public void setHref(String string) {
                this.href = string;
            }

            public void setPart(String string) {
                this.part = string;
            }

            public void setSize(String string) {
                this.size = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }
        }

        public class Jar
        implements JNLPTaskMember {
            String href = null;
            String part = null;
            String download = null;
            String size = null;
            String main = null;
            String version = null;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<jar");
                if (this.href == null) {
                    throw new RuntimeException("<jar> requires attribute href");
                }
                sb.append(" href=\"").append(this.href).append('\"');
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.main != null) {
                    sb.append(" main=\"").append(this.main).append('\"');
                }
                if (this.download != null) {
                    sb.append(" download=\"").append(this.download).append('\"');
                }
                if (this.size != null) {
                    sb.append(" size=\"").append(this.size).append('\"');
                }
                if (this.part != null) {
                    sb.append(" part=\"").append(this.part).append('\"');
                }
                sb.append("/>").append(JNLPTask.this.br());
            }

            public void setDownload(String string) {
                this.download = string;
            }

            public void setHref(String string) {
                this.href = string;
            }

            public void setPart(String string) {
                this.part = string;
            }

            public void setMain(String string) {
                this.main = string.toLowerCase();
                if (!this.main.equals("true") && !this.main.equals("false")) {
                    throw new BuildException("\"main\" attribute of jar ");
                }
            }

            public void setSize(String string) {
                this.size = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }
        }

        public class Extension
        implements JNLPTaskMember {
            ArrayList extDownloads = new ArrayList();
            String name = null;
            String version = null;
            String href = null;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<extension");
                if (this.href == null) {
                    throw new RuntimeException("<extension> requires attribute href");
                }
                sb.append(" href=\"").append(this.href).append('\"');
                if (this.version != null) {
                    sb.append(" version=\"").append(this.version).append('\"');
                }
                if (this.name != null) {
                    sb.append(" name=\"").append(this.name).append('\"');
                }
                if (this.extDownloads.size() > 0) {
                    sb.append('>').append(JNLPTask.this.br());
                } else {
                    sb.append("/>").append(JNLPTask.this.br());
                }
                int i = 0;
                while (i < this.extDownloads.size()) {
                    ExtDownload extDownload = (ExtDownload)this.extDownloads.get(i);
                    extDownload.toString(sb, depth + 1);
                    ++i;
                }
                if (this.extDownloads.size() > 0) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("</extension>").append(JNLPTask.this.br());
                }
            }

            public ExtDownload createExtDownload() {
                ExtDownload extDownload = new ExtDownload();
                this.extDownloads.add(this.extDownloads);
                return extDownload;
            }

            public void setHref(String string) {
                this.href = string;
            }

            public void setName(String string) {
                this.name = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }

            public class ExtDownload
            implements JNLPTaskMember {
                String extPart = null;
                String download = null;
                String part = null;

                public void execute() throws BuildException {
                }

                public void toString(StringBuffer sb, int depth) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("<ext-download");
                    if (this.extPart == null) {
                        throw new RuntimeException("<ext-download> requires attribute ext-part");
                    }
                    sb.append(" ext-part=\"").append(this.extPart).append('\"');
                    if (this.download != null) {
                        sb.append(" download=\"").append(this.download).append('\"');
                    }
                    if (this.part != null) {
                        sb.append(" part=\"").append(this.part).append('\"');
                    }
                    sb.append("/>").append(JNLPTask.this.br());
                }

                public void setDownload(String string) {
                    this.download = string;
                }

                public void setExt_Part(String string) {
                    this.extPart = string;
                }

                public void setPart(String string) {
                    this.part = string;
                }
            }
        }

        public class Property
        implements JNLPTaskMember {
            String name = null;
            String value = null;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<property");
                if (this.name == null) {
                    throw new RuntimeException("<property> requires attribute name");
                }
                sb.append(" name=\"").append(this.name).append('\"');
                if (this.value == null) {
                    throw new RuntimeException("<property> requires attribute value");
                }
                sb.append(" value=\"").append(this.value).append('\"');
                sb.append("/>").append(JNLPTask.this.br());
            }

            public void setName(String string) {
                this.name = string;
            }

            public void setValue(String string) {
                this.value = string;
            }
        }

        public class Package
        implements JNLPTaskMember {
            String name = null;
            String part = null;
            String recursive = null;

            public void setName(String string) {
                this.name = string;
            }

            public void setPart(String string) {
                this.part = string;
            }

            public void setRecursive(String string) {
                this.recursive = string;
            }

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<package");
                if (this.name == null) {
                    throw new RuntimeException("<package> requires attribute name");
                }
                sb.append(" name=\"").append(this.name).append('\"');
                if (this.part == null) {
                    throw new RuntimeException("<package> requires attribute part");
                }
                sb.append(" part=\"").append(this.part).append('\"');
                if (this.recursive != null) {
                    sb.append(" recursive=\"").append(this.recursive).append('\"');
                }
                sb.append("/>").append(JNLPTask.this.br());
            }
        }

        public class J2SE
        implements JNLPTaskMember {
            ArrayList resources = new ArrayList();
            String version = null;
            String href = null;
            String initialHeapSize = null;
            String maxHeapSize = null;

            public void execute() throws BuildException {
            }

            public void toString(StringBuffer sb, int depth) {
                JNLPTask.this.appendTabs(sb, depth);
                sb.append("<j2se");
                if (this.version == null) {
                    throw new RuntimeException("<j2se> requires attribute version");
                }
                sb.append(" version=\"").append(this.version).append('\"');
                if (this.href != null) {
                    sb.append(" href=\"").append(this.href).append('\"');
                }
                if (this.initialHeapSize != null) {
                    sb.append(" initial-heap-size=\"").append(this.initialHeapSize).append('\"');
                }
                if (this.maxHeapSize != null) {
                    sb.append(" max-heap-size=\"").append(this.maxHeapSize).append('\"');
                }
                if (this.resources.size() == 0) {
                    sb.append("/>").append(JNLPTask.this.br());
                } else {
                    sb.append('>').append(JNLPTask.this.br());
                }
                int i = 0;
                while (i < this.resources.size()) {
                    Resources resources = (Resources)this.resources.get(i);
                    resources.toString(sb, depth + 1);
                    ++i;
                }
                if (this.resources.size() > 0) {
                    JNLPTask.this.appendTabs(sb, depth);
                    sb.append("</j2se>").append(JNLPTask.this.br());
                }
            }

            public Resources createResources() {
                Resources _resources = new Resources();
                this.resources.add(_resources);
                return _resources;
            }

            public void setHref(String string) {
                this.href = string;
            }

            public void setInitial_Heap_Size(String string) {
                this.initialHeapSize = string;
            }

            public void setMax_Heap_Size(String string) {
                this.maxHeapSize = string;
            }

            public void setVersion(String string) {
                this.version = string;
            }
        }
    }
}

