/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class KDEShortcutDirectoryTask
extends Task {
    Properties p = new Properties();
    File file = null;
    ArrayList customProperties = new ArrayList();

    public void setName(String s) {
        this.p.put("Name", s);
    }

    public void setHidden(boolean b) {
        this.p.put("Hidden", b ? "1" : "0");
    }

    public Property createProperty() {
        Property prop = new Property();
        this.customProperties.add(prop);
        return prop;
    }

    public void setIcon(String s) {
        this.p.put("Icon", s);
    }

    public void setIconFile(File f) {
        this.p.put("Icon", f.getAbsolutePath());
    }

    public void setComment(String s) {
        this.p.put("Comment", s);
    }

    public void execute() throws BuildException {
        if (this.file == null || !this.p.containsKey("Name")) {
            throw new BuildException("Attributes \"directory\" are required.");
        }
        if (!this.file.exists() && !this.file.mkdirs()) {
            throw new BuildException("Creating kde shortcut directory " + this.file.getAbsolutePath() + " failed.");
        }
        this.file = new File(this.file, ".directory");
        Iterator iter = this.customProperties.iterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            prop.run();
        }
        try {
            this.log("Writing kde shortcut directory file " + this.file.getAbsolutePath());
            PrintWriter pw = new PrintWriter(new FileWriter(this.file));
            pw.println("[Desktop Entry]");
            Enumeration<Object> e = this.p.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                pw.println(String.valueOf(key) + "=" + this.p.getProperty(key));
            }
            pw.close();
        }
        catch (IOException ex) {
            throw new BuildException("Writing kde shortcut directory file " + this.file.getAbsolutePath() + "failed : " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setDirectory(File file) {
        this.file = file;
    }

    public class Property
    implements Runnable {
        String name = null;
        String value = null;

        public void setName(String s) {
            this.name = s;
        }

        public void setValue(String s) {
            this.value = s;
        }

        public void addText(String s) {
            if (s.trim().length() > 0) {
                this.value = KDEShortcutDirectoryTask.this.getProject().replaceProperties(s.trim());
            }
        }

        public void run() {
            if (this.name == null || this.value == null) {
                throw new BuildException("Attribute \"name\" and \"value\" are required for shortcut properties");
            }
            KDEShortcutDirectoryTask.this.p.put(this.name, this.value);
        }
    }
}

