/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class PropertiesTask
extends Task {
    File file = null;
    String header = null;
    boolean overwrite = true;
    ArrayList properties = new ArrayList();
    FileSet merge = null;

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void setHeader(String s) {
        this.header = s;
    }

    public Property createProperty() {
        Property p = new Property();
        this.properties.add(p);
        return p;
    }

    public FileSet createMerge() {
        if (this.merge != null) {
            throw new BuildException("<properties> accepts only one <merge> sub element.");
        }
        this.merge = new FileSet();
        return this.merge;
    }

    public Header createHeader() {
        if (this.header != null) {
            throw new BuildException("header is already defined !");
        }
        return new Header();
    }

    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("<properties> requires attribute \"file\"");
        }
        if (this.file.isDirectory()) {
            throw new BuildException("<properties> attribute \"file\" cannot be a directory.");
        }
        try {
            Properties p = new Properties();
            if (!this.overwrite && this.file.exists()) {
                this.log("load existing property file " + this.file.getAbsolutePath(), 2);
                p.load(new FileInputStream(this.file));
            }
            if (this.merge != null) {
                DirectoryScanner ds = this.merge.getDirectoryScanner(this.getProject());
                String[] files = ds.getIncludedFiles();
                int i = 0;
                while (i < files.length) {
                    File _file = new File(ds.getBasedir(), files[i]);
                    if (!_file.equals(this.file)) {
                        this.log("merge property file " + _file, 2);
                        p.load(new FileInputStream(_file));
                    }
                    ++i;
                }
            }
            Iterator iter = this.properties.iterator();
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                property.attach(p);
            }
            this.log("write property file " + this.file.getAbsolutePath(), 2);
            p.save(new FileOutputStream(this.file), this.header);
        }
        catch (IOException ex) {
            throw new BuildException("<properties> failed : " + ex.getMessage(), (Throwable)ex);
        }
    }

    public class Property {
        String name = null;
        String value = null;
        String isTrue = null;
        String isFalse = null;
        String _if = null;
        String unless = null;
        String available = null;

        public void setIsFalse(String string) {
            if (this.isTrue != null || this.isFalse != null || this._if != null || this.unless != null || this.available != null) {
                throw new BuildException("Only one of istrue, isfalse, if, unless or available can be used as property attribute");
            }
            this.isFalse = string;
        }

        public void setIsTrue(String string) {
            if (this.isTrue != null || this.isFalse != null || this._if != null || this.unless != null || this.available != null) {
                throw new BuildException("Only one of istrue, isfalse, if, unless or available can be used as property attribute");
            }
            this.isTrue = string;
        }

        public void setAvailable(String string) {
            if (this.isTrue != null || this.isFalse != null || this._if != null || this.unless != null || this.available != null) {
                throw new BuildException("Only one of istrue, isfalse, if, unless or available can be used as property attribute");
            }
            this.available = string;
        }

        public void setName(String string) {
            this.name = string;
        }

        public void setIf(String string) {
            if (this.isTrue != null || this.isFalse != null || this._if != null || this.unless != null || this.available != null) {
                throw new BuildException("Only one of istrue, isfalse, if, unless or available can be used as property attribute");
            }
            this._if = string;
        }

        public void setUnless(String string) {
            if (this.isTrue != null || this.isFalse != null || this._if != null || this.unless != null || this.available != null) {
                throw new BuildException("Only one of istrue, isfalse, if, unless or available can be used as property attribute");
            }
            this.unless = string;
        }

        public void setValue(String string) {
            if (this.value != null) {
                throw new BuildException("Property attribute value already set !");
            }
            this.value = string;
        }

        public void addText(String s) {
            if (s.trim().length() > 0) {
                if (this.value != null) {
                    throw new BuildException("Property attribute value already set !");
                }
                this.value = PropertiesTask.this.getProject().replaceProperties(s.trim());
            }
        }

        public void attach(Properties p) {
            if (this.name == null) {
                throw new BuildException("<property> attribute \"name\" is required.");
            }
            if (this.value == null) {
                throw new BuildException("<property> attribute \"value\" is required.");
            }
            if (this.isTrue != null) {
                if (this.isTrue.equalsIgnoreCase("true")) {
                    p.setProperty(this.name, this.value);
                }
            } else if (this.isFalse != null) {
                if (this.isFalse.equalsIgnoreCase("false")) {
                    p.setProperty(this.name, this.value);
                }
            } else if (this.available != null) {
                try {
                    Class.forName(this.available);
                    p.setProperty(this.name, this.value);
                }
                catch (Exception e) {
                    ClassLoader.getSystemResource(this.available);
                    p.setProperty(this.name, this.value);
                }
            } else if (this._if != null) {
                if (PropertiesTask.this.getProject().getProperty(this._if) != null) {
                    p.setProperty(this.name, this.value);
                }
            } else if (this.unless != null) {
                if (PropertiesTask.this.getProject().getProperty(this.unless) == null) {
                    p.setProperty(this.name, this.value);
                }
            } else {
                p.setProperty(this.name, this.value);
            }
        }
    }

    public class Header {
        public void addText(String s) {
            if (s.trim().length() > 0) {
                PropertiesTask.this.header = PropertiesTask.this.getProject().replaceProperties(s.trim());
            }
        }
    }
}

