/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Sequential;

public class SwitchTask
extends Task {
    private String value;
    private ArrayList cases = new ArrayList();
    private Sequential defaultCase;
    private boolean caseInsensitive;

    public void execute() throws BuildException {
        if (this.value == null) {
            throw new BuildException("Attribute \"value\" is required");
        }
        if (this.cases.size() == 0 && this.defaultCase == null) {
            throw new BuildException("At least one inner element \"case\" is required.");
        }
        Sequential selectedCase = this.defaultCase;
        Iterator iter = this.cases.iterator();
        while (iter.hasNext()) {
            Case c = (Case)((Object)iter.next());
            String cvalue = c.value;
            if (cvalue == null) {
                throw new BuildException("Attribute \"value\" is required.");
            }
            String mvalue = this.value;
            if (this.caseInsensitive) {
                cvalue = cvalue.toUpperCase();
                mvalue = mvalue.toUpperCase();
            }
            if (!cvalue.equals(mvalue) || c == this.defaultCase) continue;
            selectedCase = c;
        }
        if (selectedCase == null) {
            throw new BuildException("No case matched value " + this.value + " and no inner element default has been specified.");
        }
        selectedCase.perform();
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setCaseInsensitive(boolean c) {
        this.caseInsensitive = c;
    }

    public Case createCase() throws BuildException {
        Case res = new Case();
        this.cases.add(res);
        return res;
    }

    public void addDefault(Sequential res) throws BuildException {
        if (this.defaultCase != null) {
            throw new BuildException("Cannot specify multiple default inner elements");
        }
        this.defaultCase = res;
    }

    public class Case
    extends Sequential {
        private String value;

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            boolean res = false;
            Case c = (Case)((Object)o);
            if (c.value.equals(this.value)) {
                res = true;
            }
            return res;
        }
    }
}

