/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;

public class UnixPropertiesTask
extends Task {
    static Properties environment = null;
    static String[] commonProgramsFolders = new String[]{"/usr/local", "/usr/local/bin", "/opt"};

    public void init() throws BuildException {
        if (environment == null) {
            environment = new Properties();
            Vector osEnv = Execute.getProcEnvironment();
            Enumeration e = osEnv.elements();
            while (e.hasMoreElements()) {
                String entry = (String)e.nextElement();
                int pos = entry.indexOf(61);
                if (pos == -1) {
                    this.log("Ignoring enviroment variable : " + entry, 4);
                    continue;
                }
                environment.put(entry.substring(0, pos), entry.substring(pos + 1));
                this.log("adding enviroment variable : \"" + entry.substring(0, pos) + "\"", 4);
            }
        }
    }

    private String trim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public void execute() throws BuildException {
        String commonPrograms;
        if (environment.getProperty("KDEHOME") != null) {
            String kdeConfig = null;
            if (environment.getProperty("PATH") != null) {
                StringTokenizer st = new StringTokenizer(environment.getProperty("PATH"), System.getProperty("path.separator"));
                while (st.hasMoreTokens()) {
                    File file = new File(this.trim(st.nextToken()), "kde-config");
                    if (!file.exists()) continue;
                    kdeConfig = file.getAbsolutePath();
                    break;
                }
                if (kdeConfig == null) {
                    this.log("KDEHOME found but cannot find executable \"kde-config\" in PATH", 1);
                } else {
                    String personalTemplates;
                    String personalProgramsMenu;
                    String kdeIcons;
                    String personalDocuments;
                    String personalAutostart;
                    String personalDesktop = this.trim(this.execute(new String[]{kdeConfig, "-userpath", "desktop"}));
                    if (personalDesktop != null) {
                        st = new StringTokenizer(personalDesktop, System.getProperty("path.separator"));
                        if (st.countTokens() > 1) {
                            personalDesktop = st.nextToken();
                            this.getProject().setProperty("unix.kde.common.desktop", st.nextToken());
                        }
                        this.getProject().setProperty("unix.kde.personal.desktop", personalDesktop);
                    }
                    if ((personalAutostart = this.trim(this.execute(new String[]{kdeConfig, "-userpath", "autostart"}))) != null) {
                        st = new StringTokenizer(personalAutostart, System.getProperty("path.separator"));
                        if (st.countTokens() > 1) {
                            personalAutostart = st.nextToken();
                            this.getProject().setProperty("unix.kde.common.autostart_menu", st.nextToken());
                        }
                        this.getProject().setProperty("unix.kde.personal.autostart_menu", personalAutostart);
                    }
                    if ((personalDocuments = this.trim(this.execute(new String[]{kdeConfig, "-userpath", "document"}))) != null) {
                        st = new StringTokenizer(personalDocuments, System.getProperty("path.separator"));
                        if (st.countTokens() > 1) {
                            personalDocuments = st.nextToken();
                            this.getProject().setProperty("unix.kde.common.documents", st.nextToken());
                        }
                        this.getProject().setProperty("unix.kde.personal.documents", personalDocuments);
                    }
                    if ((kdeIcons = this.trim(this.execute(new String[]{kdeConfig, "-path", "icon"}))) != null) {
                        st = new StringTokenizer(kdeIcons, System.getProperty("path.separator"));
                        if (st.countTokens() > 1) {
                            kdeIcons = st.nextToken();
                        }
                        this.getProject().setProperty("unix.kde.icons", kdeIcons);
                    }
                    if ((personalProgramsMenu = this.trim(this.execute(new String[]{kdeConfig, "-path", "apps"}))) != null) {
                        st = new StringTokenizer(personalProgramsMenu, System.getProperty("path.separator"));
                        if (st.countTokens() > 1) {
                            personalProgramsMenu = st.nextToken();
                            this.getProject().setProperty("unix.kde.common.programs_menu", st.nextToken());
                        }
                        this.getProject().setProperty("unix.kde.personal.programs_menu", personalProgramsMenu);
                    }
                    if ((personalTemplates = this.trim(this.execute(new String[]{kdeConfig, "-path", "templates"}))) != null) {
                        st = new StringTokenizer(personalTemplates, System.getProperty("path.separator"));
                        if (st.countTokens() > 1) {
                            personalTemplates = st.nextToken();
                            this.getProject().setProperty("unix.kde.common.templates", st.nextToken());
                        }
                        this.getProject().setProperty("unix.kde.personal.templates", personalTemplates);
                    }
                    this.getProject().setProperty("unix.kde.home", environment.getProperty("KDEHOME"));
                }
            }
        } else {
            this.log("KDEHOME not found", 2);
        }
        if ((commonPrograms = UnixPropertiesTask.getCommonProgramsFolder()) != null) {
            this.getProject().setProperty("unix.common.programfiles", commonPrograms);
        }
        this.getProject().setProperty("unix.common.programfiles", commonPrograms);
        File file = new File(System.getProperty("user.home"), "bin");
        if (!file.exists()) {
            if (!file.mkdirs()) {
                this.log("Creation of \"unix.programfiles\" (" + file.getAbsolutePath() + ") failed.", 1);
            } else {
                this.log("Creation of \"unix.programfiles\" (" + file.getAbsolutePath() + ") successful.", 1);
                this.getProject().setProperty("unix.programfiles", file.getAbsolutePath());
            }
        } else {
            this.getProject().setProperty("unix.programfiles", file.getAbsolutePath());
        }
        if (environment.getProperty("UID") != null) {
            try {
                if (Integer.parseInt(environment.getProperty("UID")) == 0) {
                    this.getProject().setProperty("unix.user.isRoot", "true");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private String execute(String[] command) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PumpStreamHandler psh = new PumpStreamHandler((OutputStream)out);
            Execute execute = new Execute((ExecuteStreamHandler)psh);
            execute.setCommandline(command);
            execute.execute();
            return Execute.toString((ByteArrayOutputStream)out);
        }
        catch (IOException ex) {
            this.log("Unable to execute kde-config " + ex.getMessage(), 1);
            return null;
        }
    }

    static String getCommonProgramsFolder() {
        int i = 0;
        while (i < commonProgramsFolders.length) {
            String path = commonProgramsFolders[i];
            File file = new File(path);
            if (file.isDirectory() && file.exists()) {
                return path;
            }
            ++i;
        }
        return null;
    }
}

