/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.antony;

import com.roxes.tools.ant.antony.AntonyEchoTask;
import com.roxes.tools.ant.antony.AntonyInputHandler;
import com.roxes.tools.ant.antony.AntonyLogger;
import com.roxes.tools.ant.antony.ProgressPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Antony
extends JFrame {
    public static final String TITLE = "ROXES Antony";
    public static final String VERSION = "1.0";
    String title = "ROXES Antony 1.0";
    Project project = new Project();
    ProgressPanel progressPanel;
    InputHandler inputHandler;
    AntonyLogger buildLogger;
    JButton start;
    JButton quit;
    Font font;
    Font boldFont;
    ActionListener quitAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (Antony.this.started && !Antony.this.progressPanel.finished && JOptionPane.showConfirmDialog(Antony.this, "Building is in progress.\nReally want to abort ?", "Abort Building", 0) != 0) {
                return;
            }
            Antony.this.dispose();
            System.exit(0);
        }
    };
    JToggleButton consoleButton;
    ActionListener consoleAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (Antony.this.consoleButton.isSelected()) {
                Antony.this.buildLogger.setVisible(true);
                Antony.this.requestFocus();
            } else {
                Antony.this.buildLogger.setVisible(false);
            }
        }
    };
    boolean started = false;
    ActionListener startAction = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            new Thread(this){
                final /* synthetic */ 3 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    3.access$0(this.this$1).start.setEnabled(false);
                    3.access$0(this.this$1).progressPanel.buildStarted(null);
                    3.access$0(this.this$1).progressPanel.setCursor(Cursor.getPredefinedCursor(3));
                    3.access$0(this.this$1).progressPanel.requestFocus();
                    if (Antony.access$0(3.access$0(this.this$1)).size() == 0 && 3.access$0(this.this$1).project.getDefaultTarget() != null) {
                        Antony.access$0(3.access$0(this.this$1)).addElement(3.access$0(this.this$1).project.getDefaultTarget());
                    }
                    3.access$0(this.this$1).started = true;
                    Exception throwable = null;
                    try {
                        try {
                            3.access$0(this.this$1).project.executeTargets(Antony.access$0(3.access$0(this.this$1)));
                        }
                        catch (Exception ex) {
                            throwable = ex;
                        }
                    }
                    catch (Throwable throwable2) {
                        Object var3_4 = null;
                        3.access$0(this.this$1).progressPanel.setCursor(Cursor.getPredefinedCursor(0));
                        throw throwable2;
                    }
                    Object var3_5 = null;
                    3.access$0(this.this$1).progressPanel.setCursor(Cursor.getPredefinedCursor(0));
                    if (!3.access$0(this.this$1).projectHelp) {
                        3.access$0(this.this$1).project.fireBuildFinished((Throwable)throwable);
                        if (throwable != null) {
                            3.access$0(this.this$1).quit.setFont(3.access$0(this.this$1).boldFont);
                            3.access$0(this.this$1).quit.setText("Abort");
                            JOptionPane.showMessageDialog(3.access$0(this.this$1), throwable.getMessage(), "Error occured in build", 0);
                            throwable.printStackTrace(System.err);
                        }
                    }
                    if (throwable == null && 3.access$0(this.this$1).autoexit) {
                        3.access$0(this.this$1).quitAction.actionPerformed(null);
                    }
                }
            }.start();
        }

        static /* synthetic */ Antony access$0(3 var0) {
            return var0.Antony.this;
        }
    };
    ImageIcon icon = null;
    boolean autostart = false;
    boolean autoexit = false;
    boolean console = false;
    boolean emacsMode = false;
    boolean projectHelp = false;
    String searchForThis = null;
    String loggerClassname = null;
    String inputHandlerClassname = null;
    boolean isLogFileUsed = false;
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;
    private Vector targets = new Vector();
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector(1);
    private Vector propertyFiles = new Vector(1);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Antony(String[] args) {
        this.setSize(320, 350);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.roxes.tools.ant.antony.Antony");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setIconImage(new ImageIcon(clazz.getResource("ant-32x32.gif")).getImage());
        Font labelFont = UIManager.getFont("Label.font");
        this.font = new Font(labelFont.getFamily(), 0, labelFont.getSize());
        this.boldFont = new Font(labelFont.getFamily(), 1, labelFont.getSize());
        UIManager.put("Button.font", this.font);
        UIManager.put("Label.font", this.font);
        this.configure(args);
        if (this.icon != null) {
            this.setIconImage(this.icon.getImage());
        }
        this.progressPanel = new ProgressPanel(this);
        this.getContentPane().add((Component)this.progressPanel, "Center");
        this.setup();
        this.setTitle(this.project.getName() != null && this.project.getName().length() > 0 ? String.valueOf(this.title) + " - " + this.project.getName() : this.title);
        if (this.project.getDescription() != null && this.project.getDescription().length() > 0) {
            JLabel label = new JLabel("<html>" + this.project.getDescription().trim() + "</html>");
            this.getContentPane().add((Component)label, "North");
            label.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        }
        JPanel buttons = new JPanel(new FlowLayout(2));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.roxes.tools.ant.antony.Antony");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.consoleButton = new JToggleButton(new ImageIcon(clazz2.getResource("console.gif")));
        buttons.add(this.consoleButton);
        this.consoleButton.setBorder(BorderFactory.createEmptyBorder());
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("com.roxes.tools.ant.antony.Antony");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.consoleButton.setSelectedIcon(new ImageIcon(clazz3.getResource("console-bw.gif")));
        this.consoleButton.setFont(this.font);
        this.consoleButton.addActionListener(this.consoleAction);
        buttons.add(new JSeparator());
        this.start = new JButton("Start");
        buttons.add(this.start);
        this.start.setEnabled(!this.autostart);
        this.start.setFont(this.font);
        this.start.addActionListener(this.startAction);
        this.quit = new JButton("Quit");
        buttons.add(this.quit);
        this.quit.setFont(this.font);
        this.quit.addActionListener(this.quitAction);
        this.getContentPane().add((Component)buttons, "South");
        Rectangle rect = this.getBounds();
        this.buildLogger.setLocation(rect.x, rect.y + rect.height);
        this.enableEvents(65L);
        this.setVisible(true);
    }

    protected void processComponentEvent(ComponentEvent e) {
        super.processComponentEvent(e);
        if (e.getID() == 100 || e.getID() == 101) {
            Rectangle rect = this.getBounds();
            this.buildLogger.setLocation(rect.x, rect.y + rect.height);
        }
    }

    void setup() {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        AntonyEchoTask.antony = this;
        this.project.setCoreLoader(this.getClass().getClassLoader());
        Throwable error = null;
        try {
            this.addBuildListeners(this.project);
            this.addInputHandler(this.project);
            PrintStream err = System.err;
            PrintStream out = System.out;
            InputStream in = System.in;
            SecurityManager oldsm = null;
            if (!JavaEnvUtils.isJavaVersion((String)VERSION) && !JavaEnvUtils.isJavaVersion((String)"1.1")) {
                oldsm = System.getSecurityManager();
            }
            try {
                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(this.project, false)));
                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(this.project, true)));
                if (!this.projectHelp) {
                    this.project.fireBuildStarted();
                }
                this.project.init();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("com.roxes.tools.ant.antony.AntonyEchoTask");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.project.addTaskDefinition("echo", (Class)clazz);
                this.project.setUserProperty("ant.version", Main.getAntVersion());
                Enumeration<Object> e = this.definedProps.keys();
                while (e.hasMoreElements()) {
                    String arg = (String)e.nextElement();
                    String value = (String)this.definedProps.get(arg);
                    this.project.setUserProperty(arg, value);
                }
                this.project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                ProjectHelper.configureProject((Project)this.project, (File)this.buildFile);
                if (this.projectHelp) {
                    Antony.printDescription(this.project);
                    Antony.printTargets(this.project, this.msgOutputLevel > 2);
                    this.quitAction.actionPerformed(null);
                }
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (oldsm != null) {
                    System.setSecurityManager(oldsm);
                }
                System.setOut(out);
                System.setErr(err);
                System.setIn(in);
                throw throwable;
            }
            Object var9_13 = null;
            if (oldsm != null) {
                System.setSecurityManager(oldsm);
            }
            System.setOut(out);
            System.setErr(err);
            System.setIn(in);
        }
        catch (RuntimeException exc) {
            error = exc;
            throw exc;
        }
        catch (Error err) {
            error = err;
            throw err;
        }
    }

    private static void printTargets(Project project, boolean printSubTargets) {
        String defaultTarget;
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        while (ptargets.hasMoreElements()) {
            int pos;
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            if (targetName.equals("")) continue;
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = Antony.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = Antony.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Antony.printTargets(project, topNames, topDescriptions, "Main targets:", maxLength);
        if (topNames.size() == 0) {
            printSubTargets = true;
        }
        if (printSubTargets) {
            Antony.printTargets(project, subNames, null, "Other targets:", 0);
        }
        if ((defaultTarget = project.getDefaultTarget()) != null && !"".equals(defaultTarget)) {
            project.log("Default target: " + defaultTarget);
        }
    }

    private static void printTargets(Project project, Vector names, Vector descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() <= maxlen) {
            spaces = String.valueOf(spaces) + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(String.valueOf(heading) + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
            ++i;
        }
        project.log(msg.toString());
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        int i = 0;
        while (i < names.size() && res == names.size()) {
            if (name.compareTo((String)names.elementAt(i)) < 0) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    private void addInputHandler(Project project) throws BuildException {
        AntonyInputHandler handler = null;
        if (this.inputHandlerClassname == null) {
            handler = new AntonyInputHandler(this);
        } else {
            try {
                handler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
            }
            catch (ClassCastException e) {
                String msg = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(msg);
            }
            catch (Exception e) {
                String msg = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + e.getClass().getName();
                throw new BuildException(msg);
            }
        }
        project.setInputHandler((InputHandler)handler);
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener((BuildListener)this.createLogger());
        project.addBuildListener((BuildListener)this.progressPanel);
        int i = 0;
        while (i < this.listeners.size()) {
            String className = (String)this.listeners.elementAt(i);
            try {
                BuildListener listener = (BuildListener)Class.forName(className).newInstance();
                project.addBuildListener(listener);
            }
            catch (Throwable exc) {
                throw new BuildException("Unable to instantiate listener " + className, exc);
            }
            ++i;
        }
    }

    private BuildLogger createLogger() {
        AntonyLogger logger = null;
        if (this.loggerClassname != null) {
            try {
                Class<?> loggerClass = Class.forName(this.loggerClassname);
                logger = (BuildLogger)loggerClass.newInstance();
            }
            catch (ClassCastException e) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception e) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + e.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            logger = this.buildLogger = new AntonyLogger(this);
        }
        logger.setMessageOutputLevel(this.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.emacsMode);
        return logger;
    }

    void configure(String[] args) {
        int i = 0;
        while (i < args.length) {
            String msg;
            String arg = args[i];
            if (arg.equals("-help")) {
                Antony.printUsage();
                this.quitAction.actionPerformed(null);
            }
            if (arg.equals("-version")) {
                this.printVersion();
                this.quitAction.actionPerformed(null);
            }
            if (arg.equals("-quiet") || arg.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (arg.equals("-verbose") || arg.equals("-v")) {
                this.printVersion();
                this.msgOutputLevel = 3;
            } else if (arg.equals("-debug")) {
                this.printVersion();
                this.msgOutputLevel = 4;
            } else if (arg.equals("-logfile") || arg.equals("-l")) {
                try {
                    File logFile = new File(args[i + 1]);
                    ++i;
                    err = out = new PrintStream(new FileOutputStream(logFile));
                    System.setOut(out);
                    System.setErr(out);
                    this.isLogFileUsed = true;
                }
                catch (IOException ioe) {
                    msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a log file when using the -log argument";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f")) {
                try {
                    this.buildFile = new File(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a buildfile when using the -buildfile argument";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.equals("-icon")) {
                try {
                    this.icon = new ImageIcon(ClassLoader.getSystemResource(args[i + 1]));
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a icon when using the -icon argument";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
                catch (NullPointerException npe) {
                    msg = "The specified icon was not found or invalid.";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.equals("-title")) {
                try {
                    this.title = args[i + 1];
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a title when using the -title argument";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.equals("-autostart")) {
                this.autostart = true;
            } else if (arg.equals("-autoexit")) {
                this.autoexit = true;
            } else if (arg.equals("-console")) {
                this.console = true;
            } else if (arg.equals("-listener")) {
                try {
                    this.listeners.addElement(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a classname when using the -listener argument";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length - 1) {
                    value = args[++i];
                }
                this.definedProps.put(name, value);
            } else if (arg.equals("-logger")) {
                if (this.loggerClassname != null) {
                    System.out.println("Only one logger class may  be specified.");
                    JOptionPane.showMessageDialog(this, "Only one logger class may  be specified.", this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
                try {
                    this.loggerClassname = args[++i];
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    System.out.println("You must specify a classname when using the -logger argument");
                    JOptionPane.showMessageDialog(this, "You must specify a classname when using the -logger argument", this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.equals("-inputhandler")) {
                if (this.inputHandlerClassname != null) {
                    System.out.println("Only one input handler class may be specified.");
                    JOptionPane.showMessageDialog(this, "Only one input handler class may be specified.", this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
                try {
                    this.inputHandlerClassname = args[++i];
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    System.out.println("You must specify a classname when using the -inputhandler argument");
                    JOptionPane.showMessageDialog(this, "You must specify a classname when using the -inputhandler argument", this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else if (arg.equals("-emacs")) {
                this.emacsMode = true;
            } else if (arg.equals("-projecthelp")) {
                this.projectHelp = true;
            } else if (arg.equals("-find")) {
                this.searchForThis = i < args.length - 1 ? args[++i] : "build.xml";
            } else if (arg.startsWith("-propertyfile")) {
                try {
                    this.propertyFiles.addElement(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a property filename when using the -propertyfile argument";
                    System.out.println(msg);
                    JOptionPane.showMessageDialog(this, msg, this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            } else {
                if (arg.startsWith("-")) {
                    String msg2 = "Unknown argument: " + arg;
                    System.out.println(msg2);
                    JOptionPane.showMessageDialog(this, msg2, this.title, 0);
                    Antony.printUsage();
                    this.quitAction.actionPerformed(null);
                }
                this.targets.addElement(arg);
            }
            ++i;
        }
        if (this.buildFile == null) {
            this.buildFile = this.searchForThis != null ? this.findBuildFile(System.getProperty("user.dir"), this.searchForThis) : new File("build.xml");
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            JOptionPane.showMessageDialog(this, "Buildfile: " + this.buildFile + " does not exist!", this.title, 0);
            this.quitAction.actionPerformed(null);
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            JOptionPane.showMessageDialog(this, "What? Buildfile: " + this.buildFile + " is a dir!", this.title, 0);
            this.quitAction.actionPerformed(null);
        }
        int propertyFileIndex = 0;
        while (propertyFileIndex < this.propertyFiles.size()) {
            IOException e3;
            Object var7_19;
            String filename = (String)this.propertyFiles.elementAt(propertyFileIndex);
            Properties props = new Properties();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(filename);
                    props.load(fis);
                }
                catch (IOException e2) {
                    System.out.println("Could not load property file " + filename + ": " + e2.getMessage());
                    JOptionPane.showMessageDialog(this, "Could not load property file " + filename + ": " + e2.getMessage(), this.title, 0);
                    this.quitAction.actionPerformed(null);
                }
            }
            catch (Throwable throwable) {
                var7_19 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            var7_19 = null;
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e3) {
                    // empty catch block
                }
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String name = (String)propertyNames.nextElement();
                if (this.definedProps.getProperty(name) != null) continue;
                this.definedProps.put(name, props.getProperty(name));
            }
            ++propertyFileIndex;
        }
    }

    private File findBuildFile(String start, String suffix) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + suffix + " ...");
        }
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    private File getParentFile(File file) {
        String filename = file.getAbsolutePath();
        file = new File(filename);
        if ((filename = file.getParent()) != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + filename);
        }
        return filename != null ? new File(filename) : null;
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append(TITLE).append(' ').append(VERSION).append(" [options] [target [target2 [target3] ...]]" + lSep);
        msg.append("Ant Options: " + lSep);
        msg.append("  -help, -h              print this message" + lSep);
        msg.append("  -projecthelp, -p       print project help information" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -quiet, -q             be extra quiet" + lSep);
        msg.append("  -verbose, -v           be extra verbose" + lSep);
        msg.append("  -debug, -d             print debugging information" + lSep);
        msg.append("  -emacs, -e             produce logging information without adornments" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("    -l     <file>                ''" + lSep);
        msg.append("  -logger <classname>    the class which is to perform logging" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("    -file    <file>              ''" + lSep);
        msg.append("    -f       <file>              ''" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        msg.append("  -propertyfile <name>   load all properties from file with -D" + lSep);
        msg.append("                         properties taking precedence" + lSep);
        msg.append("  -inputhandler <class>  the class which will handle input requests" + lSep);
        msg.append("  -find <file>           (s)earch for buildfile towards the root of" + lSep);
        msg.append("    -s  <file>           the filesystem and use it" + lSep);
        msg.append(lSep).append("Antony Options").append(lSep);
        msg.append("    -autostart           starts the build process immediately" + lSep);
        msg.append("    -autoexit            exits immediately after build process finished" + lSep);
        msg.append("    -title <title>       title in the title bar" + lSep);
        msg.append("                         (default is ROXES Antony 1.0" + lSep);
        msg.append("    -icon <icon>         path to classpath icon resource" + lSep);
        msg.append("                         (default is com/roxes/tools/ant/antony/roxes.gif)" + lSep);
        msg.append("    -console    \t\t enable console window" + lSep);
        System.out.println(msg.toString());
        JOptionPane.showMessageDialog(null, msg.toString(), "ROXES Antony 1.0", 1);
    }

    void printVersion() {
        System.out.println("ROXES Antony 1.0 (" + Main.getAntVersion() + ")");
        JOptionPane.showMessageDialog(this, "ROXES Antony 1.0 (" + Main.getAntVersion() + ")", "ROXES Antony 1.0", 1);
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
            JOptionPane.showMessageDialog(null, project.getDescription(), "ROXES Antony 1.0", 1);
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.quitAction.actionPerformed(null);
        } else if (e.getID() == 200) {
            if (this.console) {
                this.consoleButton.setSelected(true);
                this.consoleAction.actionPerformed(null);
            }
            if (this.autostart) {
                this.startAction.actionPerformed(null);
            }
        } else {
            super.processWindowEvent(e);
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Antony antony = null;
        try {
            antony = new Antony(args);
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            JOptionPane.showMessageDialog(antony, "Starting ROXES Antony failed:\n\n." + sw.toString(), "ROXES Antony 1.0", 0);
        }
    }

    static /* synthetic */ Vector access$0(Antony antony) {
        return antony.targets;
    }
}

