/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.antony;

import com.roxes.tools.ant.antony.Antony;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Task;

class ProgressPanel
extends JPanel
implements BuildListener {
    Antony app;
    GridBagConstraints gbc = new GridBagConstraints();
    int index = 1;
    static final ImageIcon arrowRight = new ImageIcon("arrow-right.gif");
    JLabel currentTargetLabel;
    JLabel currentTaskLabel;
    boolean finished = false;
    Task currentTask;

    public ProgressPanel(Antony app) {
        super(new GridBagLayout());
        this.app = app;
        this.gbc.fill = 1;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 1.0;
        this.add((Component)new JLabel(), this.gbc);
        this.gbc.insets = new Insets(3, 5, 3, 5);
        this.gbc.weighty = 0.0;
        this.gbc.fill = 2;
        this.currentTaskLabel = new JLabel("Press Start.");
        this.add(this.currentTaskLabel, this.gbc, 1);
        this.currentTaskLabel.setForeground(Color.blue.darker());
        this.currentTaskLabel.setFont(app.font);
        this.currentTaskLabel.setBorder(BorderFactory.createEmptyBorder(7, 0, 7, 0));
    }

    public void buildFinished(BuildEvent arg0) {
        JLabel label = new JLabel("Finished");
        this.add(label, this.gbc, this.index++);
        label.setFont(this.app.boldFont);
        this.getComponent(0).setFont(this.app.font);
        this.invalidate();
        this.validate();
        this.repaint();
        this.app.quit.setText("Exit");
        this.app.quit.setFont(this.app.boldFont);
        this.finished = true;
        System.out.println("finished");
    }

    public void buildStarted(BuildEvent arg0) {
        if (arg0 == null) {
            JLabel label = new JLabel("Building");
            this.add(label, this.gbc, 0);
            label.setFont(this.app.boldFont);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void messageLogged(BuildEvent arg0) {
        if (this.app.started && (arg0.getPriority() != 0 || arg0.getPriority() != 1)) {
            this.currentTaskLabel.setText(arg0.getMessage());
        } else {
            this.currentTaskLabel.setText(" ");
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void targetFinished(BuildEvent arg0) {
        this.currentTargetLabel.setFont(this.app.font);
    }

    public void targetStarted(BuildEvent arg0) {
        if (this.currentTargetLabel != null) {
            this.currentTargetLabel.setFont(this.app.font);
        }
        this.currentTargetLabel = new JLabel(String.valueOf(arg0.getTarget().getName()) + (arg0.getTarget().getDescription() != null ? " (" + arg0.getTarget().getDescription() + ")" : ""), arrowRight, 2);
        this.add(this.currentTargetLabel, this.gbc, this.index++);
        this.currentTargetLabel.setFont(this.app.boldFont);
        this.currentTargetLabel.setToolTipText(arg0.getTarget().getDescription());
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void taskFinished(BuildEvent arg0) {
        this.currentTaskLabel.setText(" ");
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void taskStarted(BuildEvent arg0) {
        this.currentTask = arg0.getTask();
    }
}

