/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.pe;

import com.roxes.tools.ant.pe.PEHeader;
import com.roxes.tools.ant.pe.PEOldMSHeader;
import com.roxes.tools.ant.pe.PEResourceDirectory;
import com.roxes.tools.ant.pe.PESection;
import com.roxes.tools.ant.pe.res.ResIcon;
import com.roxes.tools.ant.pe.res.ResIconDir;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Vector;
import javax.swing.JLabel;

public class PEFile {
    private File m_file;
    private FileInputStream m_in = null;
    private FileChannel m_channel = null;
    private PEOldMSHeader m_oldmsheader;
    private PEHeader m_header;
    private Vector m_sections = new Vector();
    private PEResourceDirectory m_resourceDir;

    public PEFile(File f) {
        this.m_file = f;
    }

    public void close() throws IOException {
        this.m_in.close();
    }

    public void open() throws FileNotFoundException, IOException {
        this.m_in = new FileInputStream(this.m_file);
        this.m_channel = this.m_in.getChannel();
        this.m_oldmsheader = new PEOldMSHeader(this);
        this.m_oldmsheader.read();
        long headoffset = this.m_oldmsheader.e_lfanew;
        this.m_header = new PEHeader(this, headoffset);
        this.m_header.read();
        int seccount = this.m_header.NumberOfSections;
        long offset = headoffset + this.m_header.NumberOfRvaAndSizes * 8L + 24L + 96L;
        int i = 0;
        while (i < seccount) {
            PESection sect = new PESection(this, offset);
            sect.read();
            this.m_sections.add(sect);
            offset += 40L;
            ++i;
        }
        ByteBuffer resbuf = null;
        long resourceoffset = this.m_header.ResourceDirectory_VA;
        int i2 = 0;
        while (i2 < seccount) {
            PESection sect = (PESection)this.m_sections.get(i2);
            if (sect.VirtualAddress == resourceoffset) {
                PEResourceDirectory prd = new PEResourceDirectory(this, sect);
                resbuf = prd.buildResource(sect.VirtualAddress);
                break;
            }
            ++i2;
        }
    }

    public FileChannel getChannel() {
        return this.m_channel;
    }

    public static void main(String[] args) throws IOException, CloneNotSupportedException, Exception {
        PEFile pe = new PEFile(new File("F:/Documents and Settings/Rodrigo/Mes documents/projects/jsmooth/skeletons/simplewrap/JWrap.exe"));
        pe.open();
        File fout = new File("F:/Documents and Settings/Rodrigo/Mes documents/projects/jsmooth/skeletons/simplewrap/gen-application.jar");
        FileInputStream fis = new FileInputStream(fout);
        ByteBuffer data = ByteBuffer.allocate((int)fout.length());
        data.order(ByteOrder.LITTLE_ENDIAN);
        FileChannel fischan = fis.getChannel();
        fischan.read(data);
        data.position(0);
        fis.close();
        PEResourceDirectory resdir = pe.getResourceDirectory();
        Image img = Toolkit.getDefaultToolkit().getImage("c:\\gnome-color-browser2.png");
        MediaTracker mt = new MediaTracker(new JLabel("toto"));
        mt.addImage(img, 1);
        try {
            mt.waitForAll();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        ResIcon newicon = new ResIcon(img);
        pe.replaceDefaultIcon(newicon);
        File out = new File("F:/Documents and Settings/Rodrigo/Mes documents/projects/jsmooth/skeletons/simplewrap/COPIE.exe");
        pe.dumpTo(out);
    }

    public PEResourceDirectory getResourceDirectory() throws IOException {
        if (this.m_resourceDir != null) {
            return this.m_resourceDir;
        }
        long resourceoffset = this.m_header.ResourceDirectory_VA;
        int i = 0;
        while (i < this.m_sections.size()) {
            PESection sect = (PESection)this.m_sections.get(i);
            if (sect.VirtualAddress == resourceoffset) {
                this.m_resourceDir = new PEResourceDirectory(this, sect);
                return this.m_resourceDir;
            }
            ++i;
        }
        return null;
    }

    public void dumpTo(File destination) throws IOException, CloneNotSupportedException {
        PESection sect;
        int outputcount = 0;
        FileOutputStream fos = new FileOutputStream(destination);
        FileChannel out = fos.getChannel();
        PEOldMSHeader oldmsheader = (PEOldMSHeader)this.m_oldmsheader.clone();
        PEHeader peheader = (PEHeader)this.m_header.clone();
        Vector<PESection> sections = new Vector<PESection>();
        int i = 0;
        while (i < this.m_sections.size()) {
            PESection sect2 = (PESection)this.m_sections.get(i);
            PESection cs = (PESection)sect2.clone();
            sections.add(cs);
            ++i;
        }
        long newexeoffset = oldmsheader.e_lfanew;
        ByteBuffer msheadbuffer = oldmsheader.get();
        outputcount = out.write(msheadbuffer);
        this.m_channel.position(64L);
        out.transferFrom(this.m_channel, 64L, newexeoffset - 64L);
        ByteBuffer headbuffer = peheader.get();
        out.position(newexeoffset);
        outputcount = out.write(headbuffer);
        long offset = oldmsheader.e_lfanew + this.m_header.NumberOfRvaAndSizes * 8L + 24L + 96L;
        out.position(offset);
        int i2 = 0;
        while (i2 < sections.size()) {
            PESection sect3 = (PESection)sections.get(i2);
            ByteBuffer buf = sect3.get();
            outputcount = out.write(buf);
            ++i2;
        }
        offset = 1024L;
        long virtualAddress = offset;
        if (virtualAddress % peheader.SectionAlignment > 0L) {
            virtualAddress += peheader.SectionAlignment - virtualAddress % peheader.SectionAlignment;
        }
        long resourceoffset = this.m_header.ResourceDirectory_VA;
        int i3 = 0;
        while (i3 < sections.size()) {
            long sectoffset;
            sect = (PESection)sections.get(i3);
            if (resourceoffset == sect.VirtualAddress) {
                long virtualSize;
                out.position(offset);
                sectoffset = offset;
                PEResourceDirectory prd = this.getResourceDirectory();
                ByteBuffer resbuf = prd.buildResource(sect.VirtualAddress);
                resbuf.position(0);
                out.write(resbuf);
                long rem = (offset += (long)resbuf.capacity()) % this.m_header.FileAlignment;
                if (rem != 0L) {
                    offset += this.m_header.FileAlignment - rem;
                }
                if (out.size() + 1L < offset) {
                    ByteBuffer padder = ByteBuffer.allocate(1);
                    out.write(padder, offset - 1L);
                }
                if ((virtualSize = (long)resbuf.capacity()) % peheader.FileAlignment > 0L) {
                    virtualSize += peheader.SectionAlignment - virtualSize % peheader.SectionAlignment;
                }
                sect.PointerToRawData = sectoffset;
                sect.SizeOfRawData = resbuf.capacity();
                if (sect.SizeOfRawData % this.m_header.FileAlignment > 0L) {
                    sect.SizeOfRawData += this.m_header.FileAlignment - sect.SizeOfRawData % this.m_header.FileAlignment;
                }
                sect.VirtualAddress = virtualAddress;
                sect.VirtualSize = virtualSize;
                virtualAddress += virtualSize;
            } else if (sect.PointerToRawData > 0L) {
                out.position(offset);
                this.m_channel.position(sect.PointerToRawData);
                sectoffset = offset;
                out.position(offset + sect.SizeOfRawData);
                ByteBuffer padder = ByteBuffer.allocate(1);
                out.write(padder, offset + sect.SizeOfRawData - 1L);
                long outted = out.transferFrom(this.m_channel, offset, sect.SizeOfRawData);
                long rem = (offset += sect.SizeOfRawData) % this.m_header.FileAlignment;
                if (rem != 0L) {
                    offset += this.m_header.FileAlignment - rem;
                }
                sect.PointerToRawData = sectoffset;
                sect.VirtualAddress = virtualAddress;
                if ((virtualAddress += sect.VirtualSize) % peheader.SectionAlignment > 0L) {
                    virtualAddress += peheader.SectionAlignment - virtualAddress % peheader.SectionAlignment;
                }
            } else {
                long virtualSize = sect.VirtualSize;
                if (virtualSize % peheader.SectionAlignment > 0L) {
                    virtualSize += peheader.SectionAlignment - virtualSize % peheader.SectionAlignment;
                }
                sect.VirtualAddress = virtualAddress;
                virtualAddress += virtualSize;
            }
            ++i3;
        }
        peheader.updateVAAndSize(this.m_sections, sections);
        headbuffer = peheader.get();
        out.position(newexeoffset);
        outputcount = out.write(headbuffer);
        offset = oldmsheader.e_lfanew + this.m_header.NumberOfRvaAndSizes * 8L + 24L + 96L;
        out.position(offset);
        i3 = 0;
        while (i3 < sections.size()) {
            sect = (PESection)sections.get(i3);
            ByteBuffer buf = sect.get();
            outputcount = out.write(buf);
            ++i3;
        }
        fos.flush();
        fos.close();
    }

    public void replaceDefaultIcon(ResIcon icon) throws Exception {
        PEResourceDirectory resdir = this.getResourceDirectory();
        PEResourceDirectory.DataEntry entry = resdir.getData("#14", null, null);
        if (entry == null) {
            throw new Exception("Can't find any icon group in the file!");
        }
        entry.Data.position(0);
        entry.Data.position(0);
        ResIconDir rid = new ResIconDir(entry.Data);
        int iconid = rid.getEntries()[0].dwImageOffset;
        PEResourceDirectory.DataEntry iconentry = resdir.getData("#3", "#" + iconid, null);
        iconentry.Data.position(0);
        rid.getEntries()[0].bWidth = (short)icon.Width;
        rid.getEntries()[0].bHeight = (short)(icon.Height / 2L);
        rid.getEntries()[0].bColorCount = (short)(1 << icon.BitsPerPixel);
        rid.getEntries()[0].wBitCount = icon.BitsPerPixel;
        rid.getEntries()[0].dwBytesInRes = icon.getData().remaining();
        iconentry.Data = icon.getData();
        iconentry.Size = iconentry.Data.remaining();
        entry.setData(rid.getData());
    }
}

