/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.pe;

import com.roxes.tools.ant.pe.PEFile;
import com.roxes.tools.ant.pe.PESection;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Vector;

public class PEHeader
implements Cloneable {
    public int Machine;
    public int NumberOfSections;
    public long TimeDateStamp;
    public long PointerToSymbolTable;
    public long NumberOfSymbols;
    public int SizeOfOptionalHeader;
    public int Characteristics;
    public int Magic;
    public short MajorLinkerVersion;
    public short MinorLinkerVersion;
    public long SizeOfCode;
    public long SizeOfInitializedData;
    public long SizeOfUninitializedData;
    public long AddressOfEntryPoint;
    public long BaseOfCode;
    public long BaseOfData;
    public long ImageBase;
    public long SectionAlignment;
    public long FileAlignment;
    public int MajorOperatingSystemVersion;
    public int MinorOperatingSystemVersion;
    public int MajorImageVersion;
    public int MinorImageVersion;
    public int MajorSubsystemVersion;
    public int MinorSubsystemVersion;
    public long Reserved1;
    public long SizeOfImage;
    public long SizeOfHeaders;
    public long CheckSum;
    public int Subsystem;
    public int DllCharacteristics;
    public long SizeOfStackReserve;
    public long SizeOfStackCommit;
    public long SizeOfHeapReserve;
    public long SizeOfHeapCommit;
    public long LoaderFlags;
    public long NumberOfRvaAndSizes;
    public long ExportDirectory_VA;
    public long ExportDirectory_Size;
    public long ImportDirectory_VA;
    public long ImportDirectory_Size;
    public long ResourceDirectory_VA;
    public long ResourceDirectory_Size;
    public long ExceptionDirectory_VA;
    public long ExceptionDirectory_Size;
    public long SecurityDirectory_VA;
    public long SecurityDirectory_Size;
    public long BaseRelocationTable_VA;
    public long BaseRelocationTable_Size;
    public long DebugDirectory_VA;
    public long DebugDirectory_Size;
    public long ArchitectureSpecificData_VA;
    public long ArchitectureSpecificData_Size;
    public long RVAofGP_VA;
    public long RVAofGP_Size;
    public long TLSDirectory_VA;
    public long TLSDirectory_Size;
    public long LoadConfigurationDirectory_VA;
    public long LoadConfigurationDirectory_Size;
    public long BoundImportDirectoryinheaders_VA;
    public long BoundImportDirectoryinheaders_Size;
    public long ImportAddressTable_VA;
    public long ImportAddressTable_Size;
    public long DelayLoadImportDescriptors_VA;
    public long DelayLoadImportDescriptors_Size;
    public long COMRuntimedescriptor_VA;
    public long COMRuntimedescriptor_Size;
    private long m_baseoffset;
    private PEFile m_pe;

    public PEHeader(PEFile pef, long baseoffset) {
        this.m_pe = pef;
        this.m_baseoffset = baseoffset;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void read() throws IOException {
        FileChannel ch = this.m_pe.getChannel();
        ByteBuffer head = ByteBuffer.allocate(255);
        head.order(ByteOrder.LITTLE_ENDIAN);
        ch.position(this.m_baseoffset);
        ch.read(head);
        head.position(0);
        int pemagic = head.getInt();
        this.Machine = head.getShort();
        this.NumberOfSections = head.getShort();
        this.TimeDateStamp = head.getInt();
        this.PointerToSymbolTable = head.getInt();
        this.NumberOfSymbols = head.getInt();
        this.SizeOfOptionalHeader = head.getShort();
        this.Characteristics = head.getShort();
        this.Magic = head.getShort();
        this.MajorLinkerVersion = head.get();
        this.MinorLinkerVersion = head.get();
        this.SizeOfCode = head.getInt();
        this.SizeOfInitializedData = head.getInt();
        this.SizeOfUninitializedData = head.getInt();
        this.AddressOfEntryPoint = head.getInt();
        this.BaseOfCode = head.getInt();
        this.BaseOfData = head.getInt();
        this.ImageBase = head.getInt();
        this.SectionAlignment = head.getInt();
        this.FileAlignment = head.getInt();
        this.MajorOperatingSystemVersion = head.getShort();
        this.MinorOperatingSystemVersion = head.getShort();
        this.MajorImageVersion = head.getShort();
        this.MinorImageVersion = head.getShort();
        this.MajorSubsystemVersion = head.getShort();
        this.MinorSubsystemVersion = head.getShort();
        this.Reserved1 = head.getInt();
        this.SizeOfImage = head.getInt();
        this.SizeOfHeaders = head.getInt();
        this.CheckSum = head.getInt();
        this.Subsystem = head.getShort();
        this.DllCharacteristics = head.getShort();
        this.SizeOfStackReserve = head.getInt();
        this.SizeOfStackCommit = head.getInt();
        this.SizeOfHeapReserve = head.getInt();
        this.SizeOfHeapCommit = head.getInt();
        this.LoaderFlags = head.getInt();
        this.NumberOfRvaAndSizes = head.getInt();
        this.ExportDirectory_VA = head.getInt();
        this.ExportDirectory_Size = head.getInt();
        this.ImportDirectory_VA = head.getInt();
        this.ImportDirectory_Size = head.getInt();
        this.ResourceDirectory_VA = head.getInt();
        this.ResourceDirectory_Size = head.getInt();
        this.ExceptionDirectory_VA = head.getInt();
        this.ExceptionDirectory_Size = head.getInt();
        this.SecurityDirectory_VA = head.getInt();
        this.SecurityDirectory_Size = head.getInt();
        this.BaseRelocationTable_VA = head.getInt();
        this.BaseRelocationTable_Size = head.getInt();
        this.DebugDirectory_VA = head.getInt();
        this.DebugDirectory_Size = head.getInt();
        this.ArchitectureSpecificData_VA = head.getInt();
        this.ArchitectureSpecificData_Size = head.getInt();
        this.RVAofGP_VA = head.getInt();
        this.RVAofGP_Size = head.getInt();
        this.TLSDirectory_VA = head.getInt();
        this.TLSDirectory_Size = head.getInt();
        this.LoadConfigurationDirectory_VA = head.getInt();
        this.LoadConfigurationDirectory_Size = head.getInt();
        this.BoundImportDirectoryinheaders_VA = head.getInt();
        this.BoundImportDirectoryinheaders_Size = head.getInt();
        this.ImportAddressTable_VA = head.getInt();
        this.ImportAddressTable_Size = head.getInt();
        this.DelayLoadImportDescriptors_VA = head.getInt();
        this.DelayLoadImportDescriptors_Size = head.getInt();
        this.COMRuntimedescriptor_VA = head.getInt();
        this.COMRuntimedescriptor_Size = head.getInt();
    }

    public void dump(PrintStream out) {
        out.println("HEADER:");
        out.println("int  Machine=" + this.Machine + " //  4");
        out.println("int  NumberOfSections=" + this.NumberOfSections + "     //  6");
        out.println("long   TimeDateStamp=" + this.TimeDateStamp + " //  8");
        out.println("long   PointerToSymbolTable=" + this.PointerToSymbolTable + "     //  C");
        out.println("long   NumberOfSymbols=" + this.NumberOfSymbols + " // 10");
        out.println("int  SizeOfOptionalHeader=" + this.SizeOfOptionalHeader + "     // 14");
        out.println("int  Characteristics=" + this.Characteristics + " // 16");
        out.println("int    Magic=" + this.Magic + "     // 18");
        out.println("short   MajorLinkerVersion=" + this.MajorLinkerVersion + "     // 1a");
        out.println("short   MinorLinkerVersion=" + this.MinorLinkerVersion + " // 1b");
        out.println("long   SizeOfCode=" + this.SizeOfCode + "     // 1c");
        out.println("long   SizeOfInitializedData=" + this.SizeOfInitializedData + " // 20");
        out.println("long   SizeOfUninitializedData=" + this.SizeOfUninitializedData + "     // 24");
        out.println("long   AddressOfEntryPoint=" + this.AddressOfEntryPoint + " // 28");
        out.println("long   BaseOfCode=" + this.BaseOfCode + "     // 2c");
        out.println("long   BaseOfData=" + this.BaseOfData + "    //    // NT additional fields. // 30");
        out.println("long   ImageBase=" + this.ImageBase + "     // 34");
        out.println("long   SectionAlignment=" + this.SectionAlignment + " // 38");
        out.println("long   FileAlignment=" + this.FileAlignment + "     // 3c");
        out.println("int    MajorOperatingSystemVersion=" + this.MajorOperatingSystemVersion + " // 40");
        out.println("int    MinorOperatingSystemVersion=" + this.MinorOperatingSystemVersion + "     // 42");
        out.println("int    MajorImageVersion=" + this.MajorImageVersion + " // 44");
        out.println("int    MinorImageVersion=" + this.MinorImageVersion + "     // 46");
        out.println("int    MajorSubsystemVersion=" + this.MajorSubsystemVersion + " // 48");
        out.println("int    MinorSubsystemVersion=" + this.MinorSubsystemVersion + "     // 4a");
        out.println("long   Reserved1=" + this.Reserved1 + "     // 4c");
        out.println("long   SizeOfImage=" + this.SizeOfImage + " // 50");
        out.println("long   SizeOfHeaders=" + this.SizeOfHeaders + "     // 54");
        out.println("long   CheckSum=" + this.CheckSum + "     // 58");
        out.println("int    Subsystem=" + this.Subsystem + " // 5c");
        out.println("int    DllCharacteristics=" + this.DllCharacteristics + "     // 5e");
        out.println("long   SizeOfStackReserve=" + this.SizeOfStackReserve + " // 60");
        out.println("long   SizeOfStackCommit=" + this.SizeOfStackCommit + "     // 64");
        out.println("long   SizeOfHeapReserve=" + this.SizeOfHeapReserve + " // 68");
        out.println("long   SizeOfHeapCommit=" + this.SizeOfHeapCommit + "     // 6c");
        out.println("long   LoaderFlags=" + this.LoaderFlags + " // 70");
        out.println("long   NumberOfRvaAndSizes=" + this.NumberOfRvaAndSizes + " // 74");
        out.println("long ExportDirectory_VA=" + this.ExportDirectory_VA + " // 78");
        out.println("long ExportDirectory_Size=" + this.ExportDirectory_Size + " // 7c");
        out.println("long ImportDirectory_VA=" + this.ImportDirectory_VA + " // 80");
        out.println("long ImportDirectory_Size=" + this.ImportDirectory_Size + " // 84");
        out.println("long ResourceDirectory_VA=" + this.ResourceDirectory_VA + " // 88");
        out.println("long ResourceDirectory_Size=" + this.ResourceDirectory_Size + " // 8c");
        out.println("long ExceptionDirectory_VA=" + this.ExceptionDirectory_VA + " // 90");
        out.println("long ExceptionDirectory_Size=" + this.ExceptionDirectory_Size + " // 94");
        out.println("long SecurityDirectory_VA=" + this.SecurityDirectory_VA + " // 98");
        out.println("long SecurityDirectory_Size=" + this.SecurityDirectory_Size + " // 9c");
        out.println("long BaseRelocationTable_VA=" + this.BaseRelocationTable_VA + " // a0");
        out.println("long BaseRelocationTable_Size=" + this.BaseRelocationTable_Size + " // a4");
        out.println("long DebugDirectory_VA=" + this.DebugDirectory_VA + " // a8");
        out.println("long DebugDirectory_Size=" + this.DebugDirectory_Size + " // ac");
        out.println("long ArchitectureSpecificData_VA=" + this.ArchitectureSpecificData_VA + " // b0");
        out.println("long ArchitectureSpecificData_Size=" + this.ArchitectureSpecificData_Size + " // b4");
        out.println("long RVAofGP_VA=" + this.RVAofGP_VA + " // b8");
        out.println("long RVAofGP_Size=" + this.RVAofGP_Size + " // bc");
        out.println("long TLSDirectory_VA=" + this.TLSDirectory_VA + " // c0");
        out.println("long TLSDirectory_Size=" + this.TLSDirectory_Size + " // c4");
        out.println("long LoadConfigurationDirectory_VA=" + this.LoadConfigurationDirectory_VA + " // c8");
        out.println("long LoadConfigurationDirectory_Size=" + this.LoadConfigurationDirectory_Size + " // cc");
        out.println("long BoundImportDirectoryinheaders_VA=" + this.BoundImportDirectoryinheaders_VA + " // d0");
        out.println("long BoundImportDirectoryinheaders_Size=" + this.BoundImportDirectoryinheaders_Size + " // d4");
        out.println("long ImportAddressTable_VA=" + this.ImportAddressTable_VA + " // d8");
        out.println("long ImportAddressTable_Size=" + this.ImportAddressTable_Size + " // dc");
        out.println("long DelayLoadImportDescriptors_VA=" + this.DelayLoadImportDescriptors_VA + " // e0");
        out.println("long DelayLoadImportDescriptors_Size=" + this.DelayLoadImportDescriptors_Size + " // e4");
        out.println("long COMRuntimedescriptor_VA=" + this.COMRuntimedescriptor_VA + " // e8");
        out.println("long COMRuntimedescriptor_Size=" + this.COMRuntimedescriptor_Size + " // ec");
    }

    public ByteBuffer get() {
        ByteBuffer head = ByteBuffer.allocate(16 + this.SizeOfOptionalHeader);
        head.order(ByteOrder.LITTLE_ENDIAN);
        head.position(0);
        head.putInt(17744);
        head.putShort((short)this.Machine);
        head.putShort((short)this.NumberOfSections);
        head.putInt((int)this.TimeDateStamp);
        head.putInt((int)this.PointerToSymbolTable);
        head.putInt((int)this.NumberOfSymbols);
        head.putShort((short)this.SizeOfOptionalHeader);
        head.putShort((short)this.Characteristics);
        head.putShort((short)this.Magic);
        head.put((byte)this.MajorLinkerVersion);
        head.put((byte)this.MinorLinkerVersion);
        head.putInt((int)this.SizeOfCode);
        head.putInt((int)this.SizeOfInitializedData);
        head.putInt((int)this.SizeOfUninitializedData);
        head.putInt((int)this.AddressOfEntryPoint);
        head.putInt((int)this.BaseOfCode);
        head.putInt((int)this.BaseOfData);
        head.putInt((int)this.ImageBase);
        head.putInt((int)this.SectionAlignment);
        head.putInt((int)this.FileAlignment);
        head.putShort((short)this.MajorOperatingSystemVersion);
        head.putShort((short)this.MinorOperatingSystemVersion);
        head.putShort((short)this.MajorImageVersion);
        head.putShort((short)this.MinorImageVersion);
        head.putShort((short)this.MajorSubsystemVersion);
        head.putShort((short)this.MinorSubsystemVersion);
        head.putInt((int)this.Reserved1);
        head.putInt((int)this.SizeOfImage);
        head.putInt((int)this.SizeOfHeaders);
        head.putInt((int)this.CheckSum);
        head.putShort((short)this.Subsystem);
        head.putShort((short)this.DllCharacteristics);
        head.putInt((int)this.SizeOfStackReserve);
        head.putInt((int)this.SizeOfStackCommit);
        head.putInt((int)this.SizeOfHeapReserve);
        head.putInt((int)this.SizeOfHeapCommit);
        head.putInt((int)this.LoaderFlags);
        head.putInt((int)this.NumberOfRvaAndSizes);
        head.putInt((int)this.ExportDirectory_VA);
        head.putInt((int)this.ExportDirectory_Size);
        head.putInt((int)this.ImportDirectory_VA);
        head.putInt((int)this.ImportDirectory_Size);
        head.putInt((int)this.ResourceDirectory_VA);
        head.putInt((int)this.ResourceDirectory_Size);
        head.putInt((int)this.ExceptionDirectory_VA);
        head.putInt((int)this.ExceptionDirectory_Size);
        head.putInt((int)this.SecurityDirectory_VA);
        head.putInt((int)this.SecurityDirectory_Size);
        head.putInt((int)this.BaseRelocationTable_VA);
        head.putInt((int)this.BaseRelocationTable_Size);
        head.putInt((int)this.DebugDirectory_VA);
        head.putInt((int)this.DebugDirectory_Size);
        head.putInt((int)this.ArchitectureSpecificData_VA);
        head.putInt((int)this.ArchitectureSpecificData_Size);
        head.putInt((int)this.RVAofGP_VA);
        head.putInt((int)this.RVAofGP_Size);
        head.putInt((int)this.TLSDirectory_VA);
        head.putInt((int)this.TLSDirectory_Size);
        head.putInt((int)this.LoadConfigurationDirectory_VA);
        head.putInt((int)this.LoadConfigurationDirectory_Size);
        head.putInt((int)this.BoundImportDirectoryinheaders_VA);
        head.putInt((int)this.BoundImportDirectoryinheaders_Size);
        head.putInt((int)this.ImportAddressTable_VA);
        head.putInt((int)this.ImportAddressTable_Size);
        head.putInt((int)this.DelayLoadImportDescriptors_VA);
        head.putInt((int)this.DelayLoadImportDescriptors_Size);
        head.putInt((int)this.COMRuntimedescriptor_VA);
        head.putInt((int)this.COMRuntimedescriptor_Size);
        head.position(0);
        return head;
    }

    public void updateVAAndSize(Vector oldsections, Vector newsections) {
        long codebase = this.findNewVA(this.BaseOfCode, oldsections, newsections);
        long codesize = this.findNewSize(this.BaseOfCode, oldsections, newsections);
        this.BaseOfCode = codebase;
        this.SizeOfCode = codesize;
        this.AddressOfEntryPoint = this.findNewVA(this.AddressOfEntryPoint, oldsections, newsections);
        long database = this.findNewVA(this.BaseOfData, oldsections, newsections);
        long datasize = this.findNewSize(this.BaseOfData, oldsections, newsections);
        this.BaseOfData = database;
        long imagesize = 0L;
        int i = 0;
        while (i < newsections.size()) {
            PESection sect = (PESection)newsections.get(i);
            long curmax = sect.VirtualAddress + sect.VirtualSize;
            if (curmax > imagesize) {
                imagesize = curmax;
            }
            ++i;
        }
        this.SizeOfImage = imagesize;
        this.ExportDirectory_Size = this.findNewSize(this.ExportDirectory_VA, oldsections, newsections);
        this.ExportDirectory_VA = this.findNewVA(this.ExportDirectory_VA, oldsections, newsections);
        this.ImportDirectory_Size = this.findNewSize(this.ImportDirectory_VA, oldsections, newsections);
        this.ImportDirectory_VA = this.findNewVA(this.ImportDirectory_VA, oldsections, newsections);
        this.ResourceDirectory_Size = this.findNewSize(this.ResourceDirectory_VA, oldsections, newsections);
        this.ResourceDirectory_VA = this.findNewVA(this.ResourceDirectory_VA, oldsections, newsections);
        this.ExceptionDirectory_Size = this.findNewSize(this.ExceptionDirectory_VA, oldsections, newsections);
        this.ExceptionDirectory_VA = this.findNewVA(this.ExceptionDirectory_VA, oldsections, newsections);
        this.SecurityDirectory_Size = this.findNewSize(this.SecurityDirectory_VA, oldsections, newsections);
        this.SecurityDirectory_VA = this.findNewVA(this.SecurityDirectory_VA, oldsections, newsections);
        this.BaseRelocationTable_Size = this.findNewSize(this.BaseRelocationTable_VA, oldsections, newsections);
        this.BaseRelocationTable_VA = this.findNewVA(this.BaseRelocationTable_VA, oldsections, newsections);
        this.DebugDirectory_Size = this.findNewSize(this.DebugDirectory_VA, oldsections, newsections);
        this.DebugDirectory_VA = this.findNewVA(this.DebugDirectory_VA, oldsections, newsections);
        this.ArchitectureSpecificData_Size = this.findNewSize(this.ArchitectureSpecificData_VA, oldsections, newsections);
        this.ArchitectureSpecificData_VA = this.findNewVA(this.ArchitectureSpecificData_VA, oldsections, newsections);
        this.RVAofGP_Size = this.findNewSize(this.RVAofGP_VA, oldsections, newsections);
        this.RVAofGP_VA = this.findNewVA(this.RVAofGP_VA, oldsections, newsections);
        this.TLSDirectory_Size = this.findNewSize(this.TLSDirectory_VA, oldsections, newsections);
        this.TLSDirectory_VA = this.findNewVA(this.TLSDirectory_VA, oldsections, newsections);
        this.LoadConfigurationDirectory_Size = this.findNewSize(this.LoadConfigurationDirectory_VA, oldsections, newsections);
        this.LoadConfigurationDirectory_VA = this.findNewVA(this.LoadConfigurationDirectory_VA, oldsections, newsections);
        this.BoundImportDirectoryinheaders_Size = this.findNewSize(this.BoundImportDirectoryinheaders_VA, oldsections, newsections);
        this.BoundImportDirectoryinheaders_VA = this.findNewVA(this.BoundImportDirectoryinheaders_VA, oldsections, newsections);
        this.ImportAddressTable_Size = this.findNewSize(this.ImportAddressTable_VA, oldsections, newsections);
        this.ImportAddressTable_VA = this.findNewVA(this.ImportAddressTable_VA, oldsections, newsections);
        this.DelayLoadImportDescriptors_Size = this.findNewSize(this.DelayLoadImportDescriptors_VA, oldsections, newsections);
        this.DelayLoadImportDescriptors_VA = this.findNewVA(this.DelayLoadImportDescriptors_VA, oldsections, newsections);
        this.COMRuntimedescriptor_Size = this.findNewSize(this.COMRuntimedescriptor_VA, oldsections, newsections);
        this.COMRuntimedescriptor_VA = this.findNewVA(this.COMRuntimedescriptor_VA, oldsections, newsections);
    }

    private long findNewVA(long current, Vector oldsections, Vector newsections) {
        int i = 0;
        while (i < oldsections.size()) {
            PESection sect = (PESection)oldsections.get(i);
            if (sect.VirtualAddress == current) {
                PESection newsect = (PESection)newsections.get(i);
                return newsect.VirtualAddress;
            }
            if (current > sect.VirtualAddress && current < sect.VirtualAddress + sect.VirtualSize) {
                long diff = current - sect.VirtualAddress;
                PESection newsect = (PESection)newsections.get(i);
                return newsect.VirtualAddress + diff;
            }
            ++i;
        }
        return 0L;
    }

    private long findNewSize(long current, Vector oldsections, Vector newsections) {
        int i = 0;
        while (i < oldsections.size()) {
            PESection sect = (PESection)oldsections.get(i);
            if (sect.VirtualAddress == current) {
                PESection newsect = (PESection)newsections.get(i);
                return newsect.VirtualSize;
            }
            ++i;
        }
        return 0L;
    }
}

