/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.pe.res;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public class ResIcon {
    public long Size;
    public long Width;
    public long Height;
    public int Planes;
    public int BitsPerPixel;
    public long Compression;
    public long SizeOfBitmap;
    public long HorzResolution;
    public long VertResolution;
    public long ColorsUsed;
    public long ColorsImportant;
    public PaletteElement[] Palette;
    public short[] BitmapXOR;
    public short[] BitmapAND;

    public ResIcon(ByteBuffer in) {
        this.Size = in.getInt();
        this.Width = in.getInt();
        this.Height = in.getInt();
        this.Planes = in.getShort();
        this.BitsPerPixel = in.getShort();
        this.Compression = in.getInt();
        this.SizeOfBitmap = in.getInt();
        this.HorzResolution = in.getInt();
        this.VertResolution = in.getInt();
        this.ColorsUsed = in.getInt();
        this.ColorsImportant = in.getInt();
        int cols = (int)this.ColorsUsed;
        if (cols == 0) {
            cols = 1 << this.BitsPerPixel;
        }
        this.Palette = new PaletteElement[cols];
        int i = 0;
        while (i < this.Palette.length) {
            PaletteElement el = new PaletteElement();
            el.Blue = in.get();
            el.Green = in.get();
            el.Red = in.get();
            el.Reserved = in.get();
            this.Palette[i] = el;
            ++i;
        }
        int xorbytes = (int)this.Height / 2 * (int)this.Width;
        this.BitmapXOR = new short[xorbytes];
        int i2 = 0;
        while (i2 < this.BitmapXOR.length) {
            switch (this.BitsPerPixel) {
                case 4: {
                    byte pix = in.get();
                    this.BitmapXOR[i2] = (short)(pix >> 4 & 0xF);
                    this.BitmapXOR[++i2] = (short)(pix & 0xF);
                    break;
                }
                case 8: {
                    this.BitmapXOR[i2] = in.get();
                }
            }
            ++i2;
        }
        int andbytes = (int)this.Height / 2 * (int)this.Width / 8;
        this.BitmapAND = new short[andbytes];
        int i3 = 0;
        while (i3 < this.BitmapAND.length) {
            this.BitmapAND[i3] = in.get();
            ++i3;
        }
    }

    public ResIcon(Image img) throws Exception {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        if (width % 8 != 0) {
            width += 7 - width % 8;
        }
        if (height % 8 != 0) {
            height += 7 - height % 8;
        }
        int[] pixelbuffer = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, width, height, pixelbuffer, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            throw new Exception("Can't load the image provided", e);
        }
        Hashtable colors = this.calculateColorCount(pixelbuffer);
        this.BitsPerPixel = 8;
        this.Palette = new PaletteElement[1 << this.BitsPerPixel];
        Enumeration e = colors.keys();
        while (e.hasMoreElements()) {
            Integer pixi = (Integer)e.nextElement();
            int pix = pixi;
            int index = (Integer)colors.get(pixi);
            this.Palette[index] = new PaletteElement();
            this.Palette[index].Blue = pix & 0xFF;
            this.Palette[index].Green = pix >> 8 & 0xFF;
            this.Palette[index].Red = pix >> 16 & 0xFF;
        }
        int i = 0;
        while (i < this.Palette.length) {
            if (this.Palette[i] == null) {
                this.Palette[i] = new PaletteElement();
            }
            ++i;
        }
        this.Size = 40L;
        this.Width = width;
        this.Height = height * 2;
        this.Planes = 1;
        this.Compression = 0L;
        this.SizeOfBitmap = 0L;
        this.HorzResolution = 0L;
        this.VertResolution = 0L;
        this.ColorsUsed = 0L;
        this.ColorsImportant = 0L;
        this.BitmapXOR = new short[(int)this.Height / 2 * (int)this.Width * this.BitsPerPixel / 8];
        this.BitmapAND = new short[(int)this.Height / 2 * (int)this.Width / 8];
        int bxl = this.BitmapXOR.length - 1;
        int bal = this.BitmapAND.length - 1;
        int i2 = 0;
        while (i2 < pixelbuffer.length) {
            int col = i2 % width;
            int line = i2 / width;
            bxl = width * height - (i2 / width + 1) * width + i2 % width;
            bal = width * height / 8 - (line + 1) * (width / 8) + col / 8;
            int pixel = pixelbuffer[i2] & 0xFFFFFF;
            Integer icol = (Integer)colors.get(new Integer(pixel));
            if (icol != null) {
                int palindex = icol;
                this.BitmapXOR[bxl] = (short)palindex;
            }
            ++i2;
        }
    }

    private int getBrightest() {
        int result = 0;
        int averesult = 0;
        int i = 0;
        while (i < this.Palette.length) {
            int ave1 = (this.Palette[0].Red + this.Palette[0].Green + this.Palette[0].Blue) / 3;
            if (ave1 > averesult) {
                averesult = ave1;
                result = i;
            }
            ++i;
        }
        return result;
    }

    private Hashtable calculateColorCount(int[] pixels) {
        Hashtable<Integer, Integer> result = new Hashtable<Integer, Integer>();
        int colorindex = 0;
        int i = 0;
        while (i < pixels.length) {
            int pix = pixels[i];
            Integer pixi = new Integer(pix &= 0xFFFFFF);
            Object o = result.get(pixi);
            if (o == null) {
                result.put(pixi, new Integer(colorindex++));
            }
            if (colorindex > 256) {
                return result;
            }
            ++i;
        }
        return result;
    }

    public ByteBuffer getData() {
        int cols = (int)this.ColorsUsed;
        if (cols == 0) {
            cols = 1 << this.BitsPerPixel;
        }
        ByteBuffer buf = ByteBuffer.allocate((int)((long)(40 + cols * 4) + this.Width * (this.Height / 2L) * (long)this.BitsPerPixel / 8L + this.Width * (this.Height / 2L) / 8L));
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(0);
        buf.putInt((int)this.Size);
        buf.putInt((int)this.Width);
        buf.putInt((int)this.Height);
        buf.putShort((short)this.Planes);
        buf.putShort((short)this.BitsPerPixel);
        buf.putInt((int)this.Compression);
        buf.putInt((int)this.SizeOfBitmap);
        buf.putInt((int)this.HorzResolution);
        buf.putInt((int)this.VertResolution);
        buf.putInt((int)this.ColorsUsed);
        buf.putInt((int)this.ColorsImportant);
        int i = 0;
        while (i < this.Palette.length) {
            PaletteElement el = this.Palette[i];
            buf.put((byte)el.Blue);
            buf.put((byte)el.Green);
            buf.put((byte)el.Red);
            buf.put((byte)el.Reserved);
            ++i;
        }
        switch (this.BitsPerPixel) {
            case 4: {
                i = 0;
                while (i < this.BitmapXOR.length) {
                    short v1 = this.BitmapXOR[i];
                    short v2 = this.BitmapXOR[i + 1];
                    buf.put((byte)(v1 << 4 | v2));
                    i += 2;
                }
                break;
            }
            case 8: {
                i = 0;
                while (i < this.BitmapXOR.length) {
                    buf.put((byte)this.BitmapXOR[i]);
                    ++i;
                }
                break;
            }
            default: {
                throw new RuntimeException("BitRes " + this.BitsPerPixel + " not supported!");
            }
        }
        i = 0;
        while (i < this.BitmapAND.length) {
            buf.put((byte)this.BitmapAND[i]);
            ++i;
        }
        buf.position(0);
        return buf;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("Size: " + this.Size);
        out.append("\nWidth: " + this.Width);
        out.append("\nHeight: " + this.Height);
        out.append("\nPlanes: " + this.Planes);
        out.append("\nBitsPerPixel: " + this.BitsPerPixel);
        out.append("\nCompression: " + this.Compression);
        out.append("\nSizeOfBitmap: " + this.SizeOfBitmap);
        out.append("\nHorzResolution: " + this.HorzResolution);
        out.append("\nVertResolution: " + this.VertResolution);
        out.append("\nColorsUsed: " + this.ColorsUsed);
        out.append("\nColorsImportant: " + this.ColorsImportant);
        out.append("\nBitmapXOR[" + this.BitmapXOR.length + "]={");
        int i = 0;
        while (i < this.BitmapXOR.length) {
            out.append((byte)this.BitmapXOR[i]);
            ++i;
        }
        out.append("}\nBitmapAnd[" + this.BitmapAND.length + "]={");
        i = 0;
        while (i < this.BitmapAND.length) {
            out.append((byte)this.BitmapAND[i]);
            ++i;
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        int read;
        ImageIcon ii = new ImageIcon("xpath-small.gif");
        Image img = ii.getImage().getScaledInstance(32, 32, 1);
        while (img.getHeight(null) == -1) {
            Thread.sleep(50L);
        }
        ResIcon ri = new ResIcon(img);
        ByteBuffer bb = ri.getData();
        FileOutputStream fos = new FileOutputStream("test.ico");
        ByteArrayInputStream bas = new ByteArrayInputStream(bb.array());
        byte[] buffer = new byte[8192];
        while ((read = bas.read(buffer)) > -1) {
            fos.write(buffer, 0, read);
        }
        fos.close();
    }

    public class PaletteElement {
        public int Blue;
        public int Green;
        public int Red;
        public int Reserved;

        public String toString() {
            return "{" + this.Blue + "," + this.Green + "," + this.Red + "," + this.Reserved + "}";
        }
    }
}

