/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.pe.res;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ResIconDir {
    private int m_idReserved;
    private int m_idType;
    private int m_idCount;
    private IconDirEntry[] m_entries;

    public ResIconDir(ByteBuffer buf) {
        this.m_idReserved = buf.getShort();
        this.m_idType = buf.getShort();
        this.m_idCount = buf.getShort();
        this.m_entries = new IconDirEntry[this.m_idCount];
        int i = 0;
        while (i < this.m_idCount) {
            this.m_entries[i] = new IconDirEntry(buf);
            ++i;
        }
    }

    public ByteBuffer getData() {
        ByteBuffer buf = ByteBuffer.allocate(6 + 16 * this.m_idCount);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(0);
        buf.putShort((short)this.m_idReserved);
        buf.putShort((short)this.m_idType);
        buf.putShort((short)this.m_idCount);
        int i = 0;
        while (i < this.m_idCount) {
            ByteBuffer b = this.m_entries[i].getData();
            b.position(0);
            buf.put(b);
            ++i;
        }
        return buf;
    }

    public IconDirEntry[] getEntries() {
        return this.m_entries;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("m_idReserved: " + this.m_idReserved + "\n");
        out.append("m_idType: " + this.m_idType + "\n");
        out.append("m_idCount: " + this.m_idCount + "\n");
        out.append("entries: ---- \n");
        int i = 0;
        while (i < this.m_entries.length) {
            out.append(this.m_entries[i].toString());
            ++i;
        }
        return out.toString();
    }

    public static class IconDirEntry {
        public short bWidth;
        public short bHeight;
        public short bColorCount;
        public short bReserved;
        public int wPlanes;
        public int wBitCount;
        public long dwBytesInRes;
        public int dwImageOffset;

        public IconDirEntry(ByteBuffer buf) {
            this.bWidth = buf.get();
            this.bHeight = buf.get();
            this.bColorCount = buf.get();
            this.bReserved = buf.get();
            this.wPlanes = buf.getShort();
            this.wBitCount = buf.getShort();
            this.dwBytesInRes = buf.getInt();
            this.dwImageOffset = buf.getShort();
        }

        public ByteBuffer getData() {
            ByteBuffer buf = ByteBuffer.allocate(16);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            buf.position(0);
            buf.put((byte)this.bWidth);
            buf.put((byte)this.bHeight);
            buf.put((byte)this.bColorCount);
            buf.put((byte)this.bReserved);
            buf.putShort((short)this.wPlanes);
            buf.putShort((short)this.wBitCount);
            buf.putInt((int)this.dwBytesInRes);
            buf.putShort((short)this.dwImageOffset);
            buf.position(0);
            return buf;
        }

        public String toString() {
            StringBuffer out = new StringBuffer();
            out.append("bWidth: " + this.bWidth + "\n");
            out.append("bHeight: " + this.bHeight + "\n");
            out.append("bColorCount: " + this.bColorCount + "\n");
            out.append("bReserved: " + this.bReserved + "\n");
            out.append("wPlanes: " + this.wPlanes + "\n");
            out.append("wBitCount: " + this.wBitCount + "\n");
            out.append("dwBytesInRes: " + this.dwBytesInRes + "\n");
            out.append("dwImageOffset: " + this.dwImageOffset + "\n");
            return out.toString();
        }
    }
}

