/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.tools.ant.pe.res.util;

public class Quantize {
    static final boolean QUICK = true;
    static final int MAX_RGB = 255;
    static final int MAX_NODES = 266817;
    static final int MAX_TREE_DEPTH = 8;
    static int[] SQUARES = new int[511];
    static int[] SHIFT;

    static {
        int i = -255;
        while (i <= 255) {
            Quantize.SQUARES[i + 255] = i * i;
            ++i;
        }
        SHIFT = new int[9];
        i = 0;
        while (i < 9) {
            Quantize.SHIFT[i] = 1 << 15 - i;
            ++i;
        }
    }

    public static int[] quantizeImage(int[][] pixels, int max_colors) {
        Cube cube = new Cube(pixels, max_colors);
        cube.classification();
        cube.reduction();
        cube.assignment();
        return cube.colormap;
    }

    static class Cube {
        int[][] pixels;
        int max_colors;
        int[] colormap;
        Node root;
        int depth;
        int colors;
        int nodes;

        Cube(int[][] pixels, int max_colors) {
            this.pixels = pixels;
            this.max_colors = max_colors;
            int i = max_colors;
            this.depth = 1;
            while (i != 0) {
                i /= 4;
                ++this.depth;
            }
            if (this.depth > 1) {
                --this.depth;
            }
            if (this.depth > 8) {
                this.depth = 8;
            } else if (this.depth < 2) {
                this.depth = 2;
            }
            this.root = new Node(this);
        }

        void classification() {
            int[][] pixels = this.pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int pixel = pixels[x][y];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    if (this.nodes > 266817) {
                        System.out.println("pruning");
                        this.root.pruneLevel();
                        --this.depth;
                    }
                    Node node = this.root;
                    int level = 1;
                    while (level <= this.depth) {
                        int id = (red > node.mid_red ? 1 : 0) << 0 | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2;
                        if (node.child[id] == null) {
                            new Node(node, id, level);
                        }
                        node = node.child[id];
                        node.number_pixels += SHIFT[level];
                        ++level;
                    }
                    ++node.unique;
                    node.total_red += red;
                    node.total_green += green;
                    node.total_blue += blue;
                }
            }
        }

        void reduction() {
            int threshold = 1;
            while (this.colors > this.max_colors) {
                this.colors = 0;
                threshold = this.root.reduce(threshold, Integer.MAX_VALUE);
            }
        }

        void assignment() {
            this.colormap = new int[this.colors];
            this.colors = 0;
            this.root.colormap();
            int[][] pixels = this.pixels;
            int width = pixels.length;
            int height = pixels[0].length;
            Search search = new Search();
            int x = width;
            while (x-- > 0) {
                int y = height;
                while (y-- > 0) {
                    int id;
                    int pixel = pixels[x][y];
                    int red = pixel >> 16 & 0xFF;
                    int green = pixel >> 8 & 0xFF;
                    int blue = pixel >> 0 & 0xFF;
                    Node node = this.root;
                    while (node.child[id = (red > node.mid_red ? 1 : 0) << 0 | (green > node.mid_green ? 1 : 0) << 1 | (blue > node.mid_blue ? 1 : 0) << 2] != null) {
                        node = node.child[id];
                    }
                    pixels[x][y] = node.color_number;
                }
            }
        }

        static class Search {
            int distance;
            int color_number;

            Search() {
            }
        }

        static class Node {
            Cube cube;
            Node parent;
            Node[] child;
            int nchild;
            int id;
            int level;
            int mid_red;
            int mid_green;
            int mid_blue;
            int number_pixels;
            int unique;
            int total_red;
            int total_green;
            int total_blue;
            int color_number;

            Node(Cube cube) {
                this.cube = cube;
                this.parent = this;
                this.child = new Node[8];
                this.id = 0;
                this.level = 0;
                this.number_pixels = Integer.MAX_VALUE;
                this.mid_red = 128;
                this.mid_green = 128;
                this.mid_blue = 128;
            }

            Node(Node parent, int id, int level) {
                this.cube = parent.cube;
                this.parent = parent;
                this.child = new Node[8];
                this.id = id;
                this.level = level;
                ++this.cube.nodes;
                if (level == this.cube.depth) {
                    ++this.cube.colors;
                }
                ++parent.nchild;
                parent.child[id] = this;
                int bi = 1 << 8 - level >> 1;
                this.mid_red = parent.mid_red + ((id & 1) > 0 ? bi : -bi);
                this.mid_green = parent.mid_green + ((id & 2) > 0 ? bi : -bi);
                this.mid_blue = parent.mid_blue + ((id & 4) > 0 ? bi : -bi);
            }

            void pruneChild() {
                --this.parent.nchild;
                this.parent.unique += this.unique;
                this.parent.total_red += this.total_red;
                this.parent.total_green += this.total_green;
                this.parent.total_blue += this.total_blue;
                this.parent.child[this.id] = null;
                --this.cube.nodes;
                this.cube = null;
                this.parent = null;
            }

            void pruneLevel() {
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            this.child[id].pruneLevel();
                        }
                        ++id;
                    }
                }
                if (this.level == this.cube.depth) {
                    this.pruneChild();
                }
            }

            int reduce(int threshold, int next_threshold) {
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            next_threshold = this.child[id].reduce(threshold, next_threshold);
                        }
                        ++id;
                    }
                }
                if (this.number_pixels <= threshold) {
                    this.pruneChild();
                } else {
                    if (this.unique != 0) {
                        ++this.cube.colors;
                    }
                    if (this.number_pixels < next_threshold) {
                        next_threshold = this.number_pixels;
                    }
                }
                return next_threshold;
            }

            void colormap() {
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            this.child[id].colormap();
                        }
                        ++id;
                    }
                }
                if (this.unique != 0) {
                    int r = (this.total_red + (this.unique >> 1)) / this.unique;
                    int g = (this.total_green + (this.unique >> 1)) / this.unique;
                    int b = (this.total_blue + (this.unique >> 1)) / this.unique;
                    this.cube.colormap[this.cube.colors] = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
                    this.color_number = this.cube.colors++;
                }
            }

            void closestColor(int red, int green, int blue, Search search) {
                int color;
                int distance;
                if (this.nchild != 0) {
                    int id = 0;
                    while (id < 8) {
                        if (this.child[id] != null) {
                            this.child[id].closestColor(red, green, blue, search);
                        }
                        ++id;
                    }
                }
                if (this.unique != 0 && (distance = Node.distance(color = this.cube.colormap[this.color_number], red, green, blue)) < search.distance) {
                    search.distance = distance;
                    search.color_number = this.color_number;
                }
            }

            static final int distance(int color, int r, int g, int b) {
                return SQUARES[(color >> 16 & 0xFF) - r + 255] + SQUARES[(color >> 8 & 0xFF) - g + 255] + SQUARES[(color >> 0 & 0xFF) - b + 255];
            }

            public String toString() {
                StringBuffer buf = new StringBuffer();
                if (this.parent == this) {
                    buf.append("root");
                } else {
                    buf.append("node");
                }
                buf.append(' ');
                buf.append(this.level);
                buf.append(" [");
                buf.append(this.mid_red);
                buf.append(',');
                buf.append(this.mid_green);
                buf.append(',');
                buf.append(this.mid_blue);
                buf.append(']');
                return new String(buf);
            }
        }
    }
}

