/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.win32;

import com.roxes.win32.Win32Exception;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;

public class Registry {
    static final String VERSION = "1.0";
    public static final int HKEY_CLASSES_ROOT = Integer.MIN_VALUE;
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int HKEY_USERS = -2147483645;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 5;
    public static final int REG_DWORD_BIG_ENDIAN = 4;
    public static final int REG_MULTI_SZ = 7;
    int hKey;
    String subKey;
    private static byte[] ba;
    static /* synthetic */ Class class$com$roxes$win32$Registry;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Number;

    public int getHKey() {
        return this.hKey;
    }

    public String getSubKey() {
        return this.subKey;
    }

    public Registry(int n) {
        this(n, "");
    }

    public Registry(int n, String string) {
        this.hKey = n;
        this.subKey = string;
    }

    public Registry(Registry registry, String string) {
        this.hKey = registry.hKey;
        this.subKey = registry.subKey.length() > 0 ? registry.subKey + "\\" + string : string;
    }

    public native boolean exists();

    public native void create() throws Win32Exception;

    public native void delete() throws Win32Exception;

    public native boolean hasSubKeys() throws Win32Exception;

    public native boolean hasValues() throws Win32Exception;

    public native boolean hasValue(String var1) throws Win32Exception;

    public native void deleteValue(String var1) throws Win32Exception;

    public void setValue(String string, int n) throws Win32Exception {
        this.setValue(string, new Integer(n), 4);
    }

    public int getIntValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to int");
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to int");
    }

    public void setValue(String string, short s) throws Win32Exception {
        this.setValue(string, new Short(s), 4);
    }

    public short getShortValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to short");
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to short");
    }

    public void setValue(String string, long l) throws Win32Exception {
        this.setValue(string, new Long(l), 4);
    }

    public long getLongValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to long");
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to long");
    }

    public void setValue(String string, boolean bl) throws Win32Exception {
        this.setValue(string, new Integer(bl ? 1 : 0), 4);
    }

    public boolean getBooleanValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to boolean");
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() != 0;
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to boolean");
    }

    public void setValue(String string, float f) throws Win32Exception {
        this.setValue(string, new Float(f));
    }

    public float getFloatValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to float");
        }
        if (object.getClass().getName().equals("[B")) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object));
                Object object2 = objectInputStream.readObject();
                if (object2 instanceof Number) {
                    return ((Number)object2).floatValue();
                }
                throw new Win32Exception("deserialized object is not of type number");
            }
            catch (IOException iOException) {
                throw new Win32Exception(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Win32Exception(classNotFoundException);
            }
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to float");
    }

    public void setValue(String string, double d) throws Win32Exception {
        this.setValue(string, new Double(d));
    }

    public double getDoubleValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to float");
        }
        if (object.getClass().getName().equals("[B")) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream((byte[])object));
                Object object2 = objectInputStream.readObject();
                if (object2 instanceof Number) {
                    return ((Number)object2).doubleValue();
                }
                throw new Win32Exception("deserialized object is not of type number");
            }
            catch (IOException iOException) {
                throw new Win32Exception(iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Win32Exception(classNotFoundException);
            }
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to double");
    }

    public void setValue(String string, byte[] byArray) throws Win32Exception {
        this.setValue(string, byArray, 3);
    }

    public void setValue(String string, byte by) throws Win32Exception {
        this.setValue(string, new Integer(by), 4);
    }

    public Byte getByteValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to Byte");
        }
        if (object instanceof Number) {
            return new Byte(((Number)object).byteValue());
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to Byte");
    }

    public byte[] getByteArrayValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to byte array");
        }
        if (object.getClass().getName().equals("[B")) {
            return (byte[])object;
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to byte array");
    }

    public BigDecimal getBigDecimalValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to BigDecimal");
        }
        if (object instanceof String) {
            return new BigDecimal(object.toString());
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to BigDecimal");
    }

    public BigInteger getBigIntegerValue(String string) {
        Object object = this.getValue(string);
        if (object == null) {
            throw new Win32Exception("Cannot convert null to BigInteger");
        }
        if (object instanceof String) {
            return new BigInteger(object.toString());
        }
        throw new Win32Exception("Cannot convert " + object.getClass().getName() + " to BigInteger");
    }

    public void setValue(String string, Object object) throws Win32Exception {
        int n = -1;
        if (object == null) {
            throw new Win32Exception("Cannot set null value in registry");
        }
        Class<?> clazz = object.getClass();
        if (clazz.getName().equals("[B")) {
            n = 3;
        } else if (clazz.equals(class$java$lang$Byte == null ? (class$java$lang$Byte = Registry.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            n = 4;
            object = new Integer(((Byte)object).intValue());
        } else if (clazz.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Registry.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            n = 4;
            object = new Integer((Boolean)object != false ? 1 : 0);
        } else if (clazz.equals(class$java$lang$Float == null ? (class$java$lang$Float = Registry.class$("java.lang.Float")) : class$java$lang$Float)) {
            try {
                n = 3;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                object = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new Win32Exception(iOException);
            }
        } else if (clazz.equals(class$java$lang$Double == null ? (class$java$lang$Double = Registry.class$("java.lang.Double")) : class$java$lang$Double)) {
            try {
                n = 3;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                object = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new Win32Exception(iOException);
            }
        } else if (clazz.equals(class$java$math$BigInteger == null ? (class$java$math$BigInteger = Registry.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            n = 1;
            object = object.toString();
        } else if (clazz.equals(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = Registry.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            n = 1;
            object = object.toString();
        } else {
            n = (class$java$lang$Number == null ? (class$java$lang$Number = Registry.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(clazz) ? 4 : 1;
        }
        this.setValue(string, object, n);
    }

    private native void setValue(String var1, Object var2, int var3) throws Win32Exception;

    public boolean hasSubKey(String string) {
        Registry registry = new Registry(this, string);
        return registry.exists();
    }

    public Iterator valueNames() {
        return this.values().iterator();
    }

    private native ArrayList values();

    public Iterator subKeyNames() {
        return this.subKeys().iterator();
    }

    public native Object getValue(String var1);

    public native int getValueType(String var1);

    public static String getValueTypeName(int n) {
        switch (n) {
            case 3: {
                return "REG_BINARY";
            }
            case 4: {
                return "REG_DWORD";
            }
            case 5: {
                return "REG_DWORD_LITTLE_ENDIAN";
            }
            case 2: {
                return "REG_EXPAND_SZ";
            }
            case 7: {
                return "REG_MULTI_SZ";
            }
            case 0: {
                return "REG_NONE";
            }
            case 1: {
                return "REG_SZ";
            }
        }
        throw new Win32Exception("valueType " + n + " is unknown.");
    }

    public static int parseValueTypeName(String string) {
        if (string.equals("REG_BINARY")) {
            return 3;
        }
        if (string.equals("REG_DWORD")) {
            return 4;
        }
        if (string.equals("REG_DWORD_BIG_ENDIAN")) {
            return 4;
        }
        if (string.equals("REG_DWORD_LITTLE_ENDIAN")) {
            return 5;
        }
        if (string.equals("REG_EXPAND_SZ")) {
            return 2;
        }
        if (string.equals("REG_MULTI_SZ")) {
            return 7;
        }
        if (string.equals("REG_NONE")) {
            return 0;
        }
        if (string.equals("REG_SZ")) {
            return 1;
        }
        throw new Win32Exception("Parsing valueType failed : valueType " + string + " is unknown.");
    }

    public static String getHKeyName(int n) {
        switch (n) {
            case -2147483648: {
                return "HKEY_CLASSES_ROOT";
            }
            case -2147483647: {
                return "HKEY_CURRENT_USER";
            }
            case -2147483646: {
                return "HKEY_LOCAL_MACHINE";
            }
            case -2147483645: {
                return "HKEY_USERS";
            }
        }
        throw new Win32Exception("hKey " + n + " is unknown.");
    }

    public static int parseHKeyName(String string) {
        if (string.equals("HKEY_CLASSES_ROOT")) {
            return Integer.MIN_VALUE;
        }
        if (string.equals("HKEY_CURRENT_USER")) {
            return -2147483647;
        }
        if (string.equals("HKEY_LOCAL_MACHINE")) {
            return -2147483646;
        }
        if (string.equals("HKEY_USERS")) {
            return -2147483645;
        }
        throw new Win32Exception("Parsing hKey failed : hKey " + string + " is unknown.");
    }

    private native ArrayList subKeys();

    public static void main(String[] stringArray) {
        System.out.println("################ test exists ################");
        Registry registry = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\AntiVir");
        System.out.println(registry + " exists()=" + registry.exists());
        registry = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\AntiVird");
        System.out.println(registry + " exists()=" + registry.exists());
        System.out.println("################ test create ################");
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies\\myapp");
        System.out.println(registry + " exists()=" + registry.exists());
        registry.create();
        System.out.println(registry + " exists()=" + registry.exists());
        try {
            registry.create();
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            System.out.println("### OK ###");
        }
        System.out.println("################ test delete ################");
        registry.delete();
        System.out.println(registry + " exists()=" + registry.exists());
        try {
            registry.delete();
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            System.out.println("### OK ###");
        }
        System.out.println("################ test hasSubkeys ################");
        try {
            registry.hasSubKeys();
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            System.out.println("### OK ###");
        }
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies");
        System.out.println(registry + " hasSubKeys()=" + registry.hasSubKeys());
        registry = new Registry(-2147483646, "SOFTWARE");
        System.out.println(registry + " hasSubKeys()=" + registry.hasSubKeys());
        System.out.println("################ test hasValues ################");
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies\\myapp");
        try {
            registry.hasValues();
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            System.out.println("### OK ###");
        }
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies");
        System.out.println(registry + " hasValues()=" + registry.hasValues());
        registry = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
        System.out.println(registry + " hasValues()=" + registry.hasValues());
        System.out.println("################ test hasValue ################");
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies\\myapp");
        try {
            registry.hasValue("dummy");
        }
        catch (Win32Exception win32Exception) {
            win32Exception.printStackTrace();
            System.out.println("### OK ###");
        }
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies");
        System.out.println(registry + " hasValue( 'dummy')=" + registry.hasValue("dummy"));
        registry = new Registry(-2147483646, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion");
        System.out.println(registry + " hasValue( 'ProgramFilesDir')=" + registry.hasValue("ProgramFilesDir"));
        registry = new Registry(-2147483646, "SOFTWARE\\Roxes Technologies");
        registry.setValue("test", "huhu");
        registry.setValue("int", new Integer(Integer.MAX_VALUE));
        registry.setValue("int", Integer.MAX_VALUE);
        registry.setValue("long", new Long(2000L));
        registry.setValue("long", 2000);
        registry.setValue("true", Boolean.TRUE);
        registry.setValue("true", true);
        registry.setValue("false", Boolean.FALSE);
        registry.setValue("short", new Short(Short.MAX_VALUE));
        registry.setValue("short", (short)Short.MAX_VALUE);
        registry.setValue("bigdecimal", new BigDecimal(333.0));
        registry.setValue("bigint", new BigInteger("300"));
        registry.setValue("byte", new Byte(127));
        registry.setValue("byte", (byte)127);
        registry.setValue("bytearray", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        System.out.println("value test=" + registry.getValue("test"));
        System.out.println("value int=" + registry.getIntValue("int"));
        System.out.println("value long=" + registry.getLongValue("long"));
        System.out.println("value true=" + registry.getBooleanValue("true"));
        System.out.println("value false=" + registry.getBooleanValue("false"));
        System.out.println("value short=" + registry.getShortValue("short"));
        System.out.println("value bigdecimal=" + registry.getBigDecimalValue("bigdecimal"));
        System.out.println("value bigint=" + registry.getBigIntegerValue("bigint"));
        System.out.println("value byte=" + registry.getByteValue("byte"));
        System.out.println("value bytearray=" + Registry.dumpByteArray(registry.getByteArrayValue("bytearray")));
        Iterator iterator = registry.valueNames();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
        registry = new Registry(-2147483646, "SOFTWARE");
        iterator = registry.subKeyNames();
        while (iterator.hasNext()) {
            System.out.println((String)iterator.next());
        }
    }

    public static String dumpByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(by);
            if (i >= byArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Registry.getHKeyName(this.hKey));
        if (this.subKey.length() > 0) {
            stringBuffer.append('\\').append(this.subKey);
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File file = new File(System.getProperty("java.home") + File.separator + "bin" + File.separator + "roxes-registry-" + VERSION + ".dll");
        if (!file.exists()) {
            try {
                System.out.println("Install native library " + file.getAbsolutePath());
                InputStream inputStream = (class$com$roxes$win32$Registry == null ? (class$com$roxes$win32$Registry = Registry.class$("com.roxes.win32.Registry")) : class$com$roxes$win32$Registry).getResourceAsStream("registry.dll");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[8192];
                InputStream inputStream2 = inputStream;
                synchronized (inputStream2) {
                    FileOutputStream fileOutputStream2 = fileOutputStream;
                    synchronized (fileOutputStream2) {
                        int n;
                        while ((n = inputStream.read(byArray)) > -1) {
                            ((OutputStream)fileOutputStream).write(byArray, 0, n);
                        }
                    }
                }
                ((OutputStream)fileOutputStream).close();
            }
            catch (Exception exception) {
                throw new Win32Exception("Unable to copy registry-1.0.dll to JAVA_HOME" + File.separator + "bin.");
            }
        }
        if (System.getProperty("roxes.native.registry.1.0") == null) {
            System.load(file.getAbsolutePath());
            System.setProperty("roxes.native.registry.1.0", "loaded");
        }
        ba = new byte[0];
    }
}

