/*
 * Decompiled with CFR 0.152.
 */
package com.roxes.win32;

import com.roxes.win32.Win32;
import com.roxes.win32.Win32Exception;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.net.URL;

public class UrlFile {
    public static final String SIGNATURE = "[InternetShortcut]";
    public static final String LINE_BREAK = "\r\n";
    public static final int SHOWCOMMAND_NORMAL = -1;
    public static final int SHOWCOMMAND_MAXIMIZED = 3;
    public static final int SHOWCOMMAND_MINIMIZED = 7;
    String workingDirectory = null;
    String iconFile = null;
    int iconIndex = -1;
    URL url = null;
    int showCommand = -1;
    int hotKey = -1;
    String modified = null;
    File file = null;

    public UrlFile(File file) throws IOException {
        this.file = file;
        if (!file.exists()) {
            return;
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        String string = lineNumberReader.readLine();
        if (!string.equals(SIGNATURE)) {
            throw new Win32Exception("Shortcut Signature \"[InternetShortcut]\" not found in file " + file.getAbsolutePath());
        }
        while ((string = lineNumberReader.readLine()) != null) {
            int n = string.indexOf(61);
            if (n == -1) {
                throw new Win32Exception("Invalid Shortcut file format (line " + lineNumberReader.getLineNumber() + "): \"=\" expected in \"" + string + "\"");
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            if (string2.equals("URL")) {
                this.url = new URL(string3);
                continue;
            }
            if (string2.equals("WorkingDirectory")) {
                this.workingDirectory = string3;
                continue;
            }
            if (string2.equals("IconFile")) {
                this.iconFile = string3;
                continue;
            }
            if (string2.equals("IconIndex")) {
                this.iconIndex = Integer.parseInt(string3);
                continue;
            }
            if (string2.equals("ShowCommand")) {
                this.showCommand = Integer.parseInt(string3);
                continue;
            }
            if (string2.equals("Modified")) {
                this.modified = string3;
                continue;
            }
            if (string2.equals("HotKey")) {
                this.hotKey = Integer.parseInt(string3);
                continue;
            }
            throw new Win32Exception("Invalid Shortcut file format (line " + lineNumberReader.getLineNumber() + "): dont know key " + string2);
        }
        lineNumberReader.close();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(SIGNATURE).append(LINE_BREAK);
        if (this.url != null) {
            stringBuffer.append("URL=").append(this.url).append(LINE_BREAK);
        }
        if (this.workingDirectory != null) {
            stringBuffer.append("WorkingDirectory=").append(this.workingDirectory).append(LINE_BREAK);
        }
        if (this.iconFile != null) {
            stringBuffer.append("IconFile=").append(this.iconFile).append(LINE_BREAK);
        }
        if (this.iconIndex != -1) {
            stringBuffer.append("IconIndex=").append(this.iconIndex).append(LINE_BREAK);
        }
        if (this.modified != null) {
            stringBuffer.append("Modified=").append(this.modified).append(LINE_BREAK);
        }
        if (this.hotKey != -1) {
            stringBuffer.append("HotKey=").append(this.hotKey).append(LINE_BREAK);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        UrlFile urlFile = new UrlFile(new File(Win32.getSpecialDirectory(10), "Go to ROXES Technologies.url"));
        urlFile.setUrl(new URL("http://www.roxes.com"));
        urlFile.setIconFile("C:\\winnt\\explorer.exe");
        urlFile.setIconIndex(3);
        urlFile.save();
        System.out.println(urlFile);
        urlFile.save(new File(Win32.getSpecialDirectory(17), "Go to ROXES Technologies.url"));
    }

    public int getIconIndex() {
        return this.iconIndex;
    }

    public String getModified() {
        return this.modified;
    }

    public int getShowCommand() {
        return this.showCommand;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setIconIndex(int n) {
        this.iconIndex = n;
    }

    public void setModified(String string) {
        this.modified = string;
    }

    public void setShowCommand(int n) {
        this.showCommand = n;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public void setWorkingDirectory(String string) {
        this.workingDirectory = string;
    }

    public void save() throws IOException {
        if (!this.file.getName().endsWith(".url")) {
            throw new Win32Exception("Shortcut/Favorite files must have prefix \".url\".");
        }
        if (!this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        PrintStream printStream = new PrintStream(new FileOutputStream(this.file));
        printStream.print(this.toString());
        printStream.close();
    }

    public void save(File file) throws IOException {
        this.file = file;
        this.save();
    }

    public int getHotKey() {
        return this.hotKey;
    }

    public String getIconFile() {
        return this.iconFile;
    }

    public void setHotKey(int n) {
        this.hotKey = n;
    }

    public void setIconFile(String string) {
        this.iconFile = string;
    }
}

