/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class PdbReader
extends AtomSetCollectionReader {
    private int lineLength;
    private final Map<String, Map<String, Boolean>> htFormul = new Hashtable<String, Map<String, Boolean>>();
    private Map<String, String> htHetero = null;
    private Map<String, Map<String, Object>> htSites = null;
    private String currentGroup3;
    private Map<String, Boolean> htElementsInCurrentGroup;
    private int maxSerial;
    private int[] chainAtomCounts;
    private int nUNK;
    private int nRes;
    private boolean isMultiModel;
    private static final String lineOptions = "ATOM    HETATM  MODEL   CONECT  HELIX   SHEET   TURN    HET     HETNAM  ANISOU  SITE    CRYST1  SCALE1  SCALE2  SCALE3  EXPDTA  FORMUL  REMARK  HEADER  COMPND  SOURCE  ";
    private int serial = 0;
    private StringBuffer pdbHeader;
    private List<Map<String, String>> vCompnds;
    private Map<String, String> currentCompnd;
    private String currentKey;
    private Map<String, Map<String, String>> htMolIds;
    private boolean resetKey = true;
    String compnd = null;
    private List<Map<String, Object>> biomolecules;
    private List<Matrix4f> biomts;
    private int atomCount;
    private String lastAtomData;
    private int lastAtomIndex;
    private boolean haveMappedSerials;

    protected void initializeReader() throws Exception {
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
        this.pdbHeader = this.getHeader ? new StringBuffer() : null;
    }

    protected boolean checkLine() throws Exception {
        boolean bl;
        boolean bl2;
        this.lineLength = this.line.length();
        int n = (this.lineLength < 6 ? -1 : lineOptions.indexOf(this.line.substring(0, 6))) >> 3;
        boolean bl3 = n == 0 || n == 1;
        boolean bl4 = bl2 = n == 2;
        if (bl3) {
            this.serial = this.parseInt(this.line, 6, 11);
        }
        boolean bl5 = bl = (this.isTrajectory || this.isSequential) && !this.isMultiModel && bl3 && this.serial == 1;
        if (this.getHeader) {
            if (bl3 || bl2) {
                this.getHeader = false;
            } else {
                this.pdbHeader.append(this.line).append('\n');
            }
        }
        if (bl2 || bl) {
            this.isMultiModel = bl2;
            this.getHeader = false;
            int n2 = bl ? this.modelNumber + 1 : this.getModelNumber();
            int n3 = this.modelNumber = this.bsModels == null ? n2 : this.modelNumber + 1;
            if (!this.doGetModel(this.modelNumber)) {
                return this.checkLastModel();
            }
            this.atomSetCollection.connectAll(this.maxSerial);
            if (this.atomCount > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            this.model(n2);
            if (!bl3) {
                return true;
            }
        }
        if (this.isMultiModel && !this.doProcessLines) {
            return true;
        }
        if (bl3) {
            this.getHeader = false;
            this.atom(this.serial);
            return true;
        }
        switch (n) {
            case 3: {
                this.conect();
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                this.structure();
                return true;
            }
            case 7: {
                this.het();
                return true;
            }
            case 8: {
                this.hetnam();
                return true;
            }
            case 9: {
                this.anisou();
                return true;
            }
            case 10: {
                this.site();
                return true;
            }
            case 11: {
                this.cryst1();
                return true;
            }
            case 12: 
            case 13: 
            case 14: {
                this.scale(n - 11);
                return true;
            }
            case 15: {
                this.expdta();
                return true;
            }
            case 16: {
                this.formul();
                return true;
            }
            case 17: {
                if (this.line.startsWith("REMARK 350")) {
                    this.remark350();
                    return false;
                }
                if (this.line.startsWith("REMARK 290")) {
                    this.remark290();
                    return false;
                }
                this.checkLineForScript();
                return true;
            }
            case 18: {
                this.header();
                return true;
            }
            case 19: {
                this.compndOld();
                this.compndSource(false);
                return true;
            }
            case 20: {
                this.compndSource(true);
                return true;
            }
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        this.checkNotPDB();
        this.atomSetCollection.connectAll(this.maxSerial);
        if (this.biomolecules != null && this.biomolecules.size() > 0 && this.atomSetCollection.getAtomCount() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("biomolecules", this.biomolecules);
            this.setBiomoleculeAtomCounts();
            if (this.biomts != null && this.filter != null && this.filter.toUpperCase().indexOf("NOSYMMETRY") < 0) {
                this.atomSetCollection.applySymmetry(this.biomts, this.notionalUnitCell, this.applySymmetryToBonds, this.filter);
            }
        }
        super.finalizeReader();
        if (this.vCompnds != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("compoundSource", this.vCompnds);
        }
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if (this.pdbHeader != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", this.pdbHeader.toString());
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.atomSetCollection.setCheckSpecial(false);
        super.applySymmetryAndSetTrajectory();
    }

    private void header() {
        if (this.lineLength < 8) {
            return;
        }
        if (this.lineLength >= 66) {
            this.atomSetCollection.setCollectionName(this.line.substring(62, 66));
        }
        if (this.lineLength > 50) {
            this.line = this.line.substring(0, 50);
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("CLASSIFICATION", this.line.substring(7).trim());
    }

    private void compndSource(boolean bl) {
        String string;
        if (this.vCompnds == null) {
            if (bl) {
                return;
            }
            this.vCompnds = new ArrayList<Map<String, String>>();
            this.htMolIds = new Hashtable<String, Map<String, String>>();
            this.currentCompnd = new Hashtable<String, String>();
            this.currentCompnd.put("select", "(*)");
            this.currentKey = "MOLECULE";
            this.htMolIds.put("", this.currentCompnd);
        }
        if (bl && this.resetKey) {
            this.resetKey = false;
            this.currentKey = "SOURCE";
            this.currentCompnd = this.htMolIds.get("");
        }
        this.line = this.line.substring(10, Math.min(this.lineLength, 72)).trim();
        int n = this.line.indexOf(":");
        if (n < 0 || n > 0 && this.line.charAt(n - 1) == '\\') {
            n = this.line.length();
        }
        String string2 = this.line.substring(0, n).trim();
        String string3 = string = n < this.line.length() ? this.line.substring(n + 1) : null;
        if (string2.equals("MOL_ID")) {
            if (string == null) {
                return;
            }
            if (bl) {
                this.currentCompnd = this.htMolIds.remove(string);
                return;
            }
            this.currentCompnd = new Hashtable<String, String>();
            this.vCompnds.add(this.currentCompnd);
            this.htMolIds.put(string, this.currentCompnd);
        }
        if (this.currentCompnd == null) {
            return;
        }
        if (string == null) {
            string = this.currentCompnd.get(this.currentKey);
            if (string == null) {
                string = "";
            }
            string = string + string2;
            if (this.vCompnds.size() == 0) {
                this.vCompnds.add(this.currentCompnd);
            }
        } else {
            this.currentKey = string2;
        }
        if (string.endsWith(";")) {
            string = string.substring(0, string.length() - 1);
        }
        this.currentCompnd.put(this.currentKey, string);
        if (this.currentKey.equals("CHAIN")) {
            this.currentCompnd.put("select", "(:" + TextFormat.simpleReplace(TextFormat.simpleReplace(string, ", ", ",:"), " ", "") + ")");
        }
    }

    private void compndOld() {
        this.compnd = this.compnd == null ? "" : this.compnd + " ";
        String string = this.line;
        if (this.lineLength > 62) {
            string = string.substring(0, 62);
        }
        this.compnd = this.compnd + string.substring(10).trim();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("COMPND", this.compnd);
    }

    private void setBiomoleculeAtomCounts() {
        int n = this.biomolecules.size();
        while (--n >= 0) {
            Map<String, Object> map = this.biomolecules.get(n);
            String string = (String)map.get("chains");
            int n2 = ((List)map.get("biomts")).size();
            int n3 = 0;
            int n4 = string.length() - 1;
            while (--n4 >= 0) {
                if (string.charAt(n4) != ':') continue;
                n3 += this.chainAtomCounts[string.charAt(n4 + 1)];
            }
            map.put("atomCount", n3 * n2);
        }
    }

    private void remark350() throws Exception {
        ArrayList<Matrix4f> arrayList = null;
        this.biomolecules = new ArrayList<Map<String, Object>>();
        this.chainAtomCounts = new int[255];
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = true;
        Hashtable<String, Object> hashtable = null;
        int n2 = 0;
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        while (true) {
            if (bl) {
                this.readLine();
            } else {
                bl = true;
            }
            if (this.line == null || !this.line.startsWith("REMARK 350")) break;
            try {
                if (this.line.startsWith("REMARK 350 BIOMOLECULE:")) {
                    if (n2 > 0) {
                        Logger.info("biomolecule " + n + ": number of transforms: " + n2);
                    }
                    hashtable = new Hashtable<String, Object>();
                    arrayList = new ArrayList<Matrix4f>();
                    n = this.parseInt(this.line.substring(this.line.indexOf(":") + 1));
                    string = this.line.trim();
                    hashtable.put("molecule", n);
                    hashtable.put("title", string);
                    hashtable.put("chains", "");
                    hashtable.put("biomts", arrayList);
                    this.biomolecules.add(hashtable);
                    n2 = 0;
                }
                if (this.line.indexOf("APPLY THE FOLLOWING TO CHAINS:") >= 0) {
                    if (hashtable == null) {
                        bl = false;
                        this.line = "REMARK 350 BIOMOLECULE: 1  APPLY THE FOLLOWING TO CHAINS:";
                        continue;
                    }
                    string2 = ":" + this.line.substring(41).trim().replace(' ', ':');
                    bl = false;
                    while (this.readLine() != null && this.line.indexOf("BIOMT") < 0) {
                        string2 = string2 + ":" + this.line.substring(11).trim().replace(' ', ':');
                    }
                    if (this.filter != null && this.filter.toUpperCase().indexOf("BIOMOLECULE " + n + ";") >= 0) {
                        this.filter = this.filter + string2;
                        Logger.info("filter set to \"" + this.filter + "\"");
                        this.biomts = arrayList;
                    }
                    hashtable.put("chains", string2);
                    continue;
                }
                if (!this.line.startsWith("REMARK 350   BIOMT1 ")) continue;
                ++n2;
                float[] fArray = new float[16];
                int n3 = 0;
                while (n3 < 12) {
                    String[] stringArray = this.getTokens();
                    fArray[n3++] = this.parseFloat(stringArray[4]);
                    fArray[n3++] = this.parseFloat(stringArray[5]);
                    fArray[n3++] = this.parseFloat(stringArray[6]);
                    fArray[n3++] = this.parseFloat(stringArray[7]);
                    if (n3 != 4 && n3 != 8) continue;
                    this.readLine();
                }
                fArray[15] = 1.0f;
                Matrix4f matrix4f2 = new Matrix4f();
                matrix4f2.set(fArray);
                if (matrix4f2.equals(matrix4f)) {
                    arrayList.add(0, matrix4f2);
                    continue;
                }
                arrayList.add(matrix4f2);
            }
            catch (Exception exception) {
                this.biomts = null;
                this.biomolecules = null;
                return;
            }
        }
        if (n2 > 0) {
            Logger.info("biomolecule " + n + ": number of transforms: " + n2);
        }
    }

    private void remark290() throws Exception {
        while (this.readLine() != null && this.line.startsWith("REMARK 290")) {
            String[] stringArray;
            if (this.line.indexOf("NNNMMM   OPERATOR") < 0) continue;
            while (this.readLine() != null && (stringArray = this.getTokens()).length >= 4) {
                this.setSymmetryOperator(stringArray[3]);
            }
        }
    }

    private void atom(int n) {
        int n2;
        if (n > this.maxSerial) {
            this.maxSerial = n;
        }
        boolean bl = this.line.startsWith("HETATM");
        char c = this.line.charAt(16);
        char c2 = this.line.charAt(21);
        if (this.chainAtomCounts != null) {
            char c3 = c2;
            this.chainAtomCounts[c3] = this.chainAtomCounts[c3] + 1;
        }
        int n3 = this.parseInt(this.line, 22, 26);
        char c4 = this.line.charAt(26);
        String string = this.parseToken(this.line, 17, 20);
        if (string == null) {
            this.currentGroup3 = null;
            this.htElementsInCurrentGroup = null;
        } else if (!string.equals(this.currentGroup3)) {
            this.currentGroup3 = string;
            this.htElementsInCurrentGroup = this.htFormul.get(string);
            ++this.nRes;
            if (string.equals("UNK")) {
                ++this.nUNK;
            }
        }
        String string2 = this.deduceElementSymbol(bl);
        String string3 = this.line.substring(12, 16);
        String string4 = string3.trim();
        int n4 = 0;
        if (this.lineLength >= 80) {
            int n5 = this.line.charAt(78);
            n2 = this.line.charAt(79);
            if (n2 >= 48 && n2 <= 55) {
                int n6 = n2;
                n2 = n5;
                n5 = n6;
            }
            if ((n2 == 43 || n2 == 45 || n2 == 32) && n5 >= 48 && n5 <= 55) {
                n4 = n5 - 48;
                if (n2 == 45) {
                    n4 = -n4;
                }
            }
        }
        float f = this.readBFactor();
        n2 = this.readOccupancy();
        float f2 = this.readPartialCharge();
        float f3 = this.readRadius();
        float f4 = this.parseFloat(this.line, 30, 38);
        float f5 = this.parseFloat(this.line, 38, 46);
        float f6 = this.parseFloat(this.line, 46, 54);
        Atom atom = new Atom();
        atom.atomName = string4;
        atom.chainID = c2;
        atom.group3 = this.currentGroup3;
        if (this.filter != null && !this.filterAtom(atom)) {
            return;
        }
        atom.elementSymbol = string2;
        if (c != ' ') {
            atom.alternateLocationID = c;
        }
        atom.formalCharge = n4;
        if (f2 != Float.MAX_VALUE) {
            atom.partialCharge = f2;
        }
        atom.occupancy = n2;
        atom.bfactor = f;
        this.setAtomCoord(atom, f4, f5, f6);
        atom.isHetero = bl;
        atom.atomSerial = n;
        atom.sequenceNumber = n3;
        atom.insertionCode = JmolAdapter.canonizeInsertionCode(c4);
        atom.radius = f3;
        this.lastAtomData = this.line.substring(6, 26);
        this.lastAtomIndex = this.atomSetCollection.getAtomCount();
        if (this.haveMappedSerials) {
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        } else {
            this.atomSetCollection.addAtom(atom);
        }
        if (this.atomCount++ == 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        if (bl && this.htHetero != null) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
    }

    protected int readOccupancy() {
        int n = 100;
        float f = this.parseFloat(this.line, 54, 60);
        if (!Float.isNaN(f)) {
            n = (int)(f * 100.0f);
        }
        return n;
    }

    protected float readBFactor() {
        return this.parseFloat(this.line, 60, 66);
    }

    protected float readPartialCharge() {
        return Float.MAX_VALUE;
    }

    protected float readRadius() {
        return Float.NaN;
    }

    private String deduceElementSymbol(boolean bl) {
        char c;
        char c2;
        if (this.lineLength >= 78) {
            c2 = this.line.charAt(76);
            c = this.line.charAt(77);
            if (c2 == ' ' && Atom.isValidElementSymbol(c)) {
                return "" + c;
            }
            if (Atom.isValidElementSymbolNoCaseSecondChar(c2, c)) {
                return "" + c2 + c;
            }
        }
        c2 = this.line.charAt(12);
        c = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidElementSymbolNoCaseSecondChar(c2, c)) {
            return bl || c2 != 'H' ? "" + c2 + c : "H";
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c) != null) && Atom.isValidElementSymbol(c)) {
            return "" + c;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c2) != null) && Atom.isValidElementSymbol(c2)) {
            return "" + c2;
        }
        return "Xx";
    }

    private void conect() {
        int n = -1;
        n = this.parseInt(this.line, 6, 11);
        if (n < 0) {
            return;
        }
        for (int i = 0; i < 9; i += i == 5 ? 2 : 1) {
            int n2;
            int n3 = i * 5 + 11;
            int n4 = n3 + 5;
            int n5 = n2 = n4 <= this.lineLength ? this.parseInt(this.line, n3, n4) : -1;
            if (n2 < n) continue;
            this.atomSetCollection.addConnection(new int[]{n, n2, i < 4 ? 1 : 2048});
        }
    }

    private void structure() {
        int n;
        int n2;
        int n3;
        int n4;
        String string = "none";
        int n5 = 0;
        if (this.line.startsWith("HELIX ")) {
            string = "helix";
            n4 = 19;
            n3 = 21;
            n2 = 31;
            n = 33;
        } else if (this.line.startsWith("SHEET ")) {
            string = "sheet";
            n4 = 21;
            n3 = 22;
            n2 = 32;
            n = 33;
            n5 = this.parseInt(this.line.substring(14, 16));
        } else if (this.line.startsWith("TURN  ")) {
            string = "turn";
            n4 = 19;
            n3 = 20;
            n2 = 30;
            n = 31;
        } else {
            return;
        }
        if (this.lineLength < n + 4) {
            return;
        }
        String string2 = this.line.substring(11, 15).trim();
        int n6 = this.parseInt(this.line.substring(7, 10));
        char c = this.line.charAt(n4);
        int n7 = this.parseInt(this.line, n3, n3 + 4);
        char c2 = this.line.charAt(n3 + 4);
        char c3 = this.line.charAt(n2);
        int n8 = this.parseInt(this.line, n, n + 4);
        char c4 = ' ';
        if (this.lineLength > n + 4) {
            c4 = this.line.charAt(n + 4);
        }
        Structure structure = new Structure(-1, string, string2, n6, n5, c, n7, c2, c3, n8, c4);
        this.atomSetCollection.addStructure(structure);
    }

    private int getModelNumber() {
        try {
            int n = 6;
            int n2 = 14;
            if (n2 > this.lineLength) {
                n2 = this.lineLength;
            }
            return this.parseInt(this.line, n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void model(int n) {
        this.checkNotPDB();
        this.haveMappedSerials = false;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        this.atomSetCollection.setAtomSetNumber(n);
    }

    private void checkNotPDB() {
        if (this.atomSetCollection.getAtomCount() > 0 && this.nUNK == this.nRes) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.FALSE);
        }
        this.nRes = 0;
        this.nUNK = 0;
    }

    private void cryst1() throws Exception {
        float f = this.getFloat(6, 9);
        if (f == 1.0f) {
            f = Float.NaN;
        }
        this.setUnitCell(f, this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
        this.setSpaceGroupName(PdbReader.parseTrimmed(this.line, 55, 66));
    }

    private float getFloat(int n, int n2) throws Exception {
        return this.parseFloat(this.line, n, n + n2);
    }

    private void scale(int n) throws Exception {
        int n2 = n * 4 + 2;
        this.setUnitCellItem(n2++, this.getFloat(10, 10));
        this.setUnitCellItem(n2++, this.getFloat(20, 10));
        this.setUnitCellItem(n2++, this.getFloat(30, 10));
        this.setUnitCellItem(n2++, this.getFloat(45, 10));
    }

    private void expdta() {
        if (this.line.toUpperCase().indexOf("NMR") >= 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isNMRdata", "true");
        }
    }

    private void formul() {
        String string;
        Map<String, Boolean> map;
        String string2 = this.parseToken(this.line, 12, 15);
        String string3 = PdbReader.parseTrimmed(this.line, 19, 70);
        int n = string3.indexOf(40);
        if (n >= 0) {
            int n2 = string3.indexOf(41);
            if (n2 < 0 || n >= n2 || n + 1 == n2) {
                return;
            }
            string3 = PdbReader.parseTrimmed(string3, n + 1, n2);
        }
        if ((map = this.htFormul.get(string2)) == null) {
            map = new Hashtable<String, Boolean>();
            this.htFormul.put(string2, map);
        }
        this.next[0] = 0;
        while ((string = this.parseTokenNext(string3)) != null) {
            char c;
            if (string.length() < 2) continue;
            char c2 = string.charAt(0);
            if (Atom.isValidElementSymbolNoCaseSecondChar(c2, c = string.charAt(1))) {
                map.put("" + c2 + c, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidElementSymbol(c2)) continue;
            map.put("" + c2, Boolean.TRUE);
        }
    }

    private void het() {
        String string;
        if (this.line.length() < 30) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        if (this.htHetero.containsKey(string = this.parseToken(this.line, 7, 10))) {
            return;
        }
        String string2 = PdbReader.parseTrimmed(this.line, 30, 70);
        this.htHetero.put(string, string2);
    }

    private void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        String string = this.parseToken(this.line, 11, 14);
        String string2 = PdbReader.parseTrimmed(this.line, 15, 70);
        if (string == null) {
            Logger.error("ERROR: HETNAM record does not contain a group name: " + this.line);
            return;
        }
        String string3 = this.htHetero.get(string);
        if (string3 != null) {
            string2 = string3 + string2;
        }
        this.htHetero.put(string, string2);
    }

    private void anisou() {
        int n;
        float[] fArray = new float[8];
        fArray[6] = 1.0f;
        int n2 = this.parseInt(this.line, 6, 11);
        if (this.line.substring(6, 26).equals(this.lastAtomData)) {
            n = this.lastAtomIndex;
        } else {
            if (!this.haveMappedSerials) {
                this.atomSetCollection.createAtomSerialMap();
            }
            n = this.atomSetCollection.getAtomSerialNumberIndex(n2);
            this.haveMappedSerials = true;
        }
        if (n < 0) {
            return;
        }
        Atom atom = this.atomSetCollection.getAtom(n);
        int n3 = 28;
        int n4 = 0;
        while (n3 < 70) {
            fArray[n4] = this.parseFloat(this.line, n3, n3 + 7);
            n3 += 7;
            ++n4;
        }
        n3 = 0;
        while (n3 < 6) {
            if (Float.isNaN(fArray[n3])) {
                Logger.error("Bad ANISOU record: " + this.line);
                return;
            }
            int n5 = n3++;
            fArray[n5] = fArray[n5] / 10000.0f;
        }
        this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
    }

    private void site() {
        int n;
        String string;
        if (this.htSites == null) {
            this.htSites = new Hashtable<String, Map<String, Object>>();
        }
        int n2 = this.parseInt(this.line, 15, 17);
        String string2 = PdbReader.parseTrimmed(this.line, 11, 14);
        Map<String, Object> map = this.htSites.get(string2);
        if (map == null) {
            map = new Hashtable<String, Object>();
            map.put("nResidues", n2);
            map.put("groups", "");
            this.htSites.put(string2, map);
        }
        String string3 = (String)map.get("groups");
        for (int i = 0; i < 4 && (string = PdbReader.parseTrimmed(this.line, n = 18 + i * 11, n + 3)).length() != 0; ++i) {
            String string4 = PdbReader.parseTrimmed(this.line, n + 4, n + 5);
            String string5 = PdbReader.parseTrimmed(this.line, n + 5, n + 9);
            String string6 = PdbReader.parseTrimmed(this.line, n + 9, n + 10);
            string3 = string3 + (string3.length() == 0 ? "" : ",") + "[" + string + "]" + string5;
            if (string6.length() > 0) {
                string3 = string3 + "^" + string6;
            }
            if (string4.length() > 0) {
                string3 = string3 + ":" + string4;
            }
            map.put("groups", string3);
        }
    }
}

