/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javax.vecmath.Vector3f;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;

public class AimsReader
extends AtomSetCollectionReader {
    private int nLatticeVectors = 0;
    private Vector3f[] latticeVectors = new Vector3f[3];

    protected boolean checkLine() {
        String[] stringArray = this.getTokens();
        if (stringArray.length == 0) {
            return true;
        }
        if (stringArray[0].equals("atom")) {
            if (stringArray.length < 5) {
                Logger.warn("cannot read line with FHI-aims atom data: " + this.line);
            } else {
                float f = this.parseFloat(stringArray[1]);
                float f2 = this.parseFloat(stringArray[2]);
                float f3 = this.parseFloat(stringArray[3]);
                String string = stringArray[4];
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.set(f, f2, f3);
                atom.elementSymbol = string;
            }
            return true;
        }
        if (stringArray[0].equals("multipole")) {
            if (stringArray.length < 6) {
                Logger.warn("cannot read line with FHI-aims atom data: " + this.line);
            } else {
                float f = this.parseFloat(stringArray[1]);
                float f4 = this.parseFloat(stringArray[2]);
                float f5 = this.parseFloat(stringArray[3]);
                int n = this.parseInt(stringArray[4]);
                float f6 = this.parseFloat(stringArray[5]);
                if (n > 0) {
                    Logger.warn("multipole line ignored since only monopoles are currently supported: " + this.line);
                    return true;
                }
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.set(f, f4, f5);
                atom.partialCharge = f6;
                atom.formalCharge = Math.round(f6);
            }
            return true;
        }
        if (stringArray[0].equals("lattice_vector")) {
            if (stringArray.length < 4) {
                Logger.warn("cannot read line with FHI-aims lattice vector: " + this.line);
            } else if (this.nLatticeVectors > 2) {
                Logger.warn("more than 3 FHI-aims lattice vectors found with line: " + this.line);
            } else {
                float f = this.parseFloat(stringArray[1]);
                float f7 = this.parseFloat(stringArray[2]);
                float f8 = this.parseFloat(stringArray[3]);
                this.latticeVectors[this.nLatticeVectors] = new Vector3f(f, f7, f8);
            }
            ++this.nLatticeVectors;
            return true;
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        if (this.nLatticeVectors == 3) {
            this.doApplySymmetry = true;
            this.setFractionalCoordinates(false);
            this.setUnitCellFromLatticeVectors(this.latticeVectors);
            int n = this.atomSetCollection.getAtomCount();
            for (int i = 0; i < n; ++i) {
                Atom atom = this.atomSetCollection.getAtom(i);
                this.setAtomCoord(atom);
            }
        }
        super.finalizeReader();
    }

    private void setUnitCellFromLatticeVectors(Vector3f[] vector3fArray) {
        float f = vector3fArray[0].length();
        float f2 = vector3fArray[1].length();
        float f3 = vector3fArray[2].length();
        float f4 = (float)Math.toDegrees(vector3fArray[1].angle(vector3fArray[2]));
        float f5 = (float)Math.toDegrees(vector3fArray[2].angle(vector3fArray[0]));
        float f6 = (float)Math.toDegrees(vector3fArray[0].angle(vector3fArray[1]));
        this.setUnitCell(f, f2, f3, f4, f5, f6);
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            vector3fArray[i].get(fArray);
            this.addPrimitiveLatticeVector(i, fArray, 0);
        }
    }
}

