/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.OutputStream;
import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.api.VertexDataServer;
import org.jmol.jvxl.calc.MarchingCubes;
import org.jmol.jvxl.calc.MarchingSquares;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public abstract class SurfaceReader
implements VertexDataServer {
    protected SurfaceGenerator sg;
    protected MeshDataServer meshDataServer;
    protected Parameters params;
    protected MeshData meshData;
    protected JvxlData jvxlData;
    protected VolumeData volumeData;
    private String edgeData;
    protected boolean allowSigma = false;
    protected boolean isProgressive = false;
    protected boolean isXLowToHigh = false;
    private float assocCutoff = 0.3f;
    protected Point4f mappingPlane;
    boolean vertexDataOnly;
    boolean hasColorData;
    protected float dataMin = Float.MAX_VALUE;
    protected float dataMax = -3.4028235E38f;
    protected float dataMean;
    protected Point3f xyzMin;
    protected Point3f xyzMax;
    protected Point3f center;
    protected float[] anisotropy;
    protected boolean isAnisotropic;
    protected Matrix3f eccentricityMatrix;
    protected Matrix3f eccentricityMatrixInverse;
    protected boolean isEccentric;
    protected float eccentricityScale;
    protected float eccentricityRatio;
    static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    static final float defaultMappedDataMin = 0.0f;
    static final float defaultMappedDataMax = 1.0f;
    static final float defaultCutoff = 0.02f;
    private int edgeCount;
    protected Point3f volumetricOrigin;
    protected Vector3f[] volumetricVectors;
    protected int[] voxelCounts;
    protected float[][][] voxelData;
    protected long nBytes;
    protected int nDataPoints;
    protected int nPointsX;
    protected int nPointsY;
    protected int nPointsZ;
    protected boolean isJvxl;
    protected int edgeFractionBase;
    protected int edgeFractionRange;
    protected int colorFractionBase;
    protected int colorFractionRange;
    protected StringBuffer jvxlFileHeaderBuffer;
    protected StringBuffer fractionData;
    protected String jvxlEdgeDataRead = "";
    protected String jvxlColorDataRead = "";
    protected BitSet jvxlVoxelBitSet;
    protected boolean jvxlDataIsColorMapped;
    protected boolean jvxlDataIsPrecisionColor;
    protected boolean jvxlDataIs2dContour;
    protected float jvxlCutoff;
    protected int jvxlNSurfaceInts;
    protected char cJvxlEdgeNaN;
    protected int contourVertexCount;
    protected MarchingSquares marchingSquares;
    private MarchingCubes marchingCubes;
    protected final Point3f ptTemp = new Point3f();
    private static final String[] colorPhases = new String[]{"_orb", "x", "y", "z", "xy", "yz", "xz", "x2-y2", "z2"};
    protected float[] minMax;
    private boolean haveSetAnisotropy = false;

    SurfaceReader(SurfaceGenerator surfaceGenerator) {
        this.sg = surfaceGenerator;
        this.params = surfaceGenerator.getParams();
        this.marchingSquares = surfaceGenerator.getMarchingSquares();
        this.assocCutoff = this.params.assocCutoff;
        this.isXLowToHigh = this.params.isXLowToHigh;
        this.center = this.params.center;
        this.anisotropy = this.params.anisotropy;
        this.isAnisotropic = this.params.isAnisotropic;
        this.eccentricityMatrix = this.params.eccentricityMatrix;
        this.eccentricityMatrixInverse = this.params.eccentricityMatrixInverse;
        this.isEccentric = this.params.isEccentric;
        this.eccentricityScale = this.params.eccentricityScale;
        this.eccentricityRatio = this.params.eccentricityRatio;
        this.meshData = surfaceGenerator.getMeshData();
        this.jvxlData = surfaceGenerator.getJvxlData();
        this.setVolumeData(surfaceGenerator.getVolumeData());
        this.meshDataServer = surfaceGenerator.getMeshDataServer();
        this.cJvxlEdgeNaN = (char)125;
    }

    protected abstract void closeReader();

    protected void setOutputStream(OutputStream outputStream) {
    }

    void setVolumeData(VolumeData volumeData) {
        this.nBytes = 0L;
        this.volumetricOrigin = volumeData.volumetricOrigin;
        this.volumetricVectors = volumeData.volumetricVectors;
        this.voxelCounts = volumeData.voxelCounts;
        this.voxelData = volumeData.voxelData;
        this.volumeData = volumeData;
    }

    protected abstract boolean readVolumeParameters();

    protected abstract boolean readVolumeData(boolean var1);

    void jvxlUpdateInfo() {
        this.jvxlData.jvxlUpdateInfo(this.params.title, this.nBytes);
    }

    boolean readAndSetVolumeParameters() {
        return this.readVolumeParameters() && (this.vertexDataOnly || this.setUnitVectors());
    }

    protected boolean setUnitVectors() {
        return this.volumeData.setUnitVectors();
    }

    boolean createIsosurface(boolean bl) {
        Object object;
        this.resetIsosurface();
        this.jvxlData.cutoff = Float.NaN;
        if (!this.readAndSetVolumeParameters()) {
            return false;
        }
        if (!(bl || Float.isNaN(this.params.sigma) || this.allowSigma)) {
            if (this.params.sigma > 0.0f) {
                Logger.error("Reader does not support SIGMA option -- using cutoff 1.6");
            }
            this.params.cutoff = 1.6f;
        }
        if (this.params.sigma < 0.0f) {
            this.params.sigma = -this.params.sigma;
        }
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.jvxlData.insideOut = this.params.insideOut;
        this.jvxlData.dataXYReversed = this.params.dataXYReversed;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.nPointsX = this.nPointsX;
        this.jvxlData.nPointsY = this.nPointsY;
        this.jvxlData.nPointsZ = this.nPointsZ;
        this.jvxlData.jvxlVolumeDataXml = this.volumeData.xmlData;
        if (bl) {
            object = this.volumeData.voxelData;
            this.volumeData.setDataDistanceToPlane(this.params.thePlane);
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
            }
            this.params.setMapRanges(this, false);
            this.generateSurfaceData();
            if (this.volumeData != null) {
                this.volumeData.voxelData = (float[][][])object;
            }
        } else {
            if (!this.readVolumeData(false)) {
                return false;
            }
            this.generateSurfaceData();
        }
        object = this.jvxlFileHeaderBuffer.toString();
        int n = ((String)object).indexOf(10, ((String)object).indexOf(10, ((String)object).indexOf(10) + 1) + 1) + 1;
        this.jvxlData.jvxlFileTitle = ((String)object).substring(0, n);
        this.jvxlData.jvxlFileHeader = object;
        if (this.xyzMin == null) {
            this.setBoundingBox();
        }
        if (!this.params.isSilent) {
            Logger.info("boundbox corners " + Escape.escape(this.xyzMin) + " " + Escape.escape(this.xyzMax));
        }
        this.jvxlData.boundingBox = new Point3f[]{this.xyzMin, this.xyzMax};
        this.jvxlData.dataMin = this.dataMin;
        this.jvxlData.dataMax = this.dataMax;
        this.jvxlData.cutoff = this.isJvxl ? this.jvxlCutoff : this.params.cutoff;
        this.jvxlData.isCutoffAbsolute = this.params.isCutoffAbsolute;
        this.jvxlData.pointsPerAngstrom = 1.0f / this.volumeData.volumetricVectorLengths[0];
        this.jvxlData.jvxlColorData = "";
        this.jvxlData.jvxlPlane = this.params.thePlane;
        this.jvxlData.jvxlEdgeData = this.edgeData;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        this.jvxlData.isContoured = this.params.isContoured;
        this.jvxlData.colorDensity = this.params.colorDensity;
        if (this.jvxlData.vContours != null) {
            this.params.nContours = this.jvxlData.vContours.length;
        }
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.nEdges = this.edgeCount;
        this.jvxlData.edgeFractionBase = this.edgeFractionBase;
        this.jvxlData.edgeFractionRange = this.edgeFractionRange;
        this.jvxlData.colorFractionBase = this.colorFractionBase;
        this.jvxlData.colorFractionRange = this.colorFractionRange;
        this.jvxlData.jvxlDataIs2dContour = this.jvxlDataIs2dContour;
        this.jvxlData.jvxlDataIsColorMapped = this.jvxlDataIsColorMapped;
        this.jvxlData.isXLowToHigh = this.isXLowToHigh;
        this.jvxlData.vertexDataOnly = this.vertexDataOnly;
        this.jvxlData.saveVertexCount = 0;
        if (this.jvxlDataIsColorMapped) {
            if (this.meshDataServer != null) {
                this.meshDataServer.fillMeshData(this.meshData, 1, null);
                this.meshDataServer.fillMeshData(this.meshData, 2, null);
            }
            this.jvxlData.jvxlColorData = this.readColorData();
            this.updateSurfaceData();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceMappingCompleted();
            }
        }
        return true;
    }

    void resetIsosurface() {
        this.meshData = new MeshData();
        this.xyzMax = null;
        this.xyzMin = null;
        this.jvxlData.isBicolorMap = this.params.isBicolorMap;
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(null, 0, null);
        }
        this.contourVertexCount = 0;
        if (this.params.cutoff == Float.MAX_VALUE) {
            this.params.cutoff = 0.02f;
        }
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.edgeCount = 0;
        this.edgeFractionBase = 35;
        this.edgeFractionRange = 90;
        this.colorFractionBase = 35;
        this.colorFractionRange = 90;
        this.params.mappedDataMin = Float.MAX_VALUE;
    }

    void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.voxelData = null;
        this.marchingSquares = null;
        this.sg.setMarchingSquares(null);
        this.marchingCubes = null;
    }

    protected void initializeVolumetricData() {
        this.nPointsX = this.voxelCounts[0];
        this.nPointsY = this.voxelCounts[1];
        this.nPointsZ = this.voxelCounts[2];
        this.setVolumeData(this.volumeData);
    }

    protected abstract void readSurfaceData(boolean var1) throws Exception;

    protected boolean gotoAndReadVoxelData(boolean bl) {
        this.initializeVolumetricData();
        if (this.nPointsX > 0 && this.nPointsY > 0 && this.nPointsZ > 0) {
            try {
                this.gotoData(this.params.fileIndex - 1, this.nPointsX * this.nPointsY * this.nPointsZ);
                this.readSurfaceData(bl);
            }
            catch (Exception exception) {
                Logger.error(exception.toString());
                return false;
            }
        }
        return true;
    }

    protected void gotoData(int n, int n2) throws Exception {
    }

    protected String readColorData() {
        return "";
    }

    public float getValue(int n, int n2, int n3, int n4) {
        return this.volumeData.voxelData[n][n2][n3];
    }

    public void getPlane(int n) {
    }

    private void generateSurfaceData() {
        this.edgeData = "";
        if (this.vertexDataOnly) {
            try {
                this.readSurfaceData(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Logger.error("Exception in SurfaceReader::readSurfaceData: " + exception.getMessage());
            }
            return;
        }
        this.contourVertexCount = 0;
        int n = -1;
        this.marchingSquares = null;
        if (this.params.thePlane != null || this.params.isContoured) {
            this.marchingSquares = new MarchingSquares(this, this.volumeData, this.params.thePlane, this.params.contoursDiscrete, this.params.nContours, this.params.thisContour, this.params.contourFromZero);
            n = this.marchingSquares.getContourType();
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
        }
        this.params.contourType = n;
        this.params.isXLowToHigh = this.isXLowToHigh;
        this.marchingCubes = new MarchingCubes(this, this.volumeData, this.params, this.jvxlVoxelBitSet);
        String string = this.marchingCubes.getEdgeData();
        if (this.params.thePlane == null) {
            this.edgeData = string;
        }
        this.jvxlData.setSurfaceInfoFromBitSet(this.marchingCubes.getBsVoxels(), this.params.thePlane);
        this.jvxlData.jvxlExcluded = this.params.bsExcluded;
        if (this.isJvxl) {
            this.edgeData = this.jvxlEdgeDataRead;
        }
    }

    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, Point3i point3i, int n4, int n5, float f2, float f3, Point3f point3f, Vector3f vector3f, boolean bl2, float[] fArray) {
        int n6;
        int n7;
        float f4 = this.getSurfacePointAndFraction(f, bl, f2, f3, point3f, vector3f, fArray, this.ptTemp);
        if (this.marchingSquares != null && this.params.isContoured) {
            return this.marchingSquares.addContourVertex(n, n2, n3, point3i, this.ptTemp, f);
        }
        int n8 = this.assocCutoff > 0.0f ? (fArray[0] < this.assocCutoff ? n4 : (fArray[0] > 1.0f - this.assocCutoff ? n5 : -1)) : (n7 = -1);
        if (n7 >= 0) {
            n7 = this.marchingCubes.getLinearOffset(n, n2, n3, n7);
        }
        if ((n6 = this.addVertexCopy(this.ptTemp, f4, n7)) >= 0 && this.params.iAddGridPoints) {
            this.marchingCubes.calcVertexPoint(n, n2, n3, n5, this.ptTemp);
            this.addVertexCopy(f2 < f3 ? point3f : this.ptTemp, Float.NaN, -3);
            this.addVertexCopy(f2 < f3 ? this.ptTemp : point3f, Float.NaN, -3);
        }
        return n6;
    }

    protected float getSurfacePointAndFraction(float f, boolean bl, float f2, float f3, Point3f point3f, Vector3f vector3f, float[] fArray, Point3f point3f2) {
        float f4 = f3 - f2;
        float f5 = (f - f2) / f4;
        if (bl && (f5 < 0.0f || f5 > 1.0f)) {
            f5 = (-f - f2) / f4;
        }
        if (f5 < 0.0f || f5 > 1.0f) {
            f5 = Float.NaN;
        }
        fArray[0] = f5;
        point3f2.scaleAdd(f5, vector3f, point3f);
        return f2 + f5 * f4;
    }

    public int addVertexCopy(Point3f point3f, float f, int n) {
        if (Float.isNaN(f) && n != -3) {
            return -1;
        }
        if (this.meshDataServer == null) {
            return this.meshData.addVertexCopy(point3f, f, n);
        }
        return this.meshDataServer.addVertexCopy(point3f, f, n);
    }

    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        if (this.marchingSquares != null && this.params.isContoured) {
            if (n6 == 0) {
                return this.marchingSquares.addTriangle(n, n2, n3, n4, n5);
            }
            n6 = 0;
        }
        return this.meshDataServer != null ? this.meshDataServer.addTriangleCheck(n, n2, n3, n4, n5, bl, n6) : (bl && !MeshData.checkCutoff(n, n2, n3, this.meshData.vertexValues) ? -1 : this.meshData.addTriangleCheck(n, n2, n3, n4, n5, n6));
    }

    void colorIsosurface() {
        if (this.params.isSquared && this.volumeData != null) {
            this.volumeData.filterData(true, Float.NaN);
        }
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.jvxlData.saveVertexCount = 0;
        if (this.params.isContoured && this.marchingSquares != null) {
            this.initializeMapping();
            this.params.setMapRanges(this, false);
            this.marchingSquares.setMinMax(this.params.valueMappedToRed, this.params.valueMappedToBlue);
            this.jvxlData.saveVertexCount = this.marchingSquares.contourVertexCount;
            this.contourVertexCount = this.marchingSquares.generateContourData(this.jvxlDataIs2dContour, this.params.isSquared ? 1.0E-8f : 1.0E-4f);
            this.jvxlData.contourValuesUsed = this.marchingSquares.getContourValues();
            this.minMax = this.marchingSquares.getMinMax();
            if (this.meshDataServer != null) {
                this.meshDataServer.notifySurfaceGenerationCompleted();
            }
            this.finalizeMapping();
        }
        this.applyColorScale();
        this.jvxlData.nContours = this.params.contourFromZero ? this.params.nContours : -1 - this.params.nContours;
        this.jvxlData.jvxlFileMessage = "mapped: min = " + this.params.valueMappedToRed + "; max = " + this.params.valueMappedToBlue;
    }

    void applyColorScale() {
        boolean bl;
        this.jvxlData.colorFractionBase = 35;
        this.colorFractionBase = 35;
        this.jvxlData.colorFractionRange = 90;
        this.colorFractionRange = 90;
        if (this.params.colorPhase == 0) {
            this.params.colorPhase = 1;
        }
        if (this.meshDataServer == null) {
            this.meshData.vertexColixes = new short[this.meshData.vertexCount];
        } else {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
            this.meshDataServer.fillMeshData(this.meshData, 2, null);
        }
        boolean bl2 = this.params.colorDensity || this.params.isBicolorMap || this.params.colorBySign || !this.params.colorByPhase;
        this.jvxlData.isJvxlPrecisionColor = true;
        this.jvxlData.vertexCount = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        this.jvxlData.minColorIndex = (short)-1;
        this.jvxlData.maxColorIndex = 0;
        this.jvxlData.contourValues = this.params.contoursDiscrete;
        this.jvxlData.isColorReversed = this.params.isColorReversed;
        if (!this.params.colorDensity && (this.params.isBicolorMap && !this.params.isContoured || this.params.colorBySign)) {
            this.jvxlData.minColorIndex = Graphics3D.getColix(this.params.isColorReversed ? this.params.colorPos : this.params.colorNeg);
            this.jvxlData.maxColorIndex = Graphics3D.getColix(this.params.isColorReversed ? this.params.colorNeg : this.params.colorPos);
        }
        this.jvxlData.isTruncated = this.jvxlData.minColorIndex >= 0 && !this.params.isContoured;
        boolean bl3 = bl = this.jvxlDataIs2dContour || this.vertexDataOnly || this.params.colorDensity || this.params.isBicolorMap && !this.params.isContoured;
        if (!bl) {
            float f = Float.MAX_VALUE;
            float f2 = -3.4028235E38f;
            this.initializeMapping();
            int n = this.meshData.vertexCount;
            while (--n >= 0) {
                float f3 = this.params.colorBySets ? (float)this.meshData.vertexSets[n] : (this.params.colorByPhase ? this.getPhase(this.meshData.vertices[n]) : this.volumeData.lookupInterpolatedVoxelValue(this.meshData.vertices[n]));
                if (f3 < f) {
                    f = f3;
                }
                if (f3 > f2 && f3 != Float.MAX_VALUE) {
                    f2 = f3;
                }
                this.meshData.vertexValues[n] = f3;
            }
            if (this.params.rangeSelected && this.minMax == null) {
                this.minMax = new float[]{f, f2};
            }
            this.finalizeMapping();
        }
        this.params.setMapRanges(this, true);
        this.jvxlData.mappedDataMin = this.params.mappedDataMin;
        this.jvxlData.mappedDataMax = this.params.mappedDataMax;
        this.jvxlData.valueMappedToRed = this.params.valueMappedToRed;
        this.jvxlData.valueMappedToBlue = this.params.valueMappedToBlue;
        this.colorData();
        JvxlCoder.jvxlCreateColorData(this.jvxlData, bl2 ? this.meshData.vertexValues : null);
        if (this.meshDataServer != null && this.params.colorBySets) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    private void colorData() {
        float[] fArray = this.meshData.vertexValues;
        short[] sArray = this.meshData.vertexColixes;
        this.meshData.polygonColixes = null;
        float f = this.jvxlData.valueMappedToBlue;
        float f2 = this.jvxlData.valueMappedToRed;
        short s = this.jvxlData.minColorIndex;
        short s2 = this.jvxlData.maxColorIndex;
        if (this.params.colorEncoder == null) {
            this.params.colorEncoder = new ColorEncoder(null);
        }
        this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
        int n = this.meshData.vertexCount;
        while (--n >= 0) {
            float f3 = fArray[n];
            if (s >= 0) {
                if (f3 <= 0.0f) {
                    sArray[n] = s;
                    continue;
                }
                if (!(f3 > 0.0f)) continue;
                sArray[n] = s2;
                continue;
            }
            if (f3 <= f2) {
                f3 = f2;
            }
            if (f3 >= f) {
                f3 = f;
            }
            sArray[n] = this.params.colorEncoder.getColorIndex(f3);
        }
        if ((this.params.nContours > 0 || this.jvxlData.contourValues != null) && this.jvxlData.contourColixes == null) {
            n = this.jvxlData.contourValues == null ? this.params.nContours : this.jvxlData.contourValues.length;
            this.jvxlData.contourColixes = new short[n];
            short[] sArray2 = this.jvxlData.contourColixes;
            float[] fArray2 = this.jvxlData.contourValues;
            if (fArray2 == null) {
                fArray2 = this.jvxlData.contourValuesUsed;
            }
            if (this.jvxlData.contourValuesUsed == null) {
                this.jvxlData.contourValuesUsed = fArray2 == null ? new float[n] : fArray2;
            }
            float f4 = (f - f2) / (float)(n + 1);
            this.params.colorEncoder.setRange(this.params.valueMappedToRed, this.params.valueMappedToBlue, this.params.isColorReversed);
            for (int i = 0; i < n; ++i) {
                float f5;
                this.jvxlData.contourValuesUsed[i] = f5 = fArray2 == null ? f2 + (float)(i + 1) * f4 : fArray2[i];
                sArray2[i] = Graphics3D.getColixTranslucent(this.params.colorEncoder.getArgb(f5));
            }
            this.jvxlData.contourColors = Graphics3D.getHexCodes(sArray2);
        }
    }

    static int getColorPhaseIndex(String string) {
        int n = -1;
        int n2 = colorPhases.length;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(colorPhases[n2])) continue;
            n = n2;
            break;
        }
        return n;
    }

    private float getPhase(Point3f point3f) {
        switch (this.params.colorPhase) {
            case -1: 
            case 0: 
            case 1: {
                return point3f.x > 0.0f ? 1 : -1;
            }
            case 2: {
                return point3f.y > 0.0f ? 1 : -1;
            }
            case 3: {
                return point3f.z > 0.0f ? 1 : -1;
            }
            case 4: {
                return point3f.x * point3f.y > 0.0f ? 1 : -1;
            }
            case 5: {
                return point3f.y * point3f.z > 0.0f ? 1 : -1;
            }
            case 6: {
                return point3f.x * point3f.z > 0.0f ? 1 : -1;
            }
            case 7: {
                return point3f.x * point3f.x - point3f.y * point3f.y > 0.0f ? 1 : -1;
            }
            case 8: {
                return point3f.z * point3f.z * 2.0f - point3f.x * point3f.x - point3f.y * point3f.y > 0.0f ? 1 : -1;
            }
        }
        return 1.0f;
    }

    public float[] getMinMaxMappedValues(boolean bl) {
        if (this.minMax != null && this.minMax[0] != Float.MAX_VALUE) {
            return this.minMax;
        }
        if (this.params.colorBySets) {
            this.minMax = new float[]{0.0f, Math.max(this.meshData.nSets - 1, 0)};
            return this.minMax;
        }
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        if (this.params.usePropertyForColorRange && this.params.theProperty != null) {
            for (int i = 0; i < this.params.theProperty.length; ++i) {
                float f3;
                if (this.params.rangeSelected && !this.params.bsSelected.get(i) || Float.isNaN(f3 = this.params.theProperty[i])) continue;
                if (f3 < f) {
                    f = f3;
                }
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            this.minMax = new float[]{f, f2};
            return this.minMax;
        }
        int n = this.contourVertexCount > 0 ? this.contourVertexCount : this.meshData.vertexCount;
        Point3f[] point3fArray = this.meshData.vertices;
        boolean bl2 = bl || this.jvxlDataIs2dContour || this.vertexDataOnly || this.params.colorDensity;
        for (int i = 0; i < n; ++i) {
            float f4 = bl2 ? this.meshData.vertexValues[i] : this.volumeData.lookupInterpolatedVoxelValue(point3fArray[i]);
            if (f4 < f) {
                f = f4;
            }
            if (!(f4 > f2) || f4 == Float.MAX_VALUE) continue;
            f2 = f4;
        }
        this.minMax = new float[]{f, f2};
        return this.minMax;
    }

    void updateTriangles() {
        if (this.meshDataServer == null) {
            this.meshData.invalidatePolygons();
        } else {
            this.meshDataServer.invalidateTriangles();
        }
    }

    void updateSurfaceData() {
        this.updateTriangles();
        this.jvxlData.updateSurfaceData(this.meshData.vertexValues, this.meshData.vertexCount, this.meshData.vertexIncrement, this.cJvxlEdgeNaN);
    }

    public void selectPocket(boolean bl) {
    }

    void excludeMinimumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int n = this.meshData.nSets;
        while (--n >= 0) {
            BitSet bitSet = this.meshData.surfaceSet[n];
            if (bitSet == null || bitSet.cardinality() >= this.params.minSet) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    void excludeMaximumSet() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        this.meshData.getSurfaceSet();
        int n = this.meshData.nSets;
        while (--n >= 0) {
            BitSet bitSet = this.meshData.surfaceSet[n];
            if (bitSet == null || bitSet.cardinality() <= this.params.maxSet) continue;
            this.meshData.invalidateSurfaceSet(n);
        }
        this.updateSurfaceData();
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 3, null);
        }
    }

    public void slabIsosurface(Object object, boolean bl) {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        if (this.meshData.polygonIndexes == null) {
            return;
        }
        this.meshData.slabPolygons(object, bl);
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 4, null);
        }
    }

    protected void setVertexAnisotropy(Point3f point3f) {
        point3f.x *= this.anisotropy[0];
        point3f.y *= this.anisotropy[1];
        point3f.z *= this.anisotropy[2];
        point3f.add(this.center);
    }

    protected void setVectorAnisotropy(Vector3f vector3f) {
        this.haveSetAnisotropy = true;
        vector3f.x *= this.anisotropy[0];
        vector3f.y *= this.anisotropy[1];
        vector3f.z *= this.anisotropy[2];
    }

    protected void setVolumetricAnisotropy() {
        if (this.haveSetAnisotropy) {
            return;
        }
        this.setVolumetricOriginAnisotropy();
        this.setVectorAnisotropy(this.volumetricVectors[0]);
        this.setVectorAnisotropy(this.volumetricVectors[1]);
        this.setVectorAnisotropy(this.volumetricVectors[2]);
    }

    protected void setVolumetricOriginAnisotropy() {
        this.volumetricOrigin.set(this.center);
    }

    protected void setBoundingBox(Point3f point3f, float f) {
        if (this.xyzMin == null) {
            this.xyzMin = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.xyzMax = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        }
        if (point3f.x - f < this.xyzMin.x) {
            this.xyzMin.x = point3f.x - f;
        }
        if (point3f.x + f > this.xyzMax.x) {
            this.xyzMax.x = point3f.x + f;
        }
        if (point3f.y - f < this.xyzMin.y) {
            this.xyzMin.y = point3f.y - f;
        }
        if (point3f.y + f > this.xyzMax.y) {
            this.xyzMax.y = point3f.y + f;
        }
        if (point3f.z - f < this.xyzMin.z) {
            this.xyzMin.z = point3f.z - f;
        }
        if (point3f.z + f > this.xyzMax.z) {
            this.xyzMax.z = point3f.z + f;
        }
    }

    private void setBoundingBox() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        for (int i = 0; i < this.meshData.vertexCount; ++i) {
            Point3f point3f = this.meshData.vertices[i];
            if (Float.isNaN(point3f.x)) continue;
            this.setBoundingBox(point3f, 0.0f);
        }
    }

    public void setMappingPlane(Point4f point4f) {
        this.mappingPlane = point4f;
    }

    public float getValueAtPoint(Point3f point3f) {
        return 0.0f;
    }

    protected void initializeMapping() {
    }

    protected void finalizeMapping() {
    }
}

