/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Polymer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AminoPolymer
extends AlphaPolymer {
    private boolean hasOAtoms;
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.5f;
    private float[][] structureList;

    AminoPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 1;
    }

    @Override
    boolean hasWingPoints() {
        return this.hasOAtoms;
    }

    @Override
    public void calcRasmolHydrogenBonds(Polymer polymer, BitSet bitSet, BitSet bitSet2, List<Bond> list, int n) {
        boolean bl;
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        boolean bl2 = bl = polymer == null;
        if (bl) {
            polymer = this;
        }
        AminoPolymer aminoPolymer = (AminoPolymer)polymer;
        for (int i = 1; i < aminoPolymer.monomerCount; ++i) {
            boolean bl3;
            AminoMonomer aminoMonomer = (AminoMonomer)aminoPolymer.monomers[i];
            if (!aminoMonomer.getNHPoint(point3f, vector3f) || !(bl3 = bitSet.get(aminoMonomer.getNitrogenAtom().index))) continue;
            this.checkRasmolHydrogenBond(aminoMonomer, bl ? i : -100, point3f, bl3 ? bitSet2 : bitSet, list, n);
        }
    }

    private void checkRasmolHydrogenBond(AminoMonomer aminoMonomer, int n, Point3f point3f, BitSet bitSet, List<Bond> list, int n2) {
        Atom atom = aminoMonomer.getLeadAtom();
        Atom atom2 = aminoMonomer.getNitrogenAtom();
        Atom atom3 = aminoMonomer.getNitrogenAtom();
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        int n7 = this.monomerCount;
        while (--n7 >= 0) {
            Atom atom4;
            float f;
            if (n7 == n || n7 + 1 == n || n7 - 1 == n) continue;
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n7];
            Atom atom5 = aminoMonomer2.getCarbonylOxygenAtom();
            if (!bitSet.get(atom5.index) || (f = atom.distanceSquared(atom4 = aminoMonomer2.getLeadAtom())) > 81.0f) continue;
            int n8 = this.calcHbondEnergy(atom2, point3f, aminoMonomer2);
            if (n8 < n3) {
                n4 = n3;
                n6 = n5;
                n3 = n8;
                n5 = n7;
                continue;
            }
            if (n8 >= n4) continue;
            n4 = n8;
            n6 = n7;
        }
        if (n5 >= 0) {
            this.addResidueHydrogenBond(atom3, ((AminoMonomer)this.monomers[n5]).getCarbonylOxygenAtom(), n, n5, (float)n3 / 1000.0f, list);
            if (n6 >= 0 && n2 > 1) {
                this.addResidueHydrogenBond(atom3, ((AminoMonomer)this.monomers[n6]).getCarbonylOxygenAtom(), n, n6, (float)n4 / 1000.0f, list);
            }
        }
    }

    private int calcHbondEnergy(Point3f point3f, Point3f point3f2, AminoMonomer aminoMonomer) {
        boolean bl;
        Atom atom = aminoMonomer.getCarbonylOxygenAtom();
        if (atom == null) {
            return 0;
        }
        float f = atom.distanceSquared(point3f);
        if (f < 0.5f) {
            return 0;
        }
        float f2 = atom.distanceSquared(point3f2);
        if (f2 < 0.5f) {
            return 0;
        }
        Atom atom2 = aminoMonomer.getCarbonylCarbonAtom();
        float f3 = atom2.distanceSquared(point3f2);
        if (f3 < 0.5f) {
            return 0;
        }
        float f4 = atom2.distanceSquared(point3f);
        if (f4 < 0.5f) {
            return 0;
        }
        double d = Math.sqrt(f2);
        double d2 = Math.sqrt(f3);
        double d3 = Math.sqrt(f4);
        double d4 = Math.sqrt(f);
        int n = HBond.getEnergy(d, d2, d3, d4);
        boolean bl2 = bl = f4 > f3 && d <= 3.0 && n <= -500;
        return !bl ? 0 : (n < -9900 ? -9900 : n);
    }

    private void addResidueHydrogenBond(Atom atom, Atom atom2, int n, int n2, float f, List<Bond> list) {
        int n3;
        switch (n - n2) {
            case 2: {
                n3 = 6144;
                break;
            }
            case 3: {
                n3 = 8192;
                break;
            }
            case 4: {
                n3 = 10240;
                break;
            }
            case 5: {
                n3 = 12288;
                break;
            }
            case -3: {
                n3 = 14336;
                break;
            }
            case -4: {
                n3 = 16384;
                break;
            }
            default: {
                n3 = 4096;
            }
        }
        list.add(new HBond(atom, atom2, n3, f));
    }

    @Override
    public void calculateStructures() {
        int n;
        if (this.structureList == null) {
            this.structureList = this.model.getModelSet().getStructureList();
        }
        char[] cArray = new char[this.monomerCount];
        for (n = 0; n < this.monomerCount - 1; ++n) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n + 1];
            float f = aminoMonomer2.getGroupParameter(1112539142);
            float f2 = aminoMonomer.getGroupParameter(1112539143);
            cArray[n] = this.isHelix(f2, f) ? (f < 0.0f && f2 < 25.0f ? 52 : 51) : (this.isSheet(f2, f) ? 115 : (this.isTurn(f2, f) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug('\u0000' + this.monomers[0].getChainID() + " aminopolymer:" + n + " " + aminoMonomer2.getGroupParameter(1112539142) + "," + aminoMonomer.getGroupParameter(1112539143) + " " + cArray[n]);
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n2;
            if (cArray[n] != '4') continue;
            for (n2 = n + 1; n2 < this.monomerCount && cArray[n2] == '4'; ++n2) {
            }
            if (--n2 >= n + 3) {
                this.addSecondaryStructure((byte)3, null, 0, 0, n, n2);
            }
            n = n2;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n3;
            if (cArray[n] != '3') continue;
            for (n3 = n + 1; n3 < this.monomerCount && cArray[n3] == '3'; ++n3) {
            }
            if (--n3 >= n + 3) {
                this.addSecondaryStructure((byte)3, null, 0, 0, n, n3);
            }
            n = n3;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n4;
            if (cArray[n] != 's') continue;
            for (n4 = n + 1; n4 < this.monomerCount && cArray[n4] == 's'; ++n4) {
            }
            if (--n4 >= n + 2) {
                this.addSecondaryStructure((byte)2, null, 0, 0, n, n4);
            }
            n = n4;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n5;
            if (cArray[n] != 't') continue;
            for (n5 = n + 1; n5 < this.monomerCount && cArray[n5] == 't'; ++n5) {
            }
            if (--n5 >= n + 2) {
                this.addSecondaryStructure((byte)1, null, 0, 0, n, n5);
            }
            n = n5;
        }
    }

    @Override
    protected void resetHydrogenPoints() {
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                proteinStructure = proteinStructure2;
                proteinStructure.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    private boolean checkWingAtoms() {
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)this.monomers[i]).hasOAtom()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void freeze() {
        this.hasOAtoms = this.checkWingAtoms();
    }

    @Override
    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles(AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        Atom atom = aminoMonomer.getNitrogenAtom();
        Atom atom2 = aminoMonomer.getLeadAtom();
        Atom atom3 = aminoMonomer.getCarbonylCarbonAtom();
        Atom atom4 = aminoMonomer2.getNitrogenAtom();
        Atom atom5 = aminoMonomer2.getLeadAtom();
        Atom atom6 = aminoMonomer2.getCarbonylCarbonAtom();
        aminoMonomer2.setGroupParameter(1112539142, Measure.computeTorsion(atom3, atom4, atom5, atom6, true));
        aminoMonomer.setGroupParameter(1112539143, Measure.computeTorsion(atom, atom2, atom3, atom4, true));
        aminoMonomer.setGroupParameter(1112539141, Measure.computeTorsion(atom2, atom3, atom4, atom5, true));
    }

    @Override
    protected float calculateRamachandranHelixAngle(int n, char c) {
        float f = n == 0 ? Float.NaN : this.monomers[n - 1].getGroupParameter(1112539143);
        float f2 = this.monomers[n].getGroupParameter(1112539143);
        float f3 = this.monomers[n].getGroupParameter(1112539142);
        float f4 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539142);
        float f5 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539143);
        switch (c) {
            default: {
                float f6 = (float)((double)((f4 - f3) / 2.0f) * Math.PI / 180.0);
                float f7 = (float)((double)((f5 - f2) / 2.0f) * Math.PI / 180.0);
                return (float)(114.59155902616465 * Math.acos(Math.cos(f7) * Math.cos(f6) - Math.cos(1.2217304763960306) * Math.sin(f7) * Math.sin(f6)));
            }
            case 'C': 
            case 'c': 
        }
        return f2 - f + f4 - f3;
    }

    @Override
    public void setStructureList(float[][] fArray) {
        this.structureList = fArray;
    }

    private boolean isTurn(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList[1], f, f2);
    }

    private boolean isSheet(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList[2], f, f2);
    }

    private boolean isHelix(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList[3], f, f2);
    }

    private static boolean checkPhiPsi(float[] fArray, float f, float f2) {
        for (int i = 0; i < fArray.length; i += 4) {
            if (!(f2 >= fArray[i]) || !(f2 <= fArray[i + 1]) || !(f >= fArray[i + 2]) || !(f <= fArray[i + 3])) continue;
            return true;
        }
        return false;
    }
}

